/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.web.spring;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.exception.ErrorList;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.ken.web.spring.BaseSendNotificationController;
import org.springframework.web.servlet.ModelAndView;

public class SendNotificationMessageController
extends BaseSendNotificationController {
    private static final Logger LOG = Logger.getLogger(SendNotificationMessageController.class);

    public ModelAndView sendSimpleNotificationMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String view = "SendSimpleNotificationMessage";
        LOG.debug((Object)("remoteUser: " + request.getRemoteUser()));
        Map<String, Object> model = this.setupModelForSendNotification(request);
        model.put("errors", new ErrorList());
        return new ModelAndView(view, model);
    }

    public ModelAndView submitSimpleNotificationMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String routeMessage = "This message was submitted via the simple notification message submission form by user ";
        String viewName = "SendSimpleNotificationMessage";
        return this.submitNotificationMessage(request, routeMessage, viewName);
    }

    @Override
    protected NotificationBo createNotification(HttpServletRequest request, Map<String, Object> model, ErrorList errors) throws ErrorList {
        NotificationBo notification = super.createNotification(request, model, errors);
        String message = this.getParameter(request, "message", model, errors, "You must fill in a message.");
        if (!errors.getErrors().isEmpty()) {
            throw errors;
        }
        NotificationContentTypeBo contentType = (NotificationContentTypeBo)((Object)Util.retrieveFieldReference("contentType", "name", "Simple", NotificationContentTypeBo.class, this.dataObjectService, Boolean.TRUE));
        notification.setContentType(contentType);
        notification.setContent("<content xmlns=\"ns:notification/ContentTypeSimple\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:notification/ContentTypeSimple resource:notification/ContentTypeSimple\"><message><![CDATA[" + message + "]]></message>" + "</content>");
        return notification;
    }
}

