/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.ActionItemBase;
import org.kuali.rice.kew.actionitem.OutboxItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.actionlist.ActionListForm;
import org.kuali.rice.kew.actionlist.ActionToTake;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionlist.web.ActionListUtil;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionInvocation;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.action.ActionItemCustomization;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.framework.KewFrameworkServiceLocator;
import org.kuali.rice.kew.framework.actionlist.ActionListCustomizationMediator;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/kew/actionList"})
public class ActionListController
extends UifControllerBase {
    private static final Logger LOG = Logger.getLogger(ActionListController.class);
    protected static final String MAX_ACTION_ITEM_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss.S";
    private static final ActionType[] actionListActionTypes = new ActionType[]{ActionType.APPROVE, ActionType.DISAPPROVE, ActionType.CANCEL, ActionType.ACKNOWLEDGE, ActionType.FYI};
    private static final String OUT_BOX_MODE = "_OUT_BOX_MODE";

    protected ActionListForm createInitialForm() {
        return new ActionListForm();
    }

    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        actionListForm.setRequeryActionList(true);
        return this.start(form);
    }

    protected void initializeFilter(ActionListForm form) {
        if (form.getFilter() == null) {
            ActionListFilter filter = new ActionListFilter();
            filter.setDelegationType(DelegationType.SECONDARY.getCode());
            filter.setExcludeDelegationType(true);
            form.setFilter(filter);
        }
    }

    protected String initializePrincipalId(ActionListForm actionListForm, ActionListFilter filter) {
        String principalId = null;
        Principal principal = actionListForm.getHelpDeskActionListPrincipal();
        if (principal != null) {
            principalId = principal.getPrincipalId();
        } else {
            if (!StringUtils.isEmpty((String)actionListForm.getDocType())) {
                this.initializeDocType(actionListForm, filter);
            }
            UserSession uSession = this.getUserSession();
            principalId = uSession.getPerson().getPrincipalId();
        }
        return principalId;
    }

    protected void initializeDocType(ActionListForm actionListForm, ActionListFilter filter) {
        filter.setDocumentType(actionListForm.getDocType());
        filter.setExcludeDocumentType(false);
        actionListForm.setRequeryActionList(true);
    }

    protected void initializeDelegators(ActionListForm actionListForm, ActionListFilter filter, List<? extends ActionItemBase> actionList, HttpServletRequest request) {
        if (!"Choose Secondary Delegation".equals(actionListForm.getDelegationId())) {
            if (StringUtils.isNotBlank((String)actionListForm.getPrimaryDelegateId()) && !"Choose Primary Delegate".equals(actionListForm.getPrimaryDelegateId())) {
                this.setDelegationId(actionListForm, request);
            } else if (StringUtils.isNotBlank((String)filter.getPrimaryDelegateId()) && !"Choose Primary Delegate".equals(filter.getPrimaryDelegateId())) {
                filter.setPrimaryDelegateId("Choose Primary Delegate");
            }
        }
        filter.setDelegatorId(actionListForm.getDelegationId());
        filter.setExcludeDelegatorId(false);
        actionList = null;
    }

    protected void setDelegationId(ActionListForm actionListForm, HttpServletRequest request) {
        if (actionListForm.getPrimaryDelegateId().equals(request.getParameter("oldPrimaryDelegateId")) && !actionListForm.getDelegationId().equals(request.getParameter("oldDelegationId"))) {
            actionListForm.setPrimaryDelegateId("Choose Primary Delegate");
        } else {
            actionListForm.setDelegationId("Choose Secondary Delegation");
        }
    }

    protected void initializePrimaryDelegate(ActionListForm actionListForm, ActionListFilter filter, List<? extends ActionItemBase> actionList, HttpServletRequest request) {
        if (!StringUtils.isEmpty((String)actionListForm.getPrimaryDelegateId())) {
            if (StringUtils.isBlank((String)actionListForm.getDelegationId()) && !"Choose Primary Delegate".equals(actionListForm.getPrimaryDelegateId()) && StringUtils.isNotBlank((String)filter.getDelegatorId()) && !"Choose Secondary Delegation".equals(filter.getDelegatorId())) {
                filter.setDelegatorId("Choose Secondary Delegation");
            }
            filter.setPrimaryDelegateId(actionListForm.getPrimaryDelegateId());
            filter.setExcludeDelegatorId(false);
            actionList = null;
        }
    }

    @MethodAccessible
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        HttpServletRequest request = actionListForm.getRequest();
        if (actionListForm.getPreferences() == null) {
            actionListForm.setPreferences(KewApiServiceLocator.getPreferencesService().getPreferences(this.getUserSession().getPrincipalId()));
        }
        request.setAttribute("preferences", (Object)actionListForm.getPreferences());
        PerformanceLogger plog = new PerformanceLogger();
        plog.log("Starting ActionList fetch");
        ActionListService actionListSrv = KEWServiceLocator.getActionListService();
        actionListForm.setDefaultActionToTake("NONE");
        boolean freshActionList = true;
        List<? extends ActionItemBase> actionList = actionListForm.getActionList();
        plog.log("Time to initialize");
        try {
            this.initializeFilter(actionListForm);
            ActionListFilter filter = actionListForm.getFilter();
            String principalId = this.initializePrincipalId(actionListForm, filter);
            boolean forceListRefresh = actionListForm.isRequeryActionList();
            Preferences preferences = actionListForm.getPreferences();
            if (!StringUtils.isEmpty((String)actionListForm.getDelegationId())) {
                this.initializeDelegators(actionListForm, filter, actionList, request);
            }
            if (!StringUtils.isEmpty((String)actionListForm.getPrimaryDelegateId())) {
                this.initializePrimaryDelegate(actionListForm, filter, actionList, request);
            }
            if (!principalId.equals(actionListForm.getUser())) {
                actionList = null;
            }
            if (this.isOutboxMode(actionListForm, request, preferences)) {
                actionList = new ArrayList<OutboxItem>(actionListSrv.getOutbox(principalId, filter));
                actionListForm.setOutBoxEmpty(actionList.isEmpty());
                actionListForm.setActionList((ArrayList)actionList);
            } else {
                if (actionList == null) {
                    actionList = new ArrayList<ActionItem>(actionListSrv.getActionList(principalId, filter));
                    actionListForm.setUser(principalId);
                } else if (forceListRefresh) {
                    actionList = new ArrayList<ActionItem>(actionListSrv.getActionList(principalId, filter));
                    actionListForm.setUser(principalId);
                } else {
                    Boolean update = actionListForm.isUpdateActionList();
                }
                actionListForm.setActionList((ArrayList)actionList);
            }
            actionListForm.setRequeryActionList(false);
            if ("Secondary Delegators on Action List Page".equalsIgnoreCase(preferences.getDelegatorFilter())) {
                Collection<Recipient> delegators = actionListSrv.findUserSecondaryDelegators(principalId);
                actionListForm.setDelegators(ActionListUtil.getWebFriendlyRecipients(delegators));
                actionListForm.setDelegationId(filter.getDelegatorId());
            }
            if ("Primary Delegates on Action List Page".equalsIgnoreCase(preferences.getPrimaryDelegateFilter())) {
                Collection<Recipient> pDelegates = actionListSrv.findUserPrimaryDelegations(principalId);
                actionListForm.setPrimaryDelegates(ActionListUtil.getWebFriendlyRecipients(pDelegates));
                actionListForm.setPrimaryDelegateId(filter.getPrimaryDelegateId());
            }
            actionListForm.setFilterLegend(filter.getFilterLegend());
            plog.log("Setting attributes");
            int pageSize = this.getPageSize(preferences);
            if (freshActionList) {
                plog.log("calling initializeActionList");
                this.initializeActionList(actionList, preferences);
                plog.log("done w/ initializeActionList");
            }
            plog.log("start addActions");
            this.addCustomActions(actionList, preferences, actionListForm);
            plog.log("done w/ addCustomActions");
            actionListForm.setUpdateActionList(false);
            plog.log("finished setting attributes, finishing action list fetch");
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading action list.", (Throwable)e);
        }
        LOG.debug((Object)"end start ActionListAction");
        String returnPage = "ActionListPage1";
        String methodToCall = actionListForm.getMethodToCall();
        if (methodToCall.equals("clear")) {
            returnPage = "ActionListPage2";
        }
        return this.getModelAndView(actionListForm, returnPage);
    }

    private boolean isOutboxMode(ActionListForm alForm, HttpServletRequest request, Preferences preferences) {
        boolean outBoxView = false;
        if (!preferences.isUsingOutbox() || !ConfigContext.getCurrentContextConfig().getOutBoxOn().booleanValue()) {
            alForm.setOutBoxMode(Boolean.FALSE);
            alForm.setViewOutbox("false");
            alForm.setShowOutbox(false);
            return false;
        }
        alForm.setShowOutbox(true);
        if (StringUtils.isNotEmpty((String)alForm.getViewOutbox())) {
            if (!Boolean.valueOf(alForm.getViewOutbox()).booleanValue()) {
                alForm.setOutBoxMode(Boolean.FALSE);
                outBoxView = false;
            } else {
                alForm.setOutBoxMode(Boolean.FALSE);
                outBoxView = true;
            }
        } else {
            outBoxView = alForm.isOutBoxMode();
        }
        if (outBoxView) {
            alForm.setViewOutbox("true");
        } else {
            alForm.setViewOutbox("false");
        }
        return outBoxView;
    }

    private void initializeActionList(List<? extends ActionItemBase> actionList, Preferences preferences) {
        ArrayList<String> actionItemProblemIds = new ArrayList<String>();
        int index = 0;
        this.generateActionItemErrors(actionList);
        Iterator<? extends ActionItemBase> iterator = actionList.iterator();
        while (iterator.hasNext()) {
            ActionItemBase actionItem = iterator.next();
            if (actionItem.getDocumentId() == null) {
                LOG.error((Object)("Somehow there exists an ActionItem with a null document id!  actionItemId=" + actionItem.getId()));
                iterator.remove();
                continue;
            }
            try {
                actionItem.initialize(preferences);
                actionItem.setActionListIndex(index);
                ++index;
            }
            catch (Exception e) {
                LOG.error((Object)("Error loading action list for action item " + actionItem.getId()), (Throwable)e);
                iterator.remove();
                actionItemProblemIds.add(actionItem.getDocumentId());
            }
        }
        this.generateActionItemErrors("actionitem", "actionlist.badActionItems", actionItemProblemIds);
    }

    protected int getPageSize(Preferences preferences) {
        return Integer.parseInt(preferences.getPageSize());
    }

    protected void addCustomActions(List<? extends ActionItemBase> actionList, Preferences preferences, ActionListForm form) throws WorkflowException {
        boolean haveCustomActions = false;
        boolean haveDisplayParameters = false;
        boolean showClearFyi = "yes".equalsIgnoreCase(preferences.getShowClearFyi());
        HashSet<ActionType> pageActions = new HashSet<ActionType>();
        ArrayList<String> customActionListProblemIds = new ArrayList<String>();
        this.generateActionItemErrors(actionList);
        LOG.info((Object)("Beginning processing of Action List Customizations (total: " + actionList.size() + " Action Items)"));
        long start = System.currentTimeMillis();
        Map customizationMap = this.getActionListCustomizationMediator().getActionListCustomizations(this.getUserSession().getPrincipalId(), this.convertToApiActionItems(actionList));
        long end = System.currentTimeMillis();
        LOG.info((Object)("Finished processing of Action List Customizations (total time: " + (end - start) + " ms)"));
        for (ActionItemBase actionItemBase : actionList) {
            try {
                ActionItemCustomization customization = (ActionItemCustomization)customizationMap.get(actionItemBase.getId());
                if (customization == null) continue;
                ActionSet actionSet = customization.getActionSet();
                LinkedHashMap<String, String> customActions = new LinkedHashMap<String, String>();
                customActions.put("NONE", "NONE");
                for (ActionType actionType : actionListActionTypes) {
                    boolean isFyi;
                    if (!actionSet.hasAction(actionType.getCode()) || !this.isActionCompatibleRequest(actionItemBase, actionType.getCode())) continue;
                    boolean bl = isFyi = ActionType.FYI == actionType;
                    if (isFyi && (!isFyi || !showClearFyi)) continue;
                    customActions.put(actionType.getCode(), actionType.getLabel());
                    pageActions.add(actionType);
                }
                if (customActions.size() > 1) {
                    actionItemBase.setCustomActions(customActions);
                    haveCustomActions = true;
                }
                actionItemBase.setDisplayParameters(customization.getDisplayParameters());
                haveDisplayParameters = haveDisplayParameters || actionItemBase.getDisplayParameters() != null;
            }
            catch (Exception e) {
                LOG.error((Object)"Problem loading custom action list attribute", (Throwable)e);
                customActionListProblemIds.add(actionItemBase.getDocumentId());
            }
        }
        form.setHasCustomActions(haveCustomActions);
        LinkedHashMap<String, String> defaultActions = new LinkedHashMap<String, String>();
        defaultActions.put("NONE", "NONE");
        for (ActionType actionType : actionListActionTypes) {
            boolean isFyi;
            if (!pageActions.contains(actionType)) continue;
            boolean bl = isFyi = ActionType.FYI == actionType;
            if (isFyi) {
                if (!showClearFyi) continue;
                defaultActions.put(actionType.getCode(), actionType.getLabel());
                continue;
            }
            defaultActions.put(actionType.getCode(), actionType.getLabel());
            form.setCustomActionList(Boolean.TRUE);
        }
        if (defaultActions.size() > 1) {
            form.setDefaultActions(defaultActions);
        }
        form.setHasDisplayParameters(haveDisplayParameters);
        this.generateActionItemErrors("customActionList", "actionlist.badCustomActionListItems", customActionListProblemIds);
    }

    private List<org.kuali.rice.kew.api.action.ActionItem> convertToApiActionItems(List<? extends ActionItemBase> actionList) {
        ArrayList<org.kuali.rice.kew.api.action.ActionItem> apiActionItems = new ArrayList<org.kuali.rice.kew.api.action.ActionItem>(actionList.size());
        for (ActionItemBase actionItemBase : actionList) {
            apiActionItems.add(ActionItem.Builder.create((ActionItemContract)actionItemBase).build());
        }
        return apiActionItems;
    }

    private void generateActionItemErrors(String propertyName, String errorKey, List<String> documentIds) {
        if (!documentIds.isEmpty()) {
            String documentIdsString = StringUtils.join(documentIds.iterator(), (String)", ");
            GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[]{documentIdsString});
        }
    }

    private void generateActionItemErrors(List<? extends ActionItemBase> actionList) {
        for (ActionItemBase actionItemBase : actionList) {
            if (KewApiConstants.ACTION_REQUEST_CODES.containsKey(actionItemBase.getActionRequestCd())) continue;
            GlobalVariables.getMessageMap().putError("actionRequestCd", "actionitem.actionrequestcd.invalid", new String[]{actionItemBase.getId() + ""});
        }
    }

    @RequestMapping(params={"methodToCall=takeMassActions"})
    protected ModelAndView takeMassActions(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        Object obj = ObjectPropertyUtils.getPropertyValue((Object)form, (String)"extensionData['actionInputField_actionSelect_line2']");
        List<? extends ActionItemBase> actionList = actionListForm.getActionList();
        if (actionList == null) {
            return this.getModelAndView(form);
        }
        ActionMessages messages = new ActionMessages();
        ArrayList<ActionInvocation> invocations = new ArrayList<ActionInvocation>();
        int index = 0;
        for (ActionToTake element : actionListForm.getActionsToTake()) {
            ActionToTake actionToTake = element;
            if (actionToTake != null && actionToTake.getActionTakenCd() != null && !"".equals(actionToTake.getActionTakenCd()) && !"NONE".equalsIgnoreCase(actionToTake.getActionTakenCd()) && actionToTake.getActionItemId() != null) {
                ActionItemBase actionItem = this.getActionItemFromActionList(actionList, actionToTake.getActionItemId());
                if (actionItem == null) {
                    LOG.warn((Object)("Could not locate the ActionItem to take mass action against in the action list: " + actionToTake.getActionItemId()));
                    continue;
                }
                invocations.add(ActionInvocation.create((ActionType)ActionType.fromCode((String)actionToTake.getActionTakenCd()), (String)actionItem.getId()));
            }
            ++index;
        }
        KEWServiceLocator.getWorkflowDocumentService().takeMassActions(this.getUserSession().getPrincipalId(), invocations);
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("general.routing.processed"));
        org.kuali.rice.kew.actionlist.web.ActionListForm cleanForm = new org.kuali.rice.kew.actionlist.web.ActionListForm();
        actionListForm.setRequeryActionList(true);
        return this.start(actionListForm);
    }

    protected ActionItemBase getActionItemFromActionList(List<? extends ActionItemBase> actionList, String actionItemId) {
        for (ActionItemBase actionItemBase : actionList) {
            if (!actionItemBase.getId().equals(actionItemId)) continue;
            return actionItemBase;
        }
        return null;
    }

    @MethodAccessible
    @RequestMapping(params={"methodToCall=helpDeskActionListLogin"})
    public ModelAndView helpDeskActionListLogin(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        String name = actionListForm.getHelpDeskActionListUserName();
        if (!actionListForm.isHelpDeskActionList()) {
            throw new AuthorizationException(this.getUserSession().getPrincipalId(), "helpDeskActionListLogin", ((Object)((Object)this)).getClass().getSimpleName());
        }
        try {
            Principal helpDeskActionListPrincipal = KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName(name);
            Person helpDeskActionListPerson = KEWServiceLocator.getIdentityHelperService().getPersonByPrincipalName(name);
            actionListForm.setHelpDeskActionListPrincipal(helpDeskActionListPrincipal);
            actionListForm.setHelpDeskActionListPerson(helpDeskActionListPerson);
        }
        catch (RiceRuntimeException rre) {
            GlobalVariables.getMessageMap().putError("helpDeskActionListUserName", "helpdesk.login.invalid", new String[]{name});
        }
        catch (RiceIllegalArgumentException e) {
            GlobalVariables.getMessageMap().putError("helpDeskActionListUserName", "helpdesk.login.invalid", new String[]{name});
        }
        catch (NullPointerException npe) {
            GlobalVariables.getMessageMap().putError("null", "helpdesk.login.empty", new String[]{name});
        }
        actionListForm.setDelegator(null);
        actionListForm.setRequeryActionList(true);
        return this.start(actionListForm);
    }

    @RequestMapping(params={"methodToCall=clearFilter"})
    public ModelAndView clearFilter(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        LOG.debug((Object)"clearFilter ActionListController");
        UserSession commonUserSession = this.getUserSession();
        actionListForm.setFilter(new ActionListFilter());
        ActionListFilter filter = new ActionListFilter();
        filter.setDelegationType(DelegationType.SECONDARY.getCode());
        filter.setExcludeDelegationType(true);
        actionListForm.setFilter(filter);
        LOG.debug((Object)"end clearFilter ActionListController");
        return this.start(actionListForm);
    }

    @RequestMapping(params={"methodToCall=clear"})
    public ModelAndView clear(UifFormBase form) {
        return this.clearFilter(form);
    }

    @RequestMapping(params={"methodToCall=setFilter"})
    public ModelAndView setFilter(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        UserSession uSession = this.getUserSession();
        ActionListFilter alFilter = actionListForm.getLoadedFilter();
        if (StringUtils.isNotBlank((String)alFilter.getDelegatorId()) && !"Choose Secondary Delegation".equals(alFilter.getDelegatorId()) && StringUtils.isNotBlank((String)alFilter.getPrimaryDelegateId()) && !"Choose Primary Delegate".equals(alFilter.getPrimaryDelegateId())) {
            alFilter.setDelegatorId("Choose Secondary Delegation");
        }
        actionListForm.setFilter(alFilter);
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            actionListForm.setRequeryActionList(true);
            return this.start(actionListForm);
        }
        return this.start(actionListForm);
    }

    @RequestMapping(params={"methodToCall=clearHelpDeskActionListUser"})
    public ModelAndView clearHelpDeskActionListUser(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        LOG.debug((Object)"clearHelpDeskActionListUser ActionListAction");
        actionListForm.setHelpDeskActionListPrincipal(null);
        actionListForm.setHelpDeskActionListPerson(null);
        LOG.debug((Object)"end clearHelpDeskActionListUser ActionListAction");
        actionListForm.setRequeryActionList(true);
        return this.start(actionListForm);
    }

    @RequestMapping(params={"methodToCall=removeOutboxItems"})
    public ModelAndView removeOutboxItems(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        Map selectedCollectionLines = actionListForm.getSelectedCollectionLines();
        Object selectedItems = selectedCollectionLines.get("ActionList");
        if (selectedItems != null) {
            ArrayList<String> outboxItemsForDeletion = new ArrayList<String>((LinkedHashSet)selectedItems);
            KEWServiceLocator.getActionListService().removeOutboxItems(this.getUserSession().getPrincipalId(), outboxItemsForDeletion);
            selectedCollectionLines.remove("ActionList");
            actionListForm.setSelectedCollectionLines(selectedCollectionLines);
        }
        actionListForm.setViewOutbox("true");
        actionListForm.setRequeryActionList(true);
        return this.start(actionListForm);
    }

    @RequestMapping(params={"methodToCall=viewFilter"})
    public ModelAndView viewFilter(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ActionListForm actionListForm = (ActionListForm)form;
        actionListForm.setOldFilter(new ActionListFilter(actionListForm.getFilter()));
        return this.getModelAndView(actionListForm, "ActionListPage2");
    }

    @RequestMapping(params={"methodToCall=cancelFilter"})
    public ModelAndView cancelFilter(UifFormBase form) {
        ActionListForm actionListForm = (ActionListForm)form;
        actionListForm.setFilter(new ActionListFilter(actionListForm.getOldFilter()));
        return this.start(actionListForm);
    }

    @RequestMapping(params={"methodToCall=viewPreferences"})
    public ModelAndView viewPreferences(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.getModelAndView(form, "ActionListPage3");
    }

    private boolean isActionCompatibleRequest(ActionItemBase actionItem, String actionTakenCode) {
        boolean actionCompatible = false;
        String requestCd = actionItem.getActionRequestCd();
        if ("F".equals(requestCd) && "F".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        if ("K".equals(requestCd) && "K".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        if ("A".equals(requestCd) && !"F".equals(actionTakenCode) && !"K".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        if ("C".equals(requestCd) && !"F".equals(actionTakenCode) && !"K".equals(actionTakenCode)) {
            actionCompatible = true;
        }
        return actionCompatible;
    }

    private UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }

    private ActionListCustomizationMediator getActionListCustomizationMediator() {
        return ActionListCustomizationMediatorHolder.actionListCustomizationMediator;
    }

    private static final class PartitionKey {
        String applicationId;
        Set<String> customActionListAttributeNames;

        PartitionKey(String applicationId, Collection<ExtensionDefinition> extensionDefinitions) {
            this.applicationId = applicationId;
            this.customActionListAttributeNames = new HashSet<String>();
            for (ExtensionDefinition extensionDefinition : extensionDefinitions) {
                this.customActionListAttributeNames.add(extensionDefinition.getName());
            }
        }

        List<String> getCustomActionListAttributeNameList() {
            return new ArrayList<String>(this.customActionListAttributeNames);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PartitionKey)) {
                return false;
            }
            PartitionKey key = (PartitionKey)o;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.applicationId, (Object)key.applicationId);
            builder.append(this.customActionListAttributeNames, key.customActionListAttributeNames);
            return builder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.applicationId);
            builder.append(this.customActionListAttributeNames);
            return builder.hashCode();
        }
    }

    private static class ActionListCustomizationMediatorHolder {
        static final ActionListCustomizationMediator actionListCustomizationMediator = KewFrameworkServiceLocator.getActionListCustomizationMediator();

        private ActionListCustomizationMediatorHolder() {
        }
    }
}

