/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.dao.ActionRequestDAO;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.service.ActionTakenService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.document.DocumentRefreshQueue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.FutureRequestDocumentStateManager;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.util.ResponsibleParty;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class ActionRequestServiceImpl
implements ActionRequestService {
    private static final Logger LOG = Logger.getLogger(ActionRequestServiceImpl.class);
    private static final String STATUS = "status";
    private static final String DOCUMENT_ID = "documentId";
    private static final String CURRENT_INDICATOR = "currentIndicator";
    private static final String PARENT_ACTION_REQUEST = "parentActionRequest";
    private static final String ACTION_REQUESTED = "actionRequested";
    private static final String ROUTE_NODE_INSTANCE_ID = "nodeInstance.routeNodeInstanceId";
    private static final String GROUP_ID = "groupId";
    private static final String ACTION_TAKEN_ID = "actionTaken.actionTakenId";
    private static final String RECIPIENT_TYPE_CD = "recipientTypeCd";
    private static final String PRINCIPAL_ID = "principalId";
    private DataObjectService dataObjectService;
    private ActionRequestDAO actionRequestDAO;

    @Override
    public ActionRequestValue findByActionRequestId(String actionRequestId) {
        return (ActionRequestValue)this.getDataObjectService().find(ActionRequestValue.class, (Object)actionRequestId);
    }

    @Override
    public Map<String, String> getActionsRequested(DocumentRouteHeaderValue routeHeader, String principalId, boolean completeAndApproveTheSame) {
        return this.getActionsRequested(principalId, routeHeader.getActionRequests(), completeAndApproveTheSame);
    }

    protected Map<String, String> getActionsRequested(String principalId, List<ActionRequestValue> actionRequests, boolean completeAndApproveTheSame) {
        HashMap<String, String> actionsRequested = new HashMap<String, String>();
        actionsRequested.put("F", "false");
        actionsRequested.put("K", "false");
        actionsRequested.put("A", "false");
        actionsRequested.put("C", "false");
        String topActionRequested = "F";
        for (ActionRequestValue actionRequest : actionRequests) {
            if (RecipientType.ROLE.getCode().equals(actionRequest.getRecipientTypeCd()) || !actionRequest.isRecipientRoutedRequest(principalId) || !actionRequest.isActive()) continue;
            int actionRequestComparison = ActionRequestValue.compareActionCode(actionRequest.getActionRequested(), topActionRequested, completeAndApproveTheSame);
            if (actionRequest.isFYIRequest() && actionRequestComparison >= 0) {
                actionsRequested.put("F", "true");
                continue;
            }
            if (actionRequest.isAcknowledgeRequest() && actionRequestComparison >= 0) {
                actionsRequested.put("K", "true");
                actionsRequested.put("F", "false");
                topActionRequested = actionRequest.getActionRequested();
                continue;
            }
            if (actionRequest.isApproveRequest() && actionRequestComparison >= 0) {
                actionsRequested.put("A", "true");
                actionsRequested.put("K", "false");
                actionsRequested.put("F", "false");
                topActionRequested = actionRequest.getActionRequested();
                continue;
            }
            if (!actionRequest.isCompleteRequst() || actionRequestComparison < 0) continue;
            actionsRequested.put("C", "true");
            actionsRequested.put("A", "false");
            actionsRequested.put("K", "false");
            actionsRequested.put("F", "false");
            if (completeAndApproveTheSame) {
                actionsRequested.put("A", "true");
            }
            topActionRequested = actionRequest.getActionRequested();
        }
        return actionsRequested;
    }

    @Override
    public ActionRequestValue initializeActionRequestGraph(ActionRequestValue actionRequest, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        if (actionRequest.getParentActionRequest() != null) {
            LOG.warn((Object)("-->A non parent action request from doc " + document.getDocumentId()));
            actionRequest = KEWServiceLocator.getActionRequestService().getRoot(actionRequest);
        }
        this.propagatePropertiesToRequestGraph(actionRequest, document, nodeInstance);
        return actionRequest;
    }

    private void propagatePropertiesToRequestGraph(ActionRequestValue actionRequest, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        this.setPropertiesToRequest(actionRequest, document, nodeInstance);
        for (ActionRequestValue actionRequestValue : actionRequest.getChildrenRequests()) {
            this.propagatePropertiesToRequestGraph(actionRequestValue, document, nodeInstance);
        }
    }

    private void setPropertiesToRequest(ActionRequestValue actionRequest, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        actionRequest.setDocumentId(document.getDocumentId());
        actionRequest.setDocVersion(document.getDocVersion());
        actionRequest.setRouteLevel(document.getDocRouteLevel());
        actionRequest.setNodeInstance(nodeInstance);
        actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
    }

    @Override
    public List<ActionRequestValue> activateRequests(List<ActionRequestValue> actionRequests) {
        return this.activateRequests(actionRequests, new ActivationContext(false));
    }

    @Override
    public List<ActionRequestValue> activateRequests(List<ActionRequestValue> actionRequests, boolean simulate) {
        return this.activateRequests(actionRequests, new ActivationContext(simulate));
    }

    @Override
    public List<ActionRequestValue> activateRequests(List<ActionRequestValue> actionRequests, ActivationContext activationContext) {
        if (actionRequests == null) {
            return new ArrayList<ActionRequestValue>();
        }
        PerformanceLogger performanceLogger = null;
        if (LOG.isInfoEnabled()) {
            performanceLogger = new PerformanceLogger();
        }
        activationContext.setGeneratedActionItems(new ArrayList<ActionItem>());
        if (!activationContext.isSimulation()) {
            actionRequests = this.saveActionRequests(actionRequests);
        }
        this.activateRequestsInternal(actionRequests, activationContext);
        if (!activationContext.isSimulation()) {
            KEWServiceLocator.getNotificationService().notify(ActionItem.to(activationContext.getGeneratedActionItems()));
        }
        if (LOG.isInfoEnabled()) {
            performanceLogger.log("Time to " + (activationContext.isSimulation() ? "simulate activation of " : "activate ") + actionRequests.size() + " action requests.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generated " + activationContext.getGeneratedActionItems().size() + " action items."));
        }
        return actionRequests;
    }

    @Override
    public ActionRequestValue activateRequest(ActionRequestValue actionRequest) {
        return this.activateRequests(Collections.singletonList(actionRequest), new ActivationContext(false)).get(0);
    }

    @Override
    public ActionRequestValue activateRequest(ActionRequestValue actionRequest, boolean simulate) {
        return this.activateRequests(Collections.singletonList(actionRequest), new ActivationContext(simulate)).get(0);
    }

    @Override
    public ActionRequestValue activateRequest(ActionRequestValue actionRequest, ActivationContext activationContext) {
        return this.activateRequests(Collections.singletonList(actionRequest), activationContext).get(0);
    }

    @Override
    public ActionRequestValue activateRequestNoNotification(ActionRequestValue actionRequest, ActivationContext activationContext) {
        activationContext.setGeneratedActionItems(new ArrayList<ActionItem>());
        actionRequest = this.saveActionRequest(actionRequest, activationContext.isSimulation());
        this.activateRequestInternal(actionRequest, activationContext);
        return actionRequest;
    }

    private void activateRequestsInternal(List<ActionRequestValue> actionRequests, ActivationContext activationContext) {
        if (actionRequests != null) {
            for (ActionRequestValue actionRequest : actionRequests) {
                this.activateRequestInternal(actionRequest, activationContext);
            }
        }
    }

    private void activateRequestInternal(ActionRequestValue actionRequest, ActivationContext activationContext) {
        PerformanceLogger performanceLogger = null;
        if (LOG.isInfoEnabled()) {
            performanceLogger = new PerformanceLogger();
        }
        if (actionRequest == null || actionRequest.isActive() || actionRequest.isDeactivated()) {
            return;
        }
        this.processResponsibilityId(actionRequest);
        if (this.deactivateOnActionAlreadyTaken(actionRequest, activationContext)) {
            return;
        }
        if (this.deactivateOnInactiveGroup(actionRequest, activationContext)) {
            return;
        }
        if (this.deactivateOnEmptyGroup(actionRequest, activationContext)) {
            return;
        }
        actionRequest.setStatus(ActionRequestStatus.ACTIVATED.getCode());
        if (!activationContext.isSimulation()) {
            activationContext.getGeneratedActionItems().addAll(this.generateActionItems(actionRequest, activationContext));
        }
        this.activateRequestsInternal(actionRequest.getChildrenRequests(), activationContext);
        this.activateRequestInternal(actionRequest.getParentActionRequest(), activationContext);
        if (LOG.isInfoEnabled()) {
            if (activationContext.isSimulation()) {
                performanceLogger.log("Time to simulate activation of request.");
            } else {
                performanceLogger.log("Time to activate action request with id " + actionRequest.getActionRequestId());
            }
        }
    }

    private List<ActionItem> generateActionItems(ActionRequestValue actionRequest, ActivationContext activationContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generating the action items for request " + actionRequest.getActionRequestId()));
        }
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
        if (!actionRequest.isPrimaryDelegator()) {
            if (actionRequest.isGroupRequest()) {
                List principalIds = KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId());
                actionItems.addAll(this.createActionItemsForPrincipals(actionRequest, principalIds));
            } else if (actionRequest.isUserRequest()) {
                ActionItem actionItem = this.getActionListService().createActionItemForActionRequest(actionRequest);
                actionItems.add(actionItem);
            }
        }
        ArrayList<ActionItem> actionItemsToReturn = new ArrayList<ActionItem>(actionItems.size());
        if (!activationContext.isSimulation()) {
            for (ActionItem actionItem : actionItems) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Saving action item: " + actionItems));
                }
                actionItem = this.getActionListService().saveActionItem(actionItem);
                actionItemsToReturn.add(actionItem);
            }
        } else {
            actionRequest.getSimulatedActionItems().addAll(actionItems);
            actionItemsToReturn.addAll(actionItems);
        }
        return actionItemsToReturn;
    }

    private List<ActionItem> createActionItemsForPrincipals(ActionRequestValue actionRequest, List<String> principalIds) {
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
        for (String principalId : principalIds) {
            ActionItem actionItem = this.getActionListService().createActionItemForActionRequest(actionRequest);
            actionItem.setPrincipalId(principalId);
            actionItem.setRoleName(actionRequest.getQualifiedRoleName());
            String ignoreUnknownPrincipalIdsValue = ConfigContext.getCurrentContextConfig().getProperty("ignoreUnknownPrincipalIds");
            boolean ignoreUnknownPrincipalIds = Boolean.parseBoolean(ignoreUnknownPrincipalIdsValue);
            if (principalId == null && ignoreUnknownPrincipalIds) {
                LOG.warn((Object)("Ignoring action item with actionRequestID of " + actionRequest.getActionRequestId() + " due to null principalId."));
                continue;
            }
            if (principalId == null) {
                IllegalArgumentException e = new IllegalArgumentException("Exception thrown when trying to add action item with null principalId");
                LOG.error((Object)e);
                throw e;
            }
            actionItems.add(actionItem);
        }
        return actionItems;
    }

    private void processResponsibilityId(ActionRequestValue actionRequest) {
        if (actionRequest.getResolveResponsibility()) {
            String responsibilityId = actionRequest.getResponsibilityId();
            try {
                RouteModule routeModule = KEWServiceLocator.getRouteModuleService().findRouteModule(actionRequest);
                if (responsibilityId != null && actionRequest.isRouteModuleRequest()) {
                    ResponsibleParty responsibleParty;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Resolving responsibility id for action request id=" + actionRequest.getActionRequestId() + " and responsibility id=" + actionRequest.getResponsibilityId()));
                    }
                    if ((responsibleParty = routeModule.resolveResponsibilityId(actionRequest.getResponsibilityId())) == null) {
                        return;
                    }
                    if (responsibleParty.getPrincipalId() != null) {
                        Principal user = KimApiServiceLocator.getIdentityService().getPrincipal(responsibleParty.getPrincipalId());
                        actionRequest.setPrincipalId(user.getPrincipalId());
                    } else if (responsibleParty.getGroupId() != null) {
                        actionRequest.setGroupId(responsibleParty.getGroupId());
                    } else if (responsibleParty.getRoleName() != null) {
                        actionRequest.setRoleName(responsibleParty.getRoleName());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception thrown when trying to resolve responsibility id " + responsibilityId), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean deactivateOnActionAlreadyTaken(ActionRequestValue actionRequestToActivate, ActivationContext activationContext) {
        FutureRequestDocumentStateManager futureRequestStateMngr = null;
        if (actionRequestToActivate.isGroupRequest()) {
            futureRequestStateMngr = new FutureRequestDocumentStateManager(actionRequestToActivate.getRouteHeader(), actionRequestToActivate.getGroup());
        } else if (actionRequestToActivate.isUserRequest()) {
            futureRequestStateMngr = new FutureRequestDocumentStateManager(actionRequestToActivate.getRouteHeader(), actionRequestToActivate.getPrincipalId());
        } else {
            return false;
        }
        if (futureRequestStateMngr.isReceiveFutureRequests()) {
            return false;
        }
        if (!actionRequestToActivate.getForceAction().booleanValue() || futureRequestStateMngr.isDoNotReceiveFutureRequests()) {
            ActionTakenValue previousActionTaken = null;
            previousActionTaken = !activationContext.isSimulation() ? this.getActionTakenService().getPreviousAction(actionRequestToActivate) : this.getActionTakenService().getPreviousAction(actionRequestToActivate, activationContext.getSimulatedActionsTaken());
            if (previousActionTaken != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found a satisfying action taken so setting this request done.  Action Request Id " + actionRequestToActivate.getActionRequestId()));
                }
                if (!previousActionTaken.isForDelegator() && actionRequestToActivate.getParentActionRequest() != null) {
                    previousActionTaken.setDelegator(actionRequestToActivate.getParentActionRequest().getRecipient());
                    if (!activationContext.isSimulation()) {
                        previousActionTaken = this.getActionTakenService().saveActionTaken(previousActionTaken);
                    }
                }
                this.deactivateRequest(previousActionTaken, actionRequestToActivate, null, activationContext);
                return true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Forcing action for action request " + actionRequestToActivate.getActionRequestId()));
        }
        return false;
    }

    protected boolean deactivateOnEmptyGroup(ActionRequestValue actionRequestToActivate, ActivationContext activationContext) {
        if (actionRequestToActivate.isGroupRequest() && KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequestToActivate.getGroup().getId()).isEmpty()) {
            this.deactivateRequest(null, actionRequestToActivate, null, activationContext);
            return true;
        }
        return false;
    }

    protected boolean deactivateOnInactiveGroup(ActionRequestValue actionRequestToActivate, ActivationContext activationContext) {
        if (actionRequestToActivate.isGroupRequest() && !actionRequestToActivate.getGroup().isActive() && !actionRequestToActivate.getRouteHeader().getDocumentType().getFailOnInactiveGroup().getPolicyValue().booleanValue()) {
            this.deactivateRequest(null, actionRequestToActivate, null, activationContext);
            return true;
        }
        return false;
    }

    @Override
    public ActionRequestValue deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest) {
        return this.deactivateRequest(actionTaken, actionRequest, null, new ActivationContext(false));
    }

    @Override
    public ActionRequestValue deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest, ActivationContext activationContext) {
        return this.deactivateRequest(actionTaken, actionRequest, null, activationContext);
    }

    @Override
    public List<ActionRequestValue> deactivateRequests(ActionTakenValue actionTaken, List<ActionRequestValue> actionRequests) {
        return this.deactivateRequests(actionTaken, actionRequests, null, new ActivationContext(false));
    }

    @Override
    public List<ActionRequestValue> deactivateRequests(ActionTakenValue actionTaken, List<ActionRequestValue> actionRequests, boolean simulate) {
        return this.deactivateRequests(actionTaken, actionRequests, null, new ActivationContext(simulate));
    }

    @Override
    public List<ActionRequestValue> deactivateRequests(ActionTakenValue actionTaken, List<ActionRequestValue> actionRequests, ActivationContext activationContext) {
        return this.deactivateRequests(actionTaken, actionRequests, null, activationContext);
    }

    private List<ActionRequestValue> deactivateRequests(ActionTakenValue actionTaken, List<ActionRequestValue> actionRequests, ActionRequestValue deactivationRequester, ActivationContext activationContext) {
        ArrayList<ActionRequestValue> deactivatedRequests = new ArrayList<ActionRequestValue>();
        if (actionRequests != null) {
            for (ActionRequestValue actionRequest : actionRequests) {
                deactivatedRequests.add(this.deactivateRequest(actionTaken, actionRequest, deactivationRequester, activationContext));
            }
        }
        return deactivatedRequests;
    }

    private ActionRequestValue deactivateRequest(ActionTakenValue actionTaken, ActionRequestValue actionRequest, ActionRequestValue deactivationRequester, ActivationContext activationContext) {
        if (actionRequest == null || actionRequest.isDeactivated() || this.haltForAllApprove(actionRequest, deactivationRequester)) {
            return actionRequest;
        }
        actionRequest.setStatus(ActionRequestStatus.DONE.getCode());
        actionRequest.setActionTaken(actionTaken);
        if (!activationContext.isSimulation()) {
            if (actionTaken != null) {
                actionTaken.getActionRequests().add(actionRequest);
            }
            actionRequest = (ActionRequestValue)this.getDataObjectService().save((Object)actionRequest, new PersistenceOption[0]);
            this.deleteActionItems(actionRequest, true);
        }
        actionRequest.setChildrenRequests(this.deactivateRequests(actionTaken, actionRequest.getChildrenRequests(), actionRequest, activationContext));
        actionRequest.setParentActionRequest(this.deactivateRequest(actionTaken, actionRequest.getParentActionRequest(), actionRequest, activationContext));
        return actionRequest;
    }

    private boolean haltForAllApprove(ActionRequestValue actionRequest, ActionRequestValue deactivationRequester) {
        if (ActionRequestPolicy.ALL.getCode().equals(actionRequest.getApprovePolicy()) && actionRequest.hasChild(deactivationRequester)) {
            for (ActionRequestValue childRequest : actionRequest.getChildrenRequests()) {
                if (childRequest.isDeactivated()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ActionRequestValue> getRootRequests(Collection<ActionRequestValue> actionRequests) {
        HashSet<ActionRequestValue> unsavedRequests = new HashSet<ActionRequestValue>();
        HashMap<String, ActionRequestValue> requestMap = new HashMap<String, ActionRequestValue>();
        for (ActionRequestValue actionRequest1 : actionRequests) {
            ActionRequestValue actionRequest = actionRequest1;
            ActionRequestValue rootRequest = this.getRoot(actionRequest);
            if (rootRequest.getActionRequestId() != null) {
                requestMap.put(rootRequest.getActionRequestId(), rootRequest);
                continue;
            }
            unsavedRequests.add(rootRequest);
        }
        ArrayList<ActionRequestValue> requests = new ArrayList<ActionRequestValue>();
        requests.addAll(requestMap.values());
        requests.addAll(unsavedRequests);
        return requests;
    }

    @Override
    public ActionRequestValue getRoot(ActionRequestValue actionRequest) {
        if (actionRequest == null) {
            return null;
        }
        if (actionRequest.getParentActionRequest() != null) {
            return this.getRoot(actionRequest.getParentActionRequest());
        }
        return actionRequest;
    }

    @Override
    public List<ActionRequestValue> findAllPendingRequests(String documentId) {
        return this.findByStatusAndDocId(ActionRequestStatus.ACTIVATED.getCode(), documentId);
    }

    @Override
    public List<ActionRequestValue> findAllValidRequests(String principalId, String documentId, String requestCode) {
        List<ActionRequestValue> pendingArs = this.findByStatusAndDocumentId(ActionRequestStatus.ACTIVATED.getCode(), documentId);
        return this.findAllValidRequests(principalId, pendingArs, requestCode);
    }

    protected List<ActionRequestValue> findByStatusAndDocumentId(String statusCode, String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)STATUS, (Object)statusCode), PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findAllValidRequests(String principalId, List<ActionRequestValue> actionRequests, String requestCode) {
        List arGroups = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        return this.filterActionRequestsByCode(actionRequests, principalId, arGroups, requestCode);
    }

    @Override
    public List<ActionRequestValue> filterActionRequestsByCode(List<ActionRequestValue> actionRequests, String principalId, List<String> principalGroupIds, String requestCode) {
        ArrayList<ActionRequestValue> filteredActionRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue ar : actionRequests) {
            if (ActionRequestValue.compareActionCode(ar.getActionRequested(), requestCode, true) > 0) continue;
            if (ar.isUserRequest() && principalId.equals(ar.getPrincipalId())) {
                filteredActionRequests.add(ar);
                continue;
            }
            if (!ar.isGroupRequest() || principalGroupIds == null || principalGroupIds.isEmpty()) continue;
            for (String groupId : principalGroupIds) {
                if (!groupId.equals(ar.getGroupId())) continue;
                filteredActionRequests.add(ar);
            }
        }
        return filteredActionRequests;
    }

    @Override
    public void updateActionRequestsForResponsibilityChange(Set<String> responsibilityIds) {
        PerformanceLogger performanceLogger = null;
        if (LOG.isInfoEnabled()) {
            performanceLogger = new PerformanceLogger();
        }
        Collection documentsAffected = this.getRouteHeaderService().findPendingByResponsibilityIds(responsibilityIds);
        String cacheWaitValue = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Rule", "RULE_CACHE_REQUEUE_DELAY");
        Long cacheWait = 5000L;
        if (!StringUtils.isEmpty((String)cacheWaitValue)) {
            try {
                cacheWait = Long.valueOf(cacheWaitValue);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Cache wait time is not a valid number: " + cacheWaitValue));
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Scheduling requeue of " + documentsAffected.size() + " documents, affected by " + responsibilityIds.size() + " responsibility changes.  Installing a processing wait time of " + cacheWait + " milliseconds to avoid stale rule cache."));
        }
        for (String documentId : documentsAffected) {
            String applicationId = null;
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByDocumentId(documentId);
            if (documentType != null) {
                applicationId = documentType.getApplicationId();
            }
            if (applicationId == null) {
                applicationId = CoreConfigHelper.getApplicationId();
            }
            if (!documentType.getRegenerateActionRequestsOnChange().getPolicyValue().booleanValue()) continue;
            DocumentRefreshQueue documentRequeuer = KewApiServiceLocator.getDocumentRequeuerService((String)applicationId, (String)documentId, (long)cacheWait);
            documentRequeuer.refreshDocument(documentId);
        }
        if (LOG.isInfoEnabled()) {
            performanceLogger.log("Time to updateActionRequestsForResponsibilityChange");
        }
    }

    @Override
    public void deleteActionRequestGraphNoOutbox(ActionRequestValue actionRequest) {
        this.deleteActionRequestGraph(actionRequest, false);
    }

    @Override
    public void deleteActionRequestGraph(ActionRequestValue actionRequest) {
        this.deleteActionRequestGraph(actionRequest, true);
    }

    protected void deleteActionRequestGraph(ActionRequestValue actionRequest, boolean populateOutbox) {
        ActionTakenValue actionTaken;
        if (actionRequest.getParentActionRequest() != null) {
            throw new IllegalArgumentException("Must delete action request graph from the root, encountered a request with a parent: " + actionRequest);
        }
        this.deleteActionItemsFromGraph(actionRequest, populateOutbox);
        if (actionRequest.getActionTakenId() != null && (actionTaken = this.getActionTakenService().findByActionTakenId(actionRequest.getActionTakenId())) != null) {
            this.getActionTakenService().delete(actionTaken);
        }
        this.getDataObjectService().delete((Object)actionRequest);
        this.getDataObjectService().flush(ActionRequestValue.class);
    }

    private void deleteActionItems(ActionRequestValue actionRequest, boolean populateOutbox) {
        List<ActionItem> actionItems = actionRequest.getActionItems();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleting " + actionItems.size() + " action items for action request: " + actionRequest));
        }
        for (ActionItem actionItem : actionItems) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("deleting action item: " + actionItem));
            }
            if (populateOutbox) {
                this.getActionListService().deleteActionItem(actionItem);
                continue;
            }
            this.getActionListService().deleteActionItemNoOutbox(actionItem);
        }
    }

    private void deleteActionItemsFromGraph(ActionRequestValue actionRequest, boolean populateOutbox) {
        if (actionRequest.getParentActionRequest() != null) {
            throw new IllegalArgumentException("Must delete action item from root of action request graph!");
        }
        ArrayList<ActionItem> actionItemsToDelete = new ArrayList<ActionItem>();
        this.accumulateActionItemsFromGraph(actionRequest, actionItemsToDelete);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleting " + actionItemsToDelete.size() + " action items for action request graph: " + actionRequest));
        }
        for (ActionItem actionItem : actionItemsToDelete) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("deleting action item: " + actionItem));
            }
            if (populateOutbox) {
                this.getActionListService().deleteActionItem(actionItem);
                continue;
            }
            this.getActionListService().deleteActionItemNoOutbox(actionItem);
        }
    }

    private void accumulateActionItemsFromGraph(ActionRequestValue actionRequest, List<ActionItem> actionItems) {
        actionItems.addAll(actionRequest.getActionItems());
        for (ActionRequestValue childRequest : actionRequest.getChildrenRequests()) {
            this.accumulateActionItemsFromGraph(childRequest, actionItems);
        }
    }

    @Override
    public List<ActionRequestValue> findByDocumentIdIgnoreCurrentInd(String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findAllActionRequestsByDocumentId(String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findAllRootActionRequestsByDocumentId(String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), PredicateFactory.isNull((String)PARENT_ACTION_REQUEST)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findPendingByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), PredicateFactory.equal((String)ACTION_REQUESTED, (Object)actionRequestedCd), this.getPendingCriteria()});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<String> getPrincipalIdsWithPendingActionRequestByActionRequestedAndDocId(String actionRequestedCd, String documentId) {
        ArrayList<String> principalIds = new ArrayList<String>();
        List<ActionRequestValue> actionRequests = this.findPendingByActionRequestedAndDocId(actionRequestedCd, documentId);
        for (ActionRequestValue actionRequest : actionRequests) {
            if (actionRequest.isUserRequest()) {
                principalIds.add(actionRequest.getPrincipalId());
                continue;
            }
            if (!actionRequest.isGroupRequest()) continue;
            principalIds.addAll(KimApiServiceLocator.getGroupService().getMemberPrincipalIds(actionRequest.getGroupId()));
        }
        return principalIds;
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocId(String documentId) {
        return this.getRootRequests(this.findPendingByDoc(documentId));
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), PredicateFactory.isNull((String)PARENT_ACTION_REQUEST), this.getPendingCriteria(), PredicateFactory.equal((String)ROUTE_NODE_INSTANCE_ID, (Object)nodeInstanceId)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findRootRequestsByDocIdAtRouteNode(String documentId, String nodeInstanceId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), PredicateFactory.isNull((String)PARENT_ACTION_REQUEST), PredicateFactory.equal((String)ROUTE_NODE_INSTANCE_ID, (Object)nodeInstanceId)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocumentType(String documentTypeId) {
        return this.getActionRequestDAO().findPendingRootRequestsByDocumentType(documentTypeId);
    }

    @Override
    public ActionRequestValue saveActionRequest(ActionRequestValue actionRequest) {
        return this.saveActionRequest(actionRequest, false);
    }

    protected ActionRequestValue saveActionRequest(ActionRequestValue actionRequest, boolean simulation) {
        if (actionRequest.isGroupRequest()) {
            Group group = actionRequest.getGroup();
            if (group == null) {
                throw new RiceRuntimeException("Attempted to save an action request with a non-existent group.");
            }
            if (!group.isActive() && actionRequest.getRouteHeader().getDocumentType().getFailOnInactiveGroup().getPolicyValue().booleanValue()) {
                throw new RiceRuntimeException("Attempted to save an action request with an inactive group.");
            }
        }
        if (actionRequest.getActionRequestId() == null) {
            this.loadDefaultValues(actionRequest);
        }
        if (actionRequest.getAnnotation() != null && actionRequest.getAnnotation().length() > 2000) {
            actionRequest.setAnnotation(StringUtils.abbreviate((String)actionRequest.getAnnotation(), (int)2000));
        }
        if (simulation) {
            return actionRequest;
        }
        return (ActionRequestValue)this.getDataObjectService().save((Object)actionRequest, new PersistenceOption[0]);
    }

    private void loadDefaultValues(ActionRequestValue actionRequest) {
        this.checkNull(actionRequest.getActionRequested(), "action requested");
        this.checkNull(actionRequest.getResponsibilityId(), "responsibility ID");
        this.checkNull(actionRequest.getRouteLevel(), "route level");
        this.checkNull(actionRequest.getDocVersion(), "doc version");
        if (actionRequest.getForceAction() == null) {
            actionRequest.setForceAction(Boolean.FALSE);
        }
        if (actionRequest.getStatus() == null) {
            actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
        }
        if (actionRequest.getPriority() == null) {
            actionRequest.setPriority(1);
        }
        if (actionRequest.getCurrentIndicator() == null) {
            actionRequest.setCurrentIndicator(true);
        }
        actionRequest.setCreateDate(new Timestamp(System.currentTimeMillis()));
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new IllegalArgumentException("Null value for " + valueName);
        }
    }

    private List<ActionRequestValue> saveActionRequests(Collection<ActionRequestValue> actionRequests) {
        ArrayList<ActionRequestValue> savedRequests = new ArrayList<ActionRequestValue>(actionRequests.size());
        for (ActionRequestValue actionRequest : actionRequests) {
            savedRequests.add(this.saveActionRequest(actionRequest));
        }
        return savedRequests;
    }

    @Override
    public List<ActionRequestValue> findPendingByDoc(String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), this.getPendingCriteria()});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findPendingByDocRequestCdNodeName(String documentId, String requestCode, String nodeName) {
        ArrayList<ActionRequestValue> requests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequest : this.findPendingByDoc(documentId)) {
            if (ActionRequestValue.compareActionCode(actionRequest.getActionRequested(), requestCode, true) > 0 || actionRequest.getNodeInstance() == null || !actionRequest.getNodeInstance().getName().equals(nodeName)) continue;
            requests.add(actionRequest);
        }
        return requests;
    }

    @Override
    public List<ActionRequestValue> findActivatedByGroup(String groupId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)STATUS, (Object)ActionRequestStatus.ACTIVATED.getCode()), PredicateFactory.equal((String)GROUP_ID, (Object)groupId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), this.getPendingCriteria()});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public List<ActionRequestValue> findByStatusAndDocId(String statusCode, String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)STATUS, (Object)statusCode), PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        return this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
    }

    @Override
    public Recipient findDelegator(List<ActionRequestValue> actionRequests) {
        Recipient delegator = null;
        String requestCode = "F";
        for (ActionRequestValue actionRequest1 : actionRequests) {
            ActionRequestValue actionRequest = actionRequest1;
            ActionRequestValue delegatorRequest = this.findDelegatorRequest(actionRequest);
            if (delegatorRequest == null || ActionRequestValue.compareActionCode(delegatorRequest.getActionRequested(), requestCode, true) < 0) continue;
            delegator = delegatorRequest.getRecipient();
            requestCode = delegatorRequest.getActionRequested();
        }
        return delegator;
    }

    @Override
    public ActionRequestValue findDelegatorRequest(ActionRequestValue actionRequest) {
        ActionRequestValue parentRequest = actionRequest.getParentActionRequest();
        if (parentRequest != null && !parentRequest.isUserRequest() && !parentRequest.isGroupRequest()) {
            parentRequest = this.findDelegatorRequest(parentRequest);
        }
        return parentRequest;
    }

    @Override
    public List<ActionRequestValue> getDelegateRequests(ActionRequestValue actionRequest) {
        ArrayList<ActionRequestValue> delegateRequests = new ArrayList<ActionRequestValue>();
        List<ActionRequestValue> requests = this.getTopLevelRequests(actionRequest);
        Iterator<ActionRequestValue> i$ = requests.iterator();
        while (i$.hasNext()) {
            ActionRequestValue request;
            ActionRequestValue parentActionRequest = request = i$.next();
            delegateRequests.addAll(parentActionRequest.getChildrenRequests());
        }
        return delegateRequests;
    }

    @Override
    public List<ActionRequestValue> getTopLevelRequests(ActionRequestValue actionRequest) {
        ArrayList<ActionRequestValue> topLevelRequests = new ArrayList<ActionRequestValue>();
        if (actionRequest.isRoleRequest()) {
            topLevelRequests.addAll(actionRequest.getChildrenRequests());
        } else {
            topLevelRequests.add(actionRequest);
        }
        return topLevelRequests;
    }

    @Override
    public boolean doesPrincipalHaveRequest(String principalId, String documentId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)PRINCIPAL_ID, (Object)principalId), PredicateFactory.equal((String)DOCUMENT_ID, (Object)documentId), PredicateFactory.equal((String)RECIPIENT_TYPE_CD, (Object)RecipientType.PRINCIPAL.getCode()), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE)});
        Integer count = this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getTotalRowCount();
        if (count != null && count > 0) {
            return true;
        }
        List<String> groupIds = this.getActionRequestDAO().getRequestGroupIds(documentId);
        for (String groupId : groupIds) {
            if (!KimApiServiceLocator.getGroupService().isMemberOfGroup(principalId, groupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionRequestValue getActionRequestForRole(String actionTakenId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)ACTION_TAKEN_ID, (Object)actionTakenId), PredicateFactory.equal((String)CURRENT_INDICATOR, (Object)Boolean.TRUE), PredicateFactory.equal((String)RECIPIENT_TYPE_CD, (Object)RecipientType.ROLE.getCode()), PredicateFactory.isNull((String)PARENT_ACTION_REQUEST)});
        List actionTakenRoleRequests = this.getDataObjectService().findMatching(ActionRequestValue.class, criteria.build()).getResults();
        if (actionTakenRoleRequests.isEmpty()) {
            return null;
        }
        return (ActionRequestValue)actionTakenRoleRequests.get(0);
    }

    protected Predicate getPendingCriteria() {
        return PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.equal((String)STATUS, (Object)ActionRequestStatus.ACTIVATED.getCode()), PredicateFactory.equal((String)STATUS, (Object)ActionRequestStatus.INITIALIZED.getCode())});
    }

    private ActionListService getActionListService() {
        return KEWServiceLocator.getActionListService();
    }

    private ActionTakenService getActionTakenService() {
        return KEWServiceLocator.getActionTakenService();
    }

    private RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ActionRequestDAO getActionRequestDAO() {
        return this.actionRequestDAO;
    }

    public void setActionRequestDAO(ActionRequestDAO actionRequestDAO) {
        this.actionRequestDAO = actionRequestDAO;
    }
}

