/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.dto;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.reflect.DataDefinition;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.InvalidDocumentContentException;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.definition.AttributeDefinition;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;
import org.kuali.rice.kew.rule.WorkflowAttributeXmlValidator;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.GenericXMLRuleAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DTOConverter {
    private static final Logger LOG = Logger.getLogger(DTOConverter.class);

    public static String buildUpdatedDocumentContent(String existingDocContent, DocumentContentUpdate documentContentUpdate, String documentTypeName) {
        if (existingDocContent == null) {
            existingDocContent = "<documentContent/>";
        }
        String documentContent = "<documentContent/>";
        StandardDocumentContent standardDocContent = new StandardDocumentContent(existingDocContent);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document document = builder.newDocument();
            Element root = document.createElement("documentContent");
            document.appendChild(root);
            Element applicationContentElement = standardDocContent.getApplicationContent();
            if (documentContentUpdate.getApplicationContent() != null) {
                if (!StringUtils.isEmpty((String)documentContentUpdate.getApplicationContent())) {
                    applicationContentElement = document.createElement("applicationContent");
                    XmlHelper.appendXml((Node)applicationContentElement, (String)documentContentUpdate.getApplicationContent());
                } else {
                    applicationContentElement = null;
                }
            }
            Element attributeContentElement = DTOConverter.createDocumentContentSection(document, standardDocContent.getAttributeContent(), documentContentUpdate.getAttributeDefinitions(), documentContentUpdate.getAttributeContent(), "attributeContent", documentTypeName);
            Element searchableContentElement = DTOConverter.createDocumentContentSection(document, standardDocContent.getSearchableContent(), documentContentUpdate.getSearchableDefinitions(), documentContentUpdate.getSearchableContent(), "searchableContent", documentTypeName);
            if (applicationContentElement != null) {
                root.appendChild(applicationContentElement);
            }
            if (attributeContentElement != null) {
                root.appendChild(attributeContentElement);
            }
            if (searchableContentElement != null) {
                root.appendChild(searchableContentElement);
            }
            documentContent = XmlJotter.jotNode((Node)document);
        }
        catch (ParserConfigurationException e) {
            throw new RiceRuntimeException("Failed to initialize XML parser.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new InvalidDocumentContentException("Failed to parse XML.", (Throwable)e);
        }
        catch (IOException e) {
            throw new InvalidDocumentContentException("Failed to parse XML.", (Throwable)e);
        }
        return documentContent;
    }

    private static Element createDocumentContentSection(org.w3c.dom.Document document, Element existingAttributeElement, List<WorkflowAttributeDefinition> definitions, String content, String elementName, String documentTypeName) throws SAXException, IOException, ParserConfigurationException {
        Element contentSectionElement = existingAttributeElement;
        if (content != null) {
            if (!StringUtils.isEmpty((String)content)) {
                contentSectionElement = document.createElement(elementName);
                Element incomingAttributeElement = XmlHelper.readXml((String)content).getDocumentElement();
                NodeList children = incomingAttributeElement.getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    contentSectionElement.appendChild(document.importNode(children.item(index), true));
                }
            } else {
                contentSectionElement = null;
            }
        }
        if (definitions != null && !definitions.isEmpty()) {
            String errorMessage = "";
            boolean inError = false;
            if (contentSectionElement == null) {
                contentSectionElement = document.createElement(elementName);
            }
            for (WorkflowAttributeDefinition definitionVO : definitions) {
                SearchableAttribute searchableAttribute;
                String searchableAttributeContent;
                List<? extends RemotableAttributeErrorContract> errors;
                AttributeDefinition definition = DTOConverter.convertWorkflowAttributeDefinition(definitionVO);
                ExtensionDefinition extensionDefinition = definition.getExtensionDefinition();
                Object attribute = null;
                attribute = GlobalResourceLoader.getObject((ObjectDefinition)definition.getObjectDefinition());
                if (attribute == null) {
                    attribute = GlobalResourceLoader.getService((QName)QName.valueOf(definition.getExtensionDefinition().getResourceDescriptor()));
                }
                if (attribute instanceof XmlConfiguredAttribute) {
                    ((XmlConfiguredAttribute)attribute).setExtensionDefinition(definition.getExtensionDefinition());
                }
                boolean propertiesAsMap = false;
                if ("RuleXmlAttribute".equals(extensionDefinition.getType())) {
                    propertiesAsMap = true;
                }
                if (propertiesAsMap) {
                    for (PropertyDefinition propertyDefinitionVO : definitionVO.getPropertyDefinitions()) {
                        if (!(attribute instanceof GenericXMLRuleAttribute)) continue;
                        ((GenericXMLRuleAttribute)attribute).getParamMap().put(propertyDefinitionVO.getName(), propertyDefinitionVO.getValue());
                    }
                }
                if (attribute instanceof WorkflowAttributeXmlValidator && !(errors = ((WorkflowAttributeXmlValidator)attribute).validateClientRoutingData()).isEmpty()) {
                    inError = true;
                    errorMessage = errorMessage + "Error validating attribute " + definitionVO.getAttributeName() + " ";
                    errorMessage = errorMessage + Joiner.on((String)"; ").join(Iterables.transform(errors, (Function)Functions.toStringFunction()));
                }
                if (inError) continue;
                if (attribute instanceof WorkflowRuleAttribute) {
                    String attributeDocContent = ((WorkflowRuleAttribute)attribute).getDocContent();
                    if (StringUtils.isEmpty((String)attributeDocContent)) continue;
                    XmlHelper.appendXml((Node)contentSectionElement, (String)attributeDocContent);
                    continue;
                }
                if (!(attribute instanceof SearchableAttribute) || StringUtils.isBlank((String)(searchableAttributeContent = (searchableAttribute = (SearchableAttribute)attribute).generateSearchContent(extensionDefinition, documentTypeName, definitionVO)))) continue;
                XmlHelper.appendXml((Node)contentSectionElement, (String)searchableAttributeContent);
            }
            if (inError) {
                throw new WorkflowRuntimeException(errorMessage);
            }
        }
        if (contentSectionElement != null) {
            contentSectionElement = (Element)document.importNode(contentSectionElement, true);
        }
        return contentSectionElement;
    }

    public static AttributeDefinition convertWorkflowAttributeDefinition(WorkflowAttributeDefinition definition) {
        boolean propertiesAsMap;
        if (definition == null) {
            return null;
        }
        ExtensionDefinition extensionDefinition = null;
        List<RuleAttribute> ruleAttribute = KEWServiceLocator.getRuleAttributeService().findByClassName(definition.getAttributeName());
        if (ruleAttribute == null || ruleAttribute.isEmpty()) {
            extensionDefinition = KewApiServiceLocator.getExtensionRepositoryService().getExtensionByName(definition.getAttributeName());
        } else {
            RuleAttribute tmpAttr = ruleAttribute.get(0);
            extensionDefinition = RuleAttribute.to(tmpAttr);
            if (ruleAttribute.size() > 1) {
                LOG.warn((Object)("AttributeDefinition lookup (findByClassName) returned multiple attribute for the same class name. This should not happen, investigation recommended for classname: " + definition.getAttributeName() + " which has " + ruleAttribute.size() + " entries."));
            }
        }
        if (extensionDefinition == null) {
            throw new WorkflowRuntimeException("Extension " + definition.getAttributeName() + " not found");
        }
        ObjectDefinition objectDefinition = new ObjectDefinition(extensionDefinition.getResourceDescriptor());
        if (definition.getParameters() != null) {
            for (String parameter : definition.getParameters()) {
                objectDefinition.addConstructorParameter(new DataDefinition((Object)parameter, String.class));
            }
        }
        boolean bl = propertiesAsMap = "RuleXmlAttribute".equals(extensionDefinition.getType()) || "SearchableXmlAttribute".equals(extensionDefinition.getType());
        if (!propertiesAsMap && definition.getPropertyDefinitions() != null) {
            for (PropertyDefinition propertyDefinition : definition.getPropertyDefinitions()) {
                objectDefinition.addProperty(new org.kuali.rice.core.api.reflect.PropertyDefinition(propertyDefinition.getName(), new DataDefinition((Object)propertyDefinition.getValue(), String.class)));
            }
        }
        return new AttributeDefinition(extensionDefinition, objectDefinition);
    }

    public static DocumentDetail convertDocumentDetailNew(DocumentRouteHeaderValue routeHeader) {
        if (routeHeader == null) {
            return null;
        }
        Document document = DocumentRouteHeaderValue.to(routeHeader);
        DocumentDetail.Builder detail = DocumentDetail.Builder.create((Document)document);
        HashMap<String, org.kuali.rice.kew.engine.node.RouteNodeInstance> nodeInstances = new HashMap<String, org.kuali.rice.kew.engine.node.RouteNodeInstance>();
        ArrayList<ActionRequest> actionRequestVOs = new ArrayList<ActionRequest>();
        List<ActionRequestValue> rootActionRequests = KEWServiceLocator.getActionRequestService().getRootRequests(routeHeader.getActionRequests());
        for (ActionRequestValue actionRequest : rootActionRequests) {
            actionRequestVOs.add(ActionRequestValue.to(actionRequest));
            org.kuali.rice.kew.engine.node.RouteNodeInstance nodeInstance = actionRequest.getNodeInstance();
            if (nodeInstance == null) continue;
            if (nodeInstance.getRouteNodeInstanceId() == null) {
                throw new IllegalStateException("Error creating document detail structure because of NULL node instance id.");
            }
            nodeInstances.put(nodeInstance.getRouteNodeInstanceId(), nodeInstance);
        }
        detail.setActionRequests(actionRequestVOs);
        ArrayList<RouteNodeInstance> nodeInstanceVOs = new ArrayList<RouteNodeInstance>();
        for (org.kuali.rice.kew.engine.node.RouteNodeInstance nodeInstance : nodeInstances.values()) {
            nodeInstanceVOs.add(org.kuali.rice.kew.engine.node.RouteNodeInstance.to(nodeInstance));
        }
        detail.setRouteNodeInstances(nodeInstanceVOs);
        ArrayList<ActionTaken> actionTakenVOs = new ArrayList<ActionTaken>();
        Iterator<ActionTakenValue> i$ = routeHeader.getActionsTaken().iterator();
        while (i$.hasNext()) {
            ActionTakenValue element;
            ActionTakenValue actionTaken = element = i$.next();
            actionTakenVOs.add(ActionTakenValue.to(actionTaken));
        }
        detail.setActionsTaken(actionTakenVOs);
        return detail.build();
    }

    public static interface RouteNodeInstanceLoader {
        public org.kuali.rice.kew.engine.node.RouteNodeInstance load(String var1);
    }
}

