/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.web;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.CustomNoteAttribute;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.service.NoteService;
import org.kuali.rice.kew.notes.web.NoteForm;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class NoteAction
extends KewKualiAction {
    private static final Logger LOG = Logger.getLogger(NoteAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.initForm(request, form);
        return super.execute(mapping, form, request, response);
    }

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        if (StringUtils.isBlank((String)noteForm.getShowEdit())) {
            noteForm.setShowEdit("no");
        }
        return super.start(mapping, (ActionForm)noteForm, request, response);
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        noteForm.setShowEdit("no");
        noteForm.setNoteIdNumber(null);
        this.retrieveNoteList(request, noteForm);
        noteForm.setShowAdd(Boolean.TRUE);
        return this.start(mapping, form, request, response);
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        NoteService noteService = KEWServiceLocator.getNoteService();
        Note note = noteService.getNoteByNoteId(noteForm.getNote().getNoteId());
        noteService.deleteAttachment(note.getAttachments().remove(0));
        noteForm.setDocId(note.getDocumentId());
        noteForm.setNoteIdNumber(note.getNoteId());
        this.edit(mapping, form, request, response);
        return this.start(mapping, form, request, response);
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        if ("yes".equalsIgnoreCase(noteForm.getShowEdit())) {
            noteForm.setNoteIdNumber(noteForm.getNote().getNoteId());
        } else {
            noteForm.setShowEdit("yes");
            Note noteToEdit = this.getNoteService().getNoteByNoteId(noteForm.getNoteIdNumber());
            noteForm.setNote(noteToEdit);
            noteForm.getNote().setNoteCreateLongDate(new Long(noteForm.getNote().getNoteCreateDate().getTime()));
        }
        this.retrieveNoteList(request, noteForm);
        return this.start(mapping, form, request, response);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        Note noteToSave = null;
        if (noteForm.getShowEdit().equals("yes")) {
            noteToSave = noteForm.getNote();
            noteToSave.setNoteCreateDate(new Timestamp(noteToSave.getNoteCreateLongDate()));
        } else {
            noteToSave = new Note();
            noteToSave.setNoteId(null);
            noteToSave.setDocumentId(noteForm.getDocId());
            noteToSave.setNoteCreateDate(new Timestamp(new Date().getTime()));
            noteToSave.setNoteAuthorWorkflowId(NoteAction.getUserSession().getPrincipalId());
            noteToSave.setNoteText(noteForm.getAddText());
        }
        CustomNoteAttribute customNoteAttribute = null;
        DocumentRouteHeaderValue routeHeader = this.getRouteHeaderService().getRouteHeader(noteToSave.getDocumentId());
        boolean canEditNote = false;
        boolean canAddNotes = false;
        if (routeHeader != null && (customNoteAttribute = routeHeader.getCustomNoteAttribute()) != null) {
            customNoteAttribute.setUserSession(GlobalVariables.getUserSession());
            canAddNotes = customNoteAttribute.isAuthorizedToAddNotes();
            canEditNote = customNoteAttribute.isAuthorizedToEditNote(noteToSave);
        }
        if (noteForm.getShowEdit().equals("yes") && canEditNote || !noteForm.getShowEdit().equals("yes") && canAddNotes) {
            FormFile uploadedFile = (FormFile)noteForm.getFile();
            if (uploadedFile != null && StringUtils.isNotBlank((String)uploadedFile.getFileName())) {
                Attachment attachment = new Attachment();
                attachment.setAttachedObject(uploadedFile.getInputStream());
                attachment.setFileName(uploadedFile.getFileName());
                attachment.setMimeType(uploadedFile.getContentType());
                attachment.setNote(noteToSave);
                noteToSave.getAttachments().add(attachment);
            } else if (noteToSave.getNoteId() != null) {
                noteToSave.setAttachments(this.getNoteService().getNoteByNoteId(noteToSave.getNoteId()).getAttachments());
            }
            this.getNoteService().saveNote(noteToSave);
        }
        if (noteForm.getShowEdit().equals("yes")) {
            noteForm.setNote(new Note());
        } else {
            noteForm.setAddText(null);
        }
        noteForm.setShowEdit("no");
        noteForm.setNoteIdNumber(null);
        this.retrieveNoteList(request, noteForm);
        return this.start(mapping, form, request, response);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        Note existingNote = this.getNoteService().getNoteByNoteId(noteForm.getNoteIdNumber());
        this.getNoteService().deleteNote(existingNote);
        noteForm.setShowEdit("no");
        noteForm.setNoteIdNumber(null);
        this.retrieveNoteList(request, noteForm);
        return this.start(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        noteForm.setShowEdit("no");
        noteForm.setNote(new Note());
        noteForm.setNoteIdNumber(null);
        this.retrieveNoteList(request, noteForm);
        return this.start(mapping, form, request, response);
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.start(mapping, form, request, response);
    }

    public ActionMessages initForm(HttpServletRequest request, ActionForm form) throws Exception {
        NoteForm noteForm = (NoteForm)form;
        noteForm.setCurrentUserName(NoteAction.getUserSession().getPerson().getName());
        noteForm.setCurrentDate(this.getCurrentDate());
        if (!("workflowReport".equalsIgnoreCase(noteForm.getMethodToCall()) || "add".equalsIgnoreCase(noteForm.getMethodToCall()) || "cancel".equalsIgnoreCase(noteForm.getMethodToCall()) || "edit".equalsIgnoreCase(noteForm.getMethodToCall()) || "delete".equalsIgnoreCase(noteForm.getMethodToCall()) || "save".equalsIgnoreCase(noteForm.getMethodToCall()))) {
            this.retrieveNoteList(request, noteForm);
        }
        boolean showAttachments = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "All", "SHOW_ATTACHMENTS_IND");
        noteForm.setShowAttachments(new Boolean(showAttachments));
        return null;
    }

    private void retrieveNoteList(HttpServletRequest request, NoteForm noteForm) throws Exception {
        if (noteForm.getDocId() != null) {
            CustomNoteAttribute customNoteAttribute = null;
            DocumentRouteHeaderValue routeHeader = this.getRouteHeaderService().getRouteHeader(noteForm.getDocId());
            List<Note> allNotes = routeHeader.getNotes();
            boolean canAddNotes = false;
            if (routeHeader != null && (customNoteAttribute = routeHeader.getCustomNoteAttribute()) != null) {
                customNoteAttribute.setUserSession(GlobalVariables.getUserSession());
                canAddNotes = customNoteAttribute.isAuthorizedToAddNotes();
            }
            for (Note singleNote : allNotes) {
                singleNote.setNoteCreateLongDate(new Long(singleNote.getNoteCreateDate().getTime()));
                this.getAuthorData(singleNote);
                boolean canEditNote = false;
                if (customNoteAttribute != null) {
                    canEditNote = customNoteAttribute.isAuthorizedToEditNote(singleNote);
                }
                singleNote.setAuthorizedToEdit(new Boolean(canEditNote));
                if (!StringUtils.equals((String)noteForm.getNoteIdNumber(), (String)singleNote.getNoteId())) continue;
                singleNote.setEditingNote(Boolean.TRUE);
            }
            if (noteForm.getSortNotes() != null && noteForm.getSortNotes().booleanValue()) {
                if ("DESCENDING".equalsIgnoreCase(noteForm.getSortOrder())) {
                    noteForm.setSortOrder("ASCENDING");
                    noteForm.setSortNotes(Boolean.FALSE);
                } else {
                    noteForm.setSortOrder("DESCENDING");
                    noteForm.setSortNotes(Boolean.FALSE);
                }
            } else {
                noteForm.setSortOrder(noteForm.getSortOrder());
            }
            noteForm.setNoteList(this.sortNotes(allNotes, noteForm.getSortOrder()));
            noteForm.setNumberOfNotes(new Integer(allNotes.size()));
            noteForm.setAuthorizedToAdd(new Boolean(canAddNotes));
            noteForm.setShowAdd(Boolean.TRUE);
            if (!canAddNotes) {
                noteForm.setShowAdd(Boolean.FALSE);
            } else if (noteForm.getNoteList().size() == 0) {
                noteForm.setShowAdd(Boolean.FALSE);
            }
        }
    }

    private void getAuthorData(Note note) throws Exception {
        Person user = null;
        String id = "";
        if (note != null && note.getNoteAuthorWorkflowId() != null && !"".equalsIgnoreCase(note.getNoteAuthorWorkflowId())) {
            user = KimApiServiceLocator.getPersonService().getPerson(note.getNoteAuthorWorkflowId());
            id = note.getNoteAuthorWorkflowId();
        }
        if (user != null) {
            note.setNoteAuthorFullName(user.getName());
            note.setNoteAuthorEmailAddress(user.getEmailAddressUnmasked());
            note.setNoteAuthorNetworkId(user.getPrincipalId());
        } else {
            note.setNoteAuthorFullName(id + " (Name not Available)");
            note.setNoteAuthorEmailAddress("Not Available");
            note.setNoteAuthorNetworkId("Not Available");
        }
    }

    public String getCurrentDate() {
        Date currentDate = new Date();
        DateFormat dateFormat = RiceConstants.getDefaultDateFormat();
        return dateFormat.format(currentDate);
    }

    private List<Note> sortNotes(List<Note> allNotes, String sortOrder) {
        final int returnCode = "DESCENDING".equalsIgnoreCase(sortOrder) ? -1 : 1;
        try {
            Collections.sort(allNotes, new Comparator<Note>(){

                @Override
                public int compare(Note o1, Note o2) {
                    Timestamp date2;
                    Timestamp date1 = o1.getNoteCreateDate();
                    if (date1.before(date2 = o2.getNoteCreateDate())) {
                        return returnCode * -1;
                    }
                    if (date1.after(date2)) {
                        return returnCode;
                    }
                    return 0;
                }
            });
        }
        catch (Throwable e) {
            LOG.error((Object)e.getMessage(), e);
        }
        return allNotes;
    }

    private NoteService getNoteService() {
        return (NoteService)KEWServiceLocator.getService("enNoteService");
    }

    private RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
    }

    private static UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }
}

