/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderContainer;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.PluginEnvironment;
import org.kuali.rice.kew.plugin.PluginRegistry;

public abstract class BasePluginRegistry
extends ResourceLoaderContainer
implements PluginRegistry {
    private List<PluginEnvironment> pluginEnvironments = Collections.synchronizedList(new ArrayList());

    public BasePluginRegistry() {
        super(new QName(CoreConfigHelper.getApplicationId(), "pluginRegistryResourceLoader"));
    }

    public BasePluginRegistry(QName name) {
        super(name);
    }

    @Override
    public PluginEnvironment getPluginEnvironment(String pluginName) {
        for (PluginEnvironment environment : this.pluginEnvironments) {
            if (!environment.getPluginName().equals(pluginName)) continue;
            return environment;
        }
        return null;
    }

    @Override
    public void addPluginEnvironment(PluginEnvironment pluginEnvironment) {
        if (pluginEnvironment.getPlugin() != null && !this.containsResourceLoader((ResourceLoader)pluginEnvironment.getPlugin())) {
            this.addResourceLoader((ResourceLoader)pluginEnvironment.getPlugin());
        }
        this.pluginEnvironments.add(pluginEnvironment);
    }

    @Override
    public PluginEnvironment removePluginEnvironment(String pluginName) {
        PluginEnvironment environment = this.getPluginEnvironment(pluginName);
        if (environment == null) {
            return null;
        }
        if (environment.getPlugin() != null) {
            super.removeResourceLoader(environment.getPlugin().getName());
        }
        if (!this.pluginEnvironments.remove(environment)) {
            return null;
        }
        return environment;
    }

    public Plugin getPlugin(QName pluginName) {
        return (Plugin)this.getResourceLoader(pluginName);
    }

    public List<QName> getPluginNames() {
        return super.getResourceLoaderNames();
    }

    @Override
    public List<PluginEnvironment> getPluginEnvironments() {
        return Collections.unmodifiableList(this.pluginEnvironments);
    }
}

