/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericAttributeContent {
    private static final XPathExpression NAME_EXPR;
    private static final XPathExpression VALUE_EXPR;
    private static final XPathExpression FIELD_EXPR;
    private final Logger log;
    private final String elementName;
    private final XPathExpression attr_expr;

    public GenericAttributeContent(Class clazz) {
        this(clazz.getName());
    }

    public GenericAttributeContent(String elementName) {
        this.elementName = elementName;
        this.log = Logger.getLogger((String)(GenericAttributeContent.class + "[" + elementName + "]"));
        try {
            this.attr_expr = XPathFactory.newInstance().newXPath().compile(elementName);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
    }

    public String generateContent(Map<String, String> properties) {
        if (properties.size() == 0) {
            return "<" + this.elementName + "/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<" + this.elementName + ">\r\n");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            sb.append("  <field>\r\n");
            if (key != null) {
                sb.append("    <name>" + key + "</name>\r\n");
            } else {
                this.log.warn((Object)"null key encountered");
            }
            String value = entry.getValue();
            if (value != null) {
                sb.append("    <value>" + entry.getValue() + "</value>\r\n");
            } else {
                this.log.warn((Object)("null value encountered for key: " + key));
            }
            sb.append("  </field>\r\n");
        }
        sb.append("</" + this.elementName + ">\r\n");
        return sb.toString();
    }

    public List<Map<String, String>> parseContent(Element attributeContent) throws XPathExpressionException {
        ArrayList<Map<String, String>> attrs = new ArrayList<Map<String, String>>();
        if (attributeContent == null) {
            return attrs;
        }
        this.log.info((Object)("Parsing content: " + XmlJotter.jotNode((Node)attributeContent)));
        NodeList attrNodes = (NodeList)this.attr_expr.evaluate(attributeContent, XPathConstants.NODESET);
        if (attrNodes != null) {
            for (int i = 0; i < attrNodes.getLength(); ++i) {
                HashMap<String, String> props = new HashMap<String, String>();
                attrs.add(props);
                Node node = attrNodes.item(i);
                this.log.info((Object)("Found matching attribute: " + XmlJotter.jotNode((Node)node)));
                NodeList fieldNodes = (NodeList)FIELD_EXPR.evaluate(node, XPathConstants.NODESET);
                for (int j = 0; j < fieldNodes.getLength(); ++j) {
                    node = fieldNodes.item(j);
                    this.log.info((Object)("Found matching attribute content field: " + XmlJotter.jotNode((Node)node)));
                    Boolean b = (Boolean)NAME_EXPR.evaluate(node, XPathConstants.BOOLEAN);
                    if (!b.booleanValue()) {
                        this.log.error((Object)"Encountered field with no name, skipping!");
                        continue;
                    }
                    String name = NAME_EXPR.evaluate(node);
                    b = (Boolean)VALUE_EXPR.evaluate(node, XPathConstants.BOOLEAN);
                    String value = null;
                    if (b.booleanValue()) {
                        value = VALUE_EXPR.evaluate(node);
                    } else {
                        this.log.warn((Object)("No value defined for transmitted field named: " + name));
                    }
                    this.log.info((Object)("Matching attribute content field value: " + name + "=" + value));
                    props.put(name, value);
                }
            }
        }
        return attrs;
    }

    static {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NAME_EXPR = xpath.compile("name");
            VALUE_EXPR = xpath.compile("value");
            FIELD_EXPR = xpath.compile("field");
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
    }
}

