/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleDelegationContract;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREW_DLGN_RSP_T")
public class RuleDelegationBo
extends PersistableBusinessObjectBase
implements RuleDelegationContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 7989203310473741293L;
    @Id
    @PortableSequenceGenerator(name="KREW_RTE_TMPL_S")
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @Column(name="DLGN_RULE_ID")
    private String ruleDelegationId;
    @Column(name="RSP_ID")
    private String responsibilityId;
    @Column(name="DLGN_RULE_BASE_VAL_ID", insertable=false, updatable=false)
    private String delegateRuleId;
    @Column(name="DLGN_TYP")
    private String delegationTypeCode = DelegationType.PRIMARY.getCode();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="DLGN_RULE_BASE_VAL_ID", nullable=false)
    private RuleBaseValues delegationRule;
    @Transient
    private String groupReviewerName;
    @Transient
    private String groupReviewerNamespace;
    @Transient
    private String personReviewer;
    @Transient
    private String personReviewerType;

    public Object copy(boolean preserveKeys) {
        RuleDelegationBo clone = new RuleDelegationBo();
        if (this._persistence_get_ruleDelegationId() != null && preserveKeys) {
            clone.setRuleDelegationId(this._persistence_get_ruleDelegationId());
        }
        clone.setDelegationRule(this._persistence_get_delegationRule());
        clone.setDelegateRuleId(this._persistence_get_delegationRule().getId());
        if (this._persistence_get_delegationTypeCode() != null) {
            clone.setDelegationType(DelegationType.fromCode((String)this._persistence_get_delegationTypeCode()));
        }
        return clone;
    }

    public String getDelegateRuleId() {
        return this._persistence_get_delegateRuleId();
    }

    public void setDelegateRuleId(String delegateRuleId) {
        this._persistence_set_delegateRuleId(delegateRuleId);
    }

    public RuleBaseValues getDelegationRule() {
        return this._persistence_get_delegationRule();
    }

    public RuleBaseValues getDelegationRuleBaseValues() {
        return this._persistence_get_delegationRule();
    }

    public void setDelegationRuleBaseValues(RuleBaseValues delegationRuleBaseValues) {
        this._persistence_set_delegationRule(delegationRuleBaseValues);
    }

    public void setDelegationRule(RuleBaseValues delegationRule) {
        this._persistence_set_delegationRule(delegationRule);
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        DelegationType.fromCode((String)delegationTypeCode);
        this._persistence_set_delegationTypeCode(delegationTypeCode);
    }

    public String getDelegationTypeCode() {
        return this._persistence_get_delegationTypeCode();
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this._persistence_get_delegationTypeCode());
    }

    public void setDelegationType(DelegationType delegationType) {
        this._persistence_set_delegationTypeCode(delegationType.getCode());
    }

    public String getRuleDelegationId() {
        return this._persistence_get_ruleDelegationId();
    }

    public void setRuleDelegationId(String ruleDelegationId) {
        this._persistence_set_ruleDelegationId(ruleDelegationId);
    }

    public RuleResponsibilityBo getRuleResponsibility() {
        if (this.getResponsibilityId() == null) {
            return null;
        }
        return KEWServiceLocator.getRuleService().findRuleResponsibility(this.getResponsibilityId());
    }

    public DocumentType getDocumentType() {
        return this.getDelegationRule().getDocumentType();
    }

    public String getResponsibilityId() {
        return this._persistence_get_responsibilityId();
    }

    public void setResponsibilityId(String ruleResponsibilityId) {
        this._persistence_set_responsibilityId(ruleResponsibilityId);
    }

    public String getGroupReviewerName() {
        return this.groupReviewerName;
    }

    public String getGroupReviewerNamespace() {
        return this.groupReviewerNamespace;
    }

    public String getPersonReviewer() {
        return this.personReviewer;
    }

    public void setGroupReviewerName(String groupReviewerName) {
        this.groupReviewerName = groupReviewerName;
    }

    public void setGroupReviewerNamespace(String groupReviewerNamespace) {
        this.groupReviewerNamespace = groupReviewerNamespace;
    }

    public void setPersonReviewer(String personReviewer) {
        this.personReviewer = personReviewer;
    }

    public String getPersonReviewerType() {
        return this.personReviewerType;
    }

    public void setPersonReviewerType(String personReviewerType) {
        this.personReviewerType = personReviewerType;
    }

    public GroupBo getGroupBo() {
        GroupBo groupBo = null;
        if (StringUtils.isNotBlank((String)this.getGroupReviewerName()) && StringUtils.isNotBlank((String)this.getGroupReviewerNamespace()) && groupBo == null) {
            groupBo = GroupBo.from((Group)KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(this.getGroupReviewerNamespace(), this.getGroupReviewerName()));
        }
        return groupBo;
    }

    public PersonImpl getPersonImpl() {
        return new PersonImpl();
    }

    public static RuleDelegation to(RuleDelegationBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleDelegation.Builder.create((RuleDelegationContract)bo).build();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RuleDelegationBo();
    }

    public Object _persistence_get(String string) {
        if (string == "delegateRuleId") {
            return this.delegateRuleId;
        }
        if (string == "responsibilityId") {
            return this.responsibilityId;
        }
        if (string == "delegationTypeCode") {
            return this.delegationTypeCode;
        }
        if (string == "ruleDelegationId") {
            return this.ruleDelegationId;
        }
        if (string == "delegationRule") {
            return this.delegationRule;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "delegateRuleId") {
            this.delegateRuleId = (String)object;
            return;
        }
        if (string == "responsibilityId") {
            this.responsibilityId = (String)object;
            return;
        }
        if (string == "delegationTypeCode") {
            this.delegationTypeCode = (String)object;
            return;
        }
        if (string == "ruleDelegationId") {
            this.ruleDelegationId = (String)object;
            return;
        }
        if (string == "delegationRule") {
            this.delegationRule = (RuleBaseValues)((Object)object);
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_delegateRuleId() {
        this._persistence_checkFetched("delegateRuleId");
        return this.delegateRuleId;
    }

    public void _persistence_set_delegateRuleId(String string) {
        this._persistence_checkFetchedForSet("delegateRuleId");
        this._persistence_propertyChange("delegateRuleId", this.delegateRuleId, string);
        this.delegateRuleId = string;
    }

    public String _persistence_get_responsibilityId() {
        this._persistence_checkFetched("responsibilityId");
        return this.responsibilityId;
    }

    public void _persistence_set_responsibilityId(String string) {
        this._persistence_checkFetchedForSet("responsibilityId");
        this._persistence_propertyChange("responsibilityId", this.responsibilityId, string);
        this.responsibilityId = string;
    }

    public String _persistence_get_delegationTypeCode() {
        this._persistence_checkFetched("delegationTypeCode");
        return this.delegationTypeCode;
    }

    public void _persistence_set_delegationTypeCode(String string) {
        this._persistence_checkFetchedForSet("delegationTypeCode");
        this._persistence_propertyChange("delegationTypeCode", this.delegationTypeCode, string);
        this.delegationTypeCode = string;
    }

    public String _persistence_get_ruleDelegationId() {
        this._persistence_checkFetched("ruleDelegationId");
        return this.ruleDelegationId;
    }

    public void _persistence_set_ruleDelegationId(String string) {
        this._persistence_checkFetchedForSet("ruleDelegationId");
        this._persistence_propertyChange("ruleDelegationId", this.ruleDelegationId, string);
        this.ruleDelegationId = string;
    }

    public RuleBaseValues _persistence_get_delegationRule() {
        this._persistence_checkFetched("delegationRule");
        return this.delegationRule;
    }

    public void _persistence_set_delegationRule(RuleBaseValues ruleBaseValues) {
        this._persistence_checkFetchedForSet("delegationRule");
        this._persistence_propertyChange("delegationRule", (Object)this.delegationRule, (Object)ruleBaseValues);
        this.delegationRule = ruleBaseValues;
    }
}

