/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.CollectionFormatter;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.lookupable.MyColumns;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.AbstractRuleLookupableHelperServiceImpl;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.service.RuleDelegationService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.comparator.CellComparatorHelper;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class RuleDelegationLookupableHelperServiceImpl
extends AbstractRuleLookupableHelperServiceImpl {
    private static final String PARENT_RESPONSIBILITY_ID_PROPERTY_NAME = "responsibilityId";
    private static final String PARENT_RULE_ID_PROPERTY_NAME = "ruleResponsibility.ruleBaseValuesId";
    private static final String RULE_TEMPLATE_PROPERTY_NAME = "delegationRule.ruleTemplate.name";
    private static final String RULE_ID_PROPERTY_NAME = "delegationRule.id";
    private static final String ACTIVE_IND_PROPERTY_NAME = "delegationRule.active";
    private static final String DELEGATION_PROPERTY_NAME = "delegationType";
    private static final String DOC_TYP_NAME_PROPERTY_NAME = "delegationRule.documentType.name";
    private static final String RULE_DESC_PROPERTY_NAME = "delegationRule.description";

    public boolean checkForAdditionalFields(Map<String, String> fieldValues) {
        String ruleTemplateNameParam = fieldValues.get(RULE_TEMPLATE_PROPERTY_NAME);
        return super.checkForAdditionalFields(fieldValues, ruleTemplateNameParam);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        Principal principal;
        String parentRuleBaseValueId = fieldValues.get(PARENT_RULE_ID_PROPERTY_NAME);
        String parentResponsibilityId = fieldValues.get(PARENT_RESPONSIBILITY_ID_PROPERTY_NAME);
        String docTypeNameParam = fieldValues.get(DOC_TYP_NAME_PROPERTY_NAME);
        String ruleTemplateIdParam = null;
        String ruleTemplateNameParam = fieldValues.get(RULE_TEMPLATE_PROPERTY_NAME);
        String groupIdParam = fieldValues.get("groupReviewer");
        String groupNameParam = fieldValues.get("groupReviewerName");
        String groupNamespaceParam = fieldValues.get("groupReviewerNamespace");
        String networkIdParam = fieldValues.get("personReviewer");
        String userDirectiveParam = fieldValues.get("personReviewerType");
        String activeParam = fieldValues.get(ACTIVE_IND_PROPERTY_NAME);
        String delegationParam = fieldValues.get(DELEGATION_PROPERTY_NAME);
        String ruleIdParam = fieldValues.get(RULE_ID_PROPERTY_NAME);
        String ruleDescription = fieldValues.get(RULE_DESC_PROPERTY_NAME);
        String docTypeSearchName = null;
        String workflowId = null;
        String workgroupId = null;
        String ruleTemplateId = null;
        Boolean isActive = null;
        String ruleId = null;
        if (ruleIdParam != null && !"".equals(ruleIdParam.trim())) {
            ruleId = ruleIdParam.trim();
        }
        if (!activeParam.equals("")) {
            isActive = activeParam.equals("Y") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (docTypeNameParam != null && !"".equals(docTypeNameParam.trim())) {
            docTypeSearchName = docTypeNameParam.replace('*', '%');
            docTypeSearchName = "%" + docTypeSearchName.trim() + "%";
        }
        if (StringUtils.isNotBlank((String)networkIdParam) && (principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(networkIdParam)) != null) {
            workflowId = principal.getPrincipalId();
        }
        if (StringUtils.isNotBlank((String)groupIdParam) || StringUtils.isNotBlank((String)groupNameParam)) {
            Group group = null;
            if (groupIdParam != null && !"".equals(groupIdParam)) {
                group = this.getGroupService().getGroup(groupIdParam.trim());
            } else {
                if (groupNamespaceParam == null) {
                    groupNamespaceParam = "KUALI";
                }
                if ((group = this.getGroupService().getGroupByNamespaceCodeAndName(groupNamespaceParam, groupNameParam.trim())) == null) {
                    GlobalVariables.getMessageMap().putError("groupReviewerNamespace", "error.custom", new String[]{"The Group Reviewer Namespace and Name combination is not valid"});
                } else {
                    workgroupId = group.getId();
                }
            }
        }
        HashMap<String, String> attributes = null;
        MyColumns myColumns = new MyColumns();
        if (StringUtils.isNotBlank((String)ruleTemplateNameParam) || StringUtils.isNotBlank(ruleTemplateIdParam) && !"null".equals(ruleTemplateIdParam)) {
            RuleTemplate ruleTemplate = null;
            if (StringUtils.isNotBlank(ruleTemplateIdParam)) {
                ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplate(ruleTemplateIdParam);
            } else {
                ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplateByName(ruleTemplateNameParam.trim());
                ruleTemplateId = ruleTemplate.getId();
            }
            if (ruleTemplate == null) {
                super.clearRows();
                LOG.info((Object)"Returning empty result set for Delegation Rule Lookup because a RuleTemplate Name or ID was provided, but no valid RuleTemplates were retrieved by the service.");
                return new ArrayList();
            }
            attributes = new HashMap<String, String>();
            for (RuleTemplateAttribute ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
                WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getSearchRows(fieldValues, ruleTemplateAttribute, false);
                for (RemotableAttributeError error : workflowRuleAttributeRows.getValidationErrors()) {
                    GlobalVariables.getMessageMap().putError(error.getAttributeName(), "error.custom", new String[]{error.getMessage()});
                }
                for (Row row : workflowRuleAttributeRows.getRows()) {
                    for (Field field : row.getFields()) {
                        String attributeParam;
                        if (fieldValues.get(field.getPropertyName()) != null && !(attributeParam = fieldValues.get(field.getPropertyName())).equals("")) {
                            attributes.put(field.getPropertyName(), attributeParam.trim());
                        }
                        if (!field.getFieldType().equals("text") && !field.getFieldType().equals("dropdown") && !field.getFieldType().equals("dropdown_refresh") && !field.getFieldType().equals("radio")) continue;
                        myColumns.getColumns().add((KeyValue)new ConcreteKeyValue(field.getPropertyName(), ruleTemplateAttribute.getId()));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((String)ruleDescription)) {
            ruleDescription = ruleDescription.replace('*', '%');
            ruleDescription = "%" + ruleDescription.trim() + "%";
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("errors in search criteria");
        }
        Iterator<Object> rules = Collections.emptyList().iterator();
        List<RuleDelegationBo> ruleDelegationBos = this.getRuleDelegationService().search(parentRuleBaseValueId, parentResponsibilityId, docTypeSearchName, ruleId, ruleTemplateId, ruleDescription, workgroupId, workflowId, delegationParam, isActive, attributes, userDirectiveParam);
        if (ruleDelegationBos != null) {
            rules = ruleDelegationBos.iterator();
        }
        ArrayList<RuleDelegationBo> displayList = new ArrayList<RuleDelegationBo>();
        while (rules.hasNext()) {
            RuleDelegationBo ruleDelegation = (RuleDelegationBo)((Object)rules.next());
            RuleBaseValues record = ruleDelegation.getDelegationRule();
            if (StringUtils.isBlank((String)record.getDescription())) {
                record.setDescription("&nbsp;");
            }
            if (ruleTemplateNameParam != null && !ruleTemplateNameParam.trim().equals("") || ruleTemplateIdParam != null && !"".equals(ruleTemplateIdParam) && !"null".equals(ruleTemplateIdParam)) {
                MyColumns myNewColumns = new MyColumns();
                for (Object object : myColumns.getColumns()) {
                    KeyValue pair = (KeyValue)object;
                    List<RuleExtensionBo> ruleExts = record.getRuleExtensions();
                    for (RuleExtensionBo ruleExt : ruleExts) {
                        if (!ruleExt.getExtensionValuesMap().containsKey(pair.getKey().toString())) continue;
                        ruleTemplateIdParam = ruleExt.getRuleTemplateAttributeId();
                    }
                    ConcreteKeyValue newPair = record.getRuleExtensionValue(ruleTemplateIdParam, pair.getKey().toString()) != null ? new ConcreteKeyValue(pair.getKey(), record.getRuleExtensionValue(ruleTemplateIdParam, pair.getKey().toString()).getValue()) : new ConcreteKeyValue(pair.getKey(), "&nbsp;");
                    myNewColumns.getColumns().add((KeyValue)newPair);
                    record.getFieldValues().put(newPair.getKey(), newPair.getValue());
                }
                record.setMyColumns(myNewColumns);
            }
            StringBuilder returnUrl = new StringBuilder("<a href=\"");
            returnUrl.append(fieldValues.get("backLocation")).append("?methodToCall=refresh&docFormKey=").append(fieldValues.get("docFormKey")).append("&");
            returnUrl.append(RULE_ID_PROPERTY_NAME);
            returnUrl.append("=").append(record.getId()).append("\">return value</a>");
            record.setReturnUrl(returnUrl.toString());
            String destinationUrl = "<a href=\"Rule.do?methodToCall=report&currentRuleId=" + record.getId() + "\">report</a>";
            record.setDestinationUrl(destinationUrl);
            displayList.add(ruleDelegation);
        }
        return displayList;
    }

    private RuleDelegationService getRuleDelegationService() {
        return (RuleDelegationService)KEWServiceLocator.getService("enRuleDelegationService");
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        List displayList = bounded ? this.getSearchResults(lookupForm.getFieldsForLookup()) : this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        boolean hasReturnableRow = false;
        List returnKeys = this.getReturnKeys();
        List pkNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : displayList) {
            if (element instanceof PersistableBusinessObject) {
                lookupForm.setLookupObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            HtmlData returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions);
            String actionUrls = this.getActionUrls(element, pkNames, businessObjectRestrictions);
            if ("".equals(actionUrls)) {
                actionUrls = "&nbsp;";
            }
            List<Column> columns = this.getColumns();
            Iterator<Column> i$ = columns.iterator();
            while (i$.hasNext()) {
                Class propClass;
                Column element2;
                Column col = element2 = i$.next();
                String curPropName = col.getPropertyName();
                Formatter formatter = col.getFormatter();
                String propValue = "";
                Object prop = null;
                boolean skipPropTypeCheck = false;
                if (element instanceof RuleDelegationBo) {
                    prop = ((RuleDelegationBo)element).getDelegationRule().getFieldValues().get(curPropName);
                    skipPropTypeCheck = true;
                }
                if (prop == null) {
                    prop = KradDataServiceLocator.getDataObjectService().wrap((Object)element).getPropertyValueNullSafe(curPropName);
                }
                if ((propClass = (Class)propertyTypes.get(curPropName)) == null && !skipPropTypeCheck) {
                    try {
                        propClass = KRADServiceLocatorWeb.getLegacyDataAdapter().getPropertyType((Object)element, col.getPropertyName());
                        propertyTypes.put(curPropName, propClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot access PropertyType for property '" + curPropName + "' " + " on an instance of '" + element.getClass().getName() + "'.", e);
                    }
                }
                if (prop != null) {
                    if (prop instanceof Boolean) {
                        formatter = new BooleanFormatter();
                    }
                    if (prop instanceof Date) {
                        formatter = new DateFormatter();
                    }
                    if (prop instanceof Collection && formatter == null) {
                        formatter = new CollectionFormatter();
                    }
                    propValue = formatter != null ? (String)formatter.format(prop) : prop.toString();
                }
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element.getClass(), curPropName, propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (!StringUtils.isNotBlank((String)propValue)) continue;
                col.setColumnAnchor(this.getInquiryUrl(element, curPropName));
            }
            ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), actionUrls);
            row.setRowId(returnUrl.getName());
            row.setReturnUrlHtmlData(returnUrl);
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            if (element instanceof PersistableBusinessObject) {
                row.setObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        RuleDelegationBo ruleDelegation = (RuleDelegationBo)businessObject;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (StringUtils.isNotBlank((String)ruleDelegation.getDelegationRule().getRuleTemplateName()) && StringUtils.isNotBlank((String)this.getMaintenanceDocumentTypeName())) {
            if (this.allowsMaintenanceEditAction(businessObject)) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
            }
            if (this.allowsMaintenanceNewOrCopyAction()) {
                htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
            }
        }
        return htmlDataList;
    }
}

