/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.api.rule.RuleTemplateAttributeContract;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleValidationAttribute;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.Boolean01BigDecimalConverter;

@Entity
@Table(name="KREW_RULE_TMPL_ATTR_T")
public class RuleTemplateAttributeBo
extends PersistableBusinessObjectBase
implements Comparable<RuleTemplateAttributeBo>,
MutableInactivatable,
RuleTemplateAttributeContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -3580049225424553828L;
    @Id
    @PortableSequenceGenerator(name="KREW_RTE_TMPL_S")
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @Column(name="RULE_TMPL_ATTR_ID")
    private String id;
    @Column(name="RULE_ATTR_ID", insertable=false, updatable=false)
    private String ruleAttributeId;
    @Column(name="REQ_IND")
    @Convert(converter=Boolean01BigDecimalConverter.class)
    private Boolean required = Boolean.FALSE;
    @Column(name="ACTV_IND")
    @Convert(converter=Boolean01BigDecimalConverter.class)
    private Boolean active = Boolean.TRUE;
    @Column(name="DSPL_ORD")
    private Integer displayOrder;
    @Column(name="DFLT_VAL")
    private String defaultValue;
    @Transient
    private String ruleTemplateId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="RULE_TMPL_ID", nullable=false)
    private RuleTemplateBo ruleTemplate;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_ATTR_ID")
    private RuleAttribute ruleAttribute;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="ruleTemplateAttribute")
    private List<RuleExtensionBo> ruleExtensions;

    @Override
    public int compareTo(RuleTemplateAttributeBo ruleTemplateAttribute) {
        if (this.getDisplayOrder() != null && ruleTemplateAttribute.getDisplayOrder() != null) {
            return this.getDisplayOrder().compareTo(ruleTemplateAttribute.getDisplayOrder());
        }
        return 0;
    }

    public Object getAttribute() {
        try {
            Object attribute = ExtensionUtils.loadExtension((ExtensionDefinitionContract)RuleAttribute.to(this.getRuleAttribute()), (String)this.getRuleAttribute().getApplicationId());
            if (attribute == null) {
                throw new WorkflowRuntimeException("Could not find attribute " + this.getRuleAttribute().getName());
            }
            if (attribute instanceof WorkflowRuleAttribute) {
                ((WorkflowRuleAttribute)attribute).setRequired(this._persistence_get_required());
            }
            return attribute;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught error attempting to load attribute class: " + this.getRuleAttribute().getResourceDescriptor(), e);
        }
    }

    public boolean isWorkflowAttribute() {
        return this.getRuleAttribute().isWorkflowAttribute();
    }

    public boolean isRuleValidationAttribute() {
        return "RuleValidationAttribute".equals(this.getRuleAttribute().getType());
    }

    public WorkflowRuleAttribute getWorkflowAttribute() {
        try {
            Object tempAttr = ExtensionUtils.loadExtension((ExtensionDefinitionContract)RuleAttribute.to(this.getRuleAttribute()), (String)this.getRuleAttribute().getApplicationId());
            if (tempAttr == null || !WorkflowRuleAttribute.class.isAssignableFrom(tempAttr.getClass())) {
                throw new WorkflowRuntimeException("Could not find workflow attribute " + this.getRuleAttribute().getName());
            }
            WorkflowRuleAttribute workflowAttribute = (WorkflowRuleAttribute)tempAttr;
            workflowAttribute.setRequired(this._persistence_get_required());
            return workflowAttribute;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception instantiating new " + this.getRuleAttribute().getResourceDescriptor(), e);
        }
    }

    public RuleValidationAttribute getRuleValidationAttribute() {
        try {
            RuleAttribute attrib = this.getRuleAttribute();
            return KEWServiceLocator.getRuleValidationAttributeResolver().resolveRuleValidationAttribute(attrib.getName(), attrib.getApplicationId());
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception instantiating new " + this.getRuleAttribute().getResourceDescriptor(), e);
        }
    }

    public List<RuleExtensionBo> getRuleExtensions() {
        return this._persistence_get_ruleExtensions();
    }

    public Map<String, String> getRuleExtensionMap() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        if (this.getRuleExtensions() != null) {
            for (RuleExtensionBo ext : this.getRuleExtensions()) {
                for (RuleExtensionValue value : ext.getExtensionValues()) {
                    extensions.put(value.getKey(), value.getValue());
                }
            }
        }
        return extensions;
    }

    public void setRuleExtensions(List<RuleExtensionBo> ruleExtensions) {
        this._persistence_set_ruleExtensions(ruleExtensions);
    }

    public RuleAttribute getRuleAttribute() {
        if (this._persistence_get_ruleAttribute() == null && this._persistence_get_ruleAttributeId() != null) {
            this._persistence_set_ruleAttribute(RuleAttribute.from(KewApiServiceLocator.getExtensionRepositoryService().getExtensionById(this._persistence_get_ruleAttributeId())));
        }
        return this._persistence_get_ruleAttribute();
    }

    public void setRuleAttribute(RuleAttribute ruleAttribute) {
        this._persistence_set_ruleAttribute(ruleAttribute);
    }

    public RuleTemplateBo getRuleTemplate() {
        return this._persistence_get_ruleTemplate();
    }

    public void setRuleTemplate(RuleTemplateBo ruleTemplate) {
        this._persistence_set_ruleTemplate(ruleTemplate);
    }

    public String getDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public void setDefaultValue(String defaultValue) {
        this._persistence_set_defaultValue(defaultValue);
    }

    public Integer getDisplayOrder() {
        return this._persistence_get_displayOrder();
    }

    public void setDisplayOrder(Integer displayOrder) {
        this._persistence_set_displayOrder(displayOrder);
    }

    public boolean isRequired() {
        return this.getRequired() == null || this.getRequired() != false;
    }

    public Boolean getRequired() {
        return this._persistence_get_required();
    }

    public void setRequired(Boolean required) {
        this._persistence_set_required(required);
    }

    public boolean isActive() {
        return this.getActive() == null || this.getActive() != false;
    }

    public Boolean getActive() {
        return this._persistence_get_active();
    }

    public void setActive(Boolean active) {
        this._persistence_set_active(active);
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getRuleAttributeId() {
        return this._persistence_get_ruleAttributeId();
    }

    public void setRuleAttributeId(String ruleAttributeId) {
        this._persistence_set_ruleAttributeId(ruleAttributeId);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getRuleTemplateId() {
        return this.getRuleTemplate() != null ? this.getRuleTemplate().getId() : null;
    }

    @Deprecated
    public void setRuleTemplateId(String ruleTemplateId) {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RuleTemplateAttributeBo();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "displayOrder") {
            return this.displayOrder;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "ruleAttributeId") {
            return this.ruleAttributeId;
        }
        if (string == "ruleExtensions") {
            return this.ruleExtensions;
        }
        if (string == "ruleTemplate") {
            return this.ruleTemplate;
        }
        if (string == "defaultValue") {
            return this.defaultValue;
        }
        if (string == "required") {
            return this.required;
        }
        if (string == "ruleAttribute") {
            return this.ruleAttribute;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "displayOrder") {
            this.displayOrder = (Integer)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "ruleAttributeId") {
            this.ruleAttributeId = (String)object;
            return;
        }
        if (string == "ruleExtensions") {
            this.ruleExtensions = (List)object;
            return;
        }
        if (string == "ruleTemplate") {
            this.ruleTemplate = (RuleTemplateBo)((Object)object);
            return;
        }
        if (string == "defaultValue") {
            this.defaultValue = (String)object;
            return;
        }
        if (string == "required") {
            this.required = (Boolean)object;
            return;
        }
        if (string == "ruleAttribute") {
            this.ruleAttribute = (RuleAttribute)((Object)object);
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public Integer _persistence_get_displayOrder() {
        this._persistence_checkFetched("displayOrder");
        return this.displayOrder;
    }

    public void _persistence_set_displayOrder(Integer n) {
        this._persistence_checkFetchedForSet("displayOrder");
        this._persistence_propertyChange("displayOrder", this.displayOrder, n);
        this.displayOrder = n;
    }

    public Boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(Boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", this.active, bl);
        this.active = bl;
    }

    public String _persistence_get_ruleAttributeId() {
        this._persistence_checkFetched("ruleAttributeId");
        return this.ruleAttributeId;
    }

    public void _persistence_set_ruleAttributeId(String string) {
        this._persistence_checkFetchedForSet("ruleAttributeId");
        this._persistence_propertyChange("ruleAttributeId", this.ruleAttributeId, string);
        this.ruleAttributeId = string;
    }

    public List _persistence_get_ruleExtensions() {
        this._persistence_checkFetched("ruleExtensions");
        return this.ruleExtensions;
    }

    public void _persistence_set_ruleExtensions(List list) {
        this._persistence_checkFetchedForSet("ruleExtensions");
        this._persistence_propertyChange("ruleExtensions", this.ruleExtensions, list);
        this.ruleExtensions = list;
    }

    public RuleTemplateBo _persistence_get_ruleTemplate() {
        this._persistence_checkFetched("ruleTemplate");
        return this.ruleTemplate;
    }

    public void _persistence_set_ruleTemplate(RuleTemplateBo ruleTemplateBo) {
        this._persistence_checkFetchedForSet("ruleTemplate");
        this._persistence_propertyChange("ruleTemplate", (Object)this.ruleTemplate, (Object)ruleTemplateBo);
        this.ruleTemplate = ruleTemplateBo;
    }

    public String _persistence_get_defaultValue() {
        this._persistence_checkFetched("defaultValue");
        return this.defaultValue;
    }

    public void _persistence_set_defaultValue(String string) {
        this._persistence_checkFetchedForSet("defaultValue");
        this._persistence_propertyChange("defaultValue", this.defaultValue, string);
        this.defaultValue = string;
    }

    public Boolean _persistence_get_required() {
        this._persistence_checkFetched("required");
        return this.required;
    }

    public void _persistence_set_required(Boolean bl) {
        this._persistence_checkFetchedForSet("required");
        this._persistence_propertyChange("required", this.required, bl);
        this.required = bl;
    }

    public RuleAttribute _persistence_get_ruleAttribute() {
        this._persistence_checkFetched("ruleAttribute");
        return this.ruleAttribute;
    }

    public void _persistence_set_ruleAttribute(RuleAttribute ruleAttribute) {
        this._persistence_checkFetchedForSet("ruleAttribute");
        this._persistence_propertyChange("ruleAttribute", (Object)this.ruleAttribute, (Object)ruleAttribute);
        this.ruleAttribute = ruleAttribute;
    }
}

