/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.dao.RuleDelegationDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class RuleDelegationDAOJpa
implements RuleDelegationDAO {
    private EntityManager entityManager;
    private DataObjectService dataObjectService;

    @Override
    public List<RuleDelegationBo> findByDelegateRuleId(String ruleId) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"ruleDelegationId", (Object)ruleId)});
        return this.getDataObjectService().findMatching(RuleDelegationBo.class, builder.build()).getResults();
    }

    @Override
    public void save(RuleDelegationBo ruleDelegation) {
        this.getDataObjectService().save((Object)ruleDelegation, new PersistenceOption[0]);
    }

    @Override
    public List<RuleDelegationBo> findAllCurrentRuleDelegations() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"delegationRule.currentInd", (Object)true)});
        return this.getDataObjectService().findMatching(RuleDelegationBo.class, builder.build()).getResults();
    }

    @Override
    public RuleDelegationBo findByRuleDelegationId(String ruleDelegationId) {
        return (RuleDelegationBo)((Object)this.getDataObjectService().find(RuleDelegationBo.class, (Object)ruleDelegationId));
    }

    @Override
    public void delete(String ruleDelegationId) {
        this.getDataObjectService().delete((Object)this.findByRuleDelegationId(ruleDelegationId));
    }

    @Override
    public List<RuleDelegationBo> findByResponsibilityIdWithCurrentRule(String responsibilityId) {
        if (StringUtils.isBlank((String)responsibilityId)) {
            return null;
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"delegationRule.currentInd", (Object)true), PredicateFactory.equal((String)"responsibilityId", (Object)responsibilityId)});
        return this.getDataObjectService().findMatching(RuleDelegationBo.class, builder.build()).getResults();
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String workflowId, String delegationType, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        return null;
    }

    @Override
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String workflowId, String delegationType, Boolean activeInd, Map extensionValues, Collection actionRequestCodes) {
        return null;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

