/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.rule.RuleTemplateAttributeContract;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.GroupRuleResponsibility;
import org.kuali.rice.kew.rule.PersonRuleResponsibility;
import org.kuali.rice.kew.rule.RoleRuleResponsibility;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.rule.web.WebRuleBaseValues;
import org.kuali.rice.kew.rule.web.WebRuleResponsibility;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;

public final class WebRuleUtils {
    public static final String RULE_TEMPLATE_ID_PARAM = "ruleCreationValues.ruleTemplateId";
    public static final String RULE_TEMPLATE_NAME_PARAM = "ruleCreationValues.ruleTemplateName";
    public static final String DOCUMENT_TYPE_NAME_PARAM = "ruleCreationValues.docTypeName";
    public static final String RESPONSIBILITY_ID_PARAM = "ruleCreationValues.responsibilityId";
    private static final String ID_SEPARATOR = "~";
    private static final String RULE_ATTRIBUTES_SECTION_ID = "RuleAttributes";
    private static final String RULE_ATTRIBUTES_SECTION_TITLE = "Rule Attributes";
    private static final String ROLES_MAINTENANCE_SECTION_ID = "RolesMaintenance";

    private WebRuleUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static WebRuleBaseValues copyRuleOntoExistingDocument(WebRuleBaseValues rule) throws Exception {
        WebRuleBaseValues ruleCopy = new WebRuleBaseValues();
        PropertyUtils.copyProperties((Object)((Object)ruleCopy), (Object)((Object)rule));
        ruleCopy.setPreviousRuleId(null);
        ruleCopy.setCurrentInd(null);
        ruleCopy.setVersionNbr(null);
        ArrayList<RuleResponsibilityBo> responsibilities = new ArrayList<RuleResponsibilityBo>();
        for (WebRuleResponsibility webRuleResponsibility : ruleCopy.getRuleResponsibilities()) {
            WebRuleResponsibility responsibilityCopy = new WebRuleResponsibility();
            PropertyUtils.copyProperties((Object)((Object)responsibilityCopy), (Object)((Object)webRuleResponsibility));
            responsibilityCopy.setResponsibilityId(null);
            responsibilityCopy.setId(null);
            ArrayList<RuleDelegationBo> delegations = new ArrayList<RuleDelegationBo>();
            for (RuleDelegationBo delegation : responsibilityCopy.getDelegationRules()) {
                RuleDelegationBo delegationCopy = new RuleDelegationBo();
                PropertyUtils.copyProperties((Object)((Object)delegationCopy), (Object)((Object)delegation));
                delegationCopy.setDelegateRuleId(null);
                delegationCopy.setVersionNumber(null);
                delegationCopy.setRuleDelegationId(null);
                delegationCopy.setResponsibilityId(null);
                WebRuleBaseValues delegationRule = (WebRuleBaseValues)delegation.getDelegationRule();
                WebRuleBaseValues ruleDelegateCopy = new WebRuleBaseValues();
                PropertyUtils.copyProperties((Object)((Object)ruleDelegateCopy), (Object)((Object)delegationRule));
                ruleDelegateCopy.setPreviousRuleId(null);
                ruleDelegateCopy.setCurrentInd(null);
                ruleDelegateCopy.setVersionNbr(null);
                ArrayList<RuleResponsibilityBo> delegateResps = new ArrayList<RuleResponsibilityBo>();
                for (WebRuleResponsibility webRuleResponsibility2 : ruleDelegateCopy.getRuleResponsibilities()) {
                    WebRuleResponsibility delegateRespCopy = new WebRuleResponsibility();
                    PropertyUtils.copyProperties((Object)((Object)delegateRespCopy), (Object)((Object)webRuleResponsibility2));
                    delegateRespCopy.setResponsibilityId(null);
                    delegateRespCopy.setId(null);
                    delegateResps.add(delegateRespCopy);
                }
                ruleDelegateCopy.setRuleResponsibilities(delegateResps);
                delegationCopy.setDelegationRule(ruleDelegateCopy);
                delegations.add(delegationCopy);
            }
            responsibilities.add(responsibilityCopy);
        }
        ruleCopy.setRuleResponsibilities(responsibilities);
        return ruleCopy;
    }

    public static WebRuleBaseValues copyToNewRule(WebRuleBaseValues webRuleBaseValues) throws Exception {
        WebRuleBaseValues newRule = WebRuleUtils.copyRuleOntoExistingDocument(webRuleBaseValues);
        newRule.setDocumentId(null);
        for (RuleResponsibilityBo responsibility : newRule.getRuleResponsibilities()) {
            for (RuleDelegationBo delegation : responsibility.getDelegationRules()) {
                delegation.getDelegationRule().setDocumentId(null);
            }
        }
        return newRule;
    }

    public static void validateRuleTemplateAndDocumentType(RuleBaseValues oldRule, RuleBaseValues newRule, Map<String, String[]> parameters) {
        Object[] ruleTemplateIds = parameters.get(RULE_TEMPLATE_ID_PARAM);
        Object[] ruleTemplateNames = parameters.get(RULE_TEMPLATE_NAME_PARAM);
        Object[] documentTypeNames = parameters.get(DOCUMENT_TYPE_NAME_PARAM);
        if (ArrayUtils.isEmpty((Object[])ruleTemplateIds) && ArrayUtils.isEmpty((Object[])ruleTemplateNames)) {
            throw new RiceRuntimeException("Rule document must be initiated with a valid rule template id or rule template name.");
        }
        if (ArrayUtils.isEmpty((Object[])documentTypeNames)) {
            throw new RiceRuntimeException("Rule document must be initiated with a valid document type name.");
        }
        RuleTemplateBo ruleTemplate = null;
        if (!ArrayUtils.isEmpty((Object[])ruleTemplateIds)) {
            Object ruleTemplateId = ruleTemplateIds[0];
            ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateId((String)ruleTemplateId);
            if (ruleTemplate == null) {
                throw new RiceRuntimeException("Failed to load rule template with id '" + (String)ruleTemplateId + "'");
            }
        }
        if (ruleTemplate == null) {
            Object ruleTemplateName = ruleTemplateNames[0];
            ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName((String)ruleTemplateName);
            if (ruleTemplate == null) {
                throw new RiceRuntimeException("Failed to load rule template with name '" + (String)ruleTemplateName + "'");
            }
        }
        Object documentTypeName = documentTypeNames[0];
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName((String)documentTypeName);
        if (documentType == null) {
            throw new RiceRuntimeException("Failed to locate document type with name '" + (String)documentTypeName + "'");
        }
        WebRuleUtils.initializeRuleAfterNew(oldRule, ruleTemplate, (String)documentTypeName);
        WebRuleUtils.initializeRuleAfterNew(newRule, ruleTemplate, (String)documentTypeName);
    }

    private static void initializeRuleAfterNew(RuleBaseValues rule, RuleTemplateBo ruleTemplate, String documentTypeName) {
        rule.setRuleTemplate(ruleTemplate);
        rule.setRuleTemplateId(ruleTemplate.getId());
        rule.setDocTypeName(documentTypeName);
    }

    public static void validateRuleAndResponsibility(RuleDelegationBo oldRuleDelegation, RuleDelegationBo newRuleDelegation, Map<String, String[]> parameters) {
        Object[] responsibilityIds = parameters.get(RESPONSIBILITY_ID_PARAM);
        if (ArrayUtils.isEmpty((Object[])responsibilityIds)) {
            throw new RiceRuntimeException("Delegation rule document must be initiated with a valid responsibility ID to delegate from.");
        }
        if (!ArrayUtils.isEmpty((Object[])responsibilityIds)) {
            Object responsibilityId = responsibilityIds[0];
            RuleResponsibilityBo ruleResponsibility = KEWServiceLocator.getRuleService().findRuleResponsibility((String)responsibilityId);
            if (ruleResponsibility == null) {
                throw new RiceRuntimeException("Failed to locate a rule responsibility for responsibility ID " + (String)responsibilityId);
            }
            oldRuleDelegation.setResponsibilityId((String)responsibilityId);
            newRuleDelegation.setResponsibilityId((String)responsibilityId);
        }
    }

    public static void establishDefaultRuleValues(RuleBaseValues rule) {
        RuleBaseValues defaultRule;
        rule.setActive(true);
        if (rule.getRuleTemplate().getDelegationTemplateId() != null && (defaultRule = ((RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal")).findDefaultRuleByRuleTemplateId(rule.getRuleTemplate().getDelegationTemplateId())) != null) {
            defaultRule.setActivationDate(null);
            defaultRule.setCurrentInd(null);
            defaultRule.setDeactivationDate(null);
            defaultRule.setDocTypeName(null);
            defaultRule.setVersionNumber(null);
            defaultRule.setId(null);
            defaultRule.setTemplateRuleInd(Boolean.FALSE);
            defaultRule.setVersionNbr(null);
            try {
                PropertyUtils.copyProperties((Object)((Object)rule), (Object)((Object)defaultRule));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<Section> customizeSections(RuleBaseValues rule, List<Section> sections, boolean delegateRule) {
        ArrayList<Section> finalSections = new ArrayList<Section>();
        for (Section section : sections) {
            if (section.getSectionTitle().equals(RULE_ATTRIBUTES_SECTION_TITLE) || RULE_ATTRIBUTES_SECTION_ID.equals(section.getSectionId())) {
                List<Row> ruleTemplateRows = WebRuleUtils.getRuleTemplateRows(rule, delegateRule);
                if (ruleTemplateRows.isEmpty()) continue;
                section.setRows(ruleTemplateRows);
                finalSections.add(section);
                continue;
            }
            if (ROLES_MAINTENANCE_SECTION_ID.equals(section.getSectionId())) {
                if (!WebRuleUtils.hasRoles(rule)) continue;
                finalSections.add(section);
                continue;
            }
            finalSections.add(section);
        }
        return finalSections;
    }

    public static List<Row> getRuleTemplateRows(RuleBaseValues rule, boolean delegateRule) {
        ArrayList<Row> rows = new ArrayList<Row>();
        RuleTemplateBo ruleTemplate = rule.getRuleTemplate();
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        if (ruleTemplate != null) {
            ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateId(ruleTemplate.getId());
            if (ruleTemplate != null) {
                List<RuleTemplateAttributeBo> ruleTemplateAttributes = ruleTemplate.getActiveRuleTemplateAttributes();
                Collections.sort(ruleTemplateAttributes);
                for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplateAttributes) {
                    if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
                    Map<String, String> parameters = WebRuleUtils.getFieldMapForRuleTemplateAttribute(rule, ruleTemplateAttribute);
                    WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRuleRows(parameters, ruleTemplateAttribute);
                    List<Row> attributeRows = WebRuleUtils.transformAndPopulateAttributeRows(workflowRuleAttributeRows.getRows(), ruleTemplateAttribute, rule, fieldNameMap, delegateRule);
                    rows.addAll(attributeRows);
                }
            }
            WebRuleUtils.transformFieldConversions(rows, fieldNameMap);
        }
        return rows;
    }

    public static void transformFieldConversions(List<Row> rows, Map<String, String> fieldNameMap) {
        for (Row row : rows) {
            HashMap<String, String> transformedFieldConversions = new HashMap<String, String>();
            for (Field field : row.getFields()) {
                Map fieldConversions = field.getFieldConversionMap();
                for (String lookupFieldName : fieldConversions.keySet()) {
                    String localFieldName = (String)fieldConversions.get(lookupFieldName);
                    if (fieldNameMap.containsKey(localFieldName)) {
                        transformedFieldConversions.put(lookupFieldName, fieldNameMap.get(localFieldName));
                        continue;
                    }
                    transformedFieldConversions.put(lookupFieldName, (String)fieldConversions.get(lookupFieldName));
                }
                field.setFieldConversions(transformedFieldConversions);
            }
        }
    }

    private static boolean hasRoles(RuleBaseValues rule) {
        RuleTemplateBo ruleTemplate = rule.getRuleTemplate();
        return !ruleTemplate.getRoles().isEmpty();
    }

    public static List<Row> transformAndPopulateAttributeRows(List<Row> attributeRows, RuleTemplateAttributeBo ruleTemplateAttribute, RuleBaseValues rule, Map<String, String> fieldNameMap, boolean delegateRule) {
        for (Row row : attributeRows) {
            for (Field field : row.getFields()) {
                String fieldName = field.getPropertyName();
                if (StringUtils.isBlank((String)fieldName)) continue;
                String valueKey = ruleTemplateAttribute.getId() + ID_SEPARATOR + fieldName;
                String propertyName = delegateRule ? "delegationRule.fieldValues(" + valueKey + ")" : "fieldValues(" + valueKey + ")";
                fieldNameMap.put(fieldName, propertyName);
                field.setPropertyName(propertyName);
                field.setPropertyValue(rule.getFieldValues().get(valueKey));
            }
        }
        return attributeRows;
    }

    public static void clearKeysForSave(RuleBaseValues rule) {
        rule.setId(null);
        rule.setActivationDate(null);
        rule.setDeactivationDate(null);
        rule.setCurrentInd(false);
        rule.setVersionNbr(null);
        rule.setObjectId(null);
        rule.setVersionNumber(null);
    }

    public static void clearKeysForSave(RuleDelegationBo ruleDelegation) {
        ruleDelegation.setRuleDelegationId(null);
        ruleDelegation.setObjectId(null);
        ruleDelegation.setVersionNumber(null);
        WebRuleUtils.clearKeysForSave(ruleDelegation.getDelegationRule());
    }

    public static void translateResponsibilitiesForSave(RuleBaseValues rule) {
        RuleResponsibilityBo ruleResponsibility;
        rule.getRuleResponsibilities().clear();
        for (PersonRuleResponsibility personRuleResponsibility : rule.getPersonResponsibilities()) {
            ruleResponsibility = new RuleResponsibilityBo();
            ruleResponsibility.setActionRequestedCd(personRuleResponsibility.getActionRequestedCd());
            ruleResponsibility.setPriority(personRuleResponsibility.getPriority());
            ruleResponsibility.setResponsibilityId(personRuleResponsibility.getResponsibilityId());
            if (ruleResponsibility.getResponsibilityId() == null) {
                ruleResponsibility.setResponsibilityId(KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId());
            }
            String principalId = KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(personRuleResponsibility.getPrincipalName());
            ruleResponsibility.setRuleResponsibilityName(principalId);
            ruleResponsibility.setRuleResponsibilityType("F");
            ruleResponsibility.setApprovePolicy(ActionRequestPolicy.FIRST.getCode());
            rule.getRuleResponsibilities().add(ruleResponsibility);
        }
        for (GroupRuleResponsibility groupRuleResponsibility : rule.getGroupResponsibilities()) {
            ruleResponsibility = new RuleResponsibilityBo();
            ruleResponsibility.setActionRequestedCd(groupRuleResponsibility.getActionRequestedCd());
            ruleResponsibility.setPriority(groupRuleResponsibility.getPriority());
            ruleResponsibility.setResponsibilityId(groupRuleResponsibility.getResponsibilityId());
            if (ruleResponsibility.getResponsibilityId() == null) {
                ruleResponsibility.setResponsibilityId(KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId());
            }
            Group group = KEWServiceLocator.getIdentityHelperService().getGroupByName(groupRuleResponsibility.getNamespaceCode(), groupRuleResponsibility.getName());
            ruleResponsibility.setRuleResponsibilityName(group.getId());
            ruleResponsibility.setRuleResponsibilityType("G");
            ruleResponsibility.setApprovePolicy(ActionRequestPolicy.FIRST.getCode());
            rule.getRuleResponsibilities().add(ruleResponsibility);
        }
        for (RoleRuleResponsibility roleRuleResponsibility : rule.getRoleResponsibilities()) {
            ruleResponsibility = new RuleResponsibilityBo();
            ruleResponsibility.setActionRequestedCd(roleRuleResponsibility.getActionRequestedCd());
            ruleResponsibility.setPriority(roleRuleResponsibility.getPriority());
            ruleResponsibility.setResponsibilityId(roleRuleResponsibility.getResponsibilityId());
            if (ruleResponsibility.getResponsibilityId() == null) {
                ruleResponsibility.setResponsibilityId(KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId());
            }
            ruleResponsibility.setRuleResponsibilityName(roleRuleResponsibility.getRoleName());
            ruleResponsibility.setRuleResponsibilityType("R");
            ruleResponsibility.setApprovePolicy(roleRuleResponsibility.getApprovePolicy());
            rule.getRuleResponsibilities().add(ruleResponsibility);
        }
    }

    public static void translateFieldValuesForSave(RuleBaseValues rule) {
        RuleTemplateBo ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateId(rule.getRuleTemplateId());
        ArrayList<RuleExtensionBo> extensions = new ArrayList<RuleExtensionBo>();
        for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
            if (!ruleTemplateAttribute.isWorkflowAttribute()) continue;
            Map<String, String> parameterMap = WebRuleUtils.getFieldMapForRuleTemplateAttribute(rule, ruleTemplateAttribute);
            WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getRuleRows(parameterMap, ruleTemplateAttribute);
            List<RemotableAttributeError> attValidationErrors = workflowRuleAttributeRows.getValidationErrors();
            if (attValidationErrors != null && !attValidationErrors.isEmpty()) {
                throw new RiceRuntimeException("Encountered attribute validation errors when attempting to save the Rule!");
            }
            Map<String, String> ruleExtensionValuesMap = workflowRuleAttributeRows.getRuleExtensionValues();
            if (ruleExtensionValuesMap == null || ruleExtensionValuesMap.isEmpty()) continue;
            RuleExtensionBo ruleExtension = new RuleExtensionBo();
            ruleExtension.setRuleTemplateAttributeId(ruleTemplateAttribute.getId());
            ArrayList<RuleExtensionValue> ruleExtensionValues = new ArrayList<RuleExtensionValue>();
            for (String key : ruleExtensionValuesMap.keySet()) {
                RuleExtensionValue ruleExtensionValue = new RuleExtensionValue();
                ruleExtensionValue.setExtension(ruleExtension);
                ruleExtensionValue.setKey(key);
                ruleExtensionValue.setValue(ruleExtensionValuesMap.get(key));
                ruleExtensionValues.add(ruleExtensionValue);
            }
            ruleExtension.setExtensionValues(ruleExtensionValues);
            extensions.add(ruleExtension);
        }
        rule.setRuleExtensions(extensions);
        for (RuleExtensionBo ruleExtension : rule.getRuleExtensions()) {
            ruleExtension.setRuleBaseValues(rule);
            for (RuleTemplateAttributeBo ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                if (!StringUtils.equals((String)ruleTemplateAttribute.getId(), (String)ruleExtension.getRuleTemplateAttributeId())) continue;
                ruleExtension.setRuleTemplateAttribute(ruleTemplateAttribute);
                break;
            }
            for (RuleExtensionValue ruleExtensionValue : ruleExtension.getExtensionValues()) {
                ruleExtensionValue.setExtension(ruleExtension);
            }
        }
    }

    public static Map<String, String> getFieldMapForRuleTemplateAttribute(RuleBaseValues rule, RuleTemplateAttributeContract ruleTemplateAttribute) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (String fieldKey : rule.getFieldValues().keySet()) {
            String ruleTemplateAttributeId = fieldKey.substring(0, fieldKey.indexOf(ID_SEPARATOR));
            String fieldName = fieldKey.substring(fieldKey.indexOf(ID_SEPARATOR) + 1);
            if (!ruleTemplateAttribute.getId().equals(ruleTemplateAttributeId)) continue;
            fieldMap.put(fieldName, rule.getFieldValues().get(fieldKey));
        }
        return fieldMap;
    }

    public static void processRuleForDelegationSave(RuleDelegationBo ruleDelegation) {
        RuleBaseValues rule = ruleDelegation.getDelegationRule();
        rule.setDelegateRule(true);
        for (RuleResponsibilityBo responsibility : rule.getRuleResponsibilities()) {
            responsibility.setActionRequestedCd(null);
            responsibility.setPriority(null);
        }
    }

    public static void populateForCopyOrEdit(RuleBaseValues oldRule, RuleBaseValues newRule) {
        WebRuleUtils.populateRuleMaintenanceFields(oldRule);
        WebRuleUtils.populateRuleMaintenanceFields(newRule);
        if (newRule.getRuleTemplate().getName() == null) {
            newRule.getRuleTemplate().setName(oldRule.getRuleTemplate().getName());
        }
        if (newRule.getDocTypeName() == null) {
            newRule.setDocTypeName(oldRule.getDocTypeName());
        }
    }

    public static void populateRuleMaintenanceFields(RuleBaseValues rule) {
        WebRuleUtils.translateResponsibilitiesForLoad(rule);
        WebRuleUtils.translateRuleExtensionsForLoad(rule);
    }

    public static void translateResponsibilitiesForLoad(RuleBaseValues rule) {
        for (RuleResponsibilityBo responsibility : rule.getRuleResponsibilities()) {
            if (responsibility.getRuleResponsibilityType().equals("F")) {
                PersonRuleResponsibility personResponsibility = new PersonRuleResponsibility();
                WebRuleUtils.copyResponsibility(responsibility, personResponsibility);
                Principal principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(personResponsibility.getRuleResponsibilityName());
                personResponsibility.setPrincipalName(principal.getPrincipalName());
                rule.getPersonResponsibilities().add(personResponsibility);
                continue;
            }
            if (responsibility.getRuleResponsibilityType().equals("G")) {
                GroupRuleResponsibility groupResponsibility = new GroupRuleResponsibility();
                WebRuleUtils.copyResponsibility(responsibility, groupResponsibility);
                Group group = KEWServiceLocator.getIdentityHelperService().getGroup(groupResponsibility.getRuleResponsibilityName());
                groupResponsibility.setNamespaceCode(group.getNamespaceCode());
                groupResponsibility.setName(group.getName());
                rule.getGroupResponsibilities().add(groupResponsibility);
                continue;
            }
            if (responsibility.getRuleResponsibilityType().equals("R")) {
                RoleRuleResponsibility roleResponsibility = new RoleRuleResponsibility();
                WebRuleUtils.copyResponsibility(responsibility, roleResponsibility);
                rule.getRoleResponsibilities().add(roleResponsibility);
                continue;
            }
            throw new RiceRuntimeException("Original responsibility with id '" + responsibility.getId() + "' contained a bad type code of '" + responsibility.getRuleResponsibilityType());
        }
        rule.getRuleResponsibilities().clear();
    }

    public static void copyResponsibility(RuleResponsibilityBo source, RuleResponsibilityBo target) {
        try {
            BeanUtils.copyProperties((Object)((Object)target), (Object)((Object)source));
        }
        catch (Exception e) {
            throw new RiceRuntimeException("Failed to copy properties from source to target responsibility", (Throwable)e);
        }
    }

    public static void translateRuleExtensionsForLoad(RuleBaseValues rule) {
        for (RuleExtensionBo ruleExtension : rule.getRuleExtensions()) {
            String ruleTemplateAttributeId = ruleExtension.getRuleTemplateAttributeId();
            for (RuleExtensionValue ruleExtensionValue : ruleExtension.getExtensionValues()) {
                String fieldMapKey = ruleTemplateAttributeId + ID_SEPARATOR + ruleExtensionValue.getKey();
                rule.getFieldValues().put(fieldMapKey, ruleExtensionValue.getValue());
            }
        }
        rule.getRuleExtensions().clear();
    }

    public static void processRuleForCopy(String documentNumber, RuleBaseValues oldRule, RuleBaseValues newRule) {
        WebRuleUtils.populateForCopyOrEdit(oldRule, newRule);
        WebRuleUtils.clearKeysForCopy(newRule);
        newRule.setDocumentId(documentNumber);
    }

    public static void clearKeysForCopy(RuleBaseValues rule) {
        rule.setId(null);
        rule.setPreviousRuleId(null);
        rule.setPreviousVersion(null);
        rule.setName(null);
        for (PersonRuleResponsibility personRuleResponsibility : rule.getPersonResponsibilities()) {
            WebRuleUtils.clearResponsibilityKeys(personRuleResponsibility);
        }
        for (GroupRuleResponsibility groupRuleResponsibility : rule.getGroupResponsibilities()) {
            WebRuleUtils.clearResponsibilityKeys(groupRuleResponsibility);
        }
        for (RoleRuleResponsibility roleRuleResponsibility : rule.getRoleResponsibilities()) {
            WebRuleUtils.clearResponsibilityKeys(roleRuleResponsibility);
        }
    }

    private static void clearResponsibilityKeys(RuleResponsibilityBo responsibility) {
        responsibility.setResponsibilityId(null);
        responsibility.setId(null);
        responsibility.setRuleBaseValuesId(null);
    }
}

