/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.util.Formatter;
import org.apache.log4j.Logger;

public class PerformanceLogger {
    private static final Logger LOG = Logger.getLogger(PerformanceLogger.class);
    private long startTime;
    private String documentId;

    public PerformanceLogger() {
        this.recordStartTime();
    }

    public PerformanceLogger(String documentId) {
        this();
        this.documentId = documentId;
    }

    private void recordStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void log(String message) {
        this.log(message, false);
    }

    public void log(String message, boolean terminalPoint) {
        if (LOG.isInfoEnabled()) {
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - this.startTime;
            String logMessage = new Formatter().format("Time: %7dms, ", totalTime).toString();
            if (this.documentId != null) {
                logMessage = logMessage + "docId=" + this.documentId + ", ";
            }
            logMessage = logMessage + message;
            if (terminalPoint) {
                logMessage = logMessage + "\n";
            }
            LOG.info((Object)logMessage);
        }
    }

    public void debug(String message) {
        this.debug(message, false);
    }

    public void debug(String message, boolean terminalPoint) {
        if (LOG.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - this.startTime;
            String logMessage = new Formatter().format("Time: %7dms, ", totalTime).toString();
            if (this.documentId != null) {
                logMessage = logMessage + "docId=" + this.documentId + ", ";
            }
            logMessage = logMessage + message;
            if (terminalPoint) {
                logMessage = logMessage + "\n";
            }
            LOG.debug((Object)logMessage);
        }
    }
}

