/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableToFromEditableBase;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.krad.data.KradDataServiceLocator;

@Entity
@Table(name="KRIM_PND_ROLE_MBR_MT")
public class KimDocumentRoleMember
extends KimDocumentBoActivatableToFromEditableBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -2463865643038170979L;
    @Id
    @Column(name="ROLE_MBR_ID")
    protected String roleMemberId;
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="MBR_ID")
    protected String memberId;
    @Column(name="MBR_TYP_CD")
    protected String memberTypeCode = KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode();
    @Transient
    protected String memberName;
    @Transient
    protected String memberNamespaceCode;
    @Transient
    protected String memberFullName;
    @OneToMany(targetEntity=KimDocumentRoleQualifier.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumns(value={@JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false), @JoinColumn(name="ROLE_MBR_ID", referencedColumnName="ROLE_MBR_ID", insertable=false, updatable=false)})
    protected List<KimDocumentRoleQualifier> qualifiers = new ArrayList<KimDocumentRoleQualifier>();
    @Transient
    protected String qualifiersToDisplay;
    @OneToMany(targetEntity=KimDocumentRoleResponsibilityAction.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumns(value={@JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false), @JoinColumn(name="ROLE_MBR_ID", referencedColumnName="ROLE_MBR_ID", insertable=false, updatable=false)})
    private List<KimDocumentRoleResponsibilityAction> roleRspActions = new ArrayList<KimDocumentRoleResponsibilityAction>();

    public int getNumberOfQualifiers() {
        return this._persistence_get_qualifiers() == null ? 0 : this._persistence_get_qualifiers().size();
    }

    public String getMemberId() {
        return this._persistence_get_memberId();
    }

    public void setMemberId(String memberId) {
        this._persistence_set_memberId(memberId);
    }

    public String getRoleMemberId() {
        return this._persistence_get_roleMemberId();
    }

    public void setRoleMemberId(String roleMemberId) {
        this._persistence_set_roleMemberId(roleMemberId);
    }

    public String getRoleId() {
        return this._persistence_get_roleId();
    }

    public void setRoleId(String roleId) {
        this._persistence_set_roleId(roleId);
    }

    public KimDocumentRoleQualifier getQualifier(String kimAttributeDefnId) {
        for (KimDocumentRoleQualifier qualifier : this._persistence_get_qualifiers()) {
            if (!qualifier.getKimAttrDefnId().equals(kimAttributeDefnId)) continue;
            return qualifier;
        }
        return null;
    }

    public List<KimDocumentRoleQualifier> getQualifiers() {
        return this._persistence_get_qualifiers();
    }

    public void setQualifiers(List<KimDocumentRoleQualifier> qualifiers) {
        this._persistence_set_qualifiers(qualifiers);
    }

    public String getMemberTypeCode() {
        return this._persistence_get_memberTypeCode();
    }

    public void setMemberTypeCode(String memberTypeCode) {
        this._persistence_set_memberTypeCode(memberTypeCode);
    }

    public String getMemberName() {
        if (this.memberName == null) {
            this.populateDerivedValues();
        }
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public List<KimDocumentRoleResponsibilityAction> getRoleRspActions() {
        return this._persistence_get_roleRspActions();
    }

    public void setRoleRspActions(List<KimDocumentRoleResponsibilityAction> roleRspActions) {
        this._persistence_set_roleRspActions(roleRspActions);
    }

    public String getMemberNamespaceCode() {
        if (this.memberNamespaceCode == null) {
            this.populateDerivedValues();
        }
        return this.memberNamespaceCode;
    }

    public void setMemberNamespaceCode(String memberNamespaceCode) {
        this.memberNamespaceCode = memberNamespaceCode;
    }

    protected void populateDerivedValues() {
        if (!StringUtils.isEmpty((String)this.getMemberId())) {
            Role roleInfo;
            if (MemberType.PRINCIPAL.getCode().equals(this.getMemberTypeCode())) {
                Principal principalInfo = KimApiServiceLocator.getIdentityService().getPrincipal(this.getMemberId());
                if (principalInfo != null) {
                    this.setMemberName(principalInfo.getPrincipalName());
                }
            } else if (MemberType.GROUP.getCode().equals(this.getMemberTypeCode())) {
                Group groupInfo = KimApiServiceLocator.getGroupService().getGroup(this.getMemberId());
                if (groupInfo != null) {
                    this.setMemberName(groupInfo.getName());
                    this.setMemberNamespaceCode(groupInfo.getNamespaceCode());
                }
            } else if (MemberType.ROLE.getCode().equals(this.getMemberTypeCode()) && (roleInfo = KimApiServiceLocator.getRoleService().getRole(this.getMemberId())) != null) {
                this.setMemberName(roleInfo.getName());
                this.setMemberNamespaceCode(roleInfo.getNamespaceCode());
            }
        }
    }

    public boolean isRole() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.ROLE.getCode());
    }

    public boolean isGroup() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.GROUP.getCode());
    }

    public boolean isPrincipal() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.PRINCIPAL.getCode());
    }

    public Map<String, String> getQualifierAsMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimDocumentRoleQualifier data : this.getQualifiers()) {
            if (data.getKimAttribute() == null) {
                KradDataServiceLocator.getDataObjectService().wrap((Object)this).fetchRelationship("kimAttribute");
            }
            if (data.getKimAttribute() == null) continue;
            m.put(data.getKimAttribute().getAttributeName(), data.getAttrVal());
        }
        return m;
    }

    public String getQualifiersToDisplay() {
        return this.qualifiersToDisplay;
    }

    public void setQualifiersToDisplay(String qualifiersToDisplay) {
        this.qualifiersToDisplay = qualifiersToDisplay;
    }

    public String getMemberFullName() {
        return this.memberFullName;
    }

    public void setMemberFullName(String memberFullName) {
        this.memberFullName = memberFullName;
    }

    public boolean isMemberNameNull() {
        return this.memberName == null;
    }

    public boolean isMemberNameSpaceCodeNull() {
        return this.memberNamespaceCode == null;
    }

    public static void copyProperties(KimDocumentRoleMember copyToKimDocRoleMember, RoleMemberBo copyFromRoleMbrBo) {
        if (copyToKimDocRoleMember != null && copyFromRoleMbrBo != null) {
            copyToKimDocRoleMember.setRoleId(copyFromRoleMbrBo.getRoleId());
            copyToKimDocRoleMember.setMemberId(copyFromRoleMbrBo.getMemberId());
            copyToKimDocRoleMember.setMemberName(copyFromRoleMbrBo.getMemberName());
            copyToKimDocRoleMember.setMemberNamespaceCode(copyFromRoleMbrBo.getMemberNamespaceCode());
            copyToKimDocRoleMember.setActive(copyFromRoleMbrBo.isActive());
            copyToKimDocRoleMember.setActiveFromDate(copyFromRoleMbrBo.getActiveFromDateValue());
            copyToKimDocRoleMember.setActiveToDate(copyFromRoleMbrBo.getActiveToDateValue());
            copyToKimDocRoleMember.setVersionNumber(copyFromRoleMbrBo.getVersionNumber());
            copyToKimDocRoleMember.setObjectId(copyFromRoleMbrBo.getObjectId());
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new KimDocumentRoleMember();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "roleRspActions") {
            return this.roleRspActions;
        }
        if (string == "roleMemberId") {
            return this.roleMemberId;
        }
        if (string == "qualifiers") {
            return this.qualifiers;
        }
        if (string == "memberId") {
            return this.memberId;
        }
        if (string == "memberTypeCode") {
            return this.memberTypeCode;
        }
        if (string == "roleId") {
            return this.roleId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "roleRspActions") {
            this.roleRspActions = (List)object;
            return;
        }
        if (string == "roleMemberId") {
            this.roleMemberId = (String)object;
            return;
        }
        if (string == "qualifiers") {
            this.qualifiers = (List)object;
            return;
        }
        if (string == "memberId") {
            this.memberId = (String)object;
            return;
        }
        if (string == "memberTypeCode") {
            this.memberTypeCode = (String)object;
            return;
        }
        if (string == "roleId") {
            this.roleId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_roleRspActions() {
        this._persistence_checkFetched("roleRspActions");
        return this.roleRspActions;
    }

    public void _persistence_set_roleRspActions(List list) {
        this._persistence_checkFetchedForSet("roleRspActions");
        this._persistence_propertyChange("roleRspActions", this.roleRspActions, list);
        this.roleRspActions = list;
    }

    public String _persistence_get_roleMemberId() {
        this._persistence_checkFetched("roleMemberId");
        return this.roleMemberId;
    }

    public void _persistence_set_roleMemberId(String string) {
        this._persistence_checkFetchedForSet("roleMemberId");
        this._persistence_propertyChange("roleMemberId", this.roleMemberId, string);
        this.roleMemberId = string;
    }

    public List _persistence_get_qualifiers() {
        this._persistence_checkFetched("qualifiers");
        return this.qualifiers;
    }

    public void _persistence_set_qualifiers(List list) {
        this._persistence_checkFetchedForSet("qualifiers");
        this._persistence_propertyChange("qualifiers", this.qualifiers, list);
        this.qualifiers = list;
    }

    public String _persistence_get_memberId() {
        this._persistence_checkFetched("memberId");
        return this.memberId;
    }

    public void _persistence_set_memberId(String string) {
        this._persistence_checkFetchedForSet("memberId");
        this._persistence_propertyChange("memberId", this.memberId, string);
        this.memberId = string;
    }

    public String _persistence_get_memberTypeCode() {
        this._persistence_checkFetched("memberTypeCode");
        return this.memberTypeCode;
    }

    public void _persistence_set_memberTypeCode(String string) {
        this._persistence_checkFetchedForSet("memberTypeCode");
        this._persistence_propertyChange("memberTypeCode", this.memberTypeCode, string);
        this.memberTypeCode = string;
    }

    public String _persistence_get_roleId() {
        this._persistence_checkFetched("roleId");
        return this.roleId;
    }

    public void _persistence_set_roleId(String string) {
        this._persistence_checkFetchedForSet("roleId");
        this._persistence_propertyChange("roleId", this.roleId, string);
        this.roleId = string;
    }
}

