/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.bo.ui.PersonDocumentBoDefaultBase;
import org.kuali.rice.kim.impl.identity.phone.EntityPhoneTypeBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KRIM_PND_PHONE_MT")
public class PersonDocumentPhone
extends PersonDocumentBoDefaultBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_ENTITY_PHONE_ID_S")
    @GeneratedValue(generator="KRIM_ENTITY_PHONE_ID_S")
    @Id
    @Column(name="ENTITY_PHONE_ID")
    protected String entityPhoneId;
    @Column(name="ENT_TYP_CD")
    protected String entityTypeCode;
    @Column(name="PHONE_TYP_CD")
    protected String phoneTypeCode;
    @Column(name="PHONE_NBR")
    protected String phoneNumber;
    @Column(name="PHONE_EXTN_NBR")
    protected String extensionNumber;
    @Column(name="POSTAL_CNTRY_CD")
    protected String countryCode;
    @ManyToOne(targetEntity=EntityPhoneTypeBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PHONE_TYP_CD", referencedColumnName="PHONE_TYP_CD", insertable=false, updatable=false)
    protected EntityPhoneTypeBo phoneType;

    public PersonDocumentPhone() {
        this.active = true;
    }

    public String getCountryCode() {
        return this._persistence_get_countryCode();
    }

    public String getEntityPhoneId() {
        return this._persistence_get_entityPhoneId();
    }

    public String getExtensionNumber() {
        return this._persistence_get_extensionNumber();
    }

    public String getPhoneNumber() {
        return this._persistence_get_phoneNumber();
    }

    public String getPhoneTypeCode() {
        return this._persistence_get_phoneTypeCode();
    }

    public void setCountryCode(String countryCode) {
        this._persistence_set_countryCode(countryCode);
    }

    public void setExtensionNumber(String extensionNumber) {
        this._persistence_set_extensionNumber(extensionNumber);
    }

    public void setPhoneNumber(String phoneNumber) {
        this._persistence_set_phoneNumber(phoneNumber);
    }

    public void setPhoneTypeCode(String phoneTypeCode) {
        this._persistence_set_phoneTypeCode(phoneTypeCode);
    }

    public String getEntityTypeCode() {
        return this._persistence_get_entityTypeCode();
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this._persistence_set_entityTypeCode(entityTypeCode);
    }

    public EntityPhoneTypeBo getPhoneType() {
        return this._persistence_get_phoneType();
    }

    public void setPhoneType(EntityPhoneTypeBo phoneType) {
        this._persistence_set_phoneType(phoneType);
    }

    public void setEntityPhoneId(String entityPhoneId) {
        this._persistence_set_entityPhoneId(entityPhoneId);
    }

    public String getFormattedPhoneNumber() {
        StringBuilder sb = new StringBuilder(30);
        sb.append(this.getPhoneNumber());
        if (StringUtils.isNotBlank((String)this.getExtensionNumber())) {
            sb.append(" x");
            sb.append(this.getExtensionNumber());
        }
        return sb.toString();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PersonDocumentPhone();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "phoneNumber") {
            return this.phoneNumber;
        }
        if (string == "phoneType") {
            return this.phoneType;
        }
        if (string == "entityTypeCode") {
            return this.entityTypeCode;
        }
        if (string == "countryCode") {
            return this.countryCode;
        }
        if (string == "extensionNumber") {
            return this.extensionNumber;
        }
        if (string == "phoneTypeCode") {
            return this.phoneTypeCode;
        }
        if (string == "entityPhoneId") {
            return this.entityPhoneId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "phoneNumber") {
            this.phoneNumber = (String)object;
            return;
        }
        if (string == "phoneType") {
            this.phoneType = (EntityPhoneTypeBo)object;
            return;
        }
        if (string == "entityTypeCode") {
            this.entityTypeCode = (String)object;
            return;
        }
        if (string == "countryCode") {
            this.countryCode = (String)object;
            return;
        }
        if (string == "extensionNumber") {
            this.extensionNumber = (String)object;
            return;
        }
        if (string == "phoneTypeCode") {
            this.phoneTypeCode = (String)object;
            return;
        }
        if (string == "entityPhoneId") {
            this.entityPhoneId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_phoneNumber() {
        this._persistence_checkFetched("phoneNumber");
        return this.phoneNumber;
    }

    public void _persistence_set_phoneNumber(String string) {
        this._persistence_checkFetchedForSet("phoneNumber");
        this._persistence_propertyChange("phoneNumber", this.phoneNumber, string);
        this.phoneNumber = string;
    }

    public EntityPhoneTypeBo _persistence_get_phoneType() {
        this._persistence_checkFetched("phoneType");
        return this.phoneType;
    }

    public void _persistence_set_phoneType(EntityPhoneTypeBo entityPhoneTypeBo) {
        this._persistence_checkFetchedForSet("phoneType");
        this._persistence_propertyChange("phoneType", this.phoneType, entityPhoneTypeBo);
        this.phoneType = entityPhoneTypeBo;
    }

    public String _persistence_get_entityTypeCode() {
        this._persistence_checkFetched("entityTypeCode");
        return this.entityTypeCode;
    }

    public void _persistence_set_entityTypeCode(String string) {
        this._persistence_checkFetchedForSet("entityTypeCode");
        this._persistence_propertyChange("entityTypeCode", this.entityTypeCode, string);
        this.entityTypeCode = string;
    }

    public String _persistence_get_countryCode() {
        this._persistence_checkFetched("countryCode");
        return this.countryCode;
    }

    public void _persistence_set_countryCode(String string) {
        this._persistence_checkFetchedForSet("countryCode");
        this._persistence_propertyChange("countryCode", this.countryCode, string);
        this.countryCode = string;
    }

    public String _persistence_get_extensionNumber() {
        this._persistence_checkFetched("extensionNumber");
        return this.extensionNumber;
    }

    public void _persistence_set_extensionNumber(String string) {
        this._persistence_checkFetchedForSet("extensionNumber");
        this._persistence_propertyChange("extensionNumber", this.extensionNumber, string);
        this.extensionNumber = string;
    }

    public String _persistence_get_phoneTypeCode() {
        this._persistence_checkFetched("phoneTypeCode");
        return this.phoneTypeCode;
    }

    public void _persistence_set_phoneTypeCode(String string) {
        this._persistence_checkFetchedForSet("phoneTypeCode");
        this._persistence_propertyChange("phoneTypeCode", this.phoneTypeCode, string);
        this.phoneTypeCode = string;
    }

    public String _persistence_get_entityPhoneId() {
        this._persistence_checkFetched("entityPhoneId");
        return this.entityPhoneId;
    }

    public void _persistence_set_entityPhoneId(String string) {
        this._persistence_checkFetchedForSet("entityPhoneId");
        this._persistence_propertyChange("entityPhoneId", this.entityPhoneId, string);
        this.entityPhoneId = string;
    }
}

