/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableEditableBase;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.springframework.util.StringUtils;

@Entity
@Table(name="KRIM_PND_ROLE_MT")
public class PersonDocumentRole
extends KimDocumentBoActivatableEditableBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger LOG = Logger.getLogger(PersonDocumentRole.class);
    private static final long serialVersionUID = 4908044213007222739L;
    @Id
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="KIM_TYP_ID")
    protected String kimTypeId;
    @Column(name="ROLE_NM")
    protected String roleName;
    @Transient
    protected RoleBo roleBo;
    @Column(name="NMSPC_CD")
    protected String namespaceCode;
    @Transient
    protected KimTypeBo kimRoleType;
    @Transient
    protected List<? extends KimAttributes> attributes = new ArrayList<KimAttributes>();
    @Transient
    protected transient List<KimAttributeField> definitions;
    @Transient
    protected transient Map<String, Object> attributeEntry;
    @OneToMany(targetEntity=KimDocumentRoleMember.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumns(value={@JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false), @JoinColumn(name="ROLE_ID", referencedColumnName="ROLE_ID", insertable=false, updatable=false)})
    protected List<KimDocumentRoleMember> rolePrncpls = new ArrayList<KimDocumentRoleMember>();
    @Transient
    protected KimDocumentRoleMember newRolePrncpl;
    @Transient
    protected boolean isEditable = true;

    public PersonDocumentRole() {
        this.attributeEntry = new HashMap<String, Object>();
    }

    public String getRoleId() {
        return this._persistence_get_roleId();
    }

    public void setRoleId(String roleId) {
        this._persistence_set_roleId(roleId);
    }

    public String getKimTypeId() {
        return this._persistence_get_kimTypeId();
    }

    public void setKimTypeId(String kimTypeId) {
        this._persistence_set_kimTypeId(kimTypeId);
    }

    public String getRoleName() {
        return this._persistence_get_roleName();
    }

    public void setRoleName(String roleName) {
        this._persistence_set_roleName(roleName);
    }

    public List<? extends KimAttributes> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<? extends KimAttributes> attributes) {
        this.attributes = attributes;
    }

    public KimTypeBo getKimRoleType() {
        if (this.kimRoleType == null && StringUtils.hasText((String)this._persistence_get_kimTypeId())) {
            this.kimRoleType = KimTypeBo.from((KimType)KimApiServiceLocator.getKimTypeInfoService().getKimType(this._persistence_get_kimTypeId()));
        }
        return this.kimRoleType;
    }

    public Map<String, KimAttributeField> getDefinitionsKeyedByAttributeName() {
        HashMap<String, KimAttributeField> map = new HashMap<String, KimAttributeField>();
        for (KimAttributeField field : this.getDefinitions()) {
            map.put(field.getAttributeField().getName(), field);
        }
        return map;
    }

    public List<KimAttributeField> getDefinitions() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)KimTypeBo.to((KimTypeBo)this.getKimRoleType()));
            try {
                this.definitions = kimTypeService != null ? kimTypeService.getAttributeDefinitions(this.getKimTypeId()) : Collections.emptyList();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve KimTypeService from remote system for KIM Role Type: " + this.getKimRoleType()), (Throwable)ex);
            }
        }
        return this.definitions;
    }

    public void setDefinitions(List<KimAttributeField> definitions) {
        this.definitions = definitions;
    }

    public Map<String, Object> getAttributeEntry() {
        if (this.attributeEntry == null || this.attributeEntry.isEmpty()) {
            this.attributeEntry = KIMServiceLocatorInternal.getUiDocumentService().getAttributeEntries(this.getDefinitions());
        }
        return this.attributeEntry;
    }

    public void setAttributeEntry(Map<String, Object> attributeEntry) {
        this.attributeEntry = attributeEntry;
    }

    public List<KimDocumentRoleMember> getRolePrncpls() {
        return this._persistence_get_rolePrncpls();
    }

    public void setRolePrncpls(List<KimDocumentRoleMember> rolePrncpls) {
        this._persistence_set_rolePrncpls(rolePrncpls);
    }

    public KimDocumentRoleMember getNewRolePrncpl() {
        return this.newRolePrncpl;
    }

    public void setNewRolePrncpl(KimDocumentRoleMember newRolePrncpl) {
        this.newRolePrncpl = newRolePrncpl;
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public RoleBo getRoleBo() {
        return this.roleBo;
    }

    public void setRoleBo(RoleBo roleBo) {
        this.roleBo = roleBo;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PersonDocumentRole();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "rolePrncpls") {
            return this.rolePrncpls;
        }
        if (string == "roleName") {
            return this.roleName;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "kimTypeId") {
            return this.kimTypeId;
        }
        if (string == "roleId") {
            return this.roleId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "rolePrncpls") {
            this.rolePrncpls = (List)object;
            return;
        }
        if (string == "roleName") {
            this.roleName = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "kimTypeId") {
            this.kimTypeId = (String)object;
            return;
        }
        if (string == "roleId") {
            this.roleId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_rolePrncpls() {
        this._persistence_checkFetched("rolePrncpls");
        return this.rolePrncpls;
    }

    public void _persistence_set_rolePrncpls(List list) {
        this._persistence_checkFetchedForSet("rolePrncpls");
        this._persistence_propertyChange("rolePrncpls", this.rolePrncpls, list);
        this.rolePrncpls = list;
    }

    public String _persistence_get_roleName() {
        this._persistence_checkFetched("roleName");
        return this.roleName;
    }

    public void _persistence_set_roleName(String string) {
        this._persistence_checkFetchedForSet("roleName");
        this._persistence_propertyChange("roleName", this.roleName, string);
        this.roleName = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }

    public String _persistence_get_kimTypeId() {
        this._persistence_checkFetched("kimTypeId");
        return this.kimTypeId;
    }

    public void _persistence_set_kimTypeId(String string) {
        this._persistence_checkFetchedForSet("kimTypeId");
        this._persistence_propertyChange("kimTypeId", this.kimTypeId, string);
        this.kimTypeId = string;
    }

    public String _persistence_get_roleId() {
        this._persistence_checkFetched("roleId");
        return this.roleId;
    }

    public void _persistence_set_roleId(String string) {
        this._persistence_checkFetchedForSet("roleId");
        this._persistence_propertyChange("roleId", this.roleId, string);
        this.roleId = string;
    }
}

