/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.bo.ui.GroupDocumentQualifier;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.IdentityManagementTypeAttributeTransactionalDocument;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_GRP_DOCUMENT_T")
public class IdentityManagementGroupDocument
extends IdentityManagementTypeAttributeTransactionalDocument
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    private static final Logger LOG = Logger.getLogger(IdentityManagementGroupDocument.class);
    private static final long serialVersionUID = 1L;
    @Column(name="GRP_ID")
    protected String groupId;
    @Column(name="KIM_TYP_ID")
    protected String groupTypeId;
    @Transient
    protected String groupTypeName;
    @Column(name="GRP_NMSPC")
    protected String groupNamespace;
    @Column(name="GRP_NM")
    protected String groupName;
    @Column(name="GRP_DESC")
    protected String groupDescription;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    protected boolean active = true;
    @Transient
    protected boolean editing;
    @OneToMany(targetEntity=GroupDocumentMember.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    private List<GroupDocumentMember> members = new AutoPopulatingList(GroupDocumentMember.class);
    @OneToMany(targetEntity=GroupDocumentQualifier.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    private List<GroupDocumentQualifier> qualifiers = new AutoPopulatingList(GroupDocumentQualifier.class);

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setRoleId(String groupId) {
        this._persistence_set_groupId(groupId);
    }

    public void addMember(GroupDocumentMember member) {
        this.getMembers().add(member);
    }

    @Override
    public KimType getKimType() {
        if (this.getGroupTypeId() != null) {
            return KimApiServiceLocator.getKimTypeInfoService().getKimType(this.getGroupTypeId());
        }
        return null;
    }

    public GroupDocumentMember getBlankMember() {
        return new GroupDocumentMember();
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            KIMServiceLocatorInternal.getUiDocumentService().saveGroup(this);
        }
    }

    public void prepareForSave() {
        String groupId;
        if (StringUtils.isBlank((String)this.getGroupId())) {
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_GRP_ID_S");
            groupId = incrementer.nextStringValue();
            this.setGroupId(groupId);
        } else {
            groupId = this.getGroupId();
        }
        if (this.getMembers() != null) {
            for (GroupDocumentMember member : this.getMembers()) {
                member.setGroupId(this.getGroupId());
                if (StringUtils.isBlank((String)member.getGroupMemberId())) {
                    DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_GRP_MBR_ID_S");
                    member.setGroupMemberId(incrementer.nextStringValue());
                }
                if (!StringUtils.isBlank((String)member.getDocumentNumber())) continue;
                member.setDocumentNumber(this.getDocumentNumber());
            }
        }
        int index = 0;
        if (this.getDefinitions() != null) {
            for (KimAttributeField key : this.getDefinitions()) {
                if (this.getQualifiers().size() > index) {
                    GroupDocumentQualifier qualifier = this.getQualifiers().get(index);
                    qualifier.setKimAttrDefnId(this.getKimAttributeDefnId(key));
                    qualifier.setKimTypId(this.getKimType().getId());
                    qualifier.setGroupId(groupId);
                }
                ++index;
            }
        }
    }

    public void initializeDocumentForNewGroup() {
        if (StringUtils.isBlank((String)this._persistence_get_groupId())) {
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_GRP_ID_S");
            this._persistence_set_groupId(incrementer.nextStringValue());
        }
        if (StringUtils.isBlank((String)this._persistence_get_groupTypeId())) {
            this._persistence_set_groupTypeId("1");
        }
    }

    public String getGroupId() {
        return this._persistence_get_groupId();
    }

    public void setGroupId(String groupId) {
        this._persistence_set_groupId(groupId);
    }

    public String getGroupName() {
        return this._persistence_get_groupName();
    }

    public void setGroupName(String groupName) {
        this._persistence_set_groupName(groupName);
    }

    public String getGroupDescription() {
        return this._persistence_get_groupDescription();
    }

    public void setGroupDescription(String groupDescription) {
        this._persistence_set_groupDescription(groupDescription);
    }

    public String getGroupNamespace() {
        return this._persistence_get_groupNamespace();
    }

    public void setGroupNamespace(String groupNamespace) {
        this._persistence_set_groupNamespace(groupNamespace);
    }

    public String getGroupTypeId() {
        return this._persistence_get_groupTypeId();
    }

    public void setGroupTypeId(String groupTypeId) {
        this._persistence_set_groupTypeId(groupTypeId);
    }

    public String getGroupTypeName() {
        return this.groupTypeName;
    }

    public void setGroupTypeName(String groupTypeName) {
        this.groupTypeName = groupTypeName;
    }

    public List<GroupDocumentMember> getMembers() {
        return this._persistence_get_members();
    }

    public void setMembers(List<GroupDocumentMember> members) {
        this._persistence_set_members(members);
    }

    public List<GroupDocumentQualifier> getQualifiers() {
        return this._persistence_get_qualifiers();
    }

    public void setQualifiers(List<GroupDocumentQualifier> qualifiers) {
        this._persistence_set_qualifiers(qualifiers);
    }

    public GroupDocumentQualifier getQualifier(String kimAttributeDefnId) {
        for (GroupDocumentQualifier qualifier : this._persistence_get_qualifiers()) {
            if (!qualifier.getKimAttrDefnId().equals(kimAttributeDefnId)) continue;
            return qualifier;
        }
        return null;
    }

    public Map<String, String> getQualifiersAsAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (GroupDocumentQualifier qualifier : this._persistence_get_qualifiers()) {
            if (qualifier.getKimAttribute() != null) {
                attributes.put(qualifier.getKimAttribute().getAttributeName(), qualifier.getAttrVal());
                continue;
            }
            LOG.warn((Object)("Unknown attribute ID on group: " + qualifier.getKimAttrDefnId() + " / value=" + qualifier.getAttrVal()));
            attributes.put("Unknown Attribute ID: " + qualifier.getKimAttrDefnId(), qualifier.getAttrVal());
        }
        return attributes;
    }

    @Override
    public void setDefinitions(List<KimAttributeField> definitions) {
        super.setDefinitions(definitions);
        if (this.getQualifiers() == null || this.getQualifiers().size() < 1) {
            this.setQualifiers(new ArrayList<GroupDocumentQualifier>());
            if (this.getDefinitions() != null) {
                for (KimAttributeField key : this.getDefinitions()) {
                    GroupDocumentQualifier qualifier = new GroupDocumentQualifier();
                    qualifier.setKimAttrDefnId(this.getKimAttributeDefnId(key));
                    this.getQualifiers().add(qualifier);
                }
            }
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    @Override
    public void setKimType(KimType kimType) {
        super.setKimType(kimType);
        if (kimType != null) {
            this.setGroupTypeId(kimType.getId());
            this.setGroupTypeName(kimType.getName());
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new IdentityManagementGroupDocument();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "groupId") {
            return this.groupId;
        }
        if (string == "groupName") {
            return this.groupName;
        }
        if (string == "groupDescription") {
            return this.groupDescription;
        }
        if (string == "groupNamespace") {
            return this.groupNamespace;
        }
        if (string == "qualifiers") {
            return this.qualifiers;
        }
        if (string == "groupTypeId") {
            return this.groupTypeId;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "members") {
            return this.members;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "groupId") {
            this.groupId = (String)object;
            return;
        }
        if (string == "groupName") {
            this.groupName = (String)object;
            return;
        }
        if (string == "groupDescription") {
            this.groupDescription = (String)object;
            return;
        }
        if (string == "groupNamespace") {
            this.groupNamespace = (String)object;
            return;
        }
        if (string == "qualifiers") {
            this.qualifiers = (List)object;
            return;
        }
        if (string == "groupTypeId") {
            this.groupTypeId = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "members") {
            this.members = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_groupId() {
        this._persistence_checkFetched("groupId");
        return this.groupId;
    }

    public void _persistence_set_groupId(String string) {
        this._persistence_checkFetchedForSet("groupId");
        this.groupId = string;
    }

    public String _persistence_get_groupName() {
        this._persistence_checkFetched("groupName");
        return this.groupName;
    }

    public void _persistence_set_groupName(String string) {
        this._persistence_checkFetchedForSet("groupName");
        this.groupName = string;
    }

    public String _persistence_get_groupDescription() {
        this._persistence_checkFetched("groupDescription");
        return this.groupDescription;
    }

    public void _persistence_set_groupDescription(String string) {
        this._persistence_checkFetchedForSet("groupDescription");
        this.groupDescription = string;
    }

    public String _persistence_get_groupNamespace() {
        this._persistence_checkFetched("groupNamespace");
        return this.groupNamespace;
    }

    public void _persistence_set_groupNamespace(String string) {
        this._persistence_checkFetchedForSet("groupNamespace");
        this.groupNamespace = string;
    }

    public List _persistence_get_qualifiers() {
        this._persistence_checkFetched("qualifiers");
        return this.qualifiers;
    }

    public void _persistence_set_qualifiers(List list) {
        this._persistence_checkFetchedForSet("qualifiers");
        this.qualifiers = list;
    }

    public String _persistence_get_groupTypeId() {
        this._persistence_checkFetched("groupTypeId");
        return this.groupTypeId;
    }

    public void _persistence_set_groupTypeId(String string) {
        this._persistence_checkFetchedForSet("groupTypeId");
        this.groupTypeId = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public List _persistence_get_members() {
        this._persistence_checkFetched("members");
        return this.members;
    }

    public void _persistence_set_members(List list) {
        this._persistence_checkFetchedForSet("members");
        this.members = list;
    }
}

