/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.document.TransactionalDocumentBase;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.AutoPopulatingList;

@MappedSuperclass
@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="FDOC_NBR"))})
public class IdentityManagementKimDocument
extends TransactionalDocumentBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = Logger.getLogger(IdentityManagementKimDocument.class);
    @OneToMany(targetEntity=RoleDocumentDelegation.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)
    protected List<RoleDocumentDelegation> delegations;
    @Transient
    protected List<RoleDocumentDelegationMember> delegationMembers;

    public IdentityManagementKimDocument() {
        this.delegations = new AutoPopulatingList(RoleDocumentDelegation.class);
        this.delegationMembers = new AutoPopulatingList(RoleDocumentDelegationMember.class);
    }

    @Transient
    protected void addDelegationMemberToDelegation(RoleDocumentDelegationMember delegationMember) {
        RoleDocumentDelegation delegation = DelegationType.PRIMARY.getCode().equals(delegationMember.getDelegationTypeCode()) ? this.getPrimaryDelegation() : this.getSecondaryDelegation();
        delegationMember.setDelegationId(delegation.getDelegationId());
        delegation.getMembers().add(delegationMember);
        delegation.setRoleId(delegationMember.getRoleBo().getId());
        delegation.setKimTypeId(delegationMember.getRoleBo().getKimTypeId());
    }

    protected RoleDocumentDelegation getPrimaryDelegation() {
        RoleDocumentDelegation primaryDelegation = null;
        for (RoleDocumentDelegation delegation : this.getDelegations()) {
            if (!delegation.isDelegationPrimary()) continue;
            primaryDelegation = delegation;
        }
        if (primaryDelegation == null) {
            primaryDelegation = new RoleDocumentDelegation();
            primaryDelegation.setDelegationId(this.getDelegationId());
            primaryDelegation.setDelegationTypeCode(DelegationType.PRIMARY.getCode());
            primaryDelegation.setDocumentNumber(this.getDocumentNumber());
            this.getDelegations().add(primaryDelegation);
        }
        return primaryDelegation;
    }

    protected String getDelegationId() {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_DLGN_ID_S");
        return incrementer.nextStringValue();
    }

    protected RoleDocumentDelegation getSecondaryDelegation() {
        RoleDocumentDelegation secondaryDelegation = null;
        for (RoleDocumentDelegation delegation : this.getDelegations()) {
            if (!delegation.isDelegationSecondary()) continue;
            secondaryDelegation = delegation;
        }
        if (secondaryDelegation == null) {
            secondaryDelegation = new RoleDocumentDelegation();
            secondaryDelegation.setDelegationId(this.getDelegationId());
            secondaryDelegation.setDelegationTypeCode(DelegationType.SECONDARY.getCode());
            secondaryDelegation.setDocumentNumber(this.getDocumentNumber());
            this.getDelegations().add(secondaryDelegation);
        }
        return secondaryDelegation;
    }

    public List<RoleDocumentDelegation> getDelegations() {
        return this._persistence_get_delegations();
    }

    public void setDelegations(List<RoleDocumentDelegation> delegations) {
        this._persistence_set_delegations(delegations);
    }

    public List<RoleDocumentDelegationMember> getDelegationMembers() {
        return this.delegationMembers;
    }

    public void setDelegationMembers(List<RoleDocumentDelegationMember> delegationMembers) {
        this.delegationMembers = delegationMembers;
    }

    public String getKimAttributeDefnId(KimAttributeField definition) {
        return definition.getId();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new IdentityManagementKimDocument(persistenceObject);
    }

    public IdentityManagementKimDocument(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "delegations") {
            return this.delegations;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "delegations") {
            this.delegations = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_delegations() {
        this._persistence_checkFetched("delegations");
        return this.delegations;
    }

    public void _persistence_set_delegations(List list) {
        this._persistence_checkFetchedForSet("delegations");
        this._persistence_propertyChange("delegations", this.delegations, list);
        this.delegations = list;
    }
}

