/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.IdentityManagementTypeAttributeTransactionalDocument;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_ROLE_DOCUMENT_T")
public class IdentityManagementRoleDocument
extends IdentityManagementTypeAttributeTransactionalDocument
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="ROLE_TYP_ID")
    protected String roleTypeId;
    @Transient
    protected String roleTypeName;
    @Column(name="ROLE_NMSPC")
    protected String roleNamespace = "";
    @Column(name="ROLE_NM")
    protected String roleName = "";
    @Column(name="DESC_TXT")
    protected String roleDescription = "";
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    protected boolean active = true;
    @Transient
    protected boolean editing;
    @OneToMany(targetEntity=KimDocumentRolePermission.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<KimDocumentRolePermission> permissions = new AutoPopulatingList(KimDocumentRolePermission.class);
    @OneToMany(targetEntity=KimDocumentRoleResponsibility.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<KimDocumentRoleResponsibility> responsibilities = new AutoPopulatingList(KimDocumentRoleResponsibility.class);
    @OneToMany(targetEntity=KimDocumentRoleMember.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<KimDocumentRoleMember> modifiedMembers = new AutoPopulatingList(KimDocumentRoleMember.class);
    @Transient
    private List<RoleDocumentDelegationMember> delegationMembers = new AutoPopulatingList(RoleDocumentDelegationMember.class);
    @OneToMany(targetEntity=RoleDocumentDelegation.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    private List<RoleDocumentDelegation> delegations = new AutoPopulatingList(RoleDocumentDelegation.class);
    @Transient
    protected List<KimDocumentRoleMember> searchResultMembers = new ArrayList<KimDocumentRoleMember>();
    @Transient
    protected List<KimDocumentRoleMember> members = new ArrayList<KimDocumentRoleMember>();
    @Transient
    private transient ResponsibilityService responsibilityService;
    @Transient
    private transient ResponsibilityInternalService responsibilityInternalService;
    @Transient
    protected RoleMemberMetaDataType memberMetaDataType = RoleMemberMetaDataType.MEMBER_NAME;

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setRoleId(String roleId) {
        this._persistence_set_roleId(roleId);
    }

    public String getRoleName() {
        return this._persistence_get_roleName();
    }

    public void setRoleName(String roleName) {
        this._persistence_set_roleName(roleName);
    }

    public String getRoleDescription() {
        return this._persistence_get_roleDescription();
    }

    public void setRoleDescription(String roleDescription) {
        this._persistence_set_roleDescription(roleDescription);
    }

    public String getRoleNamespace() {
        return this._persistence_get_roleNamespace();
    }

    public void setRoleNamespace(String roleNamespace) {
        this._persistence_set_roleNamespace(roleNamespace);
    }

    public String getRoleTypeId() {
        return this._persistence_get_roleTypeId();
    }

    public void setRoleTypeId(String roleTypeId) {
        this._persistence_set_roleTypeId(roleTypeId);
    }

    public String getRoleTypeName() {
        if (this.roleTypeName == null) {
            if (this.kimType != null) {
                this.roleTypeName = this.kimType.getName();
            } else if (this._persistence_get_roleTypeId() != null) {
                this.setKimType(KimApiServiceLocator.getKimTypeInfoService().getKimType(this._persistence_get_roleTypeId()));
                if (this.kimType != null) {
                    this.roleTypeName = this.kimType.getName();
                }
            }
        }
        return this.roleTypeName;
    }

    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    @Override
    public List<RoleDocumentDelegationMember> getDelegationMembers() {
        return this.delegationMembers;
    }

    @Override
    public void setDelegationMembers(List<RoleDocumentDelegationMember> delegationMembers) {
        this.delegationMembers = delegationMembers;
    }

    public List<KimDocumentRolePermission> getPermissions() {
        return this._persistence_get_permissions();
    }

    public void setPermissions(List<KimDocumentRolePermission> permissions) {
        this._persistence_set_permissions(permissions);
    }

    public List<KimDocumentRoleResponsibility> getResponsibilities() {
        return this._persistence_get_responsibilities();
    }

    public void setResponsibilities(List<KimDocumentRoleResponsibility> responsibilities) {
        this._persistence_set_responsibilities(responsibilities);
    }

    public List<KimDocumentRoleMember> getMembers() {
        return this.members;
    }

    public void setMemberMetaDataTypeToSort(Integer columnNumber) {
        switch (columnNumber) {
            case 1: {
                this.memberMetaDataType = RoleMemberMetaDataType.MEMBER_ID;
                break;
            }
            case 2: {
                this.memberMetaDataType = RoleMemberMetaDataType.MEMBER_NAME;
                break;
            }
            case 3: {
                this.memberMetaDataType = RoleMemberMetaDataType.FULL_MEMBER_NAME;
                break;
            }
            default: {
                this.memberMetaDataType = RoleMemberMetaDataType.MEMBER_NAME;
            }
        }
    }

    public RoleMemberMetaDataType getMemberMetaDataType() {
        return this.memberMetaDataType;
    }

    public void setMemberMetaDataType(RoleMemberMetaDataType memberMetaDataType) {
        this.memberMetaDataType = memberMetaDataType;
    }

    public KimDocumentRoleMember getMember(String roleMemberId) {
        if (StringUtils.isEmpty((String)roleMemberId)) {
            return null;
        }
        for (KimDocumentRoleMember roleMember : this.getMembers()) {
            if (!roleMemberId.equals(roleMember.getRoleMemberId())) continue;
            return roleMember;
        }
        return null;
    }

    public void setMembers(List<KimDocumentRoleMember> members) {
        this.members = members;
    }

    public List<KimDocumentRoleMember> getModifiedMembers() {
        return this._persistence_get_modifiedMembers();
    }

    public void setModifiedMembers(List<KimDocumentRoleMember> modifiedMembers) {
        this._persistence_set_modifiedMembers(modifiedMembers);
    }

    public List<KimDocumentRoleMember> getSearchResultMembers() {
        return this.searchResultMembers;
    }

    public void setSearchResultMembers(List<KimDocumentRoleMember> searchResultMembers) {
        this.searchResultMembers = searchResultMembers;
    }

    public void addResponsibility(KimDocumentRoleResponsibility roleResponsibility) {
        if (!this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResponsibility.getResponsibilityId())) {
            roleResponsibility.getRoleRspActions().add(this.getNewRespAction(roleResponsibility));
        }
        this.getResponsibilities().add(roleResponsibility);
    }

    protected KimDocumentRoleResponsibilityAction getNewRespAction(KimDocumentRoleResponsibility roleResponsibility) {
        KimDocumentRoleResponsibilityAction roleRspAction = new KimDocumentRoleResponsibilityAction();
        roleRspAction.setKimResponsibility(roleResponsibility.getKimResponsibility());
        roleRspAction.setRoleResponsibilityId(roleResponsibility.getRoleResponsibilityId());
        return roleRspAction;
    }

    public void addDelegationMember(RoleDocumentDelegationMember newDelegationMember) {
        this.getDelegationMembers().add(newDelegationMember);
    }

    public void addMember(KimDocumentRoleMember member) {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_MBR_ID_S");
        member.setRoleMemberId(incrementer.nextStringValue());
        this.setupMemberRspActions(member);
        this.getModifiedMembers().add(member);
    }

    public KimDocumentRoleMember getBlankMember() {
        KimDocumentRoleMember member = new KimDocumentRoleMember();
        if (this.getDefinitions() != null) {
            for (KimAttributeField key : this.getDefinitions()) {
                KimDocumentRoleQualifier qualifier = new KimDocumentRoleQualifier();
                qualifier.setKimAttrDefnId(this.getKimAttributeDefnId(key));
                member.getQualifiers().add(qualifier);
            }
        }
        this.setupMemberRspActions(member);
        return member;
    }

    public RoleDocumentDelegationMember getBlankDelegationMember() {
        RoleDocumentDelegationMember member = new RoleDocumentDelegationMember();
        if (this.getDefinitions() != null) {
            for (KimAttributeField key : this.getDefinitions()) {
                RoleDocumentDelegationMemberQualifier qualifier = new RoleDocumentDelegationMemberQualifier();
                this.setAttrDefnIdForDelMemberQualifier(qualifier, key);
                member.getQualifiers().add(qualifier);
            }
        }
        return member;
    }

    public void setupMemberRspActions(KimDocumentRoleMember member) {
        member.getRoleRspActions().clear();
        for (KimDocumentRoleResponsibility roleResp : this.getResponsibilities()) {
            if (!this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResp.getResponsibilityId())) continue;
            KimDocumentRoleResponsibilityAction action = new KimDocumentRoleResponsibilityAction();
            action.setRoleResponsibilityId("*");
            action.setRoleMemberId(member.getRoleMemberId());
            member.getRoleRspActions().add(action);
            break;
        }
    }

    public void updateMembers(IdentityManagementRoleDocumentForm roleDocumentForm) {
        for (KimDocumentRoleMember member : roleDocumentForm.getRoleDocument().getMembers()) {
            roleDocumentForm.getRoleDocument().setupMemberRspActions(member);
        }
    }

    public void updateMembers(KimDocumentRoleResponsibility newResponsibility) {
        for (KimDocumentRoleMember member : this.getMembers()) {
            this.setupMemberRspActions(newResponsibility, member);
        }
    }

    public void setupMemberRspActions(KimDocumentRoleResponsibility roleResp, KimDocumentRoleMember member) {
        if ((member.getRoleRspActions() == null || member.getRoleRspActions().size() < 1) && this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResp.getResponsibilityId())) {
            KimDocumentRoleResponsibilityAction action = new KimDocumentRoleResponsibilityAction();
            action.setRoleResponsibilityId("*");
            action.setRoleMemberId(member.getRoleMemberId());
            if (member.getRoleRspActions() == null) {
                member.setRoleRspActions(new ArrayList<KimDocumentRoleResponsibilityAction>());
            }
            member.getRoleRspActions().add(action);
        }
    }

    protected void setAttrDefnIdForDelMemberQualifier(RoleDocumentDelegationMemberQualifier qualifier, KimAttributeField definition) {
        qualifier.setKimAttrDefnId(definition.getId());
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            KIMServiceLocatorInternal.getUiDocumentService().saveRole(this);
        }
    }

    public void initializeDocumentForNewRole() {
        if (StringUtils.isBlank((String)this._persistence_get_roleId())) {
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_ID_S");
            this._persistence_set_roleId(incrementer.nextStringValue());
        }
        if (StringUtils.isBlank((String)this._persistence_get_roleTypeId())) {
            this._persistence_set_roleTypeId("1");
        }
    }

    public String getRoleId() {
        if (StringUtils.isBlank((String)this._persistence_get_roleId())) {
            this.initializeDocumentForNewRole();
        }
        return this._persistence_get_roleId();
    }

    public void prepareForSave() {
        DataFieldMaxValueIncrementer incrementer;
        String roleId;
        if (StringUtils.isBlank((String)this.getRoleId())) {
            DataFieldMaxValueIncrementer incrementer2 = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_ID_S");
            roleId = incrementer2.nextStringValue();
            this.setRoleId(roleId);
        } else {
            roleId = this.getRoleId();
        }
        if (this.getPermissions() != null) {
            for (KimDocumentRolePermission permission : this.getPermissions()) {
                permission.setRoleId(roleId);
                permission.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isBlank((String)permission.getRolePermissionId())) continue;
                incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_PERM_ID_S");
                permission.setRolePermissionId(incrementer.nextStringValue());
            }
        }
        if (this.getResponsibilities() != null) {
            for (KimDocumentRoleResponsibility responsibility : this.getResponsibilities()) {
                DataFieldMaxValueIncrementer incrementer3;
                String nextRoleResponsibilityId = null;
                if (StringUtils.isBlank((String)responsibility.getRoleResponsibilityId())) {
                    incrementer3 = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_RSP_ID_S");
                    nextRoleResponsibilityId = incrementer3.nextStringValue();
                    responsibility.setRoleResponsibilityId(nextRoleResponsibilityId);
                } else {
                    responsibility.setDocumentNumber(this.getDocumentNumber());
                    responsibility.setVersionNumber(null);
                }
                responsibility.setRoleId(roleId);
                if (this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(responsibility.getResponsibilityId())) continue;
                if (StringUtils.isBlank((String)responsibility.getRoleRspActions().get(0).getRoleResponsibilityActionId())) {
                    incrementer3 = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_RSP_ACTN_ID_S");
                    responsibility.getRoleRspActions().get(0).setRoleResponsibilityActionId(incrementer3.nextStringValue());
                }
                if (StringUtils.isBlank((String)responsibility.getRoleRspActions().get(0).getRoleResponsibilityId())) {
                    if (StringUtils.isBlank((String)nextRoleResponsibilityId)) {
                        responsibility.getRoleRspActions().get(0).setRoleResponsibilityId(responsibility.getRoleResponsibilityId());
                    } else {
                        responsibility.getRoleRspActions().get(0).setRoleResponsibilityId(nextRoleResponsibilityId);
                    }
                }
                responsibility.getRoleRspActions().get(0).setRoleMemberId("*");
                responsibility.getRoleRspActions().get(0).setDocumentNumber(this.getDocumentNumber());
            }
        }
        if (this.getModifiedMembers() != null) {
            for (KimDocumentRoleMember member : this.getModifiedMembers()) {
                member.setDocumentNumber(this.getDocumentNumber());
                member.setRoleId(roleId);
                if (StringUtils.isBlank((String)member.getRoleMemberId())) {
                    incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_MBR_ID_S");
                    member.setRoleMemberId(incrementer.nextStringValue());
                }
                for (KimDocumentRoleQualifier qualifier : member.getQualifiers()) {
                    qualifier.setDocumentNumber(this.getDocumentNumber());
                    qualifier.setRoleMemberId(member.getRoleMemberId());
                    qualifier.setKimTypId(this.getKimType().getId());
                }
                for (KimDocumentRoleResponsibilityAction roleRespAction : member.getRoleRspActions()) {
                    if (StringUtils.isBlank((String)roleRespAction.getRoleResponsibilityActionId())) {
                        DataFieldMaxValueIncrementer incrementer4 = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_RSP_ACTN_ID_S");
                        roleRespAction.setRoleResponsibilityActionId(incrementer4.nextStringValue());
                    }
                    roleRespAction.setRoleMemberId(member.getRoleMemberId());
                    roleRespAction.setDocumentNumber(this.getDocumentNumber());
                    if (StringUtils.equals((String)roleRespAction.getRoleResponsibilityId(), (String)"*")) continue;
                    for (KimDocumentRoleResponsibility responsibility : this.getResponsibilities()) {
                        if (!StringUtils.equals((String)roleRespAction.getKimResponsibility().getId(), (String)responsibility.getResponsibilityId())) continue;
                        roleRespAction.setRoleResponsibilityId(responsibility.getRoleResponsibilityId());
                    }
                }
            }
        }
        if (this.getDelegationMembers() != null) {
            for (RoleDocumentDelegationMember delegationMember : this.getDelegationMembers()) {
                delegationMember.setDocumentNumber(this.getDocumentNumber());
                this.addDelegationMemberToDelegation(delegationMember);
            }
            for (RoleDocumentDelegation delegation : this.getDelegations()) {
                delegation.setDocumentNumber(this.getDocumentNumber());
                delegation.setKimTypeId(this.getKimType().getId());
                AutoPopulatingList membersToRemove = new AutoPopulatingList(RoleDocumentDelegationMember.class);
                for (RoleDocumentDelegationMember member : delegation.getMembers()) {
                    if (delegation.getDelegationId().equals(member.getDelegationId()) && delegation.getDelegationTypeCode().equals(member.getDelegationTypeCode())) {
                        for (RoleDocumentDelegationMemberQualifier qualifier : member.getQualifiers()) {
                            qualifier.setKimTypId(this.getKimType().getId());
                        }
                        continue;
                    }
                    membersToRemove.add(member);
                }
                if (!membersToRemove.isEmpty()) {
                    for (RoleDocumentDelegationMember member : membersToRemove) {
                        delegation.getMembers().remove((Object)member);
                    }
                }
                delegation.setRoleId(roleId);
            }
        }
    }

    public ResponsibilityService getResponsibilityService() {
        if (this.responsibilityService == null) {
            this.responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return this.responsibilityService;
    }

    public ResponsibilityInternalService getResponsibilityInternalService() {
        if (this.responsibilityInternalService == null) {
            this.responsibilityInternalService = KimImplServiceLocator.getResponsibilityInternalService();
        }
        return this.responsibilityInternalService;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    @Override
    public List<RoleDocumentDelegation> getDelegations() {
        return this._persistence_get_delegations();
    }

    @Override
    public void setDelegations(List<RoleDocumentDelegation> delegations) {
        this._persistence_set_delegations(delegations);
    }

    @Override
    public void setKimType(KimType kimType) {
        super.setKimType(kimType);
        if (kimType != null) {
            this.setRoleTypeId(kimType.getId());
            this.setRoleTypeName(kimType.getName());
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new IdentityManagementRoleDocument();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "roleName") {
            return this.roleName;
        }
        if (string == "roleDescription") {
            return this.roleDescription;
        }
        if (string == "roleTypeId") {
            return this.roleTypeId;
        }
        if (string == "delegations") {
            return this.delegations;
        }
        if (string == "roleNamespace") {
            return this.roleNamespace;
        }
        if (string == "responsibilities") {
            return this.responsibilities;
        }
        if (string == "permissions") {
            return this.permissions;
        }
        if (string == "modifiedMembers") {
            return this.modifiedMembers;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "roleId") {
            return this.roleId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "roleName") {
            this.roleName = (String)object;
            return;
        }
        if (string == "roleDescription") {
            this.roleDescription = (String)object;
            return;
        }
        if (string == "roleTypeId") {
            this.roleTypeId = (String)object;
            return;
        }
        if (string == "delegations") {
            this.delegations = (List)object;
            return;
        }
        if (string == "roleNamespace") {
            this.roleNamespace = (String)object;
            return;
        }
        if (string == "responsibilities") {
            this.responsibilities = (List)object;
            return;
        }
        if (string == "permissions") {
            this.permissions = (List)object;
            return;
        }
        if (string == "modifiedMembers") {
            this.modifiedMembers = (List)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "roleId") {
            this.roleId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_roleName() {
        this._persistence_checkFetched("roleName");
        return this.roleName;
    }

    public void _persistence_set_roleName(String string) {
        this._persistence_checkFetchedForSet("roleName");
        this._persistence_propertyChange("roleName", this.roleName, string);
        this.roleName = string;
    }

    public String _persistence_get_roleDescription() {
        this._persistence_checkFetched("roleDescription");
        return this.roleDescription;
    }

    public void _persistence_set_roleDescription(String string) {
        this._persistence_checkFetchedForSet("roleDescription");
        this._persistence_propertyChange("roleDescription", this.roleDescription, string);
        this.roleDescription = string;
    }

    public String _persistence_get_roleTypeId() {
        this._persistence_checkFetched("roleTypeId");
        return this.roleTypeId;
    }

    public void _persistence_set_roleTypeId(String string) {
        this._persistence_checkFetchedForSet("roleTypeId");
        this._persistence_propertyChange("roleTypeId", this.roleTypeId, string);
        this.roleTypeId = string;
    }

    @Override
    public List _persistence_get_delegations() {
        this._persistence_checkFetched("delegations");
        return this.delegations;
    }

    @Override
    public void _persistence_set_delegations(List list) {
        this._persistence_checkFetchedForSet("delegations");
        this._persistence_propertyChange("delegations", this.delegations, list);
        this.delegations = list;
    }

    public String _persistence_get_roleNamespace() {
        this._persistence_checkFetched("roleNamespace");
        return this.roleNamespace;
    }

    public void _persistence_set_roleNamespace(String string) {
        this._persistence_checkFetchedForSet("roleNamespace");
        this._persistence_propertyChange("roleNamespace", this.roleNamespace, string);
        this.roleNamespace = string;
    }

    public List _persistence_get_responsibilities() {
        this._persistence_checkFetched("responsibilities");
        return this.responsibilities;
    }

    public void _persistence_set_responsibilities(List list) {
        this._persistence_checkFetchedForSet("responsibilities");
        this._persistence_propertyChange("responsibilities", this.responsibilities, list);
        this.responsibilities = list;
    }

    public List _persistence_get_permissions() {
        this._persistence_checkFetched("permissions");
        return this.permissions;
    }

    public void _persistence_set_permissions(List list) {
        this._persistence_checkFetchedForSet("permissions");
        this._persistence_propertyChange("permissions", this.permissions, list);
        this.permissions = list;
    }

    public List _persistence_get_modifiedMembers() {
        this._persistence_checkFetched("modifiedMembers");
        return this.modifiedMembers;
    }

    public void _persistence_set_modifiedMembers(List list) {
        this._persistence_checkFetchedForSet("modifiedMembers");
        this._persistence_propertyChange("modifiedMembers", this.modifiedMembers, list);
        this.modifiedMembers = list;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_roleId() {
        this._persistence_checkFetched("roleId");
        return this.roleId;
    }

    public void _persistence_set_roleId(String string) {
        this._persistence_checkFetchedForSet("roleId");
        this._persistence_propertyChange("roleId", this.roleId, string);
        this.roleId = string;
    }

    public static enum RoleMemberMetaDataType implements Comparator<KimDocumentRoleMember>
    {
        MEMBER_ID("memberId"),
        MEMBER_NAME("memberName"),
        FULL_MEMBER_NAME("memberFullName");

        private final String attributeName;

        private RoleMemberMetaDataType(String anAttributeName) {
            this.attributeName = anAttributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public int compare(KimDocumentRoleMember m1, KimDocumentRoleMember m2) {
            if (m1 == null && m2 == null) {
                return 0;
            }
            if (m1 == null) {
                return -1;
            }
            if (m2 == null) {
                return 1;
            }
            if (this.getAttributeName().equals(MEMBER_ID.getAttributeName())) {
                return m1.getMemberId().compareToIgnoreCase(m2.getMemberId());
            }
            if (this.getAttributeName().equals(FULL_MEMBER_NAME.getAttributeName())) {
                return m1.getMemberFullName().compareToIgnoreCase(m2.getMemberFullName());
            }
            return m1.getMemberName().compareToIgnoreCase(m2.getMemberName());
        }
    }
}

