/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.util;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;

public final class KimCommonUtilsInternal {
    private static final Logger LOG = Logger.getLogger(KimCommonUtilsInternal.class);

    private KimCommonUtilsInternal() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void copyProperties(Object targetToCopyTo, Object sourceToCopyFrom) {
        if (targetToCopyTo != null && sourceToCopyFrom != null) {
            try {
                PropertyUtils.copyProperties((Object)targetToCopyTo, (Object)sourceToCopyFrom);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to copy from source object: " + sourceToCopyFrom.getClass() + " to target object: " + targetToCopyTo, ex);
            }
        }
    }

    public static String getKimBasePath() {
        String kimBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kim.url");
        if (!kimBaseUrl.endsWith("/")) {
            kimBaseUrl = kimBaseUrl + "/";
        }
        return kimBaseUrl;
    }

    public static String getPathWithKimContext(String path, String kimActionName) {
        String kimContext = "kim/";
        String kimContextParameterized = "kim%2F";
        if (path.contains(kimActionName) && !path.contains(kimContext + kimActionName) && !path.contains(kimContextParameterized + kimActionName)) {
            path = path.replace(kimActionName, kimContext + kimActionName);
        }
        return path;
    }
}

