/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.plugin.PluginEnvironment;
import org.kuali.rice.kew.plugin.PluginRegistry;
import org.kuali.rice.kew.plugin.PluginUtils;
import org.kuali.rice.kew.plugin.ZipFilePluginLoader;

public class HotDeployer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(HotDeployer.class);
    private PluginRegistry registry;
    private File sharedPluginDirectory;
    private List<String> pluginDirectories;

    public HotDeployer(PluginRegistry registry, File sharedPluginDirectory, List<String> pluginDirectories) {
        this.registry = registry;
        this.sharedPluginDirectory = sharedPluginDirectory;
        this.pluginDirectories = pluginDirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            LOG.debug((Object)"Checking for added and removed plugins...");
            Set<PluginEnvironment> removedPlugins = this.getRemovedPlugins();
            for (PluginEnvironment pluginContext : removedPlugins) {
                LOG.info((Object)("Detected a removed plugin '" + pluginContext.getPluginName() + "', shutting down plugin."));
                try {
                    pluginContext.unload();
                    this.registry.removePluginEnvironment(pluginContext.getPluginName());
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to unload plugin '" + pluginContext.getPluginName() + "'"), (Throwable)e);
                }
            }
            Set<PluginEnvironment> addedPlugins = this.getAddedPlugins();
            for (PluginEnvironment pluginContext : addedPlugins) {
                try {
                    LOG.info((Object)"Detected a new plugin.  Loading plugin...");
                    pluginContext.load();
                    LOG.info((Object)("...plugin '" + pluginContext.getPluginName() + "' loaded."));
                }
                catch (Exception e) {
                    String pluginName = "<<unknown>>";
                    if (pluginContext.getPlugin() != null) {
                        pluginName = String.valueOf(pluginContext.getPluginName());
                    }
                    LOG.error((Object)("Failed to load plugin '" + pluginName + "'"), (Throwable)e);
                }
                finally {
                    this.registry.addPluginEnvironment(pluginContext);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to check for hot deploy.", (Throwable)e);
        }
    }

    protected Set<PluginEnvironment> getRemovedPlugins() {
        HashSet<PluginEnvironment> removedPlugins = new HashSet<PluginEnvironment>();
        for (PluginEnvironment environment : this.registry.getPluginEnvironments()) {
            if (!environment.getLoader().isRemoved()) continue;
            removedPlugins.add(environment);
        }
        return removedPlugins;
    }

    protected Set<PluginEnvironment> getAddedPlugins() throws Exception {
        HashSet<PluginEnvironment> addedPlugins = new HashSet<PluginEnvironment>();
        HashSet<File> newPluginZipFiles = new HashSet<File>();
        for (String pluginDirName : this.pluginDirectories) {
            File[] pluginDirFiles;
            File pluginDir = new File(pluginDirName);
            if (!pluginDir.exists() || !pluginDir.isDirectory()) continue;
            for (File pluginZip : pluginDirFiles = pluginDir.listFiles(new PluginUtils.PluginZipFileFilter())) {
                int indexOf = pluginZip.getName().lastIndexOf(".zip");
                String pluginName = pluginZip.getName().substring(0, indexOf);
                List<PluginEnvironment> currentEnvironments = this.registry.getPluginEnvironments();
                boolean pluginExists = false;
                for (PluginEnvironment environment : currentEnvironments) {
                    if (!environment.getPluginName().equals(pluginName)) continue;
                    pluginExists = true;
                    break;
                }
                if (pluginExists) continue;
                long lastModified1 = pluginZip.lastModified();
                Thread.sleep(100L);
                long lastModified2 = pluginZip.lastModified();
                if (lastModified1 == lastModified2) {
                    newPluginZipFiles.add(pluginZip);
                    continue;
                }
                LOG.warn((Object)("Detected that the plugin zip is still being modified, holding off on hot deploy: " + pluginZip.getAbsolutePath()));
            }
        }
        ClassLoader parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
        Config parentConfig = ConfigContext.getCurrentContextConfig();
        for (File newPluginZipFile : newPluginZipFiles) {
            ZipFilePluginLoader loader = new ZipFilePluginLoader(newPluginZipFile, this.sharedPluginDirectory, parentClassLoader, parentConfig);
            PluginEnvironment environment = new PluginEnvironment(loader, this.registry);
            addedPlugins.add(environment);
        }
        return addedPlugins;
    }
}

