/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.plugin.BasePluginLoader;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.PluginClassLoader;
import org.kuali.rice.kew.plugin.PluginException;
import org.kuali.rice.kew.plugin.PluginUtils;

public class ZipFilePluginLoader
extends BasePluginLoader {
    private static final Logger LOG = Logger.getLogger(ZipFilePluginLoader.class);
    private final File pluginZipFile;
    private final File extractionDirectory;
    private long zipFileLastModified = -1L;
    private boolean loadFailed = false;

    private static String validatePluginZipFile(File pluginZipFile) {
        PluginUtils.validatePluginZipFile(pluginZipFile);
        String fileName = pluginZipFile.getName();
        int indexOf = fileName.lastIndexOf(".zip");
        return fileName.substring(0, indexOf);
    }

    public ZipFilePluginLoader(File pluginZipFile, File sharedPluginDirectory, ClassLoader parentClassLoader, Config parentConfig) {
        super(ZipFilePluginLoader.validatePluginZipFile(pluginZipFile), sharedPluginDirectory, parentClassLoader, parentConfig);
        this.pluginZipFile = pluginZipFile;
        this.extractionDirectory = this.determineExtractionDirectory(this.getSimplePluginName(), pluginZipFile);
    }

    @Override
    public boolean isModified() {
        long currentZipFileLastModified = this.pluginZipFile.lastModified();
        if (this.zipFileLastModified == -1L) {
            this.zipFileLastModified = currentZipFileLastModified;
            return false;
        }
        if (currentZipFileLastModified > this.zipFileLastModified) {
            return !this.isZipFileStillBeingModified();
        }
        return false;
    }

    protected boolean isZipFileStillBeingModified() {
        long lastModified = this.pluginZipFile.lastModified();
        long size = this.pluginZipFile.length();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (lastModified != this.pluginZipFile.lastModified()) {
            return true;
        }
        return size != this.pluginZipFile.length();
    }

    @Override
    public boolean isRemoved() {
        return this.pluginZipFile != null && !this.pluginZipFile.exists();
    }

    @Override
    public Plugin load() throws Exception {
        try {
            this.updateLastModified();
            this.extractPluginFiles();
            Plugin plugin = super.load();
            this.loadFailed = false;
            return plugin;
        }
        catch (Exception e) {
            this.loadFailed = true;
            throw e;
        }
    }

    protected File determineExtractionDirectory(String pluginName, File pluginZipFile) {
        return new File(pluginZipFile.getParentFile(), pluginName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractPluginFiles() throws Exception {
        if (this.isExtractNeeded()) {
            if (this.extractionDirectory.exists()) {
                FileUtils.deleteDirectory((File)this.extractionDirectory);
            }
            if (!this.extractionDirectory.mkdir()) {
                throw new WorkflowRuntimeException("Could not create the extraction directory for the plugin: " + this.extractionDirectory.getAbsolutePath());
            }
            ZipFile zipFile = new ZipFile(this.pluginZipFile, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryFile = new File(this.extractionDirectory + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    if (entryFile.mkdir()) continue;
                    throw new WorkflowRuntimeException("Failed to create directory: " + entryFile.getAbsolutePath());
                }
                BufferedInputStream is = null;
                OutputStream os = null;
                try {
                    is = new BufferedInputStream(zipFile.getInputStream(entry));
                    os = new BufferedOutputStream(new FileOutputStream(entryFile));
                    while (((InputStream)is).available() > 0) {
                        os.write(((InputStream)is).read());
                    }
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
        }
    }

    public boolean isLoadFailed() {
        return this.loadFailed;
    }

    protected boolean isExtractNeeded() {
        return this.isModified() || this.pluginZipFile.lastModified() > this.extractionDirectory.lastModified();
    }

    protected void updateLastModified() {
        this.zipFileLastModified = this.pluginZipFile.lastModified();
    }

    @Override
    protected PluginClassLoader createPluginClassLoader() throws MalformedURLException {
        LOG.info((Object)(this.getLogPrefix() + " Initiating loading of plugin from file system: " + this.extractionDirectory.getPath()));
        LOG.info((Object)(this.getLogPrefix() + " Absolute path on file system is: " + this.extractionDirectory.getAbsolutePath()));
        return new PluginClassLoader(this.parentClassLoader, this.sharedPluginDirectory, this.extractionDirectory);
    }

    @Override
    protected URL getPluginConfigURL() throws PluginException, MalformedURLException {
        File pluginConfigFile = new File(this.extractionDirectory, this.pluginConfigPath);
        if (!pluginConfigFile.exists() || !pluginConfigFile.isFile()) {
            throw new PluginException(this.getLogPrefix() + " Could not locate the plugin config file at path " + pluginConfigFile.getAbsolutePath());
        }
        return pluginConfigFile.toURI().toURL();
    }
}

