/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.web.struts.action.IdentityManagementBaseInquiryAction;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementGroupDocumentForm;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementGroupInquiry
extends IdentityManagementBaseInquiryAction {
    private static final Logger LOG = Logger.getLogger(IdentityManagementGroupInquiry.class);

    @Override
    protected void loadKimObject(HttpServletRequest request, IdentityManagementDocumentFormBase form) {
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        String id = request.getParameter("id");
        String altId = request.getParameter("groupId");
        String groupId = StringUtils.isNotEmpty((String)id) ? id : altId;
        Group group = null;
        if (StringUtils.isNotEmpty((String)groupId)) {
            group = KimApiServiceLocator.getGroupService().getGroup(groupId);
        } else {
            String namespaceCode = request.getParameter("namespaceCode");
            String groupName = request.getParameter("name");
            if (!StringUtils.isBlank((String)namespaceCode) && !StringUtils.isBlank((String)groupName)) {
                group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
            }
        }
        if (group != null) {
            this.getUiDocumentService().loadGroupDoc(groupDocumentForm.getGroupDocument(), group);
        } else {
            LOG.error((Object)"No records found for Group Inquiry.");
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inquiry", new String[0]);
        }
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementGroupDocumentForm groupDocumentForm = (IdentityManagementGroupDocumentForm)form;
        ActionForward forward = super.execute(mapping, form, request, response);
        String previouslySortedColumnName = (String)GlobalVariables.getUserSession().retrieveObject("KIM_GROUP_INQUIRY_SORT_PREV_COL_NM");
        Boolean sortDescending = (Boolean)GlobalVariables.getUserSession().retrieveObject("KIM_GROUP_INQUIRY_SORT_DESC_VALUE");
        KualiTableRenderFormMetadata memberTableMetadata = groupDocumentForm.getMemberTableMetadata();
        memberTableMetadata.setPreviouslySortedColumnName(previouslySortedColumnName);
        if (sortDescending != null) {
            memberTableMetadata.setSortDescending(sortDescending.booleanValue());
        }
        if (groupDocumentForm.getMemberRows() != null) {
            memberTableMetadata.sort(groupDocumentForm.getMemberRows(), groupDocumentForm.getRecordsPerPage());
            memberTableMetadata.jumpToPage(memberTableMetadata.getSwitchToPageNumber(), groupDocumentForm.getMemberRows().size(), groupDocumentForm.getRecordsPerPage());
        }
        GlobalVariables.getUserSession().addObject("KIM_GROUP_INQUIRY_SORT_PREV_COL_NM", (Object)memberTableMetadata.getPreviouslySortedColumnName());
        GlobalVariables.getUserSession().addObject("KIM_GROUP_INQUIRY_SORT_DESC_VALUE", (Object)memberTableMetadata.isSortDescending());
        return forward;
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }
}

