/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.bo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeAttributeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.mockito.Mockito;

public class DocumentTypeBoTest {
    private static final List<DocumentTypePolicy> DOCUMENT_TYPE_POLICIES = new ArrayList<DocumentTypePolicy>();

    @Test
    public void testEquals() {
        org.kuali.rice.kew.api.doctype.DocumentType immutable = DocumentTypeBoTest.create();
        DocumentType bo = DocumentType.from((DocumentTypeContract)immutable);
        Assert.assertEquals((Object)immutable, (Object)DocumentType.to((DocumentType)bo));
    }

    @Test
    public void testGetPolicies() {
        DocumentType dt = new DocumentType();
        dt.setDocumentTypePolicies(DOCUMENT_TYPE_POLICIES);
        HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> policies = new HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String>();
        policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_ROUTE, Boolean.TRUE.toString());
        policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_SAVE, Boolean.FALSE.toString());
        policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ENROUTE_ERROR_SUPPRESSION, Boolean.FALSE.toString());
        policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOC_SEARCH_TARGET, "_top");
        Assert.assertEquals(policies, (Object)dt.getPolicies());
    }

    @Test
    public void testGetPolicyByName_boolean() {
        DocumentType parentdt = (DocumentType)Mockito.spy((Object)new DocumentType());
        parentdt.setDocumentTypePolicies(DOCUMENT_TYPE_POLICIES);
        ((DocumentType)Mockito.doReturn(null).when((Object)parentdt)).getParentDocType();
        DocumentType childdt = (DocumentType)Mockito.spy((Object)new DocumentType());
        ((DocumentType)Mockito.doReturn((Object)parentdt).when((Object)childdt)).getParentDocType();
        DocumentTypePolicy policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_ROUTE.getCode(), Boolean.valueOf(false));
        Assert.assertTrue((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
        policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_SAVE.getCode(), Boolean.valueOf(true));
        Assert.assertFalse((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
        policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ENROUTE_ERROR_SUPPRESSION.getCode(), Boolean.valueOf(true));
        Assert.assertFalse((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
        policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_SU_FINAL_APPROVAL.getCode(), Boolean.valueOf(true));
        Assert.assertTrue((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
    }

    @Test
    public void testGetPolicyByName_string() {
        DocumentType parentdt = (DocumentType)Mockito.spy((Object)new DocumentType());
        parentdt.setDocumentTypePolicies(DOCUMENT_TYPE_POLICIES);
        ((DocumentType)Mockito.doReturn(null).when((Object)parentdt)).getParentDocType();
        DocumentType childdt = (DocumentType)Mockito.spy((Object)new DocumentType());
        ((DocumentType)Mockito.doReturn((Object)parentdt).when((Object)childdt)).getParentDocType();
        DocumentTypePolicy policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_ROUTE.getCode(), "MUST_ROUTE");
        Assert.assertTrue((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
        policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_SAVE.getCode(), "MUST_SAVE");
        Assert.assertFalse((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
        policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ENROUTE_ERROR_SUPPRESSION.getCode(), "ERROR_SUPPRESSION");
        Assert.assertFalse((boolean)policy.getPolicyValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
        policy = childdt.getPolicyByName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ALLOW_SU_FINAL_APPROVAL.getCode(), "DEFAULT VALUE");
        Assert.assertTrue((boolean)policy.getPolicyValue());
        Assert.assertEquals((Object)"DEFAULT VALUE", (Object)policy.getPolicyStringValue());
        Assert.assertTrue((boolean)policy.getInheritedFlag());
    }

    public static org.kuali.rice.kew.api.doctype.DocumentType create() {
        return DocumentType.Builder.create((DocumentTypeContract)new DocumentTypeContract(){

            public String getName() {
                return "DocumentTypeTestName";
            }

            public Integer getDocumentTypeVersion() {
                return 5;
            }

            public String getLabel() {
                return "documenttypetest label";
            }

            public String getDescription() {
                return "documenttypetest description";
            }

            public String getParentId() {
                return "fakeparentid";
            }

            public boolean isActive() {
                return true;
            }

            public String getHelpDefinitionUrl() {
                return "http://fakehelpdefinitionurl";
            }

            public String getDocSearchHelpUrl() {
                return "http://fakedocsearchhelpurl";
            }

            public String getPostProcessorName() {
                return "postprocessor name";
            }

            public String getApplicationId() {
                return "application id";
            }

            public boolean isCurrent() {
                return true;
            }

            public String getBlanketApproveGroupId() {
                return "fakeblanketapprovegroupid";
            }

            public String getSuperUserGroupId() {
                return "fakesuperusergroupid";
            }

            public Map<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> getPolicies() {
                HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String> policies = new HashMap<org.kuali.rice.kew.api.doctype.DocumentTypePolicy, String>();
                policies.put(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DEFAULT_APPROVE, "true");
                return policies;
            }

            public List<? extends DocumentTypeAttributeContract> getDocumentTypeAttributes() {
                return Collections.emptyList();
            }

            public String getResolvedDocumentHandlerUrl() {
                return "http://fakedochandlerurl";
            }

            public String getUnresolvedDocHandlerUrl() {
                return "http://fakedochandlerurl";
            }

            public String getAuthorizer() {
                return "fakeDocumentTypeAuthorizer";
            }

            public String getId() {
                return "fakeid";
            }

            public Long getVersionNumber() {
                return 3L;
            }
        }).build();
    }

    static {
        DOCUMENT_TYPE_POLICIES.add(new DocumentTypePolicy(null, org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_ROUTE.getCode(), Boolean.valueOf(true)));
        DOCUMENT_TYPE_POLICIES.add(new DocumentTypePolicy(null, org.kuali.rice.kew.api.doctype.DocumentTypePolicy.INITIATOR_MUST_SAVE.getCode(), Boolean.valueOf(false)));
        DOCUMENT_TYPE_POLICIES.add(new DocumentTypePolicy(null, org.kuali.rice.kew.api.doctype.DocumentTypePolicy.ENROUTE_ERROR_SUPPRESSION.getCode(), Boolean.valueOf(false)));
        DOCUMENT_TYPE_POLICIES.add(new DocumentTypePolicy(null, org.kuali.rice.kew.api.doctype.DocumentTypePolicy.DOC_SEARCH_TARGET.getCode(), Boolean.valueOf(false)));
        DOCUMENT_TYPE_POLICIES.get(3).setPolicyStringValue("_top");
    }
}

