/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.ken.api.service.KENAPIService;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.UserPreferenceService;
import org.springframework.beans.factory.annotation.Required;

public class KENAPIServiceImpl
implements KENAPIService {
    private NotificationChannelService channelService;
    private UserPreferenceService prefsService;

    @Required
    public void setNotificationChannelService(NotificationChannelService ncs) {
        this.channelService = ncs;
    }

    @Required
    public void setUserPreferenceService(UserPreferenceService ups) {
        this.prefsService = ups;
    }

    public Collection<String> getAllChannelNames() {
        Collection<NotificationChannelBo> chans = this.channelService.getAllNotificationChannels();
        ArrayList<String> chanNames = new ArrayList<String>(chans.size());
        for (NotificationChannelBo c : chans) {
            chanNames.add(c.getName());
        }
        return chanNames;
    }

    public Collection<String> getDeliverersForRecipientAndChannel(String recipient, String channel) {
        if (StringUtils.isBlank((String)recipient)) {
            throw new RiceIllegalArgumentException("recipient is null or blank");
        }
        if (StringUtils.isBlank((String)channel)) {
            throw new RiceIllegalArgumentException("channel is null or blank");
        }
        return null;
    }

    public String getRecipientPreference(String recipient, String prefKey) {
        if (StringUtils.isBlank((String)recipient)) {
            throw new RiceIllegalArgumentException("recipient is null or blank");
        }
        if (StringUtils.isBlank((String)prefKey)) {
            throw new RiceIllegalArgumentException("prefKey is null or blank");
        }
        return null;
    }
}

