/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.service.NotificationAuthorizationService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class NotificationAuthorizationServiceImpl
implements NotificationAuthorizationService {
    private static Logger LOG = Logger.getLogger(NotificationAuthorizationServiceImpl.class);

    @Override
    public boolean isProducerAuthorizedToSendNotificationForChannel(NotificationProducerBo producer, NotificationChannelBo channel) {
        List<Long> channelIds = producer.getChannelIds();
        return channelIds.contains(channel.getId());
    }

    @Override
    public boolean isUserAdministrator(String userId) {
        String groupNameId = "NotificationAdmin";
        Person user = KimApiServiceLocator.getPersonService().getPerson(userId);
        if (user == null) {
            return false;
        }
        GroupService groupService = KimApiServiceLocator.getGroupService();
        Group group = groupService.getGroupByNamespaceCodeAndName("KR-WKFLW", groupNameId);
        return group == null ? false : groupService.isMemberOfGroup(user.getPrincipalId(), group.getId());
    }
}

