/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionitem;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionItemContract;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@MappedSuperclass
public class ActionItemBase
implements ActionItemContract,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = -1079562205125660151L;
    @Id
    @GeneratedValue(generator="KREW_ACTN_ITM_S")
    @PortableSequenceGenerator(name="KREW_ACTN_ITM_S")
    @Column(name="ACTN_ITM_ID")
    private String id;
    @Column(name="PRNCPL_ID")
    private String principalId;
    @Column(name="ASND_DT")
    private Timestamp dateAssigned;
    @Column(name="RQST_CD")
    private String actionRequestCd;
    @Column(name="ACTN_RQST_ID")
    private String actionRequestId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="GRP_ID")
    private String groupId;
    @Column(name="DOC_HDR_TTL")
    private String docTitle;
    @Column(name="DOC_TYP_LBL")
    private String docLabel;
    @Column(name="DOC_HDLR_URL")
    private String docHandlerURL;
    @Column(name="DOC_TYP_NM")
    private String docName;
    @Column(name="RSP_ID")
    private String responsibilityId;
    @Column(name="ROLE_NM")
    private String roleName;
    @Column(name="DLGN_PRNCPL_ID")
    private String delegatorPrincipalId;
    @Column(name="DLGN_GRP_ID")
    private String delegatorGroupId;
    @Column(name="DLGN_TYP")
    private String delegationType;
    @Column(name="RQST_LBL")
    private String requestLabel;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    private DocumentRouteHeaderValue routeHeader;
    @Transient
    private String dateAssignedStringValue;
    @Transient
    private Timestamp lastApprovedDate;
    @Transient
    private Map<String, String> customActions;
    @Transient
    private String rowStyleClass;
    @Transient
    private Integer actionListIndex;
    @Transient
    private String delegatorName;
    @Transient
    private String groupName;
    @Transient
    private DisplayParameters displayParameters;
    @Transient
    private boolean isInitialized;
    @Transient
    private DocumentRouteHeaderValue minimalRouteHeader;
    @Transient
    private boolean lastApprovedDateInitialized;
    @Transient
    private boolean delegatorNameInitialized;
    @Transient
    private boolean groupNameInitialized;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_routeHeader_vh;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    public ActionItemBase() {
        this.responsibilityId = "1";
        this.customActions = new HashMap<String, String>();
        this.delegatorName = "";
        this.groupName = "";
        this.isInitialized = false;
        this.lastApprovedDateInitialized = false;
        this.delegatorNameInitialized = false;
        this.groupNameInitialized = false;
    }

    @Deprecated
    public String getActionToTake() {
        return null;
    }

    @Deprecated
    public String getDateAssignedString() {
        return null;
    }

    public String getDateAssignedStringValue() {
        if (StringUtils.isBlank((String)this.dateAssignedStringValue)) {
            return RiceConstants.getDefaultDateFormat().format(this.getDateAssigned());
        }
        return this.dateAssignedStringValue;
    }

    public void setDateAssignedStringValue(String dateAssignedStringValue) {
        this.dateAssignedStringValue = dateAssignedStringValue;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public String getPrincipalId() {
        return this._persistence_get_principalId();
    }

    public Timestamp getDateAssigned() {
        return this._persistence_get_dateAssigned();
    }

    public DateTime getDateTimeAssigned() {
        return new DateTime((Object)this._persistence_get_dateAssigned());
    }

    public String getActionRequestCd() {
        return this._persistence_get_actionRequestCd();
    }

    public String getActionRequestId() {
        return this._persistence_get_actionRequestId();
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public String getGroupId() {
        return this._persistence_get_groupId();
    }

    public String getDocTitle() {
        return this._persistence_get_docTitle();
    }

    public String getDocLabel() {
        return this._persistence_get_docLabel();
    }

    public String getDocHandlerURL() {
        return this._persistence_get_docHandlerURL();
    }

    public String getDocName() {
        return this._persistence_get_docName();
    }

    public String getResponsibilityId() {
        return this._persistence_get_responsibilityId();
    }

    public String getRoleName() {
        return this._persistence_get_roleName();
    }

    public String getDelegatorPrincipalId() {
        return this._persistence_get_delegatorPrincipalId();
    }

    public String getDelegatorGroupId() {
        return this._persistence_get_delegatorGroupId();
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this._persistence_get_delegationType());
    }

    public String getRequestLabel() {
        return this._persistence_get_requestLabel();
    }

    private Group getGroup(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            return null;
        }
        return KimApiServiceLocator.getGroupService().getGroup(groupId);
    }

    public Group getGroup() {
        return this.getGroup(this._persistence_get_groupId());
    }

    public String getRecipientTypeCode() {
        String recipientTypeCode = RecipientType.PRINCIPAL.getCode();
        if (this.getRoleName() != null) {
            recipientTypeCode = RecipientType.ROLE.getCode();
        }
        if (this.getGroupId() != null) {
            recipientTypeCode = RecipientType.GROUP.getCode();
        }
        return recipientTypeCode;
    }

    public String getActionRequestLabel() {
        if (StringUtils.isNotBlank((String)this.getRequestLabel())) {
            return this.getRequestLabel();
        }
        return CodeTranslator.getActionRequestLabel((String)this.getActionRequestCd());
    }

    public boolean isWorkgroupItem() {
        return this.getGroupId() != null;
    }

    public Principal getPrincipal() {
        return KimApiServiceLocator.getIdentityService().getPrincipal(this._persistence_get_principalId());
    }

    public void setResponsibilityId(String responsibilityId) {
        this._persistence_set_responsibilityId(responsibilityId);
    }

    public void setDocName(String docName) {
        this._persistence_set_docName(docName);
    }

    public void setActionRequestCd(String actionRequestCd) {
        this._persistence_set_actionRequestCd(actionRequestCd);
    }

    public void setDateAssigned(Timestamp dateAssigned) {
        this._persistence_set_dateAssigned(dateAssigned);
    }

    public void setPrincipalId(String principalId) {
        this._persistence_set_principalId(principalId);
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public void setActionRequestId(String actionRequestId) {
        this._persistence_set_actionRequestId(actionRequestId);
    }

    public void setDocHandlerURL(String docHandlerURL) {
        this._persistence_set_docHandlerURL(docHandlerURL);
    }

    public void setGroupId(String groupId) {
        this._persistence_set_groupId(groupId);
    }

    public void setDocLabel(String docLabel) {
        this._persistence_set_docLabel(docLabel);
    }

    public void setDocTitle(String docTitle) {
        this._persistence_set_docTitle(docTitle);
    }

    public void setRoleName(String roleName) {
        this._persistence_set_roleName(roleName);
    }

    public void setDelegatorPrincipalId(String delegatorPrincipalId) {
        this._persistence_set_delegatorPrincipalId(delegatorPrincipalId);
    }

    public void setDelegatorGroupId(String delegatorGroupId) {
        this._persistence_set_delegatorGroupId(delegatorGroupId);
    }

    public void setDelegationType(DelegationType delegationType) {
        this._persistence_set_delegationType(delegationType == null ? null : delegationType.getCode());
    }

    public void setRequestLabel(String requestLabel) {
        this._persistence_set_requestLabel(requestLabel);
    }

    @Deprecated
    public Integer getActionItemIndex() {
        return null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this._persistence_get_id()).append("principalId", (Object)this._persistence_get_principalId()).append("dateAssigned", (Object)this._persistence_get_dateAssigned()).append("actionRequestCd", (Object)this._persistence_get_actionRequestCd()).append("actionRequestId", (Object)this._persistence_get_actionRequestId()).append("documentId", (Object)this._persistence_get_documentId()).append("groupId", (Object)this._persistence_get_groupId()).append("docTitle", (Object)this._persistence_get_docTitle()).append("docLabel", (Object)this._persistence_get_docLabel()).append("docHandlerURL", (Object)this._persistence_get_docHandlerURL()).append("docName", (Object)this._persistence_get_docName()).append("responsibilityId", (Object)this._persistence_get_responsibilityId()).append("roleName", (Object)this._persistence_get_roleName()).append("delegatorPrincipalId", (Object)this._persistence_get_delegatorPrincipalId()).append("delegatorGroupId", (Object)this._persistence_get_delegatorGroupId()).append("delegationType", (Object)this._persistence_get_delegationType()).toString();
    }

    public String getRouteHeaderRouteStatus() {
        return this.getMinimalRouteHeader().getDocRouteStatus();
    }

    public String getRouteHeaderCombinedStatus() {
        return this.getMinimalRouteHeader().getCombinedStatus();
    }

    public Timestamp getRouteHeaderCreateDate() {
        return this.getMinimalRouteHeader().getCreateDate();
    }

    public String getRouteHeaderInitiatorName() {
        return this.getMinimalRouteHeader().getInitiatorDisplayName();
    }

    public Timestamp getRouteHeaderApprovedDate() {
        return this.getMinimalRouteHeader().getApprovedDate();
    }

    public String getRouteHeaderCurrentRouteLevelName() {
        return this.getMinimalRouteHeader().getCurrentRouteLevelName();
    }

    public String getRouteHeaderInitiatorWorkflowId() {
        return this.getMinimalRouteHeader().getInitiatorWorkflowId();
    }

    public Integer getActionListIndex() {
        return this.actionListIndex;
    }

    public void setActionListIndex(Integer actionListIndex) {
        this.actionListIndex = actionListIndex;
    }

    public Timestamp getLastApprovedDate() {
        this.initializeLastApprovedDate();
        return this.lastApprovedDate;
    }

    public Map<String, String> getCustomActions() {
        return this.customActions;
    }

    public void setCustomActions(Map<String, String> customActions) {
        this.customActions = customActions;
    }

    public String getRowStyleClass() {
        return this.rowStyleClass;
    }

    public void setRowStyleClass(String rowStyleClass) {
        this.rowStyleClass = rowStyleClass;
    }

    public String getDelegatorName() {
        this.initializeDelegatorName();
        return this.delegatorName;
    }

    public String getGroupName() {
        this.initializeGroupName();
        return this.groupName;
    }

    public void initialize(Preferences preferences) {
        this.initializeRowStyleClass(preferences);
        if (this.isInitialized) {
            return;
        }
        if ("yes".equals(preferences.getShowWorkgroupRequest())) {
            this.initializeGroupName();
        }
        if ("yes".equals(preferences.getShowDelegator())) {
            this.initializeDelegatorName();
        }
        if ("yes".equals(preferences.getShowDateApproved())) {
            this.initializeLastApprovedDate();
        }
        this.isInitialized = true;
    }

    private void initializeRowStyleClass(Preferences preferences) {
        String docRouteStatus = this.getRouteHeaderRouteStatus();
        if ("X".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorCanceled()));
        } else if ("D".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorDisapproved()));
        } else if ("R".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorEnroute()));
        } else if ("E".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorException()));
        } else if ("F".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorFinal()));
        } else if ("I".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorInitiated()));
        } else if ("P".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorProcessed()));
        } else if ("S".equalsIgnoreCase(docRouteStatus)) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorSaved()));
        }
    }

    private void initializeGroupName() {
        if (!this.groupNameInitialized) {
            if (this.getGroupId() != null) {
                Group group = this.getGroup();
                this.groupName = group.getName();
            }
            this.groupNameInitialized = true;
        }
    }

    private void initializeDelegatorName() {
        if (!this.delegatorNameInitialized) {
            Group delegatorGroup;
            EntityNamePrincipalName name;
            if (this.getDelegatorPrincipalId() != null && (name = KimApiServiceLocator.getIdentityService().getDefaultNamesForPrincipalId(this.getDelegatorPrincipalId())) != null) {
                this.delegatorName = name.getDefaultName().getCompositeName();
            }
            if (this.getDelegatorGroupId() != null && (delegatorGroup = KimApiServiceLocator.getGroupService().getGroup(this.getDelegatorGroupId())) != null) {
                this.delegatorName = delegatorGroup.getName();
            }
            this.delegatorNameInitialized = true;
        }
    }

    private void initializeLastApprovedDate() {
        if (!this.lastApprovedDateInitialized) {
            this.lastApprovedDate = KEWServiceLocator.getActionTakenService().getLastApprovedDate(this.getDocumentId());
            this.lastApprovedDateInitialized = true;
        }
    }

    public DisplayParameters getDisplayParameters() {
        return this.displayParameters;
    }

    public void setDisplayParameters(DisplayParameters displayParameters) {
        this.displayParameters = displayParameters;
    }

    public DocumentRouteHeaderValue getRouteHeader() {
        return this._persistence_get_routeHeader();
    }

    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this._persistence_set_routeHeader(routeHeader);
    }

    public DocumentRouteHeaderValue getMinimalRouteHeader() {
        if (this.minimalRouteHeader == null) {
            this.minimalRouteHeader = KEWServiceLocator.getActionListService().getMinimalRouteHeader(this._persistence_get_documentId());
        }
        return this.minimalRouteHeader;
    }

    protected <T extends ActionItemBase> T deepCopy(Map<Object, Object> visited, Class<T> type) {
        if (visited.containsKey(this)) {
            return (T)((ActionItemBase)visited.get(this));
        }
        ActionItemBase copy = null;
        try {
            copy = (ActionItemBase)type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        visited.put(this, copy);
        copy.setId(this._persistence_get_id());
        copy.setPrincipalId(this._persistence_get_principalId());
        if (this._persistence_get_dateAssigned() != null) {
            copy.setDateAssigned(new Timestamp(this._persistence_get_dateAssigned().getTime()));
        }
        copy.setActionRequestCd(this._persistence_get_actionRequestCd());
        copy.setActionRequestId(this._persistence_get_actionRequestId());
        copy.setDocumentId(this._persistence_get_documentId());
        copy.setGroupId(this._persistence_get_groupId());
        copy.setDocTitle(this._persistence_get_docTitle());
        copy.setDocLabel(this._persistence_get_docLabel());
        copy.setDocHandlerURL(this._persistence_get_docHandlerURL());
        copy.setDocName(this._persistence_get_docName());
        copy.setResponsibilityId(this._persistence_get_responsibilityId());
        copy.setRoleName(this._persistence_get_roleName());
        copy.setDelegatorPrincipalId(this._persistence_get_delegatorPrincipalId());
        copy.setDelegatorGroupId(this._persistence_get_delegatorGroupId());
        copy.setDelegationType(DelegationType.fromCode((String)this._persistence_get_delegationType()));
        copy.setRequestLabel(this._persistence_get_requestLabel());
        copy.setDateAssignedStringValue(this.dateAssignedStringValue);
        if (this._persistence_get_routeHeader() != null) {
            copy.setRouteHeader(this._persistence_get_routeHeader().deepCopy(visited));
        }
        return (T)copy;
    }

    public String getTarget() {
        DocumentType documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this._persistence_get_docName());
        Map policies = documentType.getPolicies();
        for (DocumentTypePolicy policy : policies.keySet()) {
            if (!policy.getCode().equals(DocumentTypePolicy.DOC_SEARCH_TARGET.getCode())) continue;
            return ((String)policies.get(DocumentTypePolicy.DOC_SEARCH_TARGET)).toLowerCase();
        }
        return null;
    }

    public Object _persistence_post_clone() {
        if (this._persistence_routeHeader_vh != null) {
            this._persistence_routeHeader_vh = (WeavedAttributeValueHolderInterface)this._persistence_routeHeader_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ActionItemBase(persistenceObject);
    }

    public ActionItemBase(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "actionRequestId") {
            return this.actionRequestId;
        }
        if (string == "routeHeader") {
            return this.routeHeader;
        }
        if (string == "docName") {
            return this.docName;
        }
        if (string == "dateAssigned") {
            return this.dateAssigned;
        }
        if (string == "docLabel") {
            return this.docLabel;
        }
        if (string == "responsibilityId") {
            return this.responsibilityId;
        }
        if (string == "docHandlerURL") {
            return this.docHandlerURL;
        }
        if (string == "delegatorPrincipalId") {
            return this.delegatorPrincipalId;
        }
        if (string == "roleName") {
            return this.roleName;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "groupId") {
            return this.groupId;
        }
        if (string == "principalId") {
            return this.principalId;
        }
        if (string == "actionRequestCd") {
            return this.actionRequestCd;
        }
        if (string == "delegationType") {
            return this.delegationType;
        }
        if (string == "docTitle") {
            return this.docTitle;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "delegatorGroupId") {
            return this.delegatorGroupId;
        }
        if (string == "requestLabel") {
            return this.requestLabel;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "actionRequestId") {
            this.actionRequestId = (String)object;
            return;
        }
        if (string == "routeHeader") {
            this.routeHeader = (DocumentRouteHeaderValue)object;
            return;
        }
        if (string == "docName") {
            this.docName = (String)object;
            return;
        }
        if (string == "dateAssigned") {
            this.dateAssigned = (Timestamp)object;
            return;
        }
        if (string == "docLabel") {
            this.docLabel = (String)object;
            return;
        }
        if (string == "responsibilityId") {
            this.responsibilityId = (String)object;
            return;
        }
        if (string == "docHandlerURL") {
            this.docHandlerURL = (String)object;
            return;
        }
        if (string == "delegatorPrincipalId") {
            this.delegatorPrincipalId = (String)object;
            return;
        }
        if (string == "roleName") {
            this.roleName = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "groupId") {
            this.groupId = (String)object;
            return;
        }
        if (string == "principalId") {
            this.principalId = (String)object;
            return;
        }
        if (string == "actionRequestCd") {
            this.actionRequestCd = (String)object;
            return;
        }
        if (string == "delegationType") {
            this.delegationType = (String)object;
            return;
        }
        if (string == "docTitle") {
            this.docTitle = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "delegatorGroupId") {
            this.delegatorGroupId = (String)object;
            return;
        }
        if (string == "requestLabel") {
            this.requestLabel = (String)object;
            return;
        }
    }

    public String _persistence_get_actionRequestId() {
        this._persistence_checkFetched("actionRequestId");
        return this.actionRequestId;
    }

    public void _persistence_set_actionRequestId(String string) {
        this._persistence_checkFetchedForSet("actionRequestId");
        this._persistence_propertyChange("actionRequestId", this.actionRequestId, string);
        this.actionRequestId = string;
    }

    protected void _persistence_initialize_routeHeader_vh() {
        if (this._persistence_routeHeader_vh == null) {
            this._persistence_routeHeader_vh = new ValueHolder((Object)this.routeHeader);
            this._persistence_routeHeader_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_routeHeader_vh() {
        DocumentRouteHeaderValue documentRouteHeaderValue;
        this._persistence_initialize_routeHeader_vh();
        if ((this._persistence_routeHeader_vh.isCoordinatedWithProperty() || this._persistence_routeHeader_vh.isNewlyWeavedValueHolder()) && (documentRouteHeaderValue = this._persistence_get_routeHeader()) != this._persistence_routeHeader_vh.getValue()) {
            this._persistence_set_routeHeader(documentRouteHeaderValue);
        }
        return this._persistence_routeHeader_vh;
    }

    public void _persistence_set_routeHeader_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_routeHeader_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            DocumentRouteHeaderValue documentRouteHeaderValue = this._persistence_get_routeHeader();
            if (documentRouteHeaderValue != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_routeHeader((DocumentRouteHeaderValue)object);
            }
        } else {
            this.routeHeader = null;
        }
    }

    public DocumentRouteHeaderValue _persistence_get_routeHeader() {
        this._persistence_checkFetched("routeHeader");
        this._persistence_initialize_routeHeader_vh();
        this.routeHeader = (DocumentRouteHeaderValue)this._persistence_routeHeader_vh.getValue();
        return this.routeHeader;
    }

    public void _persistence_set_routeHeader(DocumentRouteHeaderValue documentRouteHeaderValue) {
        this._persistence_checkFetchedForSet("routeHeader");
        this._persistence_initialize_routeHeader_vh();
        this.routeHeader = (DocumentRouteHeaderValue)this._persistence_routeHeader_vh.getValue();
        this._persistence_propertyChange("routeHeader", this.routeHeader, documentRouteHeaderValue);
        this.routeHeader = documentRouteHeaderValue;
        this._persistence_routeHeader_vh.setValue((Object)documentRouteHeaderValue);
    }

    public String _persistence_get_docName() {
        this._persistence_checkFetched("docName");
        return this.docName;
    }

    public void _persistence_set_docName(String string) {
        this._persistence_checkFetchedForSet("docName");
        this._persistence_propertyChange("docName", this.docName, string);
        this.docName = string;
    }

    public Timestamp _persistence_get_dateAssigned() {
        this._persistence_checkFetched("dateAssigned");
        return this.dateAssigned;
    }

    public void _persistence_set_dateAssigned(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("dateAssigned");
        this._persistence_propertyChange("dateAssigned", this.dateAssigned, timestamp);
        this.dateAssigned = timestamp;
    }

    public String _persistence_get_docLabel() {
        this._persistence_checkFetched("docLabel");
        return this.docLabel;
    }

    public void _persistence_set_docLabel(String string) {
        this._persistence_checkFetchedForSet("docLabel");
        this._persistence_propertyChange("docLabel", this.docLabel, string);
        this.docLabel = string;
    }

    public String _persistence_get_responsibilityId() {
        this._persistence_checkFetched("responsibilityId");
        return this.responsibilityId;
    }

    public void _persistence_set_responsibilityId(String string) {
        this._persistence_checkFetchedForSet("responsibilityId");
        this._persistence_propertyChange("responsibilityId", this.responsibilityId, string);
        this.responsibilityId = string;
    }

    public String _persistence_get_docHandlerURL() {
        this._persistence_checkFetched("docHandlerURL");
        return this.docHandlerURL;
    }

    public void _persistence_set_docHandlerURL(String string) {
        this._persistence_checkFetchedForSet("docHandlerURL");
        this._persistence_propertyChange("docHandlerURL", this.docHandlerURL, string);
        this.docHandlerURL = string;
    }

    public String _persistence_get_delegatorPrincipalId() {
        this._persistence_checkFetched("delegatorPrincipalId");
        return this.delegatorPrincipalId;
    }

    public void _persistence_set_delegatorPrincipalId(String string) {
        this._persistence_checkFetchedForSet("delegatorPrincipalId");
        this._persistence_propertyChange("delegatorPrincipalId", this.delegatorPrincipalId, string);
        this.delegatorPrincipalId = string;
    }

    public String _persistence_get_roleName() {
        this._persistence_checkFetched("roleName");
        return this.roleName;
    }

    public void _persistence_set_roleName(String string) {
        this._persistence_checkFetchedForSet("roleName");
        this._persistence_propertyChange("roleName", this.roleName, string);
        this.roleName = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_groupId() {
        this._persistence_checkFetched("groupId");
        return this.groupId;
    }

    public void _persistence_set_groupId(String string) {
        this._persistence_checkFetchedForSet("groupId");
        this._persistence_propertyChange("groupId", this.groupId, string);
        this.groupId = string;
    }

    public String _persistence_get_principalId() {
        this._persistence_checkFetched("principalId");
        return this.principalId;
    }

    public void _persistence_set_principalId(String string) {
        this._persistence_checkFetchedForSet("principalId");
        this._persistence_propertyChange("principalId", this.principalId, string);
        this.principalId = string;
    }

    public String _persistence_get_actionRequestCd() {
        this._persistence_checkFetched("actionRequestCd");
        return this.actionRequestCd;
    }

    public void _persistence_set_actionRequestCd(String string) {
        this._persistence_checkFetchedForSet("actionRequestCd");
        this._persistence_propertyChange("actionRequestCd", this.actionRequestCd, string);
        this.actionRequestCd = string;
    }

    public String _persistence_get_delegationType() {
        this._persistence_checkFetched("delegationType");
        return this.delegationType;
    }

    public void _persistence_set_delegationType(String string) {
        this._persistence_checkFetchedForSet("delegationType");
        this._persistence_propertyChange("delegationType", this.delegationType, string);
        this.delegationType = string;
    }

    public String _persistence_get_docTitle() {
        this._persistence_checkFetched("docTitle");
        return this.docTitle;
    }

    public void _persistence_set_docTitle(String string) {
        this._persistence_checkFetchedForSet("docTitle");
        this._persistence_propertyChange("docTitle", this.docTitle, string);
        this.docTitle = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this._persistence_propertyChange("documentId", this.documentId, string);
        this.documentId = string;
    }

    public String _persistence_get_delegatorGroupId() {
        this._persistence_checkFetched("delegatorGroupId");
        return this.delegatorGroupId;
    }

    public void _persistence_set_delegatorGroupId(String string) {
        this._persistence_checkFetchedForSet("delegatorGroupId");
        this._persistence_propertyChange("delegatorGroupId", this.delegatorGroupId, string);
        this.delegatorGroupId = string;
    }

    public String _persistence_get_requestLabel() {
        this._persistence_checkFetched("requestLabel");
        return this.requestLabel;
    }

    public void _persistence_set_requestLabel(String string) {
        this._persistence_checkFetchedForSet("requestLabel");
        this._persistence_propertyChange("requestLabel", this.requestLabel, string);
        this.requestLabel = string;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

