/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.attribute;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLAttributeUtils {
    private static final Logger LOG = Logger.getLogger(XMLAttributeUtils.class);

    private XMLAttributeUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void establishFieldLookup(Field field, Node lookupNode) {
        NamedNodeMap quickfinderAttributes = lookupNode.getAttributes();
        String businessObjectClass = quickfinderAttributes.getNamedItem("businessObjectClass").getNodeValue();
        field.setQuickFinderClassNameImpl(businessObjectClass);
        HashMap<String, String> fieldConversionsMap = new HashMap<String, String>();
        for (int lcIndex = 0; lcIndex < lookupNode.getChildNodes().getLength(); ++lcIndex) {
            Node fieldConversionsChildNode = lookupNode.getChildNodes().item(lcIndex);
            if (!"fieldConversions".equals(fieldConversionsChildNode.getNodeName())) continue;
            for (int fcIndex = 0; fcIndex < fieldConversionsChildNode.getChildNodes().getLength(); ++fcIndex) {
                Node fieldConversionChildNode = fieldConversionsChildNode.getChildNodes().item(fcIndex);
                if (!"fieldConversion".equals(fieldConversionChildNode.getNodeName())) continue;
                NamedNodeMap fieldConversionAttributes = fieldConversionChildNode.getAttributes();
                String lookupFieldName = fieldConversionAttributes.getNamedItem("lookupFieldName").getNodeValue();
                String localFieldName = fieldConversionAttributes.getNamedItem("localFieldName").getNodeValue();
                fieldConversionsMap.put(lookupFieldName, localFieldName);
            }
        }
        field.setFieldConversions(fieldConversionsMap);
    }

    public static void establishFieldLookup(RemotableAttributeField.Builder fieldBuilder, Node lookupNode) {
        NamedNodeMap quickfinderAttributes = lookupNode.getAttributes();
        Node dataObjectNode = quickfinderAttributes.getNamedItem("dataObjectClass");
        if (dataObjectNode == null) {
            dataObjectNode = quickfinderAttributes.getNamedItem("businessObjectClass");
            if (dataObjectNode != null) {
                LOG.warn((Object)("Field is using deprecated 'businessObjectClass' instead of 'dataObjectClass' for lookup definition, field name is: " + fieldBuilder.getName()));
            } else {
                throw new ConfigurationException("Failed to locate 'dataObjectClass' for lookup definition.");
            }
        }
        String dataObjectClass = dataObjectNode.getNodeValue();
        String baseLookupUrl = LookupUtils.getBaseLookupUrl((boolean)false);
        RemotableQuickFinder.Builder quickFinderBuilder = RemotableQuickFinder.Builder.create((String)baseLookupUrl, (String)dataObjectClass);
        for (int lcIndex = 0; lcIndex < lookupNode.getChildNodes().getLength(); ++lcIndex) {
            HashMap<String, String> fieldConversionsMap = new HashMap<String, String>();
            Node fieldConversionsChildNode = lookupNode.getChildNodes().item(lcIndex);
            if ("fieldConversions".equals(fieldConversionsChildNode)) {
                for (int fcIndex = 0; fcIndex < fieldConversionsChildNode.getChildNodes().getLength(); ++fcIndex) {
                    Node fieldConversionChildNode = fieldConversionsChildNode.getChildNodes().item(fcIndex);
                    if (!"fieldConversion".equals(fieldConversionChildNode)) continue;
                    NamedNodeMap fieldConversionAttributes = fieldConversionChildNode.getAttributes();
                    String lookupFieldName = fieldConversionAttributes.getNamedItem("lookupFieldName").getNodeValue();
                    String localFieldName = fieldConversionAttributes.getNamedItem("localFieldName").getNodeValue();
                    fieldConversionsMap.put(lookupFieldName, localFieldName);
                }
            }
            quickFinderBuilder.setFieldConversions(fieldConversionsMap);
            fieldBuilder.getWidgets().add(quickFinderBuilder);
        }
    }
}

