/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.kew.api.doctype.RouteNodeConfigurationParameterContract;
import org.kuali.rice.kew.api.doctype.RouteNodeContract;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.ActivationTypeEnum;
import org.kuali.rice.kew.engine.node.BranchPrototype;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNodeConfigParam;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.Boolean01BigDecimalConverter;

@Entity
@Table(name="KREW_RTE_NODE_T")
public class RouteNode
implements Serializable,
RouteNodeContract,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = 4891233177051752726L;
    public static final String CONTENT_FRAGMENT_CFG_KEY = "contentFragment";
    public static final String RULE_SELECTOR_CFG_KEY = "ruleSelector";
    @Id
    @PortableSequenceGenerator(name="KREW_RTE_NODE_S")
    @GeneratedValue(generator="KREW_RTE_NODE_S")
    @Column(name="RTE_NODE_ID", nullable=false)
    private String routeNodeId;
    @Column(name="DOC_TYP_ID", insertable=false, updatable=false)
    private String documentTypeId;
    @ManyToOne
    @JoinColumn(name="DOC_TYP_ID", nullable=false)
    private DocumentType documentType;
    @Column(name="NM", nullable=false)
    private String routeNodeName;
    @Column(name="RTE_MTHD_NM")
    private String routeMethodName;
    @Column(name="FNL_APRVR_IND")
    @Convert(converter=Boolean01BigDecimalConverter.class)
    private Boolean finalApprovalInd;
    @Column(name="MNDTRY_RTE_IND")
    @Convert(converter=Boolean01BigDecimalConverter.class)
    private Boolean mandatoryRouteInd;
    @Column(name="GRP_ID")
    private String exceptionWorkgroupId;
    @Column(name="RTE_MTHD_CD")
    private String routeMethodCode;
    @Column(name="ACTVN_TYP")
    private String activationType = ActivationTypeEnum.PARALLEL.getCode();
    @Column(name="NEXT_DOC_STAT")
    private String nextDocStatus;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @Column(name="TYP")
    private String nodeType = RequestsNode.class.getName();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="nextNodes")
    private List<RouteNode> previousNodes = new ArrayList<RouteNode>();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="KREW_RTE_NODE_LNK_T", joinColumns={@JoinColumn(name="FROM_RTE_NODE_ID")}, inverseJoinColumns={@JoinColumn(name="TO_RTE_NODE_ID")})
    private List<RouteNode> nextNodes = new ArrayList<RouteNode>();
    @OneToMany(fetch=FetchType.EAGER, mappedBy="routeNode", cascade={CascadeType.ALL})
    private List<RouteNodeConfigParam> configParams = new ArrayList<RouteNodeConfigParam>(0);
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="BRCH_PROTO_ID")
    private BranchPrototype branch;
    @Transient
    private String exceptionWorkgroupName;
    @Transient
    private RuleTemplateBo ruleTemplate;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    protected RouteNodeConfigParam getConfigParam(String key) {
        Map configParamMap = Utilities.getKeyValueCollectionAsLookupTable(this._persistence_get_configParams());
        return (RouteNodeConfigParam)((Object)configParamMap.get(key));
    }

    protected void setConfigParam(String key, String value) {
        Map configParamMap = Utilities.getKeyValueCollectionAsLookupTable(this._persistence_get_configParams());
        RouteNodeConfigParam cfCfgParam = (RouteNodeConfigParam)((Object)configParamMap.get(key));
        if (cfCfgParam == null) {
            cfCfgParam = new RouteNodeConfigParam(this, key, value);
            this._persistence_get_configParams().add(cfCfgParam);
        } else {
            cfCfgParam.setValue(value);
        }
    }

    public List<RouteNodeConfigParam> getConfigParams() {
        return this._persistence_get_configParams();
    }

    public void setConfigParams(List<RouteNodeConfigParam> configParams) {
        this._persistence_set_configParams(configParams);
    }

    public String getContentFragment() {
        RouteNodeConfigParam cfCfgParam = this.getConfigParam(CONTENT_FRAGMENT_CFG_KEY);
        if (cfCfgParam == null) {
            return null;
        }
        return cfCfgParam.getValue();
    }

    public void setContentFragment(String contentFragment) {
        this.setConfigParam(CONTENT_FRAGMENT_CFG_KEY, contentFragment);
    }

    public String getActivationType() {
        return this._persistence_get_activationType();
    }

    public void setActivationType(String activationType) {
        ActivationTypeEnum at = ActivationTypeEnum.lookupCode(activationType);
        this._persistence_set_activationType(at.getCode());
    }

    public Group getExceptionWorkgroup() {
        if (!StringUtils.isBlank((String)this._persistence_get_exceptionWorkgroupId())) {
            return KimApiServiceLocator.getGroupService().getGroup(this._persistence_get_exceptionWorkgroupId());
        }
        return null;
    }

    public boolean isExceptionGroupDefined() {
        return this.getExceptionWorkgroupId() != null;
    }

    public String getExceptionWorkgroupId() {
        return this._persistence_get_exceptionWorkgroupId();
    }

    public void setExceptionWorkgroupId(String workgroupId) {
        this._persistence_set_exceptionWorkgroupId(workgroupId);
    }

    public void setFinalApprovalInd(Boolean finalApprovalInd) {
        this._persistence_set_finalApprovalInd(finalApprovalInd);
    }

    public void setMandatoryRouteInd(Boolean mandatoryRouteInd) {
        this._persistence_set_mandatoryRouteInd(mandatoryRouteInd);
    }

    public String getRouteMethodName() {
        return this._persistence_get_routeMethodName();
    }

    public void setRouteMethodName(String routeMethodName) {
        this._persistence_set_routeMethodName(routeMethodName);
    }

    public String getDocumentTypeId() {
        return this.getDocumentType() != null ? this.getDocumentType().getDocumentTypeId() : this._persistence_get_documentTypeId();
    }

    public void setDocumentTypeId(String documentTypeId) {
        this._persistence_set_documentTypeId(documentTypeId);
    }

    public String getRouteNodeId() {
        return this._persistence_get_routeNodeId();
    }

    public void setRouteNodeId(String routeNodeId) {
        this._persistence_set_routeNodeId(routeNodeId);
    }

    public String getRouteNodeName() {
        return this._persistence_get_routeNodeName();
    }

    public void setRouteNodeName(String routeLevelName) {
        this._persistence_set_routeNodeName(routeLevelName);
    }

    public DocumentType getDocumentType() {
        return this._persistence_get_documentType();
    }

    public void setDocumentType(DocumentType documentType) {
        this._persistence_set_documentType(documentType);
    }

    public String getRouteMethodCode() {
        return this._persistence_get_routeMethodCode();
    }

    public void setRouteMethodCode(String routeMethodCode) {
        this._persistence_set_routeMethodCode(routeMethodCode);
    }

    public void setNextDocStatus(String nextDocStatus) {
        this._persistence_set_nextDocStatus(nextDocStatus);
    }

    public String getNextDocStatus() {
        return this._persistence_get_nextDocStatus();
    }

    public String getExceptionWorkgroupName() {
        Group exceptionGroup = this.getExceptionWorkgroup();
        if ((this.exceptionWorkgroupName == null || this.exceptionWorkgroupName.equals("")) && exceptionGroup != null) {
            return exceptionGroup.getName();
        }
        return this.exceptionWorkgroupName;
    }

    public void setExceptionWorkgroupName(String exceptionWorkgroupName) {
        this.exceptionWorkgroupName = exceptionWorkgroupName;
    }

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    public boolean isFlexRM() {
        return this._persistence_get_routeMethodCode() != null && this._persistence_get_routeMethodCode().equals("FR");
    }

    public boolean isRulesEngineNode() {
        return StringUtils.equals((String)this._persistence_get_routeMethodCode(), (String)"RE");
    }

    public boolean isPeopleFlowNode() {
        return StringUtils.equals((String)this._persistence_get_routeMethodCode(), (String)"PF");
    }

    public boolean isRoleNode() {
        try {
            return this._persistence_get_nodeType() != null && NodeType.fromNode(this).isTypeOf(NodeType.ROLE);
        }
        catch (ResourceUnavailableException ex) {
            Logger.getLogger(RouteNode.class).info((Object)("isRoleNode(): Unable to determine node type: " + ex.getMessage()));
            return false;
        }
    }

    public Boolean getFinalApprovalInd() {
        return this._persistence_get_finalApprovalInd();
    }

    public Boolean getMandatoryRouteInd() {
        return this._persistence_get_mandatoryRouteInd();
    }

    public void addNextNode(RouteNode nextNode) {
        this.getNextNodes().add(nextNode);
        nextNode.getPreviousNodes().add(this);
    }

    public List<RouteNode> getNextNodes() {
        return this._persistence_get_nextNodes();
    }

    public void setNextNodes(List<RouteNode> nextNodes) {
        this._persistence_set_nextNodes(nextNodes);
    }

    public List<RouteNode> getPreviousNodes() {
        return this._persistence_get_previousNodes();
    }

    public void setPreviousNodes(List<RouteNode> parentNodes) {
        this._persistence_set_previousNodes(parentNodes);
    }

    public RuleTemplateBo getRuleTemplate() {
        if (this.ruleTemplate == null) {
            RuleTemplateService ruleTemplateService = (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
            this.ruleTemplate = ruleTemplateService.findByRuleTemplateName(this.getRouteMethodName());
        }
        return this.ruleTemplate;
    }

    public String getNodeType() {
        return this._persistence_get_nodeType();
    }

    public void setNodeType(String nodeType) {
        this._persistence_set_nodeType(nodeType);
    }

    public BranchPrototype getBranch() {
        return this._persistence_get_branch();
    }

    public void setBranch(BranchPrototype branch) {
        this._persistence_set_branch(branch);
    }

    public String toString() {
        return "RouteNode[routeNodeName=" + this._persistence_get_routeNodeName() + ", nodeType=" + this._persistence_get_nodeType() + ", activationType=" + this._persistence_get_activationType() + "]";
    }

    public Long getVersionNumber() {
        if (this._persistence_get_lockVerNbr() == null) {
            return null;
        }
        return this._persistence_get_lockVerNbr().longValue();
    }

    public String getId() {
        if (this._persistence_get_routeNodeId() == null) {
            return null;
        }
        return this._persistence_get_routeNodeId().toString();
    }

    public String getName() {
        return this.getRouteNodeName();
    }

    public boolean isFinalApproval() {
        if (this._persistence_get_finalApprovalInd() == null) {
            return false;
        }
        return this._persistence_get_finalApprovalInd();
    }

    public boolean isMandatory() {
        if (this._persistence_get_mandatoryRouteInd() == null) {
            return false;
        }
        return this._persistence_get_mandatoryRouteInd();
    }

    public String getExceptionGroupId() {
        return this._persistence_get_exceptionWorkgroupId();
    }

    public String getType() {
        return this._persistence_get_nodeType();
    }

    public String getBranchName() {
        if (this._persistence_get_branch() == null) {
            return null;
        }
        return this._persistence_get_branch().getName();
    }

    public String getNextDocumentStatus() {
        return this._persistence_get_nextDocStatus();
    }

    public List<? extends RouteNodeConfigurationParameterContract> getConfigurationParameters() {
        return this._persistence_get_configParams();
    }

    public List<String> getPreviousNodeIds() {
        ArrayList<String> previousNodeIds = new ArrayList<String>();
        if (this._persistence_get_previousNodes() != null) {
            for (RouteNode previousNode : this._persistence_get_previousNodes()) {
                previousNodeIds.add(previousNode.getRouteNodeId().toString());
            }
        }
        return previousNodeIds;
    }

    public List<String> getNextNodeIds() {
        ArrayList<String> nextNodeIds = new ArrayList<String>();
        if (nextNodeIds != null) {
            for (RouteNode nextNode : this._persistence_get_nextNodes()) {
                nextNodeIds.add(nextNode.getRouteNodeId().toString());
            }
        }
        return nextNodeIds;
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RouteNode();
    }

    public Object _persistence_get(String string) {
        if (string == "documentType") {
            return this.documentType;
        }
        if (string == "routeNodeName") {
            return this.routeNodeName;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "routeNodeId") {
            return this.routeNodeId;
        }
        if (string == "finalApprovalInd") {
            return this.finalApprovalInd;
        }
        if (string == "activationType") {
            return this.activationType;
        }
        if (string == "nextNodes") {
            return this.nextNodes;
        }
        if (string == "configParams") {
            return this.configParams;
        }
        if (string == "exceptionWorkgroupId") {
            return this.exceptionWorkgroupId;
        }
        if (string == "documentTypeId") {
            return this.documentTypeId;
        }
        if (string == "previousNodes") {
            return this.previousNodes;
        }
        if (string == "branch") {
            return this.branch;
        }
        if (string == "routeMethodCode") {
            return this.routeMethodCode;
        }
        if (string == "mandatoryRouteInd") {
            return this.mandatoryRouteInd;
        }
        if (string == "nextDocStatus") {
            return this.nextDocStatus;
        }
        if (string == "nodeType") {
            return this.nodeType;
        }
        if (string == "routeMethodName") {
            return this.routeMethodName;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "documentType") {
            this.documentType = (DocumentType)object;
            return;
        }
        if (string == "routeNodeName") {
            this.routeNodeName = (String)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "routeNodeId") {
            this.routeNodeId = (String)object;
            return;
        }
        if (string == "finalApprovalInd") {
            this.finalApprovalInd = (Boolean)object;
            return;
        }
        if (string == "activationType") {
            this.activationType = (String)object;
            return;
        }
        if (string == "nextNodes") {
            this.nextNodes = (List)object;
            return;
        }
        if (string == "configParams") {
            this.configParams = (List)object;
            return;
        }
        if (string == "exceptionWorkgroupId") {
            this.exceptionWorkgroupId = (String)object;
            return;
        }
        if (string == "documentTypeId") {
            this.documentTypeId = (String)object;
            return;
        }
        if (string == "previousNodes") {
            this.previousNodes = (List)object;
            return;
        }
        if (string == "branch") {
            this.branch = (BranchPrototype)object;
            return;
        }
        if (string == "routeMethodCode") {
            this.routeMethodCode = (String)object;
            return;
        }
        if (string == "mandatoryRouteInd") {
            this.mandatoryRouteInd = (Boolean)object;
            return;
        }
        if (string == "nextDocStatus") {
            this.nextDocStatus = (String)object;
            return;
        }
        if (string == "nodeType") {
            this.nodeType = (String)object;
            return;
        }
        if (string == "routeMethodName") {
            this.routeMethodName = (String)object;
            return;
        }
    }

    public DocumentType _persistence_get_documentType() {
        this._persistence_checkFetched("documentType");
        return this.documentType;
    }

    public void _persistence_set_documentType(DocumentType documentType) {
        this._persistence_checkFetchedForSet("documentType");
        this.documentType = documentType;
    }

    public String _persistence_get_routeNodeName() {
        this._persistence_checkFetched("routeNodeName");
        return this.routeNodeName;
    }

    public void _persistence_set_routeNodeName(String string) {
        this._persistence_checkFetchedForSet("routeNodeName");
        this.routeNodeName = string;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this.lockVerNbr = n;
    }

    public String _persistence_get_routeNodeId() {
        this._persistence_checkFetched("routeNodeId");
        return this.routeNodeId;
    }

    public void _persistence_set_routeNodeId(String string) {
        this._persistence_checkFetchedForSet("routeNodeId");
        this.routeNodeId = string;
    }

    public Boolean _persistence_get_finalApprovalInd() {
        this._persistence_checkFetched("finalApprovalInd");
        return this.finalApprovalInd;
    }

    public void _persistence_set_finalApprovalInd(Boolean bl) {
        this._persistence_checkFetchedForSet("finalApprovalInd");
        this.finalApprovalInd = bl;
    }

    public String _persistence_get_activationType() {
        this._persistence_checkFetched("activationType");
        return this.activationType;
    }

    public void _persistence_set_activationType(String string) {
        this._persistence_checkFetchedForSet("activationType");
        this.activationType = string;
    }

    public List _persistence_get_nextNodes() {
        this._persistence_checkFetched("nextNodes");
        return this.nextNodes;
    }

    public void _persistence_set_nextNodes(List list) {
        this._persistence_checkFetchedForSet("nextNodes");
        this.nextNodes = list;
    }

    public List _persistence_get_configParams() {
        this._persistence_checkFetched("configParams");
        return this.configParams;
    }

    public void _persistence_set_configParams(List list) {
        this._persistence_checkFetchedForSet("configParams");
        this.configParams = list;
    }

    public String _persistence_get_exceptionWorkgroupId() {
        this._persistence_checkFetched("exceptionWorkgroupId");
        return this.exceptionWorkgroupId;
    }

    public void _persistence_set_exceptionWorkgroupId(String string) {
        this._persistence_checkFetchedForSet("exceptionWorkgroupId");
        this.exceptionWorkgroupId = string;
    }

    public String _persistence_get_documentTypeId() {
        this._persistence_checkFetched("documentTypeId");
        return this.documentTypeId;
    }

    public void _persistence_set_documentTypeId(String string) {
        this._persistence_checkFetchedForSet("documentTypeId");
        this.documentTypeId = string;
    }

    public List _persistence_get_previousNodes() {
        this._persistence_checkFetched("previousNodes");
        return this.previousNodes;
    }

    public void _persistence_set_previousNodes(List list) {
        this._persistence_checkFetchedForSet("previousNodes");
        this.previousNodes = list;
    }

    public BranchPrototype _persistence_get_branch() {
        this._persistence_checkFetched("branch");
        return this.branch;
    }

    public void _persistence_set_branch(BranchPrototype branchPrototype) {
        this._persistence_checkFetchedForSet("branch");
        this.branch = branchPrototype;
    }

    public String _persistence_get_routeMethodCode() {
        this._persistence_checkFetched("routeMethodCode");
        return this.routeMethodCode;
    }

    public void _persistence_set_routeMethodCode(String string) {
        this._persistence_checkFetchedForSet("routeMethodCode");
        this.routeMethodCode = string;
    }

    public Boolean _persistence_get_mandatoryRouteInd() {
        this._persistence_checkFetched("mandatoryRouteInd");
        return this.mandatoryRouteInd;
    }

    public void _persistence_set_mandatoryRouteInd(Boolean bl) {
        this._persistence_checkFetchedForSet("mandatoryRouteInd");
        this.mandatoryRouteInd = bl;
    }

    public String _persistence_get_nextDocStatus() {
        this._persistence_checkFetched("nextDocStatus");
        return this.nextDocStatus;
    }

    public void _persistence_set_nextDocStatus(String string) {
        this._persistence_checkFetchedForSet("nextDocStatus");
        this.nextDocStatus = string;
    }

    public String _persistence_get_nodeType() {
        this._persistence_checkFetched("nodeType");
        return this.nodeType;
    }

    public void _persistence_set_nodeType(String string) {
        this._persistence_checkFetchedForSet("nodeType");
        this.nodeType = string;
    }

    public String _persistence_get_routeMethodName() {
        this._persistence_checkFetched("routeMethodName");
        return this.routeMethodName;
    }

    public void _persistence_set_routeMethodName(String string) {
        this._persistence_checkFetchedForSet("routeMethodName");
        this.routeMethodName = string;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

