/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.kuali.rice.kew.rule.RoleAttribute;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.RoleRecipient;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREW_RULE_RSP_T")
public class RuleResponsibilityBo
extends PersistableBusinessObjectBase
implements RuleResponsibilityContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -1565688857123316797L;
    @Id
    @PortableSequenceGenerator(name="KREW_RSP_S")
    @GeneratedValue(generator="KREW_RSP_S")
    @Column(name="RULE_RSP_ID")
    private String id;
    @Column(name="RSP_ID")
    private String responsibilityId;
    @Column(name="RULE_ID", insertable=false, updatable=false)
    private String ruleBaseValuesId;
    @Column(name="ACTN_RQST_CD")
    private String actionRequestedCd;
    @Column(name="NM")
    private String ruleResponsibilityName;
    @Column(name="TYP")
    private String ruleResponsibilityType;
    @Column(name="PRIO")
    private Integer priority;
    @Column(name="APPR_PLCY")
    private String approvePolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RULE_ID")
    private RuleBaseValues ruleBaseValues;

    public Principal getPrincipal() {
        if (this.isUsingPrincipal()) {
            return KEWServiceLocator.getIdentityHelperService().getPrincipal(this._persistence_get_ruleResponsibilityName());
        }
        return null;
    }

    public Group getGroup() {
        if (this.isUsingGroup()) {
            return KimApiServiceLocator.getGroupService().getGroup(this._persistence_get_ruleResponsibilityName());
        }
        return null;
    }

    public String getRole() {
        if (this.isUsingRole()) {
            return this._persistence_get_ruleResponsibilityName();
        }
        return null;
    }

    public String getResolvedRoleName() {
        if (this.isUsingRole()) {
            return this.getRole().substring(this.getRole().indexOf("!") + 1, this.getRole().length());
        }
        return null;
    }

    public String getRoleAttributeName() {
        return this.getRole().substring(0, this.getRole().indexOf("!"));
    }

    public RoleAttribute resolveRoleAttribute() {
        if (this.isUsingRole()) {
            String attributeName = this.getRoleAttributeName();
            return (RoleAttribute)GlobalResourceLoader.getResourceLoader().getObject(new ObjectDefinition(attributeName));
        }
        return null;
    }

    public boolean isUsingRole() {
        return this._persistence_get_ruleResponsibilityName() != null && this._persistence_get_ruleResponsibilityType() != null && this._persistence_get_ruleResponsibilityType().equals("R");
    }

    public boolean isUsingPrincipal() {
        return this._persistence_get_ruleResponsibilityName() != null && !this._persistence_get_ruleResponsibilityName().trim().equals("") && this._persistence_get_ruleResponsibilityType() != null && this._persistence_get_ruleResponsibilityType().equals("F");
    }

    public boolean isUsingGroup() {
        return this._persistence_get_ruleResponsibilityName() != null && !this._persistence_get_ruleResponsibilityName().trim().equals("") && this._persistence_get_ruleResponsibilityType() != null && this._persistence_get_ruleResponsibilityType().equals("G");
    }

    public String getRuleBaseValuesId() {
        return this._persistence_get_ruleBaseValuesId();
    }

    public void setRuleBaseValuesId(String ruleBaseValuesId) {
        this._persistence_set_ruleBaseValuesId(ruleBaseValuesId);
    }

    public RuleBaseValues getRuleBaseValues() {
        return this._persistence_get_ruleBaseValues();
    }

    public void setRuleBaseValues(RuleBaseValues ruleBaseValues) {
        this._persistence_set_ruleBaseValues(ruleBaseValues);
    }

    public String getActionRequestedCd() {
        return this._persistence_get_actionRequestedCd();
    }

    public void setActionRequestedCd(String actionRequestedCd) {
        this._persistence_set_actionRequestedCd(actionRequestedCd);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String ruleResponsibilityId) {
        this._persistence_set_id(ruleResponsibilityId);
    }

    public Integer getPriority() {
        return this._persistence_get_priority();
    }

    public void setPriority(Integer priority) {
        this._persistence_set_priority(priority);
    }

    public String getApprovePolicy() {
        return this._persistence_get_approvePolicy();
    }

    public void setApprovePolicy(String approvePolicy) {
        this._persistence_set_approvePolicy(approvePolicy);
    }

    public Object copy(boolean preserveKeys) {
        RuleResponsibilityBo ruleResponsibilityClone = new RuleResponsibilityBo();
        ruleResponsibilityClone.setApprovePolicy(this.getApprovePolicy());
        if (this._persistence_get_actionRequestedCd() != null) {
            ruleResponsibilityClone.setActionRequestedCd(this._persistence_get_actionRequestedCd());
        }
        if (this._persistence_get_id() != null && preserveKeys) {
            ruleResponsibilityClone.setId(this._persistence_get_id());
        }
        if (this._persistence_get_responsibilityId() != null) {
            ruleResponsibilityClone.setResponsibilityId(this._persistence_get_responsibilityId());
        }
        if (this._persistence_get_ruleResponsibilityName() != null) {
            ruleResponsibilityClone.setRuleResponsibilityName(this._persistence_get_ruleResponsibilityName());
        }
        if (this._persistence_get_ruleResponsibilityType() != null) {
            ruleResponsibilityClone.setRuleResponsibilityType(this._persistence_get_ruleResponsibilityType());
        }
        if (this._persistence_get_priority() != null) {
            ruleResponsibilityClone.setPriority(this._persistence_get_priority());
        }
        return ruleResponsibilityClone;
    }

    public String getRuleResponsibilityName() {
        return this._persistence_get_ruleResponsibilityName();
    }

    public void setRuleResponsibilityName(String ruleResponsibilityName) {
        this._persistence_set_ruleResponsibilityName(ruleResponsibilityName);
    }

    public String getRuleResponsibilityType() {
        return this._persistence_get_ruleResponsibilityType();
    }

    public void setRuleResponsibilityType(String ruleResponsibilityType) {
        this._persistence_set_ruleResponsibilityType(ruleResponsibilityType);
    }

    public String getResponsibilityId() {
        return this._persistence_get_responsibilityId();
    }

    public void setResponsibilityId(String responsibilityId) {
        this._persistence_set_responsibilityId(responsibilityId);
    }

    public List<RuleDelegationBo> getDelegationRules() {
        return KEWServiceLocator.getRuleDelegationService().findByResponsibilityId(this.getResponsibilityId());
    }

    public RuleDelegationBo getDelegationRule(int index) {
        return this.getDelegationRules().get(index);
    }

    public String getActionRequestedDisplayValue() {
        return (String)KewApiConstants.ACTION_REQUEST_CODES.get(this.getActionRequestedCd());
    }

    public String getRuleResponsibilityTypeDisplayValue() {
        return (String)KewApiConstants.RULE_RESPONSIBILITY_TYPES.get(this.getRuleResponsibilityType());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RuleResponsibilityBo)) {
            return false;
        }
        RuleResponsibilityBo pred = (RuleResponsibilityBo)((Object)o);
        return ObjectUtils.equals((Object)this._persistence_get_ruleResponsibilityName(), (Object)pred.getRuleResponsibilityName()) && ObjectUtils.equals((Object)this._persistence_get_actionRequestedCd(), (Object)pred.getActionRequestedCd()) && ObjectUtils.equals((Object)this._persistence_get_priority(), (Object)pred.getPriority()) && ObjectUtils.equals((Object)this._persistence_get_approvePolicy(), (Object)pred.getApprovePolicy());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._persistence_get_actionRequestedCd()).append((Object)this._persistence_get_approvePolicy()).append((Object)this._persistence_get_priority()).append((Object)this._persistence_get_ruleResponsibilityName()).toHashCode();
    }

    public String getGroupId() {
        if (!this.isUsingGroup()) {
            return null;
        }
        return this.getGroup().getId();
    }

    public String getPrincipalId() {
        if (this.getPrincipal() == null) {
            return null;
        }
        return this.getPrincipal().getPrincipalId();
    }

    public String getRoleName() {
        return this.getRole();
    }

    public Recipient getRecipient() {
        if (this.isUsingPrincipal()) {
            return new KimPrincipalRecipient((PrincipalContract)this.getPrincipal());
        }
        if (this.isUsingGroup()) {
            return new KimGroupRecipient(this.getGroup());
        }
        if (this.isUsingRole()) {
            return new RoleRecipient(this.getRole());
        }
        return null;
    }

    public static RuleResponsibility to(RuleResponsibilityBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleResponsibility.Builder.create((RuleResponsibilityContract)bo).build();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RuleResponsibilityBo();
    }

    public Object _persistence_get(String string) {
        if (string == "ruleResponsibilityType") {
            return this.ruleResponsibilityType;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "ruleBaseValues") {
            return this.ruleBaseValues;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "ruleResponsibilityName") {
            return this.ruleResponsibilityName;
        }
        if (string == "responsibilityId") {
            return this.responsibilityId;
        }
        if (string == "actionRequestedCd") {
            return this.actionRequestedCd;
        }
        if (string == "approvePolicy") {
            return this.approvePolicy;
        }
        if (string == "ruleBaseValuesId") {
            return this.ruleBaseValuesId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "ruleResponsibilityType") {
            this.ruleResponsibilityType = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "ruleBaseValues") {
            this.ruleBaseValues = (RuleBaseValues)((Object)object);
            return;
        }
        if (string == "priority") {
            this.priority = (Integer)object;
            return;
        }
        if (string == "ruleResponsibilityName") {
            this.ruleResponsibilityName = (String)object;
            return;
        }
        if (string == "responsibilityId") {
            this.responsibilityId = (String)object;
            return;
        }
        if (string == "actionRequestedCd") {
            this.actionRequestedCd = (String)object;
            return;
        }
        if (string == "approvePolicy") {
            this.approvePolicy = (String)object;
            return;
        }
        if (string == "ruleBaseValuesId") {
            this.ruleBaseValuesId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_ruleResponsibilityType() {
        this._persistence_checkFetched("ruleResponsibilityType");
        return this.ruleResponsibilityType;
    }

    public void _persistence_set_ruleResponsibilityType(String string) {
        this._persistence_checkFetchedForSet("ruleResponsibilityType");
        this._persistence_propertyChange("ruleResponsibilityType", this.ruleResponsibilityType, string);
        this.ruleResponsibilityType = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public RuleBaseValues _persistence_get_ruleBaseValues() {
        this._persistence_checkFetched("ruleBaseValues");
        return this.ruleBaseValues;
    }

    public void _persistence_set_ruleBaseValues(RuleBaseValues ruleBaseValues) {
        this._persistence_checkFetchedForSet("ruleBaseValues");
        this._persistence_propertyChange("ruleBaseValues", (Object)this.ruleBaseValues, (Object)ruleBaseValues);
        this.ruleBaseValues = ruleBaseValues;
    }

    public Integer _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(Integer n) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", this.priority, n);
        this.priority = n;
    }

    public String _persistence_get_ruleResponsibilityName() {
        this._persistence_checkFetched("ruleResponsibilityName");
        return this.ruleResponsibilityName;
    }

    public void _persistence_set_ruleResponsibilityName(String string) {
        this._persistence_checkFetchedForSet("ruleResponsibilityName");
        this._persistence_propertyChange("ruleResponsibilityName", this.ruleResponsibilityName, string);
        this.ruleResponsibilityName = string;
    }

    public String _persistence_get_responsibilityId() {
        this._persistence_checkFetched("responsibilityId");
        return this.responsibilityId;
    }

    public void _persistence_set_responsibilityId(String string) {
        this._persistence_checkFetchedForSet("responsibilityId");
        this._persistence_propertyChange("responsibilityId", this.responsibilityId, string);
        this.responsibilityId = string;
    }

    public String _persistence_get_actionRequestedCd() {
        this._persistence_checkFetched("actionRequestedCd");
        return this.actionRequestedCd;
    }

    public void _persistence_set_actionRequestedCd(String string) {
        this._persistence_checkFetchedForSet("actionRequestedCd");
        this._persistence_propertyChange("actionRequestedCd", this.actionRequestedCd, string);
        this.actionRequestedCd = string;
    }

    public String _persistence_get_approvePolicy() {
        this._persistence_checkFetched("approvePolicy");
        return this.approvePolicy;
    }

    public void _persistence_set_approvePolicy(String string) {
        this._persistence_checkFetchedForSet("approvePolicy");
        this._persistence_propertyChange("approvePolicy", this.approvePolicy, string);
        this.approvePolicy = string;
    }

    public String _persistence_get_ruleBaseValuesId() {
        this._persistence_checkFetched("ruleBaseValuesId");
        return this.ruleBaseValuesId;
    }

    public void _persistence_set_ruleBaseValuesId(String string) {
        this._persistence_checkFetchedForSet("ruleBaseValuesId");
        this._persistence_propertyChange("ruleBaseValuesId", this.ruleBaseValuesId, string);
        this.ruleBaseValuesId = string;
    }
}

