/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.impl.identity.email.EntityEmailBo;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.kim.impl.identity.entity.EntityBo;
import org.kuali.rice.kim.impl.identity.name.EntityNameBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.identity.type.EntityTypeContactInfoBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.xml.sax.SAXException;

public class UserXmlParser {
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"", (String)"ns:workflow/User");
    private static final String USERS_ELEMENT = "users";
    private static final String USER_ELEMENT = "user";
    private static final String WORKFLOW_ID_ELEMENT = "workflowId";
    private static final String AUTHENTICATION_ID_ELEMENT = "authenticationId";
    private static final String PRINCIPAL_ID_ELEMENT = "principalId";
    private static final String PRINCIPAL_NAME_ELEMENT = "principalName";
    private static final String EMPL_ID_ELEMENT = "emplId";
    private static final String EMAIL_ELEMENT = "emailAddress";
    private static final String GIVEN_NAME_ELEMENT = "givenName";
    private static final String LAST_NAME_ELEMENT = "lastName";
    private static final String TYPE_ELEMENT = "type";
    private DataSource kimDataSource;

    public void parseUsers(InputStream input) throws IOException, XmlException {
        try {
            Document doc = XmlHelper.trimSAXXml((InputStream)input);
            Element root = doc.getRootElement();
            this.parseUsers(root);
        }
        catch (JDOMException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
    }

    public void parseUsers(Element root) throws XmlException {
        for (Element usersElement : root.getChildren(USERS_ELEMENT, NAMESPACE)) {
            for (Element userElement : usersElement.getChildren(USER_ELEMENT, NAMESPACE)) {
                EntityBo entity = this.constructEntity(userElement);
                this.constructPrincipal(userElement, entity.getId());
            }
        }
    }

    protected EntityBo constructEntity(Element userElement) {
        String firstName = userElement.getChildTextTrim(GIVEN_NAME_ELEMENT, NAMESPACE);
        String lastName = userElement.getChildTextTrim(LAST_NAME_ELEMENT, NAMESPACE);
        String emplId = userElement.getChildTextTrim(EMPL_ID_ELEMENT, NAMESPACE);
        String entityTypeCode = userElement.getChildTextTrim(TYPE_ELEMENT, NAMESPACE);
        if (StringUtils.isBlank((String)entityTypeCode)) {
            entityTypeCode = "PERSON";
        }
        Long entityId = new Long(MaxValueIncrementerFactory.getIncrementer((DataSource)this.getKimDataSource(), (String)"KRIM_ENTITY_ID_S").nextLongValue());
        EntityEmploymentBo emplInfo = null;
        if (!StringUtils.isBlank((String)emplId)) {
            emplInfo = new EntityEmploymentBo();
            emplInfo.setActive(true);
            emplInfo.setEmployeeId(emplId);
            emplInfo.setPrimary(true);
            emplInfo.setEntityId("" + entityId);
            emplInfo.setId(emplId);
            emplInfo.setEntityAffiliationId(null);
        }
        EntityBo entity = new EntityBo();
        entity.setActive(true);
        entity.setId("" + entityId);
        ArrayList<EntityEmploymentBo> emplInfos = new ArrayList<EntityEmploymentBo>();
        if (emplInfo != null) {
            emplInfos.add(emplInfo);
        }
        entity.setEmploymentInformation(emplInfos);
        EntityTypeContactInfoBo entityType = new EntityTypeContactInfoBo();
        entityType.setEntityTypeCode(entityTypeCode);
        entityType.setEntityId(entity.getId());
        entityType.setActive(true);
        String emailAddress = userElement.getChildTextTrim(EMAIL_ELEMENT, NAMESPACE);
        if (!StringUtils.isBlank((String)emailAddress)) {
            Long emailId = new Long(MaxValueIncrementerFactory.getIncrementer((DataSource)this.getKimDataSource(), (String)"KRIM_ENTITY_EMAIL_ID_S").nextLongValue());
            EntityEmail.Builder email = EntityEmail.Builder.create();
            email.setActive(true);
            email.setId("" + emailId);
            email.setEntityTypeCode(entityTypeCode);
            email.setEmailType(CodedAttribute.Builder.create((String)"WRK"));
            email.setEmailAddress(emailAddress);
            email.setDefaultValue(true);
            email.setEntityId(entity.getId());
            ArrayList<EntityEmailBo> emailAddresses = new ArrayList<EntityEmailBo>(1);
            emailAddresses.add(EntityEmailBo.from((EntityEmail)email.build()));
            entityType.setEmailAddresses(emailAddresses);
        }
        ArrayList<EntityTypeContactInfoBo> entityTypes = new ArrayList<EntityTypeContactInfoBo>(1);
        entityTypes.add(entityType);
        entity.setEntityTypeContactInfos(entityTypes);
        if (!StringUtils.isBlank((String)firstName) || !StringUtils.isBlank((String)lastName)) {
            Long entityNameId = MaxValueIncrementerFactory.getIncrementer((DataSource)this.getKimDataSource(), (String)"KRIM_ENTITY_NM_ID_S").nextLongValue();
            EntityNameBo name = new EntityNameBo();
            name.setActive(true);
            name.setId("" + entityNameId);
            name.setEntityId(entity.getId());
            name.setNameCode("PRFR");
            name.setFirstName(firstName);
            name.setMiddleName("");
            name.setLastName(lastName);
            name.setDefaultValue(true);
            entity.setNames(Collections.singletonList(name));
        }
        entity = (EntityBo)KradDataServiceLocator.getDataObjectService().save((Object)entity, new PersistenceOption[0]);
        return entity;
    }

    protected PrincipalBo constructPrincipal(Element userElement, String entityId) {
        String principalName;
        String principalId = userElement.getChildTextTrim(WORKFLOW_ID_ELEMENT, NAMESPACE);
        if (principalId == null) {
            principalId = userElement.getChildTextTrim(PRINCIPAL_ID_ELEMENT, NAMESPACE);
        }
        if ((principalName = userElement.getChildTextTrim(AUTHENTICATION_ID_ELEMENT, NAMESPACE)) == null) {
            principalName = userElement.getChildTextTrim(PRINCIPAL_NAME_ELEMENT, NAMESPACE);
        }
        PrincipalBo principal = new PrincipalBo();
        principal.setActive(true);
        principal.setPrincipalId(principalId);
        principal.setPrincipalName(principalName);
        principal.setEntityId(entityId);
        principal = (PrincipalBo)KradDataServiceLocator.getDataObjectService().save((Object)principal, new PersistenceOption[0]);
        return principal;
    }

    public DataSource getKimDataSource() {
        if (this.kimDataSource == null) {
            this.kimDataSource = KimImplServiceLocator.getDataSource();
            if (this.kimDataSource == null) {
                throw new ConfigurationException("Failed to locate 'kimDataSource'");
            }
        }
        return this.kimDataSource;
    }

    public void setKimDataSource(DataSource kimDataSource) {
        this.kimDataSource = kimDataSource;
    }
}

