/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.authorization.BusinessObjectAuthorizer;
import org.kuali.rice.kns.bo.authorization.InquiryOrMaintenanceDocumentAuthorizer;
import org.kuali.rice.kns.bo.authorization.InquiryOrMaintenanceDocumentPresentationController;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.datadictionary.FieldDefinition;
import org.kuali.rice.kns.datadictionary.InquiryCollectionDefinition;
import org.kuali.rice.kns.datadictionary.InquirySectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictionsBase;
import org.kuali.rice.kns.document.authorization.InquiryOrMaintenanceDocumentRestrictions;
import org.kuali.rice.kns.document.authorization.InquiryOrMaintenanceDocumentRestrictionsBase;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentPresentationController;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictionsBase;
import org.kuali.rice.kns.inquiry.InquiryAuthorizer;
import org.kuali.rice.kns.inquiry.InquiryPresentationController;
import org.kuali.rice.kns.inquiry.InquiryRestrictions;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.impl.DataObjectAuthorizationServiceImpl;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
@LegacyDataFramework
public class BusinessObjectAuthorizationServiceImpl
extends DataObjectAuthorizationServiceImpl
implements BusinessObjectAuthorizationService {
    private DataDictionaryService dataDictionaryService;
    private PermissionService permissionService;
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private DocumentHelperService documentHelperService;
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private ConfigurationService kualiConfigurationService;

    public BusinessObjectRestrictions getLookupResultRestrictions(Object dataObject, Person user) {
        BusinessObjectRestrictionsBase businessObjectRestrictions = new BusinessObjectRestrictionsBase();
        this.considerBusinessObjectFieldUnmaskAuthorization(dataObject, user, (BusinessObjectRestrictions)businessObjectRestrictions, "", null);
        return businessObjectRestrictions;
    }

    public InquiryRestrictions getInquiryRestrictions(BusinessObject businessObject, Person user) {
        InquiryOrMaintenanceDocumentRestrictionsBase inquiryRestrictions = new InquiryOrMaintenanceDocumentRestrictionsBase();
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObject.getClass().getName());
        InquiryPresentationController inquiryPresentationController = this.getBusinessObjectDictionaryService().getInquiryPresentationController(businessObject.getClass());
        InquiryAuthorizer inquiryAuthorizer = this.getBusinessObjectDictionaryService().getInquiryAuthorizer(businessObject.getClass());
        this.considerBusinessObjectFieldUnmaskAuthorization(businessObject, user, (BusinessObjectRestrictions)inquiryRestrictions, "", null);
        this.considerBusinessObjectFieldViewAuthorization((DataObjectEntry)businessObjectEntry, businessObject, null, user, (BusinessObjectAuthorizer)inquiryAuthorizer, (InquiryOrMaintenanceDocumentRestrictions)inquiryRestrictions, "");
        this.considerInquiryOrMaintenanceDocumentPresentationController((InquiryOrMaintenanceDocumentPresentationController)inquiryPresentationController, businessObject, (InquiryOrMaintenanceDocumentRestrictions)inquiryRestrictions);
        this.considerInquiryOrMaintenanceDocumentAuthorizer((InquiryOrMaintenanceDocumentAuthorizer)inquiryAuthorizer, businessObject, user, (InquiryOrMaintenanceDocumentRestrictions)inquiryRestrictions);
        for (InquirySectionDefinition inquirySectionDefinition : businessObjectEntry.getInquiryDefinition().getInquirySections()) {
            List inquiryFields;
            if (inquirySectionDefinition.getInquiryCollections() != null) {
                this.addInquirableItemRestrictions(inquirySectionDefinition.getInquiryCollections().values(), inquiryAuthorizer, (InquiryRestrictions)inquiryRestrictions, businessObject, businessObject, "", user);
            }
            if ((inquiryFields = inquirySectionDefinition.getInquiryFields()) == null) continue;
            for (FieldDefinition fieldDefinition : inquiryFields) {
                this.addInquirableItemRestrictions(inquiryFields, inquiryAuthorizer, (InquiryRestrictions)inquiryRestrictions, businessObject, businessObject, "", user);
            }
        }
        return inquiryRestrictions;
    }

    public MaintenanceDocumentRestrictions getMaintenanceDocumentRestrictions(MaintenanceDocument maintenanceDocument, Person user) {
        MaintenanceDocumentRestrictionsBase maintenanceDocumentRestrictions = new MaintenanceDocumentRestrictionsBase();
        DataObjectEntry dataObjectEntry = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(maintenanceDocument.getNewMaintainableObject().getDataObject().getClass().getName());
        MaintenanceDocumentPresentationController maintenanceDocumentPresentationController = (MaintenanceDocumentPresentationController)this.getDocumentHelperService().getDocumentPresentationController((Document)maintenanceDocument);
        MaintenanceDocumentAuthorizer maintenanceDocumentAuthorizer = (MaintenanceDocumentAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer((Document)maintenanceDocument);
        this.considerBusinessObjectFieldUnmaskAuthorization(maintenanceDocument.getNewMaintainableObject().getDataObject(), user, (BusinessObjectRestrictions)maintenanceDocumentRestrictions, "", (Document)maintenanceDocument);
        this.considerBusinessObjectFieldViewAuthorization(dataObjectEntry, maintenanceDocument.getNewMaintainableObject().getDataObject(), null, user, (BusinessObjectAuthorizer)maintenanceDocumentAuthorizer, (InquiryOrMaintenanceDocumentRestrictions)maintenanceDocumentRestrictions, "");
        this.considerBusinessObjectFieldModifyAuthorization(dataObjectEntry, maintenanceDocument.getNewMaintainableObject().getDataObject(), null, user, (BusinessObjectAuthorizer)maintenanceDocumentAuthorizer, (MaintenanceDocumentRestrictions)maintenanceDocumentRestrictions, "");
        this.considerCustomButtonFieldAuthorization(dataObjectEntry, maintenanceDocument.getNewMaintainableObject().getDataObject(), null, user, (BusinessObjectAuthorizer)maintenanceDocumentAuthorizer, (MaintenanceDocumentRestrictions)maintenanceDocumentRestrictions, "");
        this.considerInquiryOrMaintenanceDocumentPresentationController((InquiryOrMaintenanceDocumentPresentationController)maintenanceDocumentPresentationController, maintenanceDocument, (InquiryOrMaintenanceDocumentRestrictions)maintenanceDocumentRestrictions);
        this.considerInquiryOrMaintenanceDocumentAuthorizer((InquiryOrMaintenanceDocumentAuthorizer)maintenanceDocumentAuthorizer, maintenanceDocument, user, (InquiryOrMaintenanceDocumentRestrictions)maintenanceDocumentRestrictions);
        this.considerMaintenanceDocumentPresentationController(maintenanceDocumentPresentationController, maintenanceDocument, (MaintenanceDocumentRestrictions)maintenanceDocumentRestrictions);
        this.considerMaintenanceDocumentAuthorizer(maintenanceDocumentAuthorizer, maintenanceDocument, user, (MaintenanceDocumentRestrictions)maintenanceDocumentRestrictions);
        MaintenanceDocumentEntry maintenanceDocumentEntry = this.getMaintenanceDocumentDictionaryService().getMaintenanceDocumentEntry(maintenanceDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintenanceDocumentEntry.getMaintainableSections()) {
            this.addMaintainableItemRestrictions(maintainableSectionDefinition.getMaintainableItems(), maintenanceDocumentAuthorizer, (MaintenanceDocumentRestrictions)maintenanceDocumentRestrictions, maintenanceDocument, (BusinessObject)maintenanceDocument.getNewMaintainableObject().getBusinessObject(), "", user);
        }
        return maintenanceDocumentRestrictions;
    }

    protected void considerBusinessObjectFieldUnmaskAuthorization(Object dataObject, Person user, BusinessObjectRestrictions businessObjectRestrictions, String propertyPrefix, Document document) {
        DataObjectEntry objectEntry = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(dataObject.getClass().getName());
        for (String attributeName : objectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = objectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getAttributeSecurity() == null) continue;
            if (attributeDefinition.getAttributeSecurity().isMask() && !this.canFullyUnmaskField(user, dataObject.getClass(), attributeName, document)) {
                businessObjectRestrictions.addFullyMaskedField(propertyPrefix + attributeName, attributeDefinition.getAttributeSecurity().getMaskFormatter());
            }
            if (!attributeDefinition.getAttributeSecurity().isPartialMask() || this.canPartiallyUnmaskField(user, dataObject.getClass(), attributeName, document)) continue;
            businessObjectRestrictions.addPartiallyMaskedField(propertyPrefix + attributeName, attributeDefinition.getAttributeSecurity().getPartialMaskFormatter());
        }
    }

    protected void considerBusinessObjectFieldViewAuthorization(DataObjectEntry dataObjectEntry, Object primaryDataObject, BusinessObject collectionItemBusinessObject, Person user, BusinessObjectAuthorizer businessObjectAuthorizer, InquiryOrMaintenanceDocumentRestrictions inquiryOrMaintenanceDocumentRestrictions, String propertyPrefix) {
        for (String attributeName : dataObjectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getAttributeSecurity() == null || !attributeDefinition.getAttributeSecurity().isHide()) continue;
            HashMap<String, String> collectionItemPermissionDetails = new HashMap<String, String>();
            HashMap collectionItemRoleQualifications = null;
            if (ObjectUtils.isNotNull((Object)collectionItemBusinessObject)) {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(collectionItemBusinessObject, attributeName));
                collectionItemPermissionDetails.putAll(businessObjectAuthorizer.getCollectionItemPermissionDetails(collectionItemBusinessObject));
                collectionItemRoleQualifications = new HashMap(businessObjectAuthorizer.getCollectionItemRoleQualifications(collectionItemBusinessObject));
            } else {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(primaryDataObject, attributeName));
            }
            if (businessObjectAuthorizer.isAuthorizedByTemplate(primaryDataObject, "KR-NS", "View Inquiry or Maintenance Document Field", user.getPrincipalId(), collectionItemPermissionDetails, collectionItemRoleQualifications)) continue;
            inquiryOrMaintenanceDocumentRestrictions.addHiddenField(propertyPrefix + attributeName);
        }
    }

    protected void considerBusinessObjectFieldModifyAuthorization(DataObjectEntry dataObjectEntry, Object primaryDataObject, BusinessObject collectionItemBusinessObject, Person user, BusinessObjectAuthorizer businessObjectAuthorizer, MaintenanceDocumentRestrictions maintenanceDocumentRestrictions, String propertyPrefix) {
        for (String attributeName : dataObjectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getAttributeSecurity() == null) continue;
            HashMap<String, String> collectionItemPermissionDetails = new HashMap<String, String>();
            HashMap collectionItemRoleQualifications = null;
            if (ObjectUtils.isNotNull((Object)collectionItemBusinessObject)) {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(collectionItemBusinessObject, attributeName));
                collectionItemPermissionDetails.putAll(businessObjectAuthorizer.getCollectionItemPermissionDetails(collectionItemBusinessObject));
                collectionItemRoleQualifications = new HashMap(businessObjectAuthorizer.getCollectionItemRoleQualifications(collectionItemBusinessObject));
            } else {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(primaryDataObject, attributeName));
            }
            if (!attributeDefinition.getAttributeSecurity().isReadOnly() || businessObjectAuthorizer.isAuthorizedByTemplate(primaryDataObject, "KR-NS", "Modify Maintenance Document Field", user.getPrincipalId(), collectionItemPermissionDetails, collectionItemRoleQualifications)) continue;
            maintenanceDocumentRestrictions.addReadOnlyField(propertyPrefix + attributeName);
        }
    }

    protected void considerCustomButtonFieldAuthorization(DataObjectEntry dataObjectEntry, Object primaryDataObject, BusinessObject collectionItemBusinessObject, Person user, BusinessObjectAuthorizer businessObjectAuthorizer, MaintenanceDocumentRestrictions maintenanceDocumentRestrictions, String propertyPrefix) {
        for (String attributeName : dataObjectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = dataObjectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getControl() == null || !attributeDefinition.getControl().isButton()) continue;
            HashMap<String, String> collectionItemPermissionDetails = new HashMap<String, String>();
            HashMap collectionItemRoleQualifications = null;
            if (ObjectUtils.isNotNull((Object)collectionItemBusinessObject)) {
                collectionItemPermissionDetails.putAll(this.getButtonFieldPermissionDetails(collectionItemBusinessObject, attributeName));
                collectionItemPermissionDetails.putAll(businessObjectAuthorizer.getCollectionItemPermissionDetails(collectionItemBusinessObject));
                collectionItemRoleQualifications = new HashMap(businessObjectAuthorizer.getCollectionItemRoleQualifications(collectionItemBusinessObject));
            } else {
                this.getButtonFieldPermissionDetails(primaryDataObject, attributeName);
            }
            if (businessObjectAuthorizer.isAuthorizedByTemplate(primaryDataObject, "KR-NS", "Perform Custom Maintenance Document Function", user.getPrincipalId(), collectionItemPermissionDetails, collectionItemRoleQualifications)) continue;
            maintenanceDocumentRestrictions.addHiddenField(propertyPrefix + attributeName);
        }
    }

    protected void considerInquiryOrMaintenanceDocumentPresentationController(InquiryOrMaintenanceDocumentPresentationController businessObjectPresentationController, Object businessObject, InquiryOrMaintenanceDocumentRestrictions inquiryOrMaintenanceDocumentRestrictions) {
        for (String attributeName : businessObjectPresentationController.getConditionallyHiddenPropertyNames(businessObject)) {
            inquiryOrMaintenanceDocumentRestrictions.addHiddenField(attributeName);
        }
        for (String sectionId : businessObjectPresentationController.getConditionallyHiddenSectionIds(businessObject)) {
            inquiryOrMaintenanceDocumentRestrictions.addHiddenSectionId(sectionId);
        }
    }

    protected void considerInquiryOrMaintenanceDocumentAuthorizer(InquiryOrMaintenanceDocumentAuthorizer authorizer, Object businessObject, Person user, InquiryOrMaintenanceDocumentRestrictions restrictions) {
        for (String sectionId : authorizer.getSecurePotentiallyHiddenSectionIds()) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("sectionId", sectionId);
            if (authorizer.isAuthorizedByTemplate(businessObject, "KR-NS", "View Inquiry or Maintenance Document Section", user.getPrincipalId(), additionalPermissionDetails, null)) continue;
            restrictions.addHiddenSectionId(sectionId);
        }
    }

    protected void considerMaintenanceDocumentPresentationController(MaintenanceDocumentPresentationController presentationController, MaintenanceDocument document, MaintenanceDocumentRestrictions restrictions) {
        for (String attributeName : presentationController.getConditionallyReadOnlyPropertyNames(document)) {
            restrictions.addReadOnlyField(attributeName);
        }
        for (String sectionId : presentationController.getConditionallyReadOnlySectionIds(document)) {
            restrictions.addReadOnlySectionId(sectionId);
        }
    }

    protected void considerMaintenanceDocumentAuthorizer(MaintenanceDocumentAuthorizer authorizer, MaintenanceDocument document, Person user, MaintenanceDocumentRestrictions restrictions) {
        for (String sectionId : authorizer.getSecurePotentiallyReadOnlySectionIds()) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("sectionId", sectionId);
            if (authorizer.isAuthorizedByTemplate((Object)document, "KR-NS", "Modify Maintenance Document Section", user.getPrincipalId(), additionalPermissionDetails, null)) continue;
            restrictions.addReadOnlySectionId(sectionId);
        }
    }

    protected void addInquirableItemRestrictions(Collection sectionDefinitions, InquiryAuthorizer authorizer, InquiryRestrictions restrictions, BusinessObject primaryBusinessObject, BusinessObject businessObject, String propertyPrefix, Person user) {
        for (Object inquirableItemDefinition : sectionDefinitions) {
            if (!(inquirableItemDefinition instanceof InquiryCollectionDefinition)) continue;
            InquiryCollectionDefinition inquiryCollectionDefinition = (InquiryCollectionDefinition)inquirableItemDefinition;
            BusinessObjectEntry collectionBusinessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(inquiryCollectionDefinition.getBusinessObjectClass().getName());
            try {
                Collection collection = (Collection)PropertyUtils.getProperty((Object)businessObject, (String)inquiryCollectionDefinition.getName());
                int i = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String newPropertyPrefix = propertyPrefix + inquiryCollectionDefinition.getName() + "[" + i + "].";
                    Object collectionItemBusinessObject = iterator.next();
                    this.considerBusinessObjectFieldUnmaskAuthorization(collectionItemBusinessObject, user, (BusinessObjectRestrictions)restrictions, newPropertyPrefix, null);
                    if (collectionItemBusinessObject instanceof BusinessObject) {
                        this.considerBusinessObjectFieldViewAuthorization((DataObjectEntry)collectionBusinessObjectEntry, primaryBusinessObject, (BusinessObject)collectionItemBusinessObject, user, (BusinessObjectAuthorizer)authorizer, (InquiryOrMaintenanceDocumentRestrictions)restrictions, newPropertyPrefix);
                        this.addInquirableItemRestrictions(inquiryCollectionDefinition.getInquiryCollections(), authorizer, restrictions, primaryBusinessObject, (BusinessObject)collectionItemBusinessObject, newPropertyPrefix, user);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to resolve collection property: " + businessObject.getClass() + ":" + inquiryCollectionDefinition.getName(), e);
            }
        }
    }

    protected void addMaintainableItemRestrictions(List<? extends MaintainableItemDefinition> itemDefinitions, MaintenanceDocumentAuthorizer authorizer, MaintenanceDocumentRestrictions restrictions, MaintenanceDocument maintenanceDocument, BusinessObject businessObject, String propertyPrefix, Person user) {
        for (MaintainableItemDefinition maintainableItemDefinition : itemDefinitions) {
            if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition)) continue;
            try {
                MaintainableCollectionDefinition maintainableCollectionDefinition = (MaintainableCollectionDefinition)maintainableItemDefinition;
                Collection collection = (Collection)ObjectUtils.getNestedValue((Object)businessObject, (String)maintainableItemDefinition.getName());
                BusinessObjectEntry collectionBusinessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(maintainableCollectionDefinition.getBusinessObjectClass().getName());
                if (!CollectionUtils.isNotEmpty((Collection)collection)) continue;
                int i = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String newPropertyPrefix = propertyPrefix + maintainableItemDefinition.getName() + "[" + i + "].";
                    BusinessObject collectionBusinessObject = (BusinessObject)iterator.next();
                    this.considerBusinessObjectFieldUnmaskAuthorization(collectionBusinessObject, user, (BusinessObjectRestrictions)restrictions, newPropertyPrefix, (Document)maintenanceDocument);
                    this.considerBusinessObjectFieldViewAuthorization((DataObjectEntry)collectionBusinessObjectEntry, maintenanceDocument, collectionBusinessObject, user, (BusinessObjectAuthorizer)authorizer, (InquiryOrMaintenanceDocumentRestrictions)restrictions, newPropertyPrefix);
                    this.considerBusinessObjectFieldModifyAuthorization((DataObjectEntry)collectionBusinessObjectEntry, maintenanceDocument, collectionBusinessObject, user, (BusinessObjectAuthorizer)authorizer, restrictions, newPropertyPrefix);
                    this.addMaintainableItemRestrictions(((MaintainableCollectionDefinition)maintainableItemDefinition).getMaintainableCollections(), authorizer, restrictions, maintenanceDocument, collectionBusinessObject, newPropertyPrefix, user);
                    this.addMaintainableItemRestrictions(((MaintainableCollectionDefinition)maintainableItemDefinition).getMaintainableFields(), authorizer, restrictions, maintenanceDocument, collectionBusinessObject, newPropertyPrefix, user);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to resolve collection property: " + businessObject.getClass() + ":" + maintainableItemDefinition.getName(), e);
            }
        }
    }

    public boolean canFullyUnmaskField(Person user, Class<?> dataObjectClass, String fieldName, Document document) {
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        if (user == null || StringUtils.isEmpty((String)user.getPrincipalId())) {
            return false;
        }
        Boolean result = null;
        if (document != null) {
            try {
                result = this.getDocumentHelperService().getDocumentAuthorizer(document).isAuthorizedByTemplate((Object)document, "KR-NS", "Full Unmask Field", user.getPrincipalId(), this.getFieldPermissionDetails(dataObjectClass, fieldName), null);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = this.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "Full Unmask Field", new HashMap<String, String>(this.getFieldPermissionDetails(dataObjectClass, fieldName)), Collections.emptyMap());
        }
        return result;
    }

    public boolean canPartiallyUnmaskField(Person user, Class<?> dataObjectClass, String fieldName, Document document) {
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        if (user == null || StringUtils.isEmpty((String)user.getPrincipalId())) {
            return false;
        }
        if (document == null) {
            return this.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "Partial Unmask Field", new HashMap<String, String>(this.getFieldPermissionDetails(dataObjectClass, fieldName)), Collections.emptyMap());
        }
        return this.getDocumentHelperService().getDocumentAuthorizer(document).isAuthorizedByTemplate((Object)document, "KR-NS", "Partial Unmask Field", user.getPrincipalId(), this.getFieldPermissionDetails(dataObjectClass, fieldName), Collections.emptyMap());
    }

    protected Map<String, String> getFieldPermissionDetails(Class<?> dataObjectClass, String attributeName) {
        try {
            return this.getFieldPermissionDetails(dataObjectClass.newInstance(), attributeName);
        }
        catch (Exception e) {
            throw new RuntimeException("The getPermissionDetails method of BusinessObjectAuthorizationServiceImpl was unable to instantiate the dataObjectClass" + dataObjectClass, e);
        }
    }

    protected Map<String, String> getFieldPermissionDetails(Object dataObject, String attributeName) {
        Map permissionDetails = null;
        Object namespaceCode = null;
        Object componentName = null;
        Object propertyName = null;
        permissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(dataObject.getClass());
        permissionDetails.put("propertyName", attributeName);
        return permissionDetails;
    }

    protected Map<String, String> getButtonFieldPermissionDetails(Object businessObject, String attributeName) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        if (attributeName.contains(".")) {
            permissionDetails.put("buttonName", attributeName);
        } else {
            permissionDetails.put("buttonName", attributeName);
        }
        return permissionDetails;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    private BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    private MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    private ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }

    private boolean isNonProductionEnvAndUnmaskingTurnedOff() {
        return !this.getKualiConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(this.getKualiConfigurationService().getPropertyValueAsString("environment")) && !this.getKualiConfigurationService().getPropertyValueAsBoolean("enable.nonproduction.data.unmasking");
    }

    protected DocumentHelperService getDocumentHelperService() {
        return KNSServiceLocator.getDocumentHelperService();
    }
}

