/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceContract;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceState;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREW_RTE_NODE_INSTN_T")
@NamedQueries(value={@NamedQuery(name="RouteNodeInstance.FindInitialNodeInstances", query="select d.initialRouteNodeInstances from DocumentRouteHeaderValue d where d.documentId = :documentId")})
public class RouteNodeInstance
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 7183670062805580420L;
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
    @PortableSequenceGenerator(name="KREW_RTE_NODE_S")
    @Column(name="RTE_NODE_INSTN_ID")
    private String routeNodeInstanceId;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="BRCH_ID")
    private Branch branch;
    @ManyToOne
    @JoinColumn(name="RTE_NODE_ID", nullable=false)
    private RouteNode routeNode;
    @Column(name="ACTV_IND")
    private boolean active = false;
    @Column(name="CMPLT_IND")
    private boolean complete = false;
    @Column(name="INIT_IND")
    private boolean initial = true;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="PROC_RTE_NODE_INSTN_ID")
    private RouteNodeInstance process;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="KREW_RTE_NODE_INSTN_LNK_T", joinColumns={@JoinColumn(name="FROM_RTE_NODE_INSTN_ID")}, inverseJoinColumns={@JoinColumn(name="TO_RTE_NODE_INSTN_ID")})
    private List<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
    @ManyToMany(mappedBy="nextNodeInstances")
    @JoinTable(name="KREW_RTE_NODE_INSTN_LNK_T", joinColumns={@JoinColumn(name="TO_RTE_NODE_INSTN_ID", updatable=false, insertable=false)}, inverseJoinColumns={@JoinColumn(name="FROM_RTE_NODE_INSTN_ID", updatable=false, insertable=false)})
    private List<RouteNodeInstance> previousNodeInstances = new ArrayList<RouteNodeInstance>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="nodeInstance", orphanRemoval=true)
    private List<NodeState> state = new ArrayList<NodeState>();
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public boolean isComplete() {
        return this._persistence_get_complete();
    }

    public void setComplete(boolean complete) {
        this._persistence_set_complete(complete);
    }

    public Branch getBranch() {
        return this._persistence_get_branch();
    }

    public void setBranch(Branch branch) {
        this._persistence_set_branch(branch);
    }

    public RouteNode getRouteNode() {
        return this._persistence_get_routeNode();
    }

    public void setRouteNode(RouteNode node) {
        this._persistence_set_routeNode(node);
    }

    public String getRouteNodeInstanceId() {
        return this._persistence_get_routeNodeInstanceId();
    }

    public void setRouteNodeInstanceId(String routeNodeInstanceId) {
        this._persistence_set_routeNodeInstanceId(routeNodeInstanceId);
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public List<RouteNodeInstance> getNextNodeInstances() {
        return this._persistence_get_nextNodeInstances();
    }

    public RouteNodeInstance getNextNodeInstance(int index) {
        while (this.getNextNodeInstances().size() <= index) {
            this._persistence_get_nextNodeInstances().add(new RouteNodeInstance());
        }
        return this.getNextNodeInstances().get(index);
    }

    public void setNextNodeInstances(List<RouteNodeInstance> nextNodeInstances) {
        this._persistence_set_nextNodeInstances(nextNodeInstances);
    }

    public List<RouteNodeInstance> getPreviousNodeInstances() {
        return this._persistence_get_previousNodeInstances();
    }

    public RouteNodeInstance getPreviousNodeInstance(int index) {
        while (this._persistence_get_previousNodeInstances().size() <= index) {
            this._persistence_get_previousNodeInstances().add(new RouteNodeInstance());
        }
        return this.getPreviousNodeInstances().get(index);
    }

    public void setPreviousNodeInstances(List<RouteNodeInstance> previousNodeInstances) {
        this._persistence_set_previousNodeInstances(previousNodeInstances);
    }

    public boolean isInitial() {
        return this._persistence_get_initial();
    }

    public void setInitial(boolean initial) {
        this._persistence_set_initial(initial);
    }

    public List<NodeState> getState() {
        return this._persistence_get_state();
    }

    public void setState(List<NodeState> state) {
        this._persistence_get_state().clear();
        this._persistence_get_state().addAll(state);
    }

    public RouteNodeInstance getProcess() {
        return this._persistence_get_process();
    }

    public void setProcess(RouteNodeInstance process) {
        this._persistence_set_process(process);
    }

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    public String getRouteNodeId() {
        if (this.getRouteNode() == null) {
            return null;
        }
        return this.getRouteNode().getRouteNodeId();
    }

    public NodeState getNodeState(String key) {
        for (NodeState nodeState : this.getState()) {
            if (!nodeState.getKey().equals(key)) continue;
            return nodeState;
        }
        return null;
    }

    public void addNodeState(NodeState state) {
        this._persistence_get_state().add(state);
        state.setNodeInstance(this);
    }

    public void removeNodeState(String key) {
        Iterator<NodeState> iter = this.getState().iterator();
        while (iter.hasNext()) {
            NodeState nodeState = iter.next();
            if (!nodeState.getKey().equals(key)) continue;
            iter.remove();
            break;
        }
    }

    public void addNextNodeInstance(RouteNodeInstance nextNodeInstance) {
        this._persistence_get_nextNodeInstances().add(nextNodeInstance);
        nextNodeInstance.getPreviousNodeInstances().add(this);
    }

    public void removeNextNodeInstance(RouteNodeInstance nextNodeInstance) {
        this._persistence_get_nextNodeInstances().remove(nextNodeInstance);
        nextNodeInstance.getPreviousNodeInstances().remove(this);
    }

    public void clearNextNodeInstances() {
        Iterator iterator = this._persistence_get_nextNodeInstances().iterator();
        while (iterator.hasNext()) {
            RouteNodeInstance nextNodeInstance = (RouteNodeInstance)iterator.next();
            iterator.remove();
            nextNodeInstance.getPreviousNodeInstances().remove(this);
        }
    }

    public String getName() {
        return this.getRouteNode() == null ? null : this.getRouteNode().getRouteNodeName();
    }

    public boolean isInProcess() {
        return this.getProcess() != null;
    }

    public DocumentType getDocumentType() {
        return KEWServiceLocator.getDocumentTypeService().findByDocumentId(this.getDocumentId());
    }

    public NodeState getNodeStateByIndex(int index) {
        while (this._persistence_get_state().size() <= index) {
            this._persistence_get_state().add(new NodeState());
        }
        return this.getState().get(index);
    }

    public void populateState(List<NodeState> state) {
        this._persistence_get_state().addAll(state);
    }

    public RouteNodeInstance deepCopy(Map<Object, Object> visited) {
        ArrayList<PersistenceWeaved> copies;
        if (visited.containsKey(this)) {
            return (RouteNodeInstance)visited.get(this);
        }
        RouteNodeInstance copy = new RouteNodeInstance();
        visited.put(this, copy);
        copy._persistence_set_routeNodeInstanceId(this._persistence_get_routeNodeInstanceId());
        copy._persistence_set_documentId(this._persistence_get_documentId());
        copy._persistence_set_active(this._persistence_get_active());
        copy._persistence_set_complete(this._persistence_get_complete());
        copy._persistence_set_initial(this._persistence_get_initial());
        copy._persistence_set_lockVerNbr(this._persistence_get_lockVerNbr());
        copy._persistence_set_routeNode(this._persistence_get_routeNode());
        if (this._persistence_get_branch() != null) {
            copy._persistence_set_branch(this._persistence_get_branch().deepCopy(visited));
        }
        if (this._persistence_get_process() != null) {
            copy._persistence_set_process(this._persistence_get_process().deepCopy(visited));
        }
        if (this._persistence_get_nextNodeInstances() != null) {
            copies = new ArrayList<PersistenceWeaved>();
            for (RouteNodeInstance nextNodeInstance : this._persistence_get_nextNodeInstances()) {
                copies.add(nextNodeInstance.deepCopy(visited));
            }
            copy._persistence_set_nextNodeInstances(copies);
        }
        if (this._persistence_get_previousNodeInstances() != null) {
            copies = new ArrayList();
            for (RouteNodeInstance previousNodeInstance : this._persistence_get_previousNodeInstances()) {
                copies.add(previousNodeInstance.deepCopy(visited));
            }
            copy._persistence_set_previousNodeInstances(copies);
        }
        if (this._persistence_get_state() != null) {
            copies = new ArrayList();
            for (NodeState aState : this._persistence_get_state()) {
                copies.add(aState.deepCopy(visited));
            }
            copy._persistence_set_state(copies);
        }
        return copy;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("routeNodeInstanceId", (Object)this._persistence_get_routeNodeInstanceId()).append("documentId", (Object)this._persistence_get_documentId()).append("branch", this._persistence_get_branch() == null ? null : this._persistence_get_branch().getBranchId()).append("routeNode", this._persistence_get_routeNode() == null ? null : this._persistence_get_routeNode().getRouteNodeName() + " " + this._persistence_get_routeNode().getRouteNodeId()).append("active", this._persistence_get_active()).append("complete", this._persistence_get_complete()).append("initial", this._persistence_get_initial()).append("process", (Object)this._persistence_get_process()).append("state", this._persistence_get_state() == null ? null : Integer.valueOf(this._persistence_get_state().size())).toString();
    }

    public static org.kuali.rice.kew.api.document.node.RouteNodeInstance to(RouteNodeInstance routeNodeInstance) {
        if (routeNodeInstance == null) {
            return null;
        }
        RouteNodeInstance.Builder builder = RouteNodeInstance.Builder.create();
        builder.setActive(routeNodeInstance.isActive());
        builder.setBranchId(routeNodeInstance.getBranch().getBranchId());
        builder.setComplete(routeNodeInstance.isComplete());
        builder.setDocumentId(routeNodeInstance.getDocumentId());
        builder.setId(routeNodeInstance.getRouteNodeInstanceId());
        builder.setInitial(routeNodeInstance.isInitial());
        builder.setName(routeNodeInstance.getName());
        if (routeNodeInstance.getProcess() != null) {
            builder.setProcessId(routeNodeInstance.getProcess().getRouteNodeInstanceId());
        }
        builder.setRouteNodeId(routeNodeInstance.getRouteNode().getRouteNodeId());
        ArrayList<RouteNodeInstanceState.Builder> states = new ArrayList<RouteNodeInstanceState.Builder>();
        for (NodeState stateBo : routeNodeInstance.getState()) {
            RouteNodeInstanceState.Builder stateBuilder = RouteNodeInstanceState.Builder.create();
            stateBuilder.setId(stateBo.getStateId());
            stateBuilder.setKey(stateBo.getKey());
            stateBuilder.setValue(stateBo.getValue());
            states.add(stateBuilder);
        }
        builder.setState(states);
        ArrayList<RouteNodeInstance.Builder> nextNodes = new ArrayList<RouteNodeInstance.Builder>();
        if (routeNodeInstance.getNextNodeInstances() != null) {
            for (RouteNodeInstance next : routeNodeInstance.getNextNodeInstances()) {
                if (next == null) continue;
                nextNodes.add(RouteNodeInstance.Builder.create((RouteNodeInstanceContract)RouteNodeInstance.to(next)));
            }
        }
        builder.setNextNodeInstances(nextNodes);
        return builder.build();
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RouteNodeInstance();
    }

    public Object _persistence_get(String string) {
        if (string == "process") {
            return this.process;
        }
        if (string == "routeNode") {
            return this.routeNode;
        }
        if (string == "nextNodeInstances") {
            return this.nextNodeInstances;
        }
        if (string == "complete") {
            return this.complete;
        }
        if (string == "routeNodeInstanceId") {
            return this.routeNodeInstanceId;
        }
        if (string == "initial") {
            return this.initial;
        }
        if (string == "state") {
            return this.state;
        }
        if (string == "previousNodeInstances") {
            return this.previousNodeInstances;
        }
        if (string == "branch") {
            return this.branch;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "process") {
            this.process = (RouteNodeInstance)object;
            return;
        }
        if (string == "routeNode") {
            this.routeNode = (RouteNode)object;
            return;
        }
        if (string == "nextNodeInstances") {
            this.nextNodeInstances = (List)object;
            return;
        }
        if (string == "complete") {
            this.complete = (Boolean)object;
            return;
        }
        if (string == "routeNodeInstanceId") {
            this.routeNodeInstanceId = (String)object;
            return;
        }
        if (string == "initial") {
            this.initial = (Boolean)object;
            return;
        }
        if (string == "state") {
            this.state = (List)object;
            return;
        }
        if (string == "previousNodeInstances") {
            this.previousNodeInstances = (List)object;
            return;
        }
        if (string == "branch") {
            this.branch = (Branch)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
    }

    public RouteNodeInstance _persistence_get_process() {
        this._persistence_checkFetched("process");
        return this.process;
    }

    public void _persistence_set_process(RouteNodeInstance routeNodeInstance) {
        this._persistence_checkFetchedForSet("process");
        this._persistence_propertyChange("process", this.process, routeNodeInstance);
        this.process = routeNodeInstance;
    }

    public RouteNode _persistence_get_routeNode() {
        this._persistence_checkFetched("routeNode");
        return this.routeNode;
    }

    public void _persistence_set_routeNode(RouteNode routeNode) {
        this._persistence_checkFetchedForSet("routeNode");
        this._persistence_propertyChange("routeNode", this.routeNode, routeNode);
        this.routeNode = routeNode;
    }

    public List _persistence_get_nextNodeInstances() {
        this._persistence_checkFetched("nextNodeInstances");
        return this.nextNodeInstances;
    }

    public void _persistence_set_nextNodeInstances(List list) {
        this._persistence_checkFetchedForSet("nextNodeInstances");
        this._persistence_propertyChange("nextNodeInstances", this.nextNodeInstances, list);
        this.nextNodeInstances = list;
    }

    public boolean _persistence_get_complete() {
        this._persistence_checkFetched("complete");
        return this.complete;
    }

    public void _persistence_set_complete(boolean bl) {
        this._persistence_checkFetchedForSet("complete");
        this._persistence_propertyChange("complete", new Boolean(this.complete), new Boolean(bl));
        this.complete = bl;
    }

    public String _persistence_get_routeNodeInstanceId() {
        this._persistence_checkFetched("routeNodeInstanceId");
        return this.routeNodeInstanceId;
    }

    public void _persistence_set_routeNodeInstanceId(String string) {
        this._persistence_checkFetchedForSet("routeNodeInstanceId");
        this._persistence_propertyChange("routeNodeInstanceId", this.routeNodeInstanceId, string);
        this.routeNodeInstanceId = string;
    }

    public boolean _persistence_get_initial() {
        this._persistence_checkFetched("initial");
        return this.initial;
    }

    public void _persistence_set_initial(boolean bl) {
        this._persistence_checkFetchedForSet("initial");
        this._persistence_propertyChange("initial", new Boolean(this.initial), new Boolean(bl));
        this.initial = bl;
    }

    public List _persistence_get_state() {
        this._persistence_checkFetched("state");
        return this.state;
    }

    public void _persistence_set_state(List list) {
        this._persistence_checkFetchedForSet("state");
        this._persistence_propertyChange("state", this.state, list);
        this.state = list;
    }

    public List _persistence_get_previousNodeInstances() {
        this._persistence_checkFetched("previousNodeInstances");
        return this.previousNodeInstances;
    }

    public void _persistence_set_previousNodeInstances(List list) {
        this._persistence_checkFetchedForSet("previousNodeInstances");
        this._persistence_propertyChange("previousNodeInstances", this.previousNodeInstances, list);
        this.previousNodeInstances = list;
    }

    public Branch _persistence_get_branch() {
        this._persistence_checkFetched("branch");
        return this.branch;
    }

    public void _persistence_set_branch(Branch branch) {
        this._persistence_checkFetchedForSet("branch");
        this._persistence_propertyChange("branch", this.branch, branch);
        this.branch = branch;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this._persistence_propertyChange("lockVerNbr", this.lockVerNbr, n);
        this.lockVerNbr = n;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this._persistence_propertyChange("documentId", this.documentId, string);
        this.documentId = string;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

