/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notification.service.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.actionitem.ActionItemComparator;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.notification.service.NotificationService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class DefaultNotificationService
implements NotificationService {
    protected final Logger LOG = Logger.getLogger(this.getClass());
    private static final Comparator notificationPriorityComparator = ComparatorUtils.reversedComparator((Comparator)new ActionItemComparator());

    @Override
    public void notify(List<ActionItem> actionItems) {
        Collections.sort(actionItems, notificationPriorityComparator);
        HashSet<String> sentNotifications = new HashSet<String>();
        for (ActionItem actionItem : actionItems) {
            if (sentNotifications.contains(actionItem.getPrincipalId()) || !this.shouldNotify(actionItem)) continue;
            sentNotifications.add(actionItem.getPrincipalId());
            this.sendNotification(actionItem);
        }
    }

    protected void sendNotification(ActionItem actionItem) {
        ImmediateEmailReminderQueue immediateEmailQueue = KewApiServiceLocator.getImmediateEmailReminderQueue();
        immediateEmailQueue.sendReminder(actionItem, Boolean.valueOf(RouteContext.getCurrentRouteContext().isDoNotSendApproveNotificationEmails()));
    }

    protected boolean shouldNotify(ActionItem actionItem) {
        try {
            boolean sendEmail = true;
            if (sendEmail && this.isItemOriginatingFromSave(actionItem) && !this.shouldNotifyOnSave(actionItem)) {
                sendEmail = false;
            }
            return sendEmail;
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException("Error loading user with workflow id " + actionItem.getPrincipalId() + " for notification.", (Throwable)e);
        }
    }

    protected boolean isItemOriginatingFromSave(ActionItem actionItem) {
        return actionItem.getResponsibilityId() != null && actionItem.getResponsibilityId().equals("-3");
    }

    protected boolean shouldNotifyOnSave(ActionItem actionItem) {
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(actionItem.getDocumentId());
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findById(document.getDocumentTypeId());
        return documentType.getNotifyOnSavePolicy().getPolicyValue();
    }

    @Override
    public void removeNotification(List<ActionItem> actionItems) {
    }
}

