/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.util.ContextClassLoaderBinder;
import org.kuali.rice.core.impl.resourceloader.BaseWrappingResourceLoader;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.plugin.PluginListener;

public class Plugin
extends BaseWrappingResourceLoader {
    private static final Logger LOG = Logger.getLogger(Plugin.class);
    private Config config;
    private List<PluginListener> pluginListeners = new ArrayList<PluginListener>();
    private boolean suppressStartupFailure = true;
    private boolean started = false;
    private boolean startupFailure = false;

    public Plugin(QName name, Config config, ClassLoader classLoader) {
        super(name, classLoader);
        this.config = config;
    }

    public synchronized void start() {
        block5: {
            if (this.started) {
                LOG.info((Object)(this.getLogPrefix() + " has already been started."));
                return;
            }
            LOG.info((Object)(this.getLogPrefix() + " Starting..."));
            try {
                ContextClassLoaderBinder.doInContextClassLoader((ClassLoader)this.getClassLoader(), (Callable)new Callable(){

                    public Object call() throws Exception {
                        Plugin.this.startupFailure = false;
                        Plugin.this.started = true;
                        Plugin.super.start();
                        LOG.info((Object)"Starting plugin listeners");
                        Plugin.this.startPluginListeners();
                        return null;
                    }
                });
                ClassLoader classLoader = this.getClassLoader();
                LOG.info((Object)(this.getLogPrefix() + " ...started." + (classLoader != null ? classLoader.toString() : "")));
            }
            catch (Throwable t) {
                LOG.error((Object)(this.getLogPrefix() + " Failure starting plugin."), t);
                this.startupFailure = true;
                this.started = true;
                this.stop();
                if (this.suppressStartupFailure) break block5;
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new WorkflowRuntimeException("Failed to startup plugin.", t);
            }
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            LOG.info((Object)(this.getLogPrefix() + " has already been stopped."));
            return;
        }
        LOG.info((Object)(this.getLogPrefix() + " Stopping..."));
        try {
            ContextClassLoaderBinder.doInContextClassLoader((ClassLoader)this.getClassLoader(), (Callable)new Callable(){

                public Object call() throws Exception {
                    Plugin.this.started = false;
                    Plugin.this.stopPluginListeners();
                    Plugin.super.stop();
                    return null;
                }
            });
        }
        catch (Throwable t) {
            LOG.error((Object)(this.getLogPrefix() + " Failed when attempting to stop the plugin."), t);
        }
        this.resetPlugin();
        LOG.info((Object)(this.getLogPrefix() + " ...stopped."));
    }

    public boolean isStarted() {
        return this.started;
    }

    public void addPluginListener(PluginListener pluginListener) {
        this.pluginListeners.add(pluginListener);
    }

    public void removePluginListener(PluginListener pluginListener) {
        this.pluginListeners.remove(pluginListener);
    }

    protected void startPluginListeners() {
        for (PluginListener listener : this.pluginListeners) {
            listener.pluginInitialized(this);
        }
    }

    protected void stopPluginListeners() {
        for (PluginListener listener : this.pluginListeners) {
            try {
                listener.pluginDestroyed(this);
            }
            catch (Throwable t) {
                LOG.error((Object)(this.getLogPrefix() + " Failed when invoking pluginDestroyed on Plugin Listener '" + listener.getClass().getName() + "'."), t);
            }
        }
    }

    public boolean isSuppressStartupFailure() {
        return this.suppressStartupFailure;
    }

    public void setSuppressStartupFailure(boolean suppressStartupFailure) {
        this.suppressStartupFailure = suppressStartupFailure;
    }

    private void resetPlugin() {
        if (!this.startupFailure) {
            this.setClassLoader(null);
        }
        this.pluginListeners.clear();
    }

    private String getLogPrefix() {
        return this.toString();
    }

    public Config getConfig() {
        return this.config;
    }

    public String toString() {
        return "[Plugin: " + this.getName() + "]";
    }
}

