/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.kuali.rice.kew.plugin.PluginConfig;
import org.kuali.rice.kew.plugin.PluginUtils;

public class PluginClassLoader
extends URLClassLoader
implements Lifecycle {
    static final String CLASSES_DIR = "classes";
    static final String LIB_DIR = "lib";
    private static final String[] SYSTEM_CLASSES = new String[]{"java.", "javax.servlet.", "javax.xml.", "javax.management.", "org.xml.", "org.w3c."};
    private PluginConfig config;
    private boolean started = false;

    public PluginClassLoader() {
        super(new URL[0]);
    }

    public PluginClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public PluginClassLoader(ClassLoader parent, File sharedDirectory, File pluginDirectory) throws MalformedURLException {
        super(new URL[0], parent);
        if (sharedDirectory != null) {
            this.addClassesDirectory(new File(sharedDirectory, CLASSES_DIR));
            this.addLibDirectory(new File(sharedDirectory, LIB_DIR));
        }
        this.addClassesDirectory(new File(pluginDirectory, CLASSES_DIR));
        this.addLibDirectory(new File(pluginDirectory, LIB_DIR));
    }

    public void addClassesDirectory(File classesDir) throws MalformedURLException {
        if (classesDir != null && classesDir.isDirectory()) {
            this.addURL(classesDir.toURI().toURL());
        }
    }

    public void addLibDirectory(File libDir) throws MalformedURLException {
        File[] jars = PluginUtils.findJars(libDir);
        for (int index = 0; index < jars.length; ++index) {
            this.addURL(jars[index].toURI().toURL());
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class loadedClass = this.loadExistingClass(name, resolve);
        if (loadedClass != null) {
            return loadedClass;
        }
        loadedClass = this.loadSystemClass(name, resolve);
        if (loadedClass != null) {
            return loadedClass;
        }
        loadedClass = this.loadLocalClass(name, resolve);
        if (loadedClass != null) {
            return loadedClass;
        }
        loadedClass = this.loadParentClass(name, resolve);
        if (loadedClass != null) {
            return loadedClass;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (resource == null) {
            resource = this.getParent().getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> localResources = this.findResources(name);
        Enumeration<URL> parentResources = this.getParent().getResources(name);
        return CollectionUtils.concat((Enumeration[])new Enumeration[]{localResources, parentResources});
    }

    private Class loadExistingClass(String name, boolean resolve) {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null && resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    private Class loadSystemClass(String name, boolean resolve) {
        Class<?> loadedClass = null;
        if (this.isSystemClass(name)) {
            try {
                loadedClass = PluginClassLoader.getSystemClassLoader().loadClass(name);
                if (loadedClass != null && resolve) {
                    this.resolveClass(loadedClass);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return loadedClass;
    }

    private Class loadLocalClass(String name, boolean resolve) {
        Class<?> loadedClass = null;
        try {
            loadedClass = this.findClass(name);
            if (loadedClass != null && resolve) {
                this.resolveClass(loadedClass);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return loadedClass;
    }

    private Class loadParentClass(String name, boolean resolve) {
        Class<?> loadedClass = null;
        try {
            loadedClass = this.getParent().loadClass(name);
            if (loadedClass != null && resolve) {
                this.resolveClass(loadedClass);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return loadedClass;
    }

    private boolean isSystemClass(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        for (int index = 0; index < SYSTEM_CLASSES.length; ++index) {
            String systemClass = SYSTEM_CLASSES[index];
            if (!(systemClass.endsWith(".") ? name.startsWith(systemClass) : name.equals(systemClass))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[PluginClassLoader: urls=");
        URL[] urls = this.getURLs();
        if (urls == null) {
            sb.append("null");
        } else {
            for (int i = 0; i < urls.length; ++i) {
                sb.append(urls[i]);
                sb.append(",");
            }
            if (urls.length > 1) {
                sb.setLength(sb.length() - 1);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    public void setConfig(PluginConfig config) {
        this.config = config;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.config = null;
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }
}

