/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routing.web;

import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.routing.web.DocHandlerForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ClientAppDocHandlerRedirectAction
extends KewKualiAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DocHandlerForm docHandlerForm = (DocHandlerForm)form;
        String docHandler = null;
        if (request.getParameter("docId") != null) {
            RouteHeaderService rhSrv = (RouteHeaderService)KEWServiceLocator.getService("enDocumentRouteHeaderService");
            DocumentRouteHeaderValue routeHeader = rhSrv.getRouteHeader(docHandlerForm.getDocId());
            if (!KEWServiceLocator.getDocumentSecurityService().routeLogAuthorized(GlobalVariables.getUserSession().getPrincipalId(), routeHeader, new SecuritySession(GlobalVariables.getUserSession().getPrincipalId()))) {
                return mapping.findForward("NotAuthorized");
            }
            docHandler = routeHeader.getDocumentType().getResolvedDocumentHandlerUrl();
            if (StringUtils.isBlank((String)docHandler)) {
                throw new WorkflowRuntimeException("Document Type '" + routeHeader.getDocumentType().getName() + "' does not have a document handler url set (attempted to open document handler url for document id " + routeHeader.getDocumentId() + ")");
            }
            docHandler = !docHandler.contains("?") ? docHandler + "?" : docHandler + "&";
            docHandler = docHandler + "docId=" + docHandlerForm.getDocId();
            if (StringUtils.isNotBlank((String)routeHeader.getAppDocId())) {
                docHandler = docHandler + "&appDocId=" + URLEncoder.encode(routeHeader.getAppDocId(), "UTF-8");
            }
        } else if (request.getParameter("docTypeName") != null) {
            DocumentTypeService documentTypeService = (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
            DocumentType documentType = documentTypeService.findByName(docHandlerForm.getDocTypeName());
            docHandler = documentType.getResolvedDocumentHandlerUrl();
            if (StringUtils.isBlank((String)docHandler)) {
                throw new WorkflowRuntimeException("Cannot find document handler url for document type '" + documentType.getName() + "'");
            }
            docHandler = !docHandler.contains("?") ? docHandler + "?" : docHandler + "&";
            docHandler = docHandler + "docTypeName=" + docHandlerForm.getDocTypeName();
        } else {
            throw new RuntimeException("Cannot determine document handler");
        }
        docHandler = docHandler + "&command=" + docHandlerForm.getCommand();
        if (ClientAppDocHandlerRedirectAction.getUserSession(request).isBackdoorInUse()) {
            docHandler = docHandler + "&backdoorId=" + ClientAppDocHandlerRedirectAction.getUserSession(request).getPrincipalName();
        }
        return new ActionForward(docHandler, true);
    }

    public static UserSession getUserSession(HttpServletRequest request) {
        return GlobalVariables.getUserSession();
    }
}

