/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.CollectionFormatter;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupQueryResults;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalQueryResults;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.type.KimTypeLookupableHelperServiceImpl;
import org.kuali.rice.kim.lookup.KimLookupableHelperServiceImpl;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceHelper;
import org.kuali.rice.kns.kim.type.KimAttributeDefinition;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.comparator.CellComparatorHelper;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.keyvalues.IndicatorValuesFinder;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class GroupLookupableHelperServiceImpl
extends KimLookupableHelperServiceImpl {
    private static final String KIM_TYPE_ID_PROPERTY_NAME = "kimTypeId";
    private List<Row> grpRows = new ArrayList<Row>();
    private List<Row> attrRows = new ArrayList<Row>();
    private String typeId = "";
    private List<KimAttributeField> attrDefinitions;
    private final Map<String, String> groupTypeValuesCache = new HashMap<String, String>();

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        GroupBo groupImpl = (GroupBo)bo;
        ArrayList<HtmlData> anchorHtmlDataList = new ArrayList<HtmlData>();
        if (this.allowsNewOrCopyAction("IdentityManagementGroupDocument")) {
            anchorHtmlDataList.add(this.getEditGroupUrl(groupImpl));
        }
        return anchorHtmlDataList;
    }

    protected HtmlData getEditGroupUrl(GroupBo groupBo) {
        String href = "";
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "IdentityManagementGroupDocument");
        parameters.put("id", groupBo.getId());
        if (StringUtils.isNotBlank((String)this.getReturnLocation())) {
            parameters.put("returnLocation", this.getReturnLocation());
        }
        href = UrlFactory.parameterizeUrl((String)(KimCommonUtilsInternal.getKimBasePath() + "identityManagementGroupDocument.do"), (Properties)parameters);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "docHandler", "edit");
        return anchorHtmlData;
    }

    public List<GroupBo> getSearchResults(Map<String, String> fieldValues) {
        HashMap<String, String> criteriaMap = new HashMap<String, String>(fieldValues);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteriaMap.remove("docFormKey");
        criteriaMap.remove("backLocation");
        criteriaMap.remove("docNum");
        String refToRef = (String)criteriaMap.get("referencesToRefresh");
        if (StringUtils.isNotBlank((String)refToRef) && refToRef.equalsIgnoreCase("GroupBo")) {
            criteriaMap.remove("referencesToRefresh");
        }
        boolean validPrncplFoundIfPrncplCritPresent = true;
        HashMap attribsMap = new HashMap();
        if (!criteriaMap.isEmpty()) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((String)((String)criteriaMap.get("principalName")))) {
                QueryByCriteria.Builder principalCriteria = QueryByCriteria.Builder.create();
                Predicate principalPred = PredicateFactory.like((String)"principalName", (CharSequence)((CharSequence)criteriaMap.get("principalName")));
                principalCriteria.setPredicates(new Predicate[]{principalPred});
                PrincipalQueryResults principals = KimApiServiceLocator.getIdentityService().findPrincipals(principalCriteria.build());
                ArrayList<String> principalIds = new ArrayList<String>();
                for (Principal principal : principals.getResults()) {
                    principalIds.add(principal.getPrincipalId());
                }
                if (CollectionUtils.isNotEmpty(principalIds)) {
                    Timestamp currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
                    predicates.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.in((String)"members.memberId", (Object[])principalIds.toArray(new String[principalIds.size()])), PredicateFactory.equal((String)"members.typeCode", (Object)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()), PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"members.activeFromDateValue"), PredicateFactory.lessThanOrEqual((String)"members.activeFromDateValue", (Object)currentTime)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"members.activeToDateValue"), PredicateFactory.greaterThan((String)"members.activeToDateValue", (Object)currentTime)})})}));
                } else {
                    validPrncplFoundIfPrncplCritPresent = false;
                }
            }
            criteriaMap.remove("principalName");
            HashMap<String, String> criteriaCopy = new HashMap<String, String>();
            criteriaCopy.putAll(criteriaMap);
            for (String key : criteriaCopy.keySet()) {
                if (!this.isParamAttribute(key)) continue;
                if (StringUtils.isNotBlank((String)((String)criteriaMap.get(key)))) {
                    String attributeName = StringUtils.substringBetween((String)key, (String)"attributes(", (String)")");
                    attribsMap.put(attributeName, criteriaMap.get(key));
                }
                criteriaMap.remove(key);
            }
            predicates.add(PredicateUtils.convertMapToPredicate(criteriaMap));
            criteria.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[predicates.size()]))});
        }
        List groups = new ArrayList();
        if (validPrncplFoundIfPrncplCritPresent) {
            GroupQueryResults groupResults = KimApiServiceLocator.getGroupService().findGroups(criteria.build());
            groups = groupResults.getResults();
        }
        HashMap<String, GroupBo> groupBos = new HashMap<String, GroupBo>(groups.size());
        for (Group group : groups) {
            if (attribsMap.isEmpty()) {
                if (groupBos.get(group.getId()) != null) continue;
                groupBos.put(group.getId(), GroupBo.from((Group)group));
                continue;
            }
            boolean containsAllAttribs = true;
            for (String attribute : attribsMap.keySet()) {
                containsAllAttribs &= group.getAttributes().containsKey(attribute) && ((String)group.getAttributes().get(attribute)).equalsIgnoreCase((String)attribsMap.get(attribute));
            }
            if (!containsAllAttribs || groupBos.get(group.getId()) != null) continue;
            groupBos.put(group.getId(), GroupBo.from((Group)group));
        }
        return new ArrayList<GroupBo>(groupBos.values());
    }

    private boolean isParamAttribute(String param) {
        return param.matches("attributes\\((.*?)\\)") && StringUtils.isNotBlank((String)StringUtils.substringBetween((String)param, (String)"attributes(", (String)")")) && StringUtils.substringBetween((String)param, (String)"attributes(", (String)")") != "null";
    }

    public boolean checkForAdditionalFields(Map<String, String> fieldValues) {
        List<Row> attributeRows = this.setupAttributeRows(fieldValues);
        if (attributeRows.isEmpty()) {
            this.setAttrRows(attributeRows);
        } else if (CollectionUtils.isEmpty(this.getAttrRows())) {
            this.setAttrRows(attributeRows);
        }
        return this.getAttrRows().size() > 0;
    }

    public List<Row> getRows() {
        if (this.getGrpRows().isEmpty()) {
            ArrayList<Field> fields;
            List rows = super.getRows();
            ArrayList<Row> returnRows = new ArrayList<Row>();
            for (Row row : rows) {
                for (int i = row.getFields().size() - 1; i >= 0; --i) {
                    Field field = (Field)row.getFields().get(i);
                    if (!field.getPropertyName().equals(KIM_TYPE_ID_PROPERTY_NAME)) continue;
                    Field typeField = new Field();
                    typeField.setFieldLabel("Type");
                    typeField.setPropertyName(KIM_TYPE_ID_PROPERTY_NAME);
                    typeField.setFieldValidValues(this.getGroupTypeOptions());
                    typeField.setFieldType("dropdown");
                    row.getFields().set(i, typeField);
                }
                returnRows.add(row);
            }
            Field typeField = new Field();
            typeField.setFieldLabel("Principal Name");
            typeField.setPropertyName("principalName");
            typeField.setFieldType("text");
            typeField.setMaxLength(40);
            typeField.setSize(20);
            typeField.setQuickFinderClassNameImpl("org.kuali.rice.kim.api.identity.Person");
            typeField.setFieldConversions("principalName:principalName");
            typeField.setLookupParameters("principalName:principalName");
            List<Object> list = fields = returnRows.isEmpty() ? new ArrayList<Field>() : ((Row)returnRows.get(returnRows.size() - 1)).getFields();
            if (!fields.isEmpty() && ((Field)fields.get(fields.size() - 1)).getFieldType().equals("blankSpace")) {
                int insertLoc;
                for (insertLoc = fields.size() - 1; insertLoc >= 0 && ((Field)fields.get(insertLoc)).getFieldType().equals("blankSpace"); --insertLoc) {
                }
                fields.set(insertLoc + 1, typeField);
                ((Row)returnRows.get(returnRows.size() - 1)).setFields(fields);
            } else {
                int fieldLen = fields.size();
                fields = new ArrayList();
                fields.add(typeField);
                for (int i = 1; i < fieldLen; ++i) {
                    Field blankSpace = new Field();
                    blankSpace.setFieldType("blankSpace");
                    blankSpace.setPropertyName("blankSpace");
                    fields.add(blankSpace);
                }
                returnRows.add(new Row(fields));
            }
            this.setGrpRows(returnRows);
        }
        if (this.getAttrRows().isEmpty()) {
            this.setAttrDefinitions(Collections.emptyList());
            return this.getGrpRows();
        }
        ArrayList<Row> fullRows = new ArrayList<Row>();
        fullRows.addAll(this.getGrpRows());
        fullRows.addAll(this.getAttrRows());
        return fullRows;
    }

    public List<Column> getColumns() {
        List columns = super.getColumns();
        for (Row row : this.attrRows) {
            for (Field field : row.getFields()) {
                Column newColumn = new Column();
                newColumn.setColumnTitle(field.getFieldLabel());
                newColumn.setMaxLength(this.getColumnMaxLength(field.getPropertyName()));
                newColumn.setPropertyName(field.getPropertyName());
                newColumn.setFormatter(field.getFormatter());
                columns.add(newColumn);
            }
        }
        return columns;
    }

    public Collection<GroupBo> performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        List displayList = bounded ? this.getSearchResults(lookupForm.getFieldsForLookup()) : this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        HashMap<String, Class> propertyTypes = new HashMap<String, Class>();
        boolean hasReturnableRow = false;
        List returnKeys = this.getReturnKeys();
        List pkNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : displayList) {
            if (element instanceof PersistableBusinessObject) {
                lookupForm.setLookupObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            HtmlData returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions);
            String actionUrls = this.getActionUrls(element, pkNames, businessObjectRestrictions);
            if ("".equals(actionUrls)) {
                actionUrls = "&nbsp;";
            }
            List<Column> columns = this.getColumns();
            Iterator<Column> i$ = columns.iterator();
            while (i$.hasNext()) {
                Class propClass;
                Column element2;
                Column col = element2 = i$.next();
                Formatter formatter = col.getFormatter();
                String propValue = "";
                String prop = null;
                if (col.getPropertyName().matches("\\w+\\.\\d+$")) {
                    String id = col.getPropertyName().substring(col.getPropertyName().lastIndexOf(46) + 1);
                    prop = ((GroupBo)element).getGroupAttributeValueById(id);
                }
                if (prop == null) {
                    prop = (String)KradDataServiceLocator.getDataObjectService().wrap((Object)element).getPropertyValueNullSafe(this.findAndConvertAttributeNamesToMappableProperty(col.getPropertyName()));
                }
                if ((propClass = (Class)propertyTypes.get(col.getPropertyName())) == null) {
                    try {
                        propClass = KRADServiceLocatorWeb.getLegacyDataAdapter().getPropertyType((Object)element, col.getPropertyName());
                        propertyTypes.put(col.getPropertyName(), propClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot access PropertyType for property '" + col.getPropertyName() + "' " + " on an instance of '" + element.getClass().getName() + "'.", e);
                    }
                }
                if (prop != null) {
                    if (prop instanceof Boolean) {
                        formatter = new BooleanFormatter();
                    }
                    if (prop instanceof Date) {
                        formatter = new DateFormatter();
                    }
                    if (prop instanceof Collection && formatter == null) {
                        formatter = new CollectionFormatter();
                    }
                    if (formatter != null) {
                        propValue = (String)formatter.format((Object)prop);
                    } else {
                        propValue = prop.toString();
                        if (col.getPropertyName().equals(KIM_TYPE_ID_PROPERTY_NAME)) {
                            propValue = this.groupTypeValuesCache.get(prop.toString());
                        }
                    }
                }
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element.getClass(), col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (!StringUtils.isNotBlank((String)propValue)) continue;
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
            ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), actionUrls);
            row.setRowId(returnUrl.getName());
            row.setReturnUrlHtmlData(returnUrl);
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            if (element instanceof PersistableBusinessObject) {
                row.setObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    private List<KeyValue> getGroupTypeOptions() {
        ArrayList<KeyValue> options = new ArrayList<KeyValue>();
        options.add((KeyValue)new ConcreteKeyValue("", ""));
        Collection kimGroupTypes = KimApiServiceLocator.getKimTypeInfoService().findAllKimTypes();
        for (KimType kimType : kimGroupTypes) {
            if (!KimTypeLookupableHelperServiceImpl.hasGroupTypeService(kimType) || this.groupTypeValuesCache.get(kimType.getId()) != null) continue;
            String value = kimType.getNamespaceCode().trim() + ":" + kimType.getName().trim();
            options.add((KeyValue)new ConcreteKeyValue(kimType.getId(), value));
        }
        Collections.sort(options, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue k1, KeyValue k2) {
                return k1.getValue().compareTo(k2.getValue());
            }
        });
        return options;
    }

    private List<Row> setupAttributeRows(Map fieldValues) {
        ArrayList<Row> returnRows = new ArrayList<Row>();
        for (Row row : this.getGrpRows()) {
            Field field = (Field)row.getFields().get(0);
            if (field.getPropertyName().equals(KIM_TYPE_ID_PROPERTY_NAME) && StringUtils.isNotBlank((String)field.getPropertyValue())) {
                if (!StringUtils.isBlank((String)this.getTypeId()) || !this.getTypeId().equals(field.getPropertyValue())) {
                    this.setTypeId(field.getPropertyValue());
                    this.setAttrRows(new ArrayList<Row>());
                    KimType kimType = this.getTypeInfoService().getKimType(field.getPropertyValue());
                    KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
                    List definitions = kimTypeService.getAttributeDefinitions(kimType.getId());
                    this.setAttrDefinitions(definitions);
                    for (KimAttributeField d : definitions) {
                        KimAttributeDefinition definition = DataDictionaryTypeServiceHelper.toKimAttributeDefinition((KimAttributeField)d);
                        ArrayList<Field> fields = new ArrayList<Field>();
                        Field typeField = new Field();
                        String attrDefnId = d.getId();
                        typeField.setFieldLabel(definition.getLabel());
                        typeField.setPropertyName("attributes(" + definition.getName() + ")");
                        typeField.setPropertyValue(fieldValues.get(typeField.getPropertyName()));
                        if (definition.getControl().isSelect()) {
                            typeField.setFieldValidValues(definition.getOptionsFinder().getKeyValues());
                            typeField.setFieldType("dropdown");
                        } else if (definition.getControl().isText()) {
                            typeField.setMaxLength(definition.getMaxLength().intValue());
                            if (definition.getControl().getSize() != null) {
                                typeField.setSize(definition.getControl().getSize().intValue());
                            }
                            typeField.setFieldType("text");
                        } else if (definition.getControl().isRadio()) {
                            typeField.setFieldValidValues(definition.getOptionsFinder().getKeyValues());
                            typeField.setFieldType("radio");
                        } else if (definition.getControl().isCheckbox()) {
                            IndicatorValuesFinder finder = new IndicatorValuesFinder();
                            typeField.setFieldValidValues(finder.getKeyValues());
                            typeField.setFieldType("radio");
                        } else if (definition.getControl().isHidden()) {
                            typeField.setFieldType("hidden");
                        } else if (definition.getControl().isLookupReadonly()) {
                            typeField.setFieldType("lookupreadonly");
                        } else if (definition.getControl().isTextarea()) {
                            typeField.setMaxLength(definition.getMaxLength().intValue());
                            if (definition.getControl().getSize() != null) {
                                typeField.setSize(definition.getControl().getSize().intValue());
                            }
                            typeField.setFieldType("textarea");
                        }
                        fields.add(typeField);
                        returnRows.add(new Row(fields));
                    }
                    continue;
                }
                return this.getAttrRows();
            }
            if (!field.getPropertyName().equals(KIM_TYPE_ID_PROPERTY_NAME) || !StringUtils.isBlank((String)field.getPropertyValue())) continue;
            this.setTypeId("");
        }
        return returnRows;
    }

    public List<Row> getGrpRows() {
        return this.grpRows;
    }

    public void setGrpRows(List<Row> grpRows) {
        this.grpRows = grpRows;
    }

    public List<KimAttributeField> getAttrDefinitions() {
        return this.attrDefinitions;
    }

    public void setAttrDefinitions(List<KimAttributeField> attrDefinitions) {
        this.attrDefinitions = attrDefinitions;
    }

    public List<Row> getAttrRows() {
        return this.attrRows;
    }

    public void setAttrRows(List<Row> attrRows) {
        this.attrRows = attrRows;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    private String findAndConvertAttributeNamesToMappableProperty(String propertyName) {
        if (this.isParamAttribute(propertyName)) {
            return propertyName.replaceAll("attributes\\((.*?)\\)", "attributes\\[$1\\]");
        }
        return propertyName;
    }

    public void performClear(LookupForm lookupForm) {
        super.performClear(lookupForm);
        this.attrRows = new ArrayList<Row>();
    }
}

