/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.dao.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.docsearch.dao.DocumentSearchDAO;
import org.kuali.rice.kew.impl.document.search.DocumentSearchGenerator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DocumentSearchDAOJdbcImpl
implements DocumentSearchDAO {
    public static final Logger LOG = Logger.getLogger(DocumentSearchDAOJdbcImpl.class);
    private static final int DEFAULT_FETCH_MORE_ITERATION_LIMIT = 10;
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
    }

    @Override
    public DocumentSearchResults.Builder findDocuments(final DocumentSearchGenerator documentSearchGenerator, final DocumentSearchCriteria criteria, final boolean criteriaModified, final List<RemotableAttributeField> searchFields) {
        final int maxResultCap = this.getMaxResultCap(criteria);
        try {
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            return (DocumentSearchResults.Builder)template.execute((ConnectionCallback)new ConnectionCallback<DocumentSearchResults.Builder>(){

                /*
                 * Exception decompiling
                 */
                public DocumentSearchResults.Builder doInConnection(Connection con) throws SQLException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (DataAccessException dae) {
            String errorMsg = "DataAccessException: " + dae.getMessage();
            LOG.error((Object)("getList() " + errorMsg), (Throwable)dae);
            throw new RuntimeException(errorMsg, dae);
        }
        catch (Exception e) {
            String errorMsg = "LookupException: " + e.getMessage();
            LOG.error((Object)("getList() " + errorMsg), (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @Override
    public int getMaxResultCap(DocumentSearchCriteria criteria) {
        int systemLimit = 500;
        String resultCapValue = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "DocumentSearch", "RESULT_CAP");
        if (StringUtils.isNotBlank((String)resultCapValue)) {
            try {
                int configuredLimit = Integer.parseInt(resultCapValue);
                if (configuredLimit <= 0) {
                    LOG.warn((Object)"RESULT_CAP was less than or equal to zero.  Please use a positive integer.");
                } else {
                    systemLimit = configuredLimit;
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("RESULT_CAP is not a valid number.  Value was " + resultCapValue + ".  Using default: " + 500));
            }
        }
        int maxResults = systemLimit;
        if (criteria.getMaxResults() != null) {
            int criteriaLimit = criteria.getMaxResults();
            if (criteriaLimit > systemLimit) {
                LOG.warn((Object)("Result set cap of " + criteriaLimit + " is greater than system value of " + systemLimit));
            } else {
                if (criteriaLimit < 0) {
                    LOG.warn((Object)"Criteria results limit was less than zero.");
                    criteriaLimit = 0;
                }
                maxResults = criteriaLimit;
            }
        }
        return maxResults;
    }

    @Override
    public int getFetchMoreIterationLimit() {
        int fetchMoreLimit = 10;
        String fetchMoreLimitValue = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "DocumentSearch", "FETCH_MORE_ITERATION_LIMIT");
        if (!StringUtils.isBlank((String)fetchMoreLimitValue)) {
            try {
                fetchMoreLimit = Integer.parseInt(fetchMoreLimitValue);
                if (fetchMoreLimit < 0) {
                    LOG.warn((Object)"FETCH_MORE_ITERATION_LIMIT was less than zero.  Please use a value greater than or equal to zero.");
                    fetchMoreLimit = 10;
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("FETCH_MORE_ITERATION_LIMIT is not a valid number.  Value was " + fetchMoreLimitValue));
            }
        }
        return fetchMoreLimit;
    }
}

