/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RequestActivationNode;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.w3c.dom.Document;

public class FYIByNetworkId
extends RequestActivationNode {
    private static final Logger LOG = Logger.getLogger(FYIByNetworkId.class);

    @Override
    public SimpleResult process(RouteContext context, RouteHelper helper) throws Exception {
        LOG.debug((Object)"processing FYIByNetworkId simple node");
        String documentId = context.getDocument().getDocumentId();
        Element rootElement = FYIByNetworkId.getRootElement(new StandardDocumentContent(context.getDocument().getDocContent()));
        Collection fieldElements = XmlHelper.findElements((Element)rootElement, (String)"field");
        for (Element field : fieldElements) {
            Element version = field.getParentElement();
            if (!version.getAttribute("current").getValue().equals("true")) continue;
            LOG.debug((Object)("Looking for networkId field:  " + field.getAttributeValue("name")));
            if (field.getAttribute("name") == null || !field.getAttributeValue("name").equals("networkId")) continue;
            LOG.debug((Object)("Should send an FYI to netID:  " + field.getChildText("value")));
            if (field.getChildText("value") == null) continue;
            Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(field.getChildText("value"));
            if (!context.isSimulation()) {
                KEWServiceLocator.getWorkflowDocumentService().adHocRouteDocumentToPrincipal(user.getPrincipalId(), context.getDocument(), "F", null, null, "Notification Request", user.getPrincipalId(), "Notification Request", true, null);
            }
            LOG.debug((Object)("Sent FYI using the adHocRouteDocumentToPrincipal function to NetworkID:  " + user.getPrincipalName()));
            break;
        }
        return super.process(context, helper);
    }

    private static Element getRootElement(DocumentContent docContent) {
        Element rootElement = null;
        try {
            rootElement = XmlHelper.buildJDocument((Document)docContent.getDocument()).getRootElement();
        }
        catch (Exception e) {
            throw new WorkflowServiceErrorException("Invalid XML submitted", new ArrayList());
        }
        return rootElement;
    }

    protected Object getService(String serviceName) {
        return KEWServiceLocator.getService(serviceName);
    }
}

