/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.util.Collections;
import javax.jws.WebParam;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.WorkflowEngineFactory;

public class DocumentProcessingQueueImpl
implements DocumentProcessingQueue {
    private static final Logger LOG = Logger.getLogger(DocumentProcessingQueueImpl.class);
    private WorkflowEngineFactory workflowEngineFactory;
    private DocumentAttributeIndexingQueue documentAttributeIndexingQueue;

    public void process(@WebParam(name="documentId") String documentId) {
        this.processWithOptions(documentId, null);
    }

    public void processWithOptions(@WebParam(name="documentId") String documentId, @WebParam(name="options") DocumentProcessingOptions options) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId was a null or blank value");
        }
        if (options == null) {
            options = DocumentProcessingOptions.createDefault();
        }
        OrchestrationConfig config = new OrchestrationConfig(OrchestrationConfig.EngineCapability.STANDARD, Collections.emptySet(), null, options.isSendNotifications(), options.isRunPostProcessor());
        Object engine = this.getWorkflowEngineFactory().newEngine(config);
        try {
            engine.process(documentId, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to process document through the workflow engine", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WorkflowRuntimeException((Throwable)e);
        }
        if (options.isIndexSearchAttributes()) {
            this.getDocumentAttributeIndexingQueue().indexDocument(documentId);
        }
    }

    public WorkflowEngineFactory getWorkflowEngineFactory() {
        return this.workflowEngineFactory;
    }

    public void setWorkflowEngineFactory(WorkflowEngineFactory workflowEngineFactory) {
        this.workflowEngineFactory = workflowEngineFactory;
    }

    public DocumentAttributeIndexingQueue getDocumentAttributeIndexingQueue() {
        return this.documentAttributeIndexingQueue;
    }

    public void setDocumentAttributeIndexingQueue(DocumentAttributeIndexingQueue documentAttributeIndexingQueue) {
        this.documentAttributeIndexingQueue = documentAttributeIndexingQueue;
    }
}

