/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.role.QualifierResolver;
import org.kuali.rice.kew.rule.XmlConfiguredAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathQualifierResolver
implements QualifierResolver,
XmlConfiguredAttribute {
    private static final Logger LOG = Logger.getLogger(XPathQualifierResolver.class);
    private ExtensionDefinition extensionDefinition;

    @Override
    public List<Map<String, String>> resolve(RouteContext context) {
        ResolverConfig config = this.parseResolverConfig();
        Document xmlContent = context.getDocumentContent().getDocument();
        XPath xPath = XPathHelper.newXPath();
        boolean isCompoundMap = config.getExpressionMap().size() > 1;
        try {
            ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
            NodeList baseElements = (NodeList)xPath.evaluate(config.getBaseXPathExpression(), xmlContent, XPathConstants.NODESET);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found " + baseElements.getLength() + " baseElements to parse for Map<String, String>s using document XML:" + XmlJotter.jotDocument((Document)xmlContent)));
            }
            for (int index = 0; index < baseElements.getLength(); ++index) {
                Node baseNode = baseElements.item(index);
                if (isCompoundMap) {
                    this.handleCompoundMap(baseNode, maps, config, xPath);
                    continue;
                }
                this.handleSimpleMap(baseNode, maps, config, xPath);
            }
            return maps;
        }
        catch (XPathExpressionException e) {
            throw new RiceRuntimeException("Encountered an issue executing XPath.", (Throwable)e);
        }
    }

    protected void handleCompoundMap(Node baseNode, List<Map<String, String>> maps, ResolverConfig config, XPath xPath) throws XPathExpressionException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String attributeName : config.getExpressionMap().keySet()) {
            String xPathExpression = config.getExpressionMap().get(attributeName);
            NodeList attributes = (NodeList)xPath.evaluate(xPathExpression, baseNode, XPathConstants.NODESET);
            if (attributes.getLength() > 1) {
                throw new RiceRuntimeException("Found more than more XPath result for an attribute in a compound attribute set for attribute: " + attributeName + " with expression " + xPathExpression);
            }
            if (attributes.getLength() == 0) continue;
            String attributeValue = ((Element)attributes.item(0)).getTextContent();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding values to compound Map<String, String>: " + attributeName + "::" + attributeValue));
            }
            map.put(attributeName, attributeValue);
        }
        maps.add(map);
    }

    protected void handleSimpleMap(Node baseNode, List<Map<String, String>> maps, ResolverConfig config, XPath xPath) throws XPathExpressionException {
        String attributeName = config.getExpressionMap().keySet().iterator().next();
        String xPathExpression = config.getExpressionMap().get(attributeName);
        NodeList attributes = (NodeList)xPath.evaluate(xPathExpression, baseNode, XPathConstants.NODESET);
        for (int index = 0; index < attributes.getLength(); ++index) {
            Element attributeElement = (Element)attributes.item(index);
            HashMap<String, String> map = new HashMap<String, String>();
            String attributeValue = attributeElement.getTextContent();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding values to simple Map<String, String>: " + attributeName + "::" + attributeValue));
            }
            map.put(attributeName, attributeValue);
            maps.add(map);
        }
    }

    protected ResolverConfig parseResolverConfig() {
        if (this.extensionDefinition.getConfiguration() != null && this.extensionDefinition.getConfiguration().get("xmlConfigData") == null) {
            throw new RiceRuntimeException("Failed to locate a RuleAttribute for the given XPathQualifierResolver");
        }
        try {
            Element expressionElement;
            NodeList expressions;
            String name;
            Element qualifierElement;
            int index;
            ResolverConfig resolverConfig = new ResolverConfig();
            String xmlConfig = (String)this.extensionDefinition.getConfiguration().get("xmlConfigData");
            XPath xPath = XPathHelper.newXPath();
            String baseExpression = xPath.evaluate("//resolverConfig/baseXPathExpression", new InputSource(new StringReader(xmlConfig)));
            if (!StringUtils.isEmpty((String)baseExpression)) {
                resolverConfig.setBaseXPathExpression(baseExpression);
            }
            NodeList qualifiers = (NodeList)xPath.evaluate("//resolverConfig/attributes", new InputSource(new StringReader(xmlConfig)), XPathConstants.NODESET);
            NodeList qualifiersLegacy = (NodeList)xPath.evaluate("//resolverConfig/qualifier", new InputSource(new StringReader(xmlConfig)), XPathConstants.NODESET);
            if (!(qualifiers != null && qualifiers.getLength() != 0 || qualifiersLegacy != null && qualifiersLegacy.getLength() != 0)) {
                throw new RiceRuntimeException("Invalid qualifier resolver configuration.  Must contain at least one qualifier!");
            }
            for (index = 0; index < qualifiers.getLength(); ++index) {
                qualifierElement = (Element)qualifiers.item(index);
                name = qualifierElement.getAttribute("name");
                expressions = qualifierElement.getElementsByTagName("xPathExpression");
                if (expressions.getLength() != 1) {
                    throw new RiceRuntimeException("There should only be a single xPathExpression per qualifier");
                }
                expressionElement = (Element)expressions.item(0);
                resolverConfig.getExpressionMap().put(name, expressionElement.getTextContent());
            }
            for (index = 0; index < qualifiersLegacy.getLength(); ++index) {
                qualifierElement = (Element)qualifiersLegacy.item(index);
                name = qualifierElement.getAttribute("name");
                expressions = qualifierElement.getElementsByTagName("xPathExpression");
                if (expressions.getLength() != 1) {
                    throw new RiceRuntimeException("There should only be a single xPathExpression per qualifier");
                }
                expressionElement = (Element)expressions.item(0);
                resolverConfig.getExpressionMap().put(name, expressionElement.getTextContent());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using Resolver Config Settings: " + resolverConfig.toString()));
            }
            return resolverConfig;
        }
        catch (XPathExpressionException e) {
            throw new RiceRuntimeException("Encountered an error parsing resolver config.", (Throwable)e);
        }
    }

    @Override
    public void setExtensionDefinition(ExtensionDefinition ruleAttribute) {
        this.extensionDefinition = ruleAttribute;
    }

    class ResolverConfig {
        private String baseXPathExpression = "/";
        private Map<String, String> expressionMap = new HashMap<String, String>();

        ResolverConfig() {
        }

        public String getBaseXPathExpression() {
            return this.baseXPathExpression;
        }

        public void setBaseXPathExpression(String baseXPathExpression) {
            this.baseXPathExpression = baseXPathExpression;
        }

        public Map<String, String> getExpressionMap() {
            return this.expressionMap;
        }

        public void setExpressionMap(Map<String, String> expressionMap) {
            this.expressionMap = expressionMap;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('\n');
            sb.append("ResolverConfig Parameters\n");
            sb.append("      baseXPathExpression: " + this.baseXPathExpression + "\n");
            sb.append("      expressionMap:\n");
            for (Map.Entry<String, String> entry : this.expressionMap.entrySet()) {
                sb.append("            " + entry.getKey() + ": " + entry.getValue() + "\n");
            }
            return sb.toString();
        }
    }
}

