/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.rules.ui;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.rule.event.ui.AddPermissionEvent;
import org.kuali.rice.kim.rule.ui.AddPermissionRule;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class KimDocumentPermissionRule
extends DocumentRuleBase
implements AddPermissionRule {
    public static final String ERROR_PATH = "document.permission.permissionId";

    @Override
    public boolean processAddPermission(AddPermissionEvent addPermissionEvent) {
        KimDocumentRolePermission newPermission = addPermissionEvent.getPermission();
        if (newPermission == null || StringUtils.isEmpty((String)newPermission.getPermissionId())) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Permission"});
            return false;
        }
        Permission kimPermissionInfo = newPermission.getPermission();
        if (kimPermissionInfo == null) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Permission"});
            return false;
        }
        boolean rulePassed = true;
        IdentityManagementRoleDocument document = (IdentityManagementRoleDocument)addPermissionEvent.getDocument();
        if (!this.hasPermissionToGrantPermission(kimPermissionInfo, document)) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.assign.perimssion", new String[]{kimPermissionInfo.getNamespaceCode(), kimPermissionInfo.getTemplate().getName()});
            return false;
        }
        if (newPermission == null || StringUtils.isBlank((String)newPermission.getPermissionId())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Permission"});
        } else {
            int i = 0;
            for (KimDocumentRolePermission permission : document.getPermissions()) {
                if (permission.getPermissionId().equals(newPermission.getPermissionId())) {
                    rulePassed = false;
                    GlobalVariables.getMessageMap().putError("document.permissions[" + i + "].permissionId", "error.duplicate.entry", new String[]{"Permission"});
                }
                ++i;
            }
        }
        return rulePassed;
    }

    @Override
    public boolean hasPermissionToGrantPermission(Permission kimPermissionInfo, IdentityManagementRoleDocument document) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", kimPermissionInfo.getNamespaceCode());
        permissionDetails.put("permissionName", kimPermissionInfo.getTemplate().getName());
        return KimDocumentPermissionRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Grant Permission", GlobalVariables.getUserSession().getPerson().getPrincipalId(), permissionDetails, null);
    }
}

