/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.type.KimTypeLookupableHelperServiceImpl;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kim.util.KimCommonUtilsInternal;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class IdentityManagementDocumentActionBase
extends KualiTransactionalDocumentActionBase {
    private static final Logger LOG = Logger.getLogger(IdentityManagementDocumentActionBase.class);
    protected static final String CHANGE_MEMBER_TYPE_CODE_METHOD_TO_CALL = "changeMemberTypeCode";
    protected static final String CHANGE_NAMESPACE_METHOD_TO_CALL = "changeNamespace";
    protected IdentityService identityService;
    protected ResponsibilityService responsibilityService;
    protected UiDocumentService uiDocumentService;

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.performLookup(mapping, form, request, response);
        String path = forward.getPath();
        forward.setPath(KimCommonUtilsInternal.getPathWithKimContext(path, this.getActionName()));
        return forward;
    }

    protected abstract String getActionName();

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected ResponsibilityService getResponsibilityService() {
        if (this.responsibilityService == null) {
            this.responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return this.responsibilityService;
    }

    protected UiDocumentService getUiDocumentService() {
        if (this.uiDocumentService == null) {
            this.uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
        }
        return this.uiDocumentService;
    }

    protected String getReturnLocation(HttpServletRequest request, ActionMapping mapping) {
        String returnLocation = super.getReturnLocation(request, mapping);
        return KimCommonUtilsInternal.getPathWithKimContext(returnLocation, this.getActionName());
    }

    protected ActionForward returnToSender(HttpServletRequest request, ActionMapping mapping, KualiDocumentFormBase form) {
        ActionForward dest;
        if (form.isReturnToActionList()) {
            String workflowBase = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
            String actionListUrl = workflowBase + "/ActionList.do";
            dest = new ActionForward(actionListUrl, true);
        } else if (StringUtils.isNotBlank((String)form.getBackLocation())) {
            dest = new ActionForward(form.getBackLocation(), true);
        } else {
            ActionForward dest2 = mapping.findForward("portal");
            ActionForward newDest = new ActionForward();
            KimCommonUtilsInternal.copyProperties(newDest, dest2);
            newDest.setPath(IdentityManagementDocumentActionBase.getApplicationBaseUrl());
            return newDest;
        }
        this.setupDocumentExit();
        return dest;
    }

    protected ActionForward getBasePathForward(HttpServletRequest request, ActionForward forward) {
        ActionForward newDest = new ActionForward();
        KimCommonUtilsInternal.copyProperties(newDest, forward);
        newDest.setPath(IdentityManagementDocumentActionBase.getApplicationBaseUrl());
        return newDest;
    }

    public ActionForward switchToPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementDocumentFormBase idmForm = (IdentityManagementDocumentFormBase)form;
        KualiTableRenderFormMetadata memberTableMetadata = idmForm.getMemberTableMetadata();
        memberTableMetadata.jumpToPage(memberTableMetadata.getSwitchToPageNumber(), idmForm.getMemberRows().size(), idmForm.getRecordsPerPage());
        memberTableMetadata.setColumnToSortIndex(memberTableMetadata.getPreviouslySortedColumnIndex());
        return mapping.findForward("basic");
    }

    protected void applyPagingAndSortingFromPreviousPageView(IdentityManagementDocumentFormBase idmForm) {
        KualiTableRenderFormMetadata memberTableMetadata = idmForm.getMemberTableMetadata();
        memberTableMetadata.jumpToPage(memberTableMetadata.getViewedPageNumber(), idmForm.getMemberRows().size(), idmForm.getRecordsPerPage());
    }

    protected boolean validateRole(String roleId, Role role, String propertyName, String message) {
        if (role == null) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.invalid.role", new String[]{roleId});
            return false;
        }
        KimType typeInfo = KimApiServiceLocator.getKimTypeInfoService().getKimType(role.getKimTypeId());
        if (KimTypeLookupableHelperServiceImpl.hasDerivedRoleTypeService(typeInfo)) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.cant.add.derived.role", new String[]{message});
            return false;
        }
        return true;
    }

    public ActionForward changeNamespace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refresh(mapping, form, request, response);
    }

    protected KimTypeService getKimTypeService(KimType typeInfo) {
        String serviceName = typeInfo.getServiceName();
        if (StringUtils.isNotBlank((String)serviceName)) {
            try {
                KimTypeService service = (KimTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(serviceName));
                if (service != null && service instanceof RoleTypeService) {
                    return service;
                }
                return (RoleTypeService)KIMServiceLocatorInternal.getService("kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to find role type service with name: " + serviceName), (Throwable)ex);
                return (RoleTypeService)KIMServiceLocatorInternal.getService("kimNoMembersRoleTypeService");
            }
        }
        return null;
    }
}

