/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;

@Deprecated
public class MaintenanceDocumentDictionaryServiceImpl
implements MaintenanceDocumentDictionaryService {
    protected static Logger LOG = Logger.getLogger(MaintenanceDocumentDictionaryServiceImpl.class);
    private DataDictionaryService dataDictionaryService;

    protected DocumentType getDocumentType(String documentTypeName) {
        return KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
    }

    public String getMaintenanceLabel(String docTypeName) {
        String label = null;
        DocumentType docType = this.getDocumentType(docTypeName);
        if (docType != null) {
            label = docType.getLabel();
        }
        return label;
    }

    public String getMaintenanceDescription(String docTypeName) {
        String description = null;
        DocumentType docType = this.getDocumentType(docTypeName);
        if (docType != null) {
            description = docType.getDescription();
        }
        return description;
    }

    @Deprecated
    public Class getMaintainableClass(String docTypeName) {
        Class maintainableClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            LOG.debug((Object)"suppling a generic Rule to insure basic validation");
            maintainableClass = entry.getMaintainableClass();
        }
        return maintainableClass;
    }

    public Class getDataObjectClass(String docTypeName) {
        Class dataObjectClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            dataObjectClass = entry.getDataObjectClass();
        }
        return dataObjectClass;
    }

    public String getDocumentTypeName(Class businessObjectClass) {
        String documentTypeName = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (entry != null) {
            documentTypeName = entry.getDocumentTypeName();
        }
        return documentTypeName;
    }

    @Deprecated
    public List getMaintainableSections(String docTypeName) {
        List sections = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            sections = entry.getMaintainableSections();
        }
        return sections;
    }

    public Collection getDefaultExistenceChecks(Class businessObjectClass) {
        return this.getDefaultExistenceChecks(this.getDocumentTypeName(businessObjectClass));
    }

    public Collection getDefaultExistenceChecks(String docTypeName) {
        List defaultExistenceChecks = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            defaultExistenceChecks = entry.getDefaultExistenceChecks();
        }
        return defaultExistenceChecks;
    }

    public List getLockingKeys(String docTypeName) {
        List lockingKeys = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            lockingKeys = entry.getLockingKeyFieldNames();
        }
        return lockingKeys;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionaryService.getDataDictionary();
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntry(String docTypeName) {
        if (StringUtils.isBlank((String)docTypeName)) {
            throw new IllegalArgumentException("invalid (blank) docTypeName");
        }
        MaintenanceDocumentEntry entry = (MaintenanceDocumentEntry)this.getDataDictionary().getDocumentEntry(docTypeName);
        return entry;
    }

    private MaintenanceDocumentEntry getMaintenanceDocumentEntry(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (blank) dataObjectClass");
        }
        org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry entry = this.getDataDictionary().getMaintenanceDocumentEntryForBusinessObjectClass(businessObjectClass);
        return entry instanceof MaintenanceDocumentEntry ? (MaintenanceDocumentEntry)entry : null;
    }

    public String getFieldDefaultValue(Class boClass, String fieldName) {
        if (boClass == null) {
            throw new IllegalArgumentException("The boClass parameter value specified was null.  A valid class representing the boClass must be specified.");
        }
        return this.getFieldDefaultValue(this.getDocumentTypeName(boClass), fieldName);
    }

    public String getFieldDefaultValue(String docTypeName, String fieldName) {
        if (StringUtils.isBlank((String)docTypeName)) {
            throw new IllegalArgumentException("The docTypeName parameter value specified was  blank, whitespace, or null.  A valid string representing the docTypeName must be specified.");
        }
        if (StringUtils.isBlank((String)fieldName)) {
            throw new IllegalArgumentException("The fieldName parameter value specified was  blank, whitespace, or null.  A valid string representing the fieldName must be specified.");
        }
        List sections = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition section : sections) {
            List fields = section.getMaintainableItems();
            String defaultValue = this.getFieldDefaultValue(fields, fieldName);
            if (defaultValue == null) continue;
            return defaultValue;
        }
        return null;
    }

    private String getFieldDefaultValue(Collection maintainableFields, String fieldName) {
        for (MaintainableItemDefinition item : maintainableFields) {
            MaintainableFieldDefinition field;
            if (!(item instanceof MaintainableFieldDefinition) || !(field = (MaintainableFieldDefinition)item).getName().endsWith(fieldName)) continue;
            if (StringUtils.isNotBlank((String)field.getDefaultValue())) {
                return field.getDefaultValue();
            }
            if (field.getDefaultValueFinderClass() != null) {
                ValueFinder valueFinder = null;
                try {
                    valueFinder = (ValueFinder)field.getDefaultValueFinderClass().newInstance();
                }
                catch (Exception e) {
                    LOG.info((Object)"Exception obtaining valueFinder for collection field default value", (Throwable)e);
                    valueFinder = null;
                }
                if (valueFinder == null) continue;
                return valueFinder.getValue();
            }
            return null;
        }
        return null;
    }

    public String getCollectionFieldDefaultValue(String docTypeName, String collectionName, String fieldName) {
        if (StringUtils.isBlank((String)docTypeName)) {
            throw new IllegalArgumentException("The docTypeName parameter value specified was blank, whitespace, or null.  A valid string representing the docTypeName must be specified.");
        }
        if (StringUtils.isBlank((String)fieldName)) {
            throw new IllegalArgumentException("The fieldName parameter value specified was blank, whitespace, or null.  A valid string representing the fieldName must be specified.");
        }
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("The collectionName parameter value specified was null.  A valid string representing the collectionName must be specified.");
        }
        MaintainableCollectionDefinition coll = this.getMaintainableCollection(docTypeName, collectionName);
        if (coll != null) {
            List collectionFields = coll.getMaintainableFields();
            return this.getFieldDefaultValue(collectionFields, fieldName);
        }
        return null;
    }

    public Boolean getAllowsCopy(MaintenanceDocument document) {
        MaintenanceDocumentEntry entry;
        Boolean allowsCopy = Boolean.FALSE;
        if (document != null && document.getNewMaintainableObject() != null && (entry = this.getMaintenanceDocumentEntry(document.getNewMaintainableObject().getBoClass())) != null) {
            allowsCopy = entry.getAllowsCopy();
        }
        return allowsCopy;
    }

    public Boolean getAllowsNewOrCopy(String docTypeName) {
        MaintenanceDocumentEntry entry;
        Boolean allowsNewOrCopy = Boolean.FALSE;
        if (docTypeName != null && (entry = this.getMaintenanceDocumentEntry(docTypeName)) != null) {
            allowsNewOrCopy = entry.getAllowsNewOrCopy();
        }
        return allowsNewOrCopy;
    }

    public MaintainableItemDefinition getMaintainableItem(String docTypeName, String itemName) {
        if (StringUtils.isBlank((String)docTypeName)) {
            throw new IllegalArgumentException("The docTypeName parameter value specified was  blank, whitespace, or null.  A valid string representing the docTypeName must be specified.");
        }
        if (StringUtils.isBlank((String)itemName)) {
            throw new IllegalArgumentException("The itemName parameter value specified was  blank, whitespace, or null.  A valid string representing the itemName must be specified.");
        }
        String[] subItems = new String[]{};
        subItems = StringUtils.split((String)itemName, (String)".");
        List sections = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition section : sections) {
            List fields = section.getMaintainableItems();
            for (MaintainableItemDefinition item : fields) {
                if (item.getName().equals(itemName)) {
                    return item;
                }
                if (!(item instanceof MaintainableCollectionDefinition)) continue;
                MaintainableCollectionDefinition col = (MaintainableCollectionDefinition)item;
                if (subItems.length <= 1 || !StringUtils.equals((String)col.getName(), (String)subItems[0])) continue;
                for (MaintainableCollectionDefinition subCol : col.getMaintainableCollections()) {
                    if (!subCol.getName().equals(subItems[1])) continue;
                    return subCol;
                }
            }
        }
        return null;
    }

    public MaintainableFieldDefinition getMaintainableField(String docTypeName, String fieldName) {
        MaintainableItemDefinition item = this.getMaintainableItem(docTypeName, fieldName);
        if (item != null && item instanceof MaintainableFieldDefinition) {
            return (MaintainableFieldDefinition)item;
        }
        return null;
    }

    public MaintainableCollectionDefinition getMaintainableCollection(String docTypeName, String collectionName) {
        MaintainableItemDefinition item;
        if (StringUtils.contains((String)collectionName, (String)"[")) {
            collectionName = StringUtils.substringBefore((String)collectionName, (String)"[") + StringUtils.substringAfter((String)collectionName, (String)"]");
        }
        if ((item = this.getMaintainableItem(docTypeName, collectionName)) != null && item instanceof MaintainableCollectionDefinition) {
            return (MaintainableCollectionDefinition)item;
        }
        return null;
    }

    public Class getCollectionBusinessObjectClass(String docTypeName, String collectionName) {
        MaintainableCollectionDefinition coll = this.getMaintainableCollection(docTypeName, collectionName);
        if (coll != null) {
            return coll.getBusinessObjectClass();
        }
        return null;
    }

    public List<MaintainableCollectionDefinition> getMaintainableCollections(String docTypeName) {
        ArrayList<MaintainableCollectionDefinition> collections = new ArrayList<MaintainableCollectionDefinition>();
        List sections = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition section : sections) {
            List fields = section.getMaintainableItems();
            for (MaintainableItemDefinition item : fields) {
                if (!(item instanceof MaintainableCollectionDefinition)) continue;
                collections.add((MaintainableCollectionDefinition)item);
            }
        }
        return collections;
    }

    public List<MaintainableCollectionDefinition> getMaintainableCollections(MaintainableCollectionDefinition parentCollection) {
        ArrayList<MaintainableCollectionDefinition> collections = new ArrayList<MaintainableCollectionDefinition>();
        List colls = parentCollection.getMaintainableCollections();
        for (MaintainableCollectionDefinition coll : colls) {
            collections.add(coll);
            collections.addAll(this.getMaintainableCollections(coll));
        }
        return collections;
    }

    public void validateMaintenanceRequiredFields(MaintenanceDocument document) {
        Maintainable newMaintainableObject = document.getNewMaintainableObject();
        if (newMaintainableObject == null) {
            LOG.error((Object)"New maintainable is null");
            throw new RuntimeException("New maintainable is null");
        }
        List maintainableSectionDefinitions = this.getMaintainableSections(this.getDocumentTypeName(newMaintainableObject.getBoClass()));
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                if (maintainableItemDefinition instanceof MaintainableFieldDefinition) {
                    this.validateMaintainableFieldRequiredFields((MaintainableFieldDefinition)maintainableItemDefinition, newMaintainableObject.getBusinessObject(), maintainableItemDefinition.getName());
                    continue;
                }
                if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition)) continue;
                this.validateMaintainableCollectionsRequiredFields(newMaintainableObject.getBusinessObject(), (MaintainableCollectionDefinition)maintainableItemDefinition);
            }
        }
    }

    private void validateMaintainableFieldRequiredFields(MaintainableFieldDefinition maintainableFieldDefinition, PersistableBusinessObject businessObject, String fieldName) {
        if (StringUtils.isBlank((String)fieldName)) {
            throw new IllegalArgumentException("invalid fieldName parameter.");
        }
        if (maintainableFieldDefinition.isRequired() && !maintainableFieldDefinition.isUnconditionallyReadOnly()) {
            try {
                String personProperty;
                Object obj = ObjectUtils.getNestedValue((Object)businessObject, (String)fieldName);
                if (obj == null || StringUtils.isBlank((String)obj.toString())) {
                    String attributeLabel = this.dataDictionaryService.getAttributeLabel(businessObject.getClass(), fieldName);
                    String shortLabel = this.dataDictionaryService.getAttributeShortLabel(businessObject.getClass(), fieldName);
                    GlobalVariables.getMessageMap().putError(fieldName, "error.required", new String[]{attributeLabel + " (" + shortLabel + ")"});
                } else if (fieldName.endsWith(".principalName") && StringUtils.isNotBlank((String)(personProperty = ObjectUtils.getNestedAttributePrefix((String)fieldName))) && StringUtils.isBlank((String)((String)ObjectUtils.getNestedValue((Object)businessObject, (String)(personProperty + ".entityId"))))) {
                    String attributeLabel = this.dataDictionaryService.getAttributeLabel(businessObject.getClass(), fieldName);
                    GlobalVariables.getMessageMap().putError(fieldName, "error.existence", new String[]{attributeLabel});
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"unable to read property during doc required field checks", (Throwable)ex);
            }
        }
    }

    private MaintainableCollectionDefinition getCollectionDefinition(String docTypeName, String collectionName) {
        String currentCollection = collectionName;
        String nestedCollections = "";
        if (StringUtils.contains((String)collectionName, (String)"[")) {
            currentCollection = StringUtils.substringBefore((String)collectionName, (String)"[");
            nestedCollections = StringUtils.substringAfter((String)collectionName, (String)".");
        }
        List maintainableSectionDefinitions = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition) || !maintainableItemDefinition.getName().equals(currentCollection)) continue;
                if (StringUtils.isBlank((String)nestedCollections)) {
                    return (MaintainableCollectionDefinition)maintainableItemDefinition;
                }
                return this.getCollectionDefinition((MaintainableCollectionDefinition)maintainableItemDefinition, nestedCollections);
            }
        }
        return null;
    }

    private MaintainableCollectionDefinition getCollectionDefinition(MaintainableCollectionDefinition collectionDef, String collectionName) {
        String currentCollection = collectionName;
        String nestedCollections = "";
        if (StringUtils.contains((String)collectionName, (String)"[")) {
            currentCollection = StringUtils.substringBefore((String)collectionName, (String)"[");
            nestedCollections = StringUtils.substringAfter((String)collectionName, (String)".");
        }
        for (MaintainableCollectionDefinition maintainableCollectionDefinition : collectionDef.getMaintainableCollections()) {
            if (!maintainableCollectionDefinition.getName().equals(currentCollection)) continue;
            if (StringUtils.isBlank((String)nestedCollections)) {
                return maintainableCollectionDefinition;
            }
            return this.getCollectionDefinition(maintainableCollectionDefinition, nestedCollections);
        }
        return null;
    }

    public void validateMaintainableCollectionsAddLineRequiredFields(MaintenanceDocument document, PersistableBusinessObject businessObject, String collectionName) {
        MaintainableCollectionDefinition def = this.getCollectionDefinition(this.getDocumentTypeName(businessObject.getClass()), collectionName);
        if (def != null) {
            this.validateMaintainableCollectionsAddLineRequiredFields(document, businessObject, collectionName, def, 0);
        }
    }

    private void validateMaintainableCollectionsAddLineRequiredFields(MaintenanceDocument document, PersistableBusinessObject businessObject, String collectionName, MaintainableCollectionDefinition maintainableCollectionDefinition, int depth) {
        if (depth == 0) {
            GlobalVariables.getMessageMap().addToErrorPath("add");
        }
        PersistableBusinessObject element = document.getNewMaintainableObject().getNewCollectionLine(collectionName);
        GlobalVariables.getMessageMap().addToErrorPath(collectionName);
        for (MaintainableFieldDefinition maintainableFieldDefinition : maintainableCollectionDefinition.getMaintainableFields()) {
            String fieldName = maintainableFieldDefinition.getName();
            this.validateMaintainableFieldRequiredFields(maintainableFieldDefinition, element, fieldName);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(collectionName);
        if (depth == 0) {
            GlobalVariables.getMessageMap().removeFromErrorPath("add");
        }
    }

    private void validateMaintainableCollectionsRequiredFields(PersistableBusinessObject businessObject, MaintainableCollectionDefinition maintainableCollectionDefinition) {
        String collectionName = maintainableCollectionDefinition.getName();
        Collection collection = (Collection)ObjectUtils.getPropertyValue((Object)businessObject, (String)collectionName);
        if (collection != null && !collection.isEmpty()) {
            for (MaintainableFieldDefinition maintainableFieldDefinition : maintainableCollectionDefinition.getMaintainableFields()) {
                int pos = 0;
                String fieldName = maintainableFieldDefinition.getName();
                for (PersistableBusinessObject element : collection) {
                    String parentName = collectionName + "[" + pos++ + "]";
                    GlobalVariables.getMessageMap().addToErrorPath(parentName);
                    this.validateMaintainableFieldRequiredFields(maintainableFieldDefinition, element, fieldName);
                    GlobalVariables.getMessageMap().removeFromErrorPath(parentName);
                }
            }
            GlobalVariables.getMessageMap().addToErrorPath(collectionName);
            for (MaintainableCollectionDefinition nestedMaintainableCollectionDefinition : maintainableCollectionDefinition.getMaintainableCollections()) {
                for (PersistableBusinessObject element : collection) {
                    this.validateMaintainableCollectionsRequiredFields(element, nestedMaintainableCollectionDefinition);
                }
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(collectionName);
        }
    }

    public void validateMaintainableCollectionsForDuplicateEntries(MaintenanceDocument document) {
        Maintainable newMaintainableObject = document.getNewMaintainableObject();
        if (newMaintainableObject == null) {
            LOG.error((Object)"New maintainable is null");
            throw new RuntimeException("New maintainable is null");
        }
        List maintainableSectionDefinitions = this.getMaintainableSections(this.getDocumentTypeName(newMaintainableObject.getBoClass()));
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition)) continue;
                this.validateMaintainableCollectionsForDuplicateEntries(newMaintainableObject.getBusinessObject(), (MaintainableCollectionDefinition)maintainableItemDefinition);
            }
        }
    }

    private void validateMaintainableCollectionsForDuplicateEntries(PersistableBusinessObject businessObject, MaintainableCollectionDefinition maintainableCollectionDefinition) {
        String collectionName = maintainableCollectionDefinition.getName();
        if (maintainableCollectionDefinition.dissallowDuplicateKey()) {
            Class<?> maintainableBusinessObjectClass = businessObject.getClass();
            Collection collection = (Collection)ObjectUtils.getPropertyValue((Object)businessObject, (String)collectionName);
            if (collection != null && !collection.isEmpty()) {
                String propertyName = maintainableCollectionDefinition.getAttributeToHighlightOnDuplicateKey();
                String label = this.dataDictionaryService.getCollectionLabel(maintainableBusinessObjectClass, collectionName);
                String shortLabel = this.dataDictionaryService.getCollectionShortLabel(maintainableBusinessObjectClass, collectionName);
                int pos = 0;
                for (PersistableBusinessObject element : collection) {
                    String pathToElement = collectionName + "[" + pos++ + "]";
                    if (ObjectUtils.countObjectsWithIdentitcalKey((Collection)collection, (PersistableBusinessObject)element) <= 1) continue;
                    GlobalVariables.getMessageMap().addToErrorPath(pathToElement);
                    GlobalVariables.getMessageMap().putError(propertyName, "error.duplicate.element", new String[]{label, shortLabel});
                    GlobalVariables.getMessageMap().removeFromErrorPath(pathToElement);
                }
                GlobalVariables.getMessageMap().addToErrorPath(collectionName);
                for (MaintainableCollectionDefinition nestedMaintainableCollectionDefinition : maintainableCollectionDefinition.getMaintainableCollections()) {
                    for (PersistableBusinessObject element : collection) {
                        this.validateMaintainableCollectionsForDuplicateEntries(element, nestedMaintainableCollectionDefinition);
                    }
                }
                GlobalVariables.getMessageMap().removeFromErrorPath(collectionName);
            }
        }
    }

    public boolean getPreserveLockingKeysOnCopy(Class businessObjectClass) {
        boolean preserveLockingKeysOnCopy = false;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (docEntry != null) {
            preserveLockingKeysOnCopy = docEntry.getPreserveLockingKeysOnCopy();
        }
        return preserveLockingKeysOnCopy;
    }

    public Boolean getAllowsRecordDeletion(Class businessObjectClass) {
        Boolean allowsRecordDeletion = Boolean.FALSE;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (docEntry != null) {
            allowsRecordDeletion = docEntry.getAllowsRecordDeletion();
        }
        return allowsRecordDeletion;
    }

    public Boolean getAllowsRecordDeletion(MaintenanceDocument document) {
        return document != null ? this.getAllowsRecordDeletion(document.getNewMaintainableObject().getBoClass()) : Boolean.FALSE;
    }

    public Boolean translateCodes(Class businessObjectClass) {
        boolean translateCodes = false;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (docEntry != null) {
            translateCodes = docEntry.isTranslateCodes();
        }
        return translateCodes;
    }
}

