/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.RouteNodeLookupLogic;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.service.impl.DocumentSearchServiceImpl;
import org.kuali.rice.kew.useroptions.UserOptions;
import org.kuali.rice.kew.useroptions.UserOptionsService;

public class DocSearchSavingTest {
    private MockDocumentSearchService docSearchService;
    private MockUserOptionsService userOptionsService;

    @Before
    public void init() {
        this.userOptionsService = new MockUserOptionsService();
        this.docSearchService = new MockDocumentSearchService();
        this.docSearchService.setUserOptionsService(this.userOptionsService);
    }

    @Test
    public void testConsumesExceptions() {
        this.docSearchService.saveSearch("princ", null);
    }

    @Test
    public void testUnnamedDocSearch() throws Exception {
        String princ = "not blank";
        Collection<UserOptions> allUserOptions_before = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)0L, (long)allUserOptions_before.size());
        DocumentSearchCriteria c1 = this.saveSearch(princ, null);
        Collection<UserOptions> allUserOptions_after = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)(allUserOptions_before.size() + 2), (long)allUserOptions_after.size());
        Assert.assertEquals((Object)"DocSearch.LastSearch.Holding0", (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Order", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c1), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding0", princ).getOptionVal());
        DocumentSearchCriteria c2 = this.saveSearch(princ, null);
        allUserOptions_after = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)(allUserOptions_before.size() + 3), (long)allUserOptions_after.size());
        Assert.assertEquals((Object)"DocSearch.LastSearch.Holding1,DocSearch.LastSearch.Holding0", (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Order", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c1), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding0", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c2), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding1", princ).getOptionVal());
        this.docSearchService.clearNamedSearches(princ);
        Assert.assertEquals((long)0L, (long)this.userOptionsService.findByWorkflowUser(princ).size());
    }

    @Test
    public void testNamedDocSearch() throws Exception {
        String princ = "not blank";
        Collection<UserOptions> allUserOptions_before = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)0L, (long)allUserOptions_before.size());
        DocumentSearchCriteria c1 = this.saveSearch(princ, "save1");
        Collection<UserOptions> allUserOptions_after = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)(allUserOptions_before.size() + 1), (long)allUserOptions_after.size());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c1), (Object)this.userOptionsService.findByOptionId("DocSearch.NamedSearch." + c1.getSaveName(), princ).getOptionVal());
        DocumentSearchCriteria c2 = this.saveSearch(princ, "save2");
        allUserOptions_after = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)(allUserOptions_before.size() + 2), (long)allUserOptions_after.size());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c2), (Object)this.userOptionsService.findByOptionId("DocSearch.NamedSearch." + c2.getSaveName(), princ).getOptionVal());
        this.docSearchService.clearNamedSearches(princ);
        Assert.assertEquals((long)0L, (long)this.userOptionsService.findByWorkflowUser(princ).size());
    }

    @Test
    public void testSavedSearchOrdering() throws Exception {
        Integer MAX_SEARCH_ITEMS = 5;
        String princ = "not blank";
        Collection<UserOptions> allUserOptions_before = this.userOptionsService.findByWorkflowUser(princ);
        DocumentSearchCriteria c1 = this.saveSearch(princ, null);
        DocumentSearchCriteria c2 = this.saveSearch(princ, null);
        DocumentSearchCriteria c3 = this.saveSearch(princ, null);
        DocumentSearchCriteria c4 = this.saveSearch(princ, null);
        DocumentSearchCriteria c5 = this.saveSearch(princ, null);
        Collection<UserOptions> allUserOptions_after = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)(allUserOptions_before.size() + 5 + 1), (long)allUserOptions_after.size());
        Assert.assertEquals((Object)"DocSearch.LastSearch.Holding4,DocSearch.LastSearch.Holding3,DocSearch.LastSearch.Holding2,DocSearch.LastSearch.Holding1,DocSearch.LastSearch.Holding0", (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Order", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c5), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding4", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c4), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding3", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c3), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding2", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c2), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding1", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c1), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding0", princ).getOptionVal());
        DocumentSearchCriteria c6 = this.saveSearch(princ, null);
        allUserOptions_after = this.userOptionsService.findByWorkflowUser(princ);
        Assert.assertEquals((long)(allUserOptions_before.size() + 5 + 1), (long)allUserOptions_after.size());
        Assert.assertEquals((Object)"DocSearch.LastSearch.Holding0,DocSearch.LastSearch.Holding4,DocSearch.LastSearch.Holding3,DocSearch.LastSearch.Holding2,DocSearch.LastSearch.Holding1", (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Order", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c6), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding0", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c5), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding4", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c4), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding3", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c3), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding2", princ).getOptionVal());
        Assert.assertEquals((Object)DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)c2), (Object)this.userOptionsService.findByOptionId("DocSearch.LastSearch.Holding1", princ).getOptionVal());
        this.docSearchService.clearNamedSearches(princ);
        Assert.assertEquals((long)0L, (long)this.userOptionsService.findByWorkflowUser(princ).size());
    }

    private DocumentSearchCriteria saveSearch(String princ, String name) {
        DocumentSearchCriteria dsc = this.createDocSearchCriteria(name);
        this.docSearchService.saveSearch(princ, dsc);
        return dsc;
    }

    private DocumentSearchCriteria createDocSearchCriteria(String saveName) {
        DocumentSearchCriteria.Builder builder = DocumentSearchCriteria.Builder.create();
        builder.setApplicationDocumentId(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setApplicationDocumentStatus(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setApproverPrincipalName(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setApproverPrincipalId(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setDocumentId(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setDocumentTypeName(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setDocumentStatusCategories(Arrays.asList(DocumentStatusCategory.PENDING, DocumentStatusCategory.SUCCESSFUL));
        builder.setDocumentStatuses(Arrays.asList(DocumentStatus.ENROUTE, DocumentStatus.INITIATED, DocumentStatus.SAVED));
        builder.setInitiatorPrincipalName(RandomStringUtils.randomAlphanumeric((int)10));
        builder.setInitiatorPrincipalId(RandomStringUtils.randomAlphanumeric((int)10));
        builder.setMaxResults(Integer.valueOf(500));
        builder.setRouteNodeName(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setSaveName(saveName);
        builder.setStartAtIndex(Integer.valueOf(1));
        builder.setTitle(RandomStringUtils.randomAlphanumeric((int)10));
        builder.setGroupViewerId(RandomStringUtils.randomAlphanumeric((int)5));
        builder.setViewerPrincipalName(RandomStringUtils.randomAlphanumeric((int)10));
        builder.setViewerPrincipalId(RandomStringUtils.randomAlphanumeric((int)10));
        builder.setRouteNodeLookupLogic(RouteNodeLookupLogic.EXACTLY);
        builder.setDateApplicationDocumentStatusChangedFrom(new DateTime());
        builder.setDateApplicationDocumentStatusChangedTo(new DateTime());
        builder.setDateApprovedFrom(new DateTime());
        builder.setDateApprovedTo(new DateTime());
        builder.setDateCreatedFrom(new DateTime());
        builder.setDateCreatedTo(new DateTime());
        builder.setDateFinalizedFrom(new DateTime());
        builder.setDateFinalizedTo(new DateTime());
        builder.setDateLastModifiedFrom(new DateTime());
        builder.setDateLastModifiedTo(new DateTime());
        HashMap attrs = new HashMap();
        for (int i = 1; i < 6; ++i) {
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 1; j < 6; ++j) {
                list.add(RandomStringUtils.randomAlphanumeric((int)5));
            }
            attrs.put(RandomStringUtils.randomAlphanumeric((int)5), list);
        }
        builder.setDocumentAttributeValues(attrs);
        return builder.build();
    }

    private class MockDocumentSearchService
    extends DocumentSearchServiceImpl {
        private static final int MAX_SEARCH_ITEMS = 5;
        private static final String LAST_SEARCH_ORDER_OPTION = "DocSearch.LastSearch.Order";
        private static final String NAMED_SEARCH_ORDER_BASE = "DocSearch.NamedSearch.";
        private static final String LAST_SEARCH_BASE_NAME = "DocSearch.LastSearch.Holding";

        private MockDocumentSearchService() {
        }

        public void saveSearch(String principalId, DocumentSearchCriteria criteria) {
            if (StringUtils.isBlank((String)principalId)) {
                return;
            }
            try {
                String savedSearchString = DocumentSearchInternalUtils.marshalDocumentSearchCriteria((DocumentSearchCriteria)criteria);
                if (StringUtils.isNotBlank((String)criteria.getSaveName())) {
                    DocSearchSavingTest.this.userOptionsService.save(principalId, NAMED_SEARCH_ORDER_BASE + criteria.getSaveName(), savedSearchString);
                } else {
                    UserOptions searchOrder = DocSearchSavingTest.this.userOptionsService.findByOptionId(LAST_SEARCH_ORDER_OPTION, principalId);
                    if (searchOrder == null) {
                        DocSearchSavingTest.this.userOptionsService.save(principalId, "DocSearch.LastSearch.Holding0", savedSearchString);
                        DocSearchSavingTest.this.userOptionsService.save(principalId, LAST_SEARCH_ORDER_OPTION, "DocSearch.LastSearch.Holding0");
                    } else {
                        String[] currentOrder = searchOrder.getOptionVal().split(",");
                        if (currentOrder.length == 5) {
                            String searchName = currentOrder[currentOrder.length - 1];
                            String[] newOrder = new String[5];
                            newOrder[0] = searchName;
                            for (int i = 0; i < currentOrder.length - 1; ++i) {
                                newOrder[i + 1] = currentOrder[i];
                            }
                            String newSearchOrder = this.rejoinWithCommas(newOrder);
                            DocSearchSavingTest.this.userOptionsService.save(principalId, searchName, savedSearchString);
                            DocSearchSavingTest.this.userOptionsService.save(principalId, LAST_SEARCH_ORDER_OPTION, newSearchOrder);
                        } else {
                            int absMax = 0;
                            for (String aCurrentOrder : currentOrder) {
                                int current = new Integer(aCurrentOrder.substring(LAST_SEARCH_BASE_NAME.length(), aCurrentOrder.length()));
                                if (current <= absMax) continue;
                                absMax = current;
                            }
                            String searchName = LAST_SEARCH_BASE_NAME + ++absMax;
                            String[] newOrder = new String[currentOrder.length + 1];
                            newOrder[0] = searchName;
                            for (int i = 0; i < currentOrder.length; ++i) {
                                newOrder[i + 1] = currentOrder[i];
                            }
                            String newSearchOrder = this.rejoinWithCommas(newOrder);
                            DocSearchSavingTest.this.userOptionsService.save(principalId, searchName, savedSearchString);
                            DocSearchSavingTest.this.userOptionsService.save(principalId, LAST_SEARCH_ORDER_OPTION, newSearchOrder);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String rejoinWithCommas(String[] newOrder) {
            StringBuilder newSearchOrder = new StringBuilder("");
            for (String aNewOrder : newOrder) {
                if (newSearchOrder.length() != 0) {
                    newSearchOrder.append(",");
                }
                newSearchOrder.append(aNewOrder);
            }
            return newSearchOrder.toString();
        }
    }

    private class MockUserOptionsService
    implements UserOptionsService {
        private HashMap<String, String> options = new HashMap();

        private MockUserOptionsService() {
        }

        public Collection<UserOptions> findByWorkflowUser(String principalId) {
            ArrayList<UserOptions> userOpts = new ArrayList<UserOptions>();
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                UserOptions opt = new UserOptions();
                opt.setOptionId(entry.getKey());
                opt.setOptionVal(entry.getValue());
                userOpts.add(opt);
            }
            return userOpts;
        }

        public List<UserOptions> findByUserQualified(String principalId, String likeString) {
            String prefix = likeString.replaceAll("%", "");
            ArrayList<UserOptions> userOpts = new ArrayList<UserOptions>();
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                UserOptions opt = new UserOptions();
                opt.setOptionId(entry.getKey());
                opt.setOptionVal(entry.getValue());
                userOpts.add(opt);
            }
            return userOpts;
        }

        public void save(UserOptions userOptions) {
            this.options.put(userOptions.getOptionId(), userOptions.getOptionVal());
        }

        public void save(String principalId, Map<String, String> optionsMap) {
            this.options.putAll(optionsMap);
        }

        public void save(String principalId, String optionId, String optionValue) {
            this.options.put(optionId, optionValue);
        }

        public void deleteUserOptions(UserOptions userOptions) {
            this.options.remove(userOptions.getOptionId());
        }

        public UserOptions findByOptionId(String optionId, String principalId) {
            if (this.options.containsKey(optionId)) {
                UserOptions opt = new UserOptions();
                opt.setOptionId(optionId);
                opt.setOptionVal(this.options.get(optionId));
                return opt;
            }
            return null;
        }

        public List<UserOptions> retrieveEmailPreferenceUserOptions(String emailSetting) {
            return null;
        }
    }
}

