/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security.credentials;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.ksb.security.credentials.X509Credentials;
import org.kuali.rice.ksb.security.credentials.X509CredentialsSource;

public class X509CredentialsSourceTest {
    private X509CredentialsSource credentialsSource;
    private X509Certificate cert = new KualiX509Certificate();

    @Before
    public void setUp() throws Exception {
        this.credentialsSource = new X509CredentialsSource(this.cert);
    }

    @Test
    public void testX509Certificate() {
        X509Credentials context = (X509Credentials)this.credentialsSource.getCredentials("test");
        Assert.assertNotNull((Object)context);
        X509Certificate cert = context.getX509Certificate();
        Assert.assertEquals((Object)this.cert, (Object)cert);
    }

    public static class KualiX509Certificate
    extends X509Certificate {
        protected KualiX509Certificate() {
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        }

        @Override
        public int getBasicConstraints() {
            return 0;
        }

        @Override
        public Principal getIssuerDN() {
            return null;
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return null;
        }

        @Override
        public boolean[] getKeyUsage() {
            return null;
        }

        @Override
        public Date getNotAfter() {
            return null;
        }

        @Override
        public Date getNotBefore() {
            return null;
        }

        @Override
        public BigInteger getSerialNumber() {
            return null;
        }

        @Override
        public String getSigAlgName() {
            return null;
        }

        @Override
        public String getSigAlgOID() {
            return null;
        }

        @Override
        public byte[] getSigAlgParams() {
            return null;
        }

        @Override
        public byte[] getSignature() {
            return null;
        }

        @Override
        public Principal getSubjectDN() {
            return null;
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return null;
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return null;
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public byte[] getExtensionValue(String arg0) {
            return null;
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public void verify(PublicKey arg0, String arg1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        @Override
        public void verify(PublicKey arg0) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }
    }
}

