/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch.xml;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.xml.StandardGenericXMLSearchableAttribute;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.krad.util.KRADConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class StandardGenericXMLSearchableAttributeUnitTest
implements GroovyObject {
    private static final String STRING_FIELD_SEARCH_CONFIG = "\n    <searchingConfig>\n            <fieldDef name=\"givenname\" title=\"First name\">\n                <display>\n                    <type>text</type>\n                </display>\n                <visibility>\n                    <column visible=\"true\"/>\n                </visibility>\n                <validation required=\"true\">\n                    <regex>^[a-zA-Z ]+$</regex>\n                    <message>Invalid first name</message>\n                </validation>\n                <fieldEvaluation>\n                    <xpathexpression>//putWhateverWordsIwantInsideThisTag/givenname/value</xpathexpression>\n                </fieldEvaluation>\n            </fieldDef>\n            <xmlSearchContent>\n                <putWhateverWordsIwantInsideThisTag>\n                    <givenname>\n                        <value>%givenname%</value>\n                    </givenname>\n                </putWhateverWordsIwantInsideThisTag>\n            </xmlSearchContent>\n        </searchingConfig>\n    ";
    private static final String STRING_FIELD_SEARCH_FORMATTER_CONFIG = "\n    <searchingConfig>\n            <fieldDef name=\"givenname\" title=\"First name\">\n                <display>\n                    <type>text</type>\n                    <formatter>org.kuali.rice.core.web.format.NoOpStringFormatter</formatter>\n                </display>\n                <visibility>\n                    <column visible=\"true\"/>\n                </visibility>\n                <validation required=\"true\">\n                    <regex>^[a-zA-Z ]+$</regex>\n                    <message>Invalid first name</message>\n                </validation>\n                <fieldEvaluation>\n                    <xpathexpression>//putWhateverWordsIwantInsideThisTag/givenname/value</xpathexpression>\n                </fieldEvaluation>\n            </fieldDef>\n            <xmlSearchContent>\n                <putWhateverWordsIwantInsideThisTag>\n                    <givenname>\n                        <value>%givenname%</value>\n                    </givenname>\n                </putWhateverWordsIwantInsideThisTag>\n            </xmlSearchContent>\n        </searchingConfig>\n    ";
    private static final String RANGE_FIELD_SEARCH_CONFIG = "\n    <searchingConfig>\n        <fieldDef name=\"givenname\" title=\"First name\">\n            <display>\n                <type>text</type>\n            </display>\n            <searchDefinition rangeSearch=\"true\"/>\n            <validation required=\"true\">\n                <regex>^[a-zA-Z ]+$</regex>\n                <message>Invalid first name</message>\n            </validation>\n            <fieldEvaluation>\n                <xpathexpression>//putWhateverWordsIwantInsideThisTag/givenname/value</xpathexpression>\n            </fieldEvaluation>\n        </fieldDef>\n        <xmlSearchContent>\n            <putWhateverWordsIwantInsideThisTag>\n                <givenname>\n                    <value>%givenname%</value>\n                </givenname>\n            </putWhateverWordsIwantInsideThisTag>\n        </xmlSearchContent>\n    </searchingConfig>\n    ";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public StandardGenericXMLSearchableAttributeUnitTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test(expected=RuntimeException.class)
    public void testXmlConfigMustBeDefined() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        callSiteArray[0].callCurrent((GroovyObject)this, null);
        callSiteArray[1].callStatic(Assert.class, (Object)"expected error");
    }

    @Test(expected=RuntimeException.class)
    public void testXmlConfigMustBeNotBeEmpty() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[2].callCurrent((GroovyObject)this, (Object)"");
        } else {
            this.testXmlConfigValidity("");
        }
        callSiteArray[3].callStatic(Assert.class, (Object)"expected error");
    }

    @Test(expected=RuntimeException.class)
    public void testXmlConfigMustBeWellFormedy() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[4].callCurrent((GroovyObject)this, (Object)"I'm not valid XML");
        } else {
            this.testXmlConfigValidity("I'm not valid XML");
        }
        callSiteArray[5].callStatic(Assert.class, (Object)"expected error");
    }

    @Test
    public void testDefaultXmlGenerationReturnsEmptyForNoFields() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[6].callCurrent((GroovyObject)this, (Object)"<validXml/>", (Object)"");
        } else {
            this.testGenerateSearchContent("<validXml/>", "");
        }
    }

    @Test
    public void testDefaultXmlGenerationWithNoValues() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[7].callCurrent((GroovyObject)this, (Object)"\n        <ruleAttribute>\n        <searchingConfig>\n            <fieldDef name=\"def1\"/>\n            <fieldDef name=\"def2\"/>\n        </searchingConfig>\n        </ruleAttribute>\n        ", (Object)"<xmlRouting></xmlRouting>");
        } else {
            this.testGenerateSearchContent("\n        <ruleAttribute>\n        <searchingConfig>\n            <fieldDef name=\"def1\"/>\n            <fieldDef name=\"def2\"/>\n        </searchingConfig>\n        </ruleAttribute>\n        ", "<xmlRouting></xmlRouting>");
        }
    }

    @Test
    public void testCustomXmlGenerationWithNoValues() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        String content = "<myGeneratedContent>\n                           <noVariableReplacement/>\n                         </myGeneratedContent>";
        callSiteArray[8].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{content}, new String[]{"\n        <ruleAttribute>\n        <searchingConfig>\n            <xmlSearchContent>\n                ", "\n            </xmlSearchContent>\n            <fieldDef name=\"def1\"/>\n            <fieldDef name=\"def2\"/>\n        </searchingConfig>\n        </ruleAttribute>\n        "}), (Object)content);
    }

    @Test
    public void testDefaultXmlGeneration() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        callSiteArray[9].callCurrent((GroovyObject)this, (Object)"\n        <ruleAttribute>\n        <searchingConfig>\n            <fieldDef name=\"def1\"/>\n            <fieldDef name=\"def2\"/>\n        </searchingConfig>\n        </ruleAttribute>\n        ", (Object)"<xmlRouting><field name=\"def1\"><value>val1</value></field></xmlRouting>", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"def1", "val1"}));
    }

    @Test
    public void testCustomXmlGeneration() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        callSiteArray[10].callCurrent((GroovyObject)this, (Object)"\n        <ruleAttribute>\n        <searchingConfig>\n            <xmlSearchContent>\n                <myGeneratedContent>\n                    <version>whatever</version>\n                    <anythingIWant>Once upon a %def1%...</anythingIWant>\n                    <conclusion>Happily ever %def2%.</conclusion>\n                    <epilogue>this var isn't set %undefined%</epilogue>\n                </myGeneratedContent>\n            </xmlSearchContent>\n            <fieldDef name=\"def1\"/>\n            <fieldDef name=\"def2\"/>\n        </searchingConfig>\n        </ruleAttribute>\n        ", (Object)"\n                <myGeneratedContent>\n                    <version>whatever</version>\n                    <anythingIWant>Once upon a val1...</anythingIWant>\n                    <conclusion>Happily ever val2.</conclusion>\n                    <epilogue>this var isn't set %undefined%</epilogue>\n                </myGeneratedContent>\n        ", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"def1", "val1", "def2", "val2", "third", "doesn't matter"}));
    }

    @Test
    public void testDocumentAttributeCriteriaIsAlwaysValidWhenNoFieldsAreDefined() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[11].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[12].callGetProperty(KewApiConstants.class), callSiteArray[13].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[14].call(callSiteArray[15].callGetProperty(edb), callSiteArray[16].callGetProperty(KewApiConstants.class), (Object)"<validXml/>");
        Object errors = callSiteArray[17].call(callSiteArray[18].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[19].call(edb), callSiteArray[20].call(callSiteArray[21].call(DocumentSearchCriteria.Builder.class)));
        callSiteArray[22].callStatic(Assert.class, (Object)"unexpected validation errors", (Object)0, callSiteArray[23].call(errors));
    }

    @Test
    public void testValidateDocumentAttributeCriteriaSimpleValue() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[24].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[25].callGetProperty(KewApiConstants.class), callSiteArray[26].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[27].call(callSiteArray[28].callGetProperty(edb), callSiteArray[29].callGetProperty(KewApiConstants.class), (Object)STRING_FIELD_SEARCH_CONFIG);
        Object c = callSiteArray[30].call(DocumentSearchCriteria.Builder.class);
        callSiteArray[31].call(callSiteArray[32].callGetProperty(c), (Object)"givenname", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"jack"}), List.class));
        Object errors = callSiteArray[33].call(callSiteArray[34].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[35].call(edb), callSiteArray[36].call(c));
        callSiteArray[37].callStatic(Assert.class, (Object)"unexpected validation errors", (Object)0, callSiteArray[38].call(errors));
    }

    @Test
    public void testValidateBoundsInclusivityDiscrepancy() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[39].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[40].callGetProperty(KewApiConstants.class), callSiteArray[41].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[42].call(callSiteArray[43].callGetProperty(edb), callSiteArray[44].callGetProperty(KewApiConstants.class), (Object)RANGE_FIELD_SEARCH_CONFIG);
        Object c = callSiteArray[45].call(DocumentSearchCriteria.Builder.class);
        callSiteArray[46].call(callSiteArray[47].callGetProperty(c), (Object)"givenname", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"jack..jill"}), List.class));
        Object errors = callSiteArray[48].call(callSiteArray[49].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[50].call(edb), callSiteArray[51].call(c));
        callSiteArray[52].callCurrent((GroovyObject)this, errors);
        callSiteArray[53].callStatic(Assert.class, (Object)"expected range upper bound inclusivity discrepancy between Range default and Attribute configuration", (Object)1, callSiteArray[54].call(errors));
    }

    @Test
    public void testValidateDocumentAttributeCriteriaExpression() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[55].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[56].callGetProperty(KewApiConstants.class), callSiteArray[57].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[58].call(callSiteArray[59].callGetProperty(edb), callSiteArray[60].callGetProperty(KewApiConstants.class), (Object)RANGE_FIELD_SEARCH_CONFIG);
        Object c = callSiteArray[61].call(DocumentSearchCriteria.Builder.class);
        callSiteArray[62].call(callSiteArray[63].callGetProperty(c), (Object)"givenname", (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"< jack"}), List.class));
        Object errors = callSiteArray[64].call(callSiteArray[65].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[66].call(edb), callSiteArray[67].call(c));
        callSiteArray[68].callCurrent((GroovyObject)this, errors);
        callSiteArray[69].callStatic(Assert.class, (Object)"unexpected validation errors", (Object)0, callSiteArray[70].call(errors));
    }

    @Test
    public void testGetSearchFields() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[71].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[72].callGetProperty(KewApiConstants.class), callSiteArray[73].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[74].call(callSiteArray[75].callGetProperty(edb), callSiteArray[76].callGetProperty(KewApiConstants.class), (Object)STRING_FIELD_SEARCH_CONFIG);
        Object fields = callSiteArray[77].call(callSiteArray[78].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[79].call(edb), (Object)"not used");
        callSiteArray[80].callCurrent((GroovyObject)this, fields);
        callSiteArray[81].callStatic(Assert.class, (Object)1, callSiteArray[82].call(fields));
        List rows = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].call(FieldUtils.class, fields), List.class);
        callSiteArray[84].callStatic(Assert.class, (Object)1, callSiteArray[85].call((Object)rows));
    }

    @Test
    public void testGetSearchFieldsFormatter() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[86].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[87].callGetProperty(KewApiConstants.class), callSiteArray[88].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[89].call(callSiteArray[90].callGetProperty(edb), callSiteArray[91].callGetProperty(KewApiConstants.class), (Object)STRING_FIELD_SEARCH_FORMATTER_CONFIG);
        Object fields = callSiteArray[92].call(callSiteArray[93].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[94].call(edb), (Object)"not used");
        callSiteArray[95].callCurrent((GroovyObject)this, fields);
        callSiteArray[96].callStatic(Assert.class, (Object)1, callSiteArray[97].call(fields));
        Column col = (Column)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].call(FieldUtils.class, callSiteArray[99].call(fields, (Object)0)), Column.class);
        callSiteArray[100].callCurrent((GroovyObject)this, callSiteArray[101].call((Object)col));
        callSiteArray[102].callStatic(Assert.class, callSiteArray[103].call((Object)col));
        callSiteArray[104].callStatic(Assert.class, (Object)"org.kuali.rice.core.web.format.NoOpStringFormatter", callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call((Object)col))));
    }

    @Test
    public void testGetRangeSearchFields() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[108].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[109].callGetProperty(KewApiConstants.class), callSiteArray[110].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[111].call(callSiteArray[112].callGetProperty(edb), callSiteArray[113].callGetProperty(KewApiConstants.class), (Object)RANGE_FIELD_SEARCH_CONFIG);
        Object fields = callSiteArray[114].call(callSiteArray[115].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[116].call(edb), (Object)"not used");
        callSiteArray[117].callCurrent((GroovyObject)this, fields);
        callSiteArray[118].callStatic(Assert.class, (Object)1, callSiteArray[119].call(fields));
        callSiteArray[120].callStatic(Assert.class, callSiteArray[121].callGetProperty(callSiteArray[122].callGetProperty(callSiteArray[123].call(fields, (Object)0))));
        callSiteArray[124].callStatic(Assert.class, callSiteArray[125].callGetProperty(callSiteArray[126].callGetProperty(callSiteArray[127].call(fields, (Object)0))));
        List rows = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].call(FieldUtils.class, fields), List.class);
        callSiteArray[129].callStatic(Assert.class, (Object)2, callSiteArray[130].call((Object)rows));
        callSiteArray[131].callStatic(Assert.class, callSiteArray[132].call(callSiteArray[133].callGetProperty(KRADConstants.class), (Object)"givenname"), callSiteArray[134].callGetProperty(callSiteArray[135].call(callSiteArray[136].callGetProperty(callSiteArray[137].call((Object)rows, (Object)0)), (Object)0)));
        callSiteArray[138].callStatic(Assert.class, (Object)"givenname", callSiteArray[139].callGetProperty(callSiteArray[140].call(callSiteArray[141].callGetProperty(callSiteArray[142].call((Object)rows, (Object)1)), (Object)0)));
    }

    @Test
    public void testSubclassCanOverrideConfigXML() {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[143].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[144].callGetProperty(KewApiConstants.class), callSiteArray[145].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[146].call(callSiteArray[147].callGetProperty(edb), callSiteArray[148].callGetProperty(KewApiConstants.class), (Object)"<searchingConfig>\n             <fieldDef name=\"def1\"/> <!-- add a single param so content is generated -->\n           </searchingConfig>");
        String content = ShortTypeHandling.castToString((Object)callSiteArray[149].call(callSiteArray[150].callConstructor(SGXSASubclass.class), callSiteArray[151].call(edb), (Object)"no document type", callSiteArray[152].call(callSiteArray[153].call(WorkflowAttributeDefinition.Builder.class, (Object)"test_attr"))));
        callSiteArray[154].callStatic(Assert.class, (Object)"dynamically added search content", (Object)content);
    }

    protected void testXmlConfigValidity(String xmlConfig) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[155].callCurrent((GroovyObject)this, (Object)xmlConfig);
        } else {
            this.testGenerateSearchContent(xmlConfig);
        }
    }

    protected void testGenerateSearchContent(String config, String expected, Object params) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object edb = callSiteArray[156].call(ExtensionDefinition.Builder.class, (Object)"test", callSiteArray[157].callGetProperty(KewApiConstants.class), callSiteArray[158].call(StandardGenericXMLSearchableAttribute.class));
        callSiteArray[159].call(callSiteArray[160].callGetProperty(edb), callSiteArray[161].callGetProperty(KewApiConstants.class), (Object)config);
        Reference ad = new Reference(callSiteArray[162].call(WorkflowAttributeDefinition.Builder.class, (Object)"test_attr"));
        public class _testGenerateSearchContent_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ad;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testGenerateSearchContent_closure1(Object _outerInstance, Object _thisObject, Reference ad) {
                Reference reference;
                CallSite[] callSiteArray = _testGenerateSearchContent_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ad = reference = ad;
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _testGenerateSearchContent_closure1.$getCallSiteArray();
                return callSiteArray[0].call(this.ad.get(), k, v);
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _testGenerateSearchContent_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, k, v);
            }

            public Object getAd() {
                CallSite[] callSiteArray = _testGenerateSearchContent_closure1.$getCallSiteArray();
                return this.ad.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testGenerateSearchContent_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "addPropertyDefinition";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _testGenerateSearchContent_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testGenerateSearchContent_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testGenerateSearchContent_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[163].call(params, (Object)new _testGenerateSearchContent_closure1(this, this, ad));
        Object generated = callSiteArray[164].call(callSiteArray[165].callConstructor(StandardGenericXMLSearchableAttribute.class), callSiteArray[166].call(edb), (Object)"no document type", callSiteArray[167].call(ad.get()));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)expected, null)) {
            callSiteArray[168].callStatic(Assert.class, callSiteArray[169].call(StringUtils.class, (Object)expected), callSiteArray[170].call(StringUtils.class, generated));
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(StandardGenericXMLSearchableAttributeUnitTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, StandardGenericXMLSearchableAttributeUnitTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(StandardGenericXMLSearchableAttributeUnitTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected void testGenerateSearchContent(String config, String expected) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        this.testGenerateSearchContent(config, expected, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected void testGenerateSearchContent(String config) {
        CallSite[] callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$getCallSiteArray();
        this.testGenerateSearchContent(config, null, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardGenericXMLSearchableAttributeUnitTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "testXmlConfigValidity";
        stringArray[1] = "fail";
        stringArray[2] = "testXmlConfigValidity";
        stringArray[3] = "fail";
        stringArray[4] = "testXmlConfigValidity";
        stringArray[5] = "fail";
        stringArray[6] = "testGenerateSearchContent";
        stringArray[7] = "testGenerateSearchContent";
        stringArray[8] = "testGenerateSearchContent";
        stringArray[9] = "testGenerateSearchContent";
        stringArray[10] = "testGenerateSearchContent";
        stringArray[11] = "create";
        stringArray[12] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[13] = "getName";
        stringArray[14] = "put";
        stringArray[15] = "configuration";
        stringArray[16] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[17] = "validateDocumentAttributeCriteria";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "build";
        stringArray[20] = "build";
        stringArray[21] = "create";
        stringArray[22] = "assertEquals";
        stringArray[23] = "size";
        stringArray[24] = "create";
        stringArray[25] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[26] = "getName";
        stringArray[27] = "put";
        stringArray[28] = "configuration";
        stringArray[29] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[30] = "create";
        stringArray[31] = "put";
        stringArray[32] = "documentAttributeValues";
        stringArray[33] = "validateDocumentAttributeCriteria";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "build";
        stringArray[36] = "build";
        stringArray[37] = "assertEquals";
        stringArray[38] = "size";
        stringArray[39] = "create";
        stringArray[40] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[41] = "getName";
        stringArray[42] = "put";
        stringArray[43] = "configuration";
        stringArray[44] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[45] = "create";
        stringArray[46] = "put";
        stringArray[47] = "documentAttributeValues";
        stringArray[48] = "validateDocumentAttributeCriteria";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "build";
        stringArray[51] = "build";
        stringArray[52] = "println";
        stringArray[53] = "assertEquals";
        stringArray[54] = "size";
        stringArray[55] = "create";
        stringArray[56] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[57] = "getName";
        stringArray[58] = "put";
        stringArray[59] = "configuration";
        stringArray[60] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[61] = "create";
        stringArray[62] = "put";
        stringArray[63] = "documentAttributeValues";
        stringArray[64] = "validateDocumentAttributeCriteria";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "build";
        stringArray[67] = "build";
        stringArray[68] = "println";
        stringArray[69] = "assertEquals";
        stringArray[70] = "size";
        stringArray[71] = "create";
        stringArray[72] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[73] = "getName";
        stringArray[74] = "put";
        stringArray[75] = "configuration";
        stringArray[76] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[77] = "getSearchFields";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "build";
        stringArray[80] = "println";
        stringArray[81] = "assertEquals";
        stringArray[82] = "size";
        stringArray[83] = "convertRemotableAttributeFields";
        stringArray[84] = "assertEquals";
        stringArray[85] = "size";
        stringArray[86] = "create";
        stringArray[87] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[88] = "getName";
        stringArray[89] = "put";
        stringArray[90] = "configuration";
        stringArray[91] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[92] = "getSearchFields";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "build";
        stringArray[95] = "println";
        stringArray[96] = "assertEquals";
        stringArray[97] = "size";
        stringArray[98] = "constructColumnFromAttributeField";
        stringArray[99] = "get";
        stringArray[100] = "println";
        stringArray[101] = "getFormatter";
        stringArray[102] = "assertNotNull";
        stringArray[103] = "getFormatter";
        stringArray[104] = "assertEquals";
        stringArray[105] = "getName";
        stringArray[106] = "getClass";
        stringArray[107] = "getFormatter";
        stringArray[108] = "create";
        stringArray[109] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[110] = "getName";
        stringArray[111] = "put";
        stringArray[112] = "configuration";
        stringArray[113] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[114] = "getSearchFields";
        stringArray[115] = "<$constructor$>";
        stringArray[116] = "build";
        stringArray[117] = "println";
        stringArray[118] = "assertEquals";
        stringArray[119] = "size";
        stringArray[120] = "assertTrue";
        stringArray[121] = "lowerBoundInclusive";
        stringArray[122] = "attributeLookupSettings";
        stringArray[123] = "getAt";
        stringArray[124] = "assertFalse";
        stringArray[125] = "upperBoundInclusive";
        stringArray[126] = "attributeLookupSettings";
        stringArray[127] = "getAt";
        stringArray[128] = "convertRemotableAttributeFields";
        stringArray[129] = "assertEquals";
        stringArray[130] = "size";
        stringArray[131] = "assertEquals";
        stringArray[132] = "plus";
        stringArray[133] = "LOOKUP_RANGE_LOWER_BOUND_PROPERTY_PREFIX";
        stringArray[134] = "propertyName";
        stringArray[135] = "getAt";
        stringArray[136] = "fields";
        stringArray[137] = "getAt";
        stringArray[138] = "assertEquals";
        stringArray[139] = "propertyName";
        stringArray[140] = "getAt";
        stringArray[141] = "fields";
        stringArray[142] = "getAt";
        stringArray[143] = "create";
        stringArray[144] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[145] = "getName";
        stringArray[146] = "put";
        stringArray[147] = "configuration";
        stringArray[148] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[149] = "generateSearchContent";
        stringArray[150] = "<$constructor$>";
        stringArray[151] = "build";
        stringArray[152] = "build";
        stringArray[153] = "create";
        stringArray[154] = "assertEquals";
        stringArray[155] = "testGenerateSearchContent";
        stringArray[156] = "create";
        stringArray[157] = "SEARCHABLE_XML_ATTRIBUTE_TYPE";
        stringArray[158] = "getName";
        stringArray[159] = "put";
        stringArray[160] = "configuration";
        stringArray[161] = "ATTRIBUTE_XML_CONFIG_DATA";
        stringArray[162] = "create";
        stringArray[163] = "each";
        stringArray[164] = "generateSearchContent";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "build";
        stringArray[167] = "build";
        stringArray[168] = "assertEquals";
        stringArray[169] = "deleteWhitespace";
        stringArray[170] = "deleteWhitespace";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[171];
        StandardGenericXMLSearchableAttributeUnitTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StandardGenericXMLSearchableAttributeUnitTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StandardGenericXMLSearchableAttributeUnitTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static class SGXSASubclass
    extends StandardGenericXMLSearchableAttribute
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public SGXSASubclass() {
            MetaClass metaClass;
            CallSite[] callSiteArray = SGXSASubclass.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected Element getConfigXML(ExtensionDefinition extensionDefinition) {
            CallSite[] callSiteArray = SGXSASubclass.$getCallSiteArray();
            Element e = (Element)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(StandardGenericXMLSearchableAttribute.class, (GroovyObject)this, (String)"getConfigXML", (Object[])new Object[]{extensionDefinition}), Element.class);
            Element xc = (Element)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)e), (Object)"xmlSearchContent"), Element.class);
            Text t = (Text)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty((Object)e), (Object)"dynamically added search content"), Text.class);
            callSiteArray[4].call((Object)xc, (Object)t);
            callSiteArray[5].call((Object)e, (Object)xc);
            callSiteArray[6].call((Object)e, (Object)"customized", (Object)"true");
            return e;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = SGXSASubclass.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(SGXSASubclass.class, StandardGenericXMLSearchableAttributeUnitTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = SGXSASubclass.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, StandardGenericXMLSearchableAttributeUnitTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = SGXSASubclass.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(SGXSASubclass.class, StandardGenericXMLSearchableAttributeUnitTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != SGXSASubclass.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public /* synthetic */ Element super$2$getConfigXML(ExtensionDefinition extensionDefinition) {
            return super.getConfigXML(extensionDefinition);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "createElement";
            stringArray[1] = "ownerDocument";
            stringArray[2] = "createTextNode";
            stringArray[3] = "ownerDocument";
            stringArray[4] = "appendChild";
            stringArray[5] = "appendChild";
            stringArray[6] = "setAttribute";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[7];
            SGXSASubclass.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(SGXSASubclass.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = SGXSASubclass.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

