/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.actionlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actionlist.DefaultCustomActionListAttribute;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemCustomization;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.framework.actionlist.ActionListCustomizationHandlerService;
import org.kuali.rice.kew.impl.actionlist.ActionListCustomizationMediatorImpl;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.mockito.Mockito;

public class ActionListCustomizationMediatorImplTest {
    private ActionListCustomizationMediatorImpl mediator = new ActionListCustomizationMediatorImpl();
    private final String FOO_ACTION_ITEM_ID = "123";
    private final ActionItemCustomization fooResult = ActionItemCustomization.Builder.create((String)"123", (ActionSet)ActionSet.Builder.create().build(), (DisplayParameters)DisplayParameters.Builder.create((Integer)10).build()).build();
    private final String DEFAULT_ACTION_ITEM_ID = "987";
    private final ActionItemCustomization defaultResult;

    public ActionListCustomizationMediatorImplTest() {
        DefaultCustomActionListAttribute defaultAttribute = new DefaultCustomActionListAttribute();
        ActionSet legalActions = null;
        DisplayParameters displayParameters = null;
        try {
            legalActions = defaultAttribute.getLegalActions(null, null);
            displayParameters = defaultAttribute.getDocHandlerDisplayParameters(null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.defaultResult = ActionItemCustomization.Builder.create((String)"987", (ActionSet)legalActions, (DisplayParameters)displayParameters).build();
    }

    @Before
    public void setup() throws Exception {
        ActionListCustomizationHandlerService fooActionListCustomizationHandlerService = (ActionListCustomizationHandlerService)Mockito.mock(ActionListCustomizationHandlerService.class);
        Mockito.when((Object)fooActionListCustomizationHandlerService.customizeActionList(Mockito.anyString(), Mockito.anyList())).thenReturn(Collections.singletonList(this.fooResult));
        ActionListCustomizationHandlerService defaultActionListCustomizationHandlerService = (ActionListCustomizationHandlerService)Mockito.mock(ActionListCustomizationHandlerService.class);
        Mockito.when((Object)defaultActionListCustomizationHandlerService.customizeActionList(Mockito.anyString(), Mockito.anyList())).thenReturn(Collections.singletonList(this.defaultResult));
        ActionListCustomizationMediatorImpl.ActionListCustomizationHandlerServiceChooser mockActionListCustomizationHandlerServiceChooser = (ActionListCustomizationMediatorImpl.ActionListCustomizationHandlerServiceChooser)Mockito.mock(ActionListCustomizationMediatorImpl.ActionListCustomizationHandlerServiceChooser.class);
        Mockito.when((Object)mockActionListCustomizationHandlerServiceChooser.getByApplicationId("foo")).thenReturn((Object)fooActionListCustomizationHandlerService);
        Mockito.when((Object)mockActionListCustomizationHandlerServiceChooser.getByApplicationId(null)).thenReturn((Object)defaultActionListCustomizationHandlerService);
        DocumentTypeService mockDocumentTypeService = (DocumentTypeService)Mockito.mock(DocumentTypeService.class);
        DocumentType fooDocType = (DocumentType)Mockito.mock(DocumentType.class);
        RuleAttribute ruleAttr = new RuleAttribute();
        ruleAttr.setApplicationId("foo");
        Mockito.when((Object)fooDocType.getCustomActionListRuleAttribute()).thenReturn((Object)ruleAttr);
        Mockito.when((Object)mockDocumentTypeService.findByName("FooDocType")).thenReturn((Object)fooDocType);
        DocumentType barDocType = (DocumentType)Mockito.mock(DocumentType.class);
        RuleAttribute ruleAttr2 = new RuleAttribute();
        ruleAttr2.setApplicationId(null);
        Mockito.when((Object)barDocType.getCustomActionListRuleAttribute()).thenReturn((Object)ruleAttr2);
        Mockito.when((Object)mockDocumentTypeService.findByName("BarDocType")).thenReturn((Object)barDocType);
        this.mediator.setDocumentTypeService(mockDocumentTypeService);
        this.mediator.setActionListCustomizationHandlerServiceChooser(mockActionListCustomizationHandlerServiceChooser);
    }

    @Test
    public void testApplicationServiceMediation() {
        ActionItem.Builder fooActionItemBuilder = ActionItem.Builder.create((String)"321", (String)"A", (String)"234", (DateTime)DateTime.now(), (String)"Foo Doc Label", (String)"http://asdf.com/", (String)"FooDocType", (String)"345", (String)"gilesp");
        fooActionItemBuilder.setId("123");
        ActionItem.Builder barActionItemBuilder = ActionItem.Builder.create((String)"322", (String)"A", (String)"235", (DateTime)DateTime.now(), (String)"Bar Doc Label", (String)"http://asdf.com/", (String)"BarDocType", (String)"346", (String)"gilesp");
        fooActionItemBuilder.setId("987");
        ArrayList<ActionItem> actionItems = new ArrayList<ActionItem>();
        actionItems.add(fooActionItemBuilder.build());
        actionItems.add(barActionItemBuilder.build());
        Map customizations = this.mediator.getActionListCustomizations("gilesp", actionItems);
        Assert.assertTrue((customizations.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.fooResult, customizations.get(this.fooResult.getActionItemId()));
        Assert.assertEquals((Object)this.defaultResult, customizations.get(this.defaultResult.getActionItemId()));
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testNullPrincipalId() {
        this.mediator.getActionListCustomizations(null, Collections.emptyList());
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testEmptyPrincipalId() {
        this.mediator.getActionListCustomizations("", Collections.emptyList());
    }

    @Test
    public void testEmptyActionItemList() {
        Map customizations = this.mediator.getActionListCustomizations("gilesp", Collections.emptyList());
        Assert.assertTrue((customizations.size() == 0 ? 1 : 0) != 0);
    }
}

