/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.api.repository.type.KewAttributeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeAttribute;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.impl.repository.KewTypeBoServiceImpl;
import org.kuali.rice.kew.impl.type.KewTypeAttributeBo;
import org.kuali.rice.kew.impl.type.KewTypeBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KewTypeBoServiceImplTest {
    private KewTypeBoServiceImpl kewTypeBoService;
    @Mock
    private DataObjectService mockDataObjectService;
    static Map<String, KewTypeBo> sampleTypes = new HashMap<String, KewTypeBo>();
    static Map<String, KewTypeBo> sampleTypesKeyedByName = new HashMap<String, KewTypeBo>();
    private static final String NAMESPACE = "KEW_TEST";
    private static final String TYPE_ID = "KC_MAP123";
    private static final String NAME = "KC_UNIT";
    private static final String SERVICE_NAME = "kcUnitService";
    private static final String ATTR_ID_1 = "UNIT_NUM";
    private static final String UNIT_NUM_ATTR_DEF_ID = "1000";
    private static final Integer SEQUENCE_NUMBER_1 = new Integer(1);
    private static final String ATTR_ID_2 = "CAMPUS";
    private static final String CAMPUS_ATTR_DEF_ID = "1002";
    private static final Integer SEQUENCE_NUMBER_2 = new Integer(2);
    private static final String ATTR_ID_3 = "NewAttr";
    private static final String NEW_ATTR_DEF_ID = "1004";
    private static final Integer SEQUENCE_NUMBER_3 = new Integer(3);
    private static final String ORG_NAME = "ORG";
    private static final String ORG_LABEL = "Organization";
    private static final String COMPONENT = "someOrgComponent";
    private static KewAttributeDefinition.Builder unitNumAttrDefn = KewAttributeDefinition.Builder.create((String)"1000", (String)"testAttrDef1", (String)"KEW_TEST");
    private static KewAttributeDefinition.Builder campusAttrDefn = KewAttributeDefinition.Builder.create((String)"1002", (String)"testAttrDef2", (String)"KEW_TEST");
    private static KewAttributeDefinition.Builder newAttrDefn = KewAttributeDefinition.Builder.create((String)"1004", (String)"testAttrDef3", (String)"KEW_TEST");
    private static KewTypeAttribute.Builder unitNumAttrBuilder = KewTypeAttribute.Builder.create((String)"UNIT_NUM", (String)"KC_MAP123", (String)"1000", (Integer)SEQUENCE_NUMBER_1).attributeDefinition(unitNumAttrDefn);
    private static KewTypeAttribute.Builder campusAttrBuilder = KewTypeAttribute.Builder.create((String)"CAMPUS", (String)"KC_MAP123", (String)"1002", (Integer)SEQUENCE_NUMBER_2).attributeDefinition(campusAttrDefn);
    private static KewTypeAttribute newAttr = KewTypeAttribute.Builder.create((String)"NewAttr", (String)"KC_MAP123", (String)"1004", (Integer)SEQUENCE_NUMBER_3).attributeDefinition(newAttrDefn).build();
    private static List<KewTypeAttribute.Builder> attrs = Arrays.asList(unitNumAttrBuilder, campusAttrBuilder);
    private static KewTypeDefinition TEST_KEW_TYPE_DEF = KewTypeDefinition.Builder.create((String)"KC_MAP123", (String)"KC_UNIT", (String)"KEW_TEST").serviceName("kcUnitService").attributes(attrs).build();
    private static KewTypeBo TEST_KEW_TYPE_BO = KewTypeBo.from((KewTypeDefinition)TEST_KEW_TYPE_DEF);
    private static KewTypeAttributeBo TEST_KEW_TYPE_ATTRIBUTE_BO = KewTypeAttributeBo.from((KewTypeAttribute)newAttr, (KewTypeBo)TEST_KEW_TYPE_BO);

    @BeforeClass
    public static void createSampleTypeBOs() {
        KewTypeBo defaultBo = KewTypeBoServiceImplTest.createKewTypeBo("1", Boolean.TRUE, "DEFAULT", NAMESPACE, "KewTypeBoServiceImpl");
        KewTypeBo studentBo = KewTypeBoServiceImplTest.createKewTypeBo("2", Boolean.TRUE, "Student", NAMESPACE, "KewTypeBoServiceImpl");
        KewTypeBo ifopalBo = KewTypeBoServiceImplTest.createKewTypeBo("3", Boolean.TRUE, "IFOPAL", "KC_TEST", null);
        for (KewTypeBo bo : Arrays.asList(defaultBo, studentBo, ifopalBo)) {
            sampleTypes.put(bo.getId(), bo);
            sampleTypesKeyedByName.put(bo.getName(), bo);
        }
    }

    public KewTypeBoServiceImplTest() {
        MockitoAnnotations.initMocks((Object)this);
        this.kewTypeBoService = new KewTypeBoServiceImpl();
    }

    @Test(expected=IllegalStateException.class)
    public void test_createKewTypeAttribute_exists() {
        this.setupDOSFetchKewTypeAttrByFind(TEST_KEW_TYPE_ATTRIBUTE_BO);
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        this.kewTypeBoService.createKewTypeAttribute(newAttr);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeAttribute>(KewTypeAttribute.class)), Matchers.anyObject());
    }

    @Test
    public void test_updateKewTypeAttribute_success() {
        this.setupDOSFetchKewTypeAttrByFind(TEST_KEW_TYPE_ATTRIBUTE_BO);
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        this.kewTypeBoService.updateKewTypeAttribute(newAttr);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeAttributeBo>(KewTypeAttributeBo.class)), Matchers.any(KewTypeAttribute.class));
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0]);
    }

    @Test
    public void testGetType() {
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.find(KewTypeBo.class, (Object)"1")).thenReturn((Object)sampleTypes.get("1"));
        KewTypeDefinition testDefn = this.getKewTypeBoService().getTypeById("1");
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService)).find(KewTypeBo.class, (Object)"1");
        Assert.assertEquals((Object)KewTypeBo.to((KewTypeBo)sampleTypes.get("1")), (Object)testDefn);
    }

    @Test
    public void testGetByIdWhenNoneFound() {
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.find(KewTypeBo.class, (Object)"I DONT EXIST")).thenReturn(null);
        KewTypeDefinition testDefn = this.getKewTypeBoService().getTypeById("I DONT EXIST");
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService)).find(KewTypeBo.class, (Object)"I DONT EXIST");
        Assert.assertNull((Object)testDefn);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByPrimaryIdEmptyTypeId() {
        this.getKewTypeBoService().getTypeById("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByPrimaryIdNullTypeId() {
        this.getKewTypeBoService().getTypeById(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByNameAndNamespace_null_type_id() {
        this.getKewTypeBoService().getTypeByNameAndNamespace(null, NAMESPACE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetByNameAndNamespace_null_namespace() {
        this.getKewTypeBoService().getTypeByNameAndNamespace("Student", null);
    }

    @Test
    public void testGetByNameAndNamespace() {
        String name = "Student";
        String namespace = NAMESPACE;
        ArgumentCaptor<QueryByCriteria> argument = this.setupDOSFetchKewTypeBoByFindMatching(Arrays.asList(sampleTypesKeyedByName.get("Student")));
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        KewTypeDefinition kewTypeDefn = this.getKewTypeBoService().getTypeByNameAndNamespace("Student", NAMESPACE);
        QueryByCriteria queryByCriteria = (QueryByCriteria)argument.getValue();
        Assert.assertTrue((String)"Name passed as criteria for findMatching", (boolean)StringUtils.contains((String)queryByCriteria.toString(), (String)"name, Student"));
        Assert.assertTrue((String)"Namespace passed as criteria for findMatching", (boolean)StringUtils.contains((String)queryByCriteria.toString(), (String)"namespace, KEW_TEST"));
        Assert.assertTrue((String)"KewTypeDefinition was returned.", (null != kewTypeDefn && kewTypeDefn.getName().equals("Student") && kewTypeDefn.getNamespace().equals(NAMESPACE) ? 1 : 0) != 0);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).findMatching((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), (QueryByCriteria)Matchers.any(QueryByCriteria.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllTypesByNamespace_null_namespace() {
        String namespace = null;
        this.getKewTypeBoService().findAllTypesByNamespace(namespace);
    }

    @Test
    public void test_findAllTypesByNamespace() {
        String namespace = NAMESPACE;
        ArgumentCaptor<QueryByCriteria> argument = this.setupDOSFetchKewTypeBoByFindMatching(Arrays.asList(sampleTypes.get("1"), sampleTypes.get("2")));
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        List resultList = this.getKewTypeBoService().findAllTypesByNamespace(NAMESPACE);
        QueryByCriteria queryByCriteria = (QueryByCriteria)argument.getValue();
        Assert.assertTrue((String)"Namespace passed as criteria for findMatching", (boolean)StringUtils.contains((String)queryByCriteria.toString(), (String)"namespace, KEW_TEST"));
        Assert.assertTrue((String)"findAllTypesByNamespace retrieved correctly", (null != resultList && resultList.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)KewTypeBo.to((KewTypeBo)sampleTypes.get("1")), resultList.get(0));
        Assert.assertEquals((Object)KewTypeBo.to((KewTypeBo)sampleTypes.get("2")), resultList.get(1));
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).findMatching((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), (QueryByCriteria)Matchers.any(QueryByCriteria.class));
    }

    @Test
    public void test_findAllTypes() {
        this.setupDOSFetchKewTypeBoByFindMatching(Arrays.asList(sampleTypes.get("1"), sampleTypes.get("2"), sampleTypes.get("3")));
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        List resultList = this.getKewTypeBoService().findAllTypes();
        Assert.assertTrue((String)"findAllTypes retrived correctly", (null != resultList && resultList.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)KewTypeBo.to((KewTypeBo)sampleTypes.get("1")), resultList.get(0));
        Assert.assertEquals((Object)KewTypeBo.to((KewTypeBo)sampleTypes.get("2")), resultList.get(1));
        Assert.assertEquals((Object)KewTypeBo.to((KewTypeBo)sampleTypes.get("3")), resultList.get(2));
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).findMatching((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), (QueryByCriteria)Matchers.any(QueryByCriteria.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createKewType_null_input() {
        this.getKewTypeBoService().createKewType(null);
    }

    @Test(expected=IllegalStateException.class)
    public void test_createKewType_exists() {
        this.setupDOSFetchKewTypeBoByFindMatching(Arrays.asList(TEST_KEW_TYPE_BO));
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        KewTypeDefinition kewTypeDefn = this.getKewTypeBoService().createKewType(TEST_KEW_TYPE_DEF);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).findMatching((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), (QueryByCriteria)Matchers.any(QueryByCriteria.class));
    }

    @Test
    public void test_createKewType_success() {
        this.setupDOSFetchKewTypeBoByFindMatching(new ArrayList<KewTypeBo>());
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_BO);
        KewTypeDefinition kewTypeDefn = this.getKewTypeBoService().createKewType(TEST_KEW_TYPE_DEF);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).findMatching((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), (QueryByCriteria)Matchers.any(QueryByCriteria.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateKewType_null_input() {
        this.getKewTypeBoService().updateKewType(null);
    }

    @Test(expected=IllegalStateException.class)
    public void test_updateKewType_does_not_exist() {
        this.setupDOSFetchKewTypeBoByFind(null);
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        this.getKewTypeBoService().updateKewType(TEST_KEW_TYPE_DEF);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), Matchers.anyObject());
    }

    @Test
    public void test_updateKewType_success() {
        this.setupDOSFetchKewTypeBoByFind(TEST_KEW_TYPE_BO);
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Mockito.eq(KewTypeAttributeBo.class), Matchers.any(String.class))).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_ATTRIBUTE_BO);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(KewTypeBo.class), new PersistenceOption[0])).thenReturn((Object)TEST_KEW_TYPE_BO);
        this.getKewTypeBoService().updateKewType(TEST_KEW_TYPE_DEF);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), Matchers.any(String.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createKewTypeAttribute_null_input() {
        this.getKewTypeBoService().createKewTypeAttribute(null);
    }

    @Test
    public void test_createKewTypeAttribute_success() {
        this.setupDOSFetchKewTypeAttrByFind(null);
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        this.getKewTypeBoService().createKewTypeAttribute(newAttr);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeAttributeBo>(KewTypeAttributeBo.class)), Matchers.any(KewTypeAttribute.class));
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).save(Matchers.any(KewTypeAttributeBo.class), new PersistenceOption[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateKewTypeAttribute_null_input() {
        this.getKewTypeBoService().updateKewTypeAttribute(null);
    }

    @Test(expected=IllegalStateException.class)
    public void test_updateKewTypeAttribute_does_not_exist() {
        this.setupDOSFetchKewTypeAttrByFind(null);
        this.kewTypeBoService = new KewTypeBoServiceImpl();
        this.kewTypeBoService.setDataObjectService(this.mockDataObjectService);
        this.getKewTypeBoService().updateKewTypeAttribute(newAttr);
        ((DataObjectService)Mockito.verify((Object)this.mockDataObjectService, (VerificationMode)Mockito.times((int)1))).find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeAttributeBo>(KewTypeAttributeBo.class)), Matchers.any(KewTypeAttribute.class));
    }

    private static KewTypeBo createKewTypeBo(String id, boolean isActive, String name, String namespace, String serviceName) {
        KewTypeBo kewTypeBo = new KewTypeBo();
        kewTypeBo.setId(id);
        kewTypeBo.setActive(isActive);
        kewTypeBo.setName(name);
        kewTypeBo.setNamespace(namespace);
        kewTypeBo.setServiceName(serviceName);
        return kewTypeBo;
    }

    private ArgumentCaptor<QueryByCriteria> setupDOSFetchKewTypeBoByFindMatching(List<KewTypeBo> resultList) {
        GenericQueryResults.Builder builder = GenericQueryResults.Builder.create();
        builder.setResults(resultList);
        ArgumentCaptor argument = ArgumentCaptor.forClass(QueryByCriteria.class);
        Mockito.when((Object)this.mockDataObjectService.findMatching((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), (QueryByCriteria)argument.capture())).thenReturn((Object)builder.build());
        return argument;
    }

    private ArgumentCaptor<QueryByCriteria> setupDOSFetchKewTypeBoByFind(KewTypeBo resultBo) {
        ArgumentCaptor argument = ArgumentCaptor.forClass(QueryByCriteria.class);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeBo>(KewTypeBo.class)), argument.capture())).thenReturn((Object)resultBo);
        return argument;
    }

    private ArgumentCaptor<QueryByCriteria> setupDOSFetchKewTypeAttrByFind(KewTypeAttributeBo resultAttr) {
        ArgumentCaptor argument = ArgumentCaptor.forClass(QueryByCriteria.class);
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.argThat(new ClassOrSubclassMatcher<KewTypeAttributeBo>(KewTypeAttributeBo.class)), argument.capture())).thenReturn((Object)resultAttr);
        return argument;
    }

    private KewTypeBoServiceImpl getKewTypeBoService() {
        return this.kewTypeBoService;
    }

    private static KewTypeAttribute createKewTypeAttribute(String attributeId, String typeId, String attrDefnId, Integer sequenceNumber) {
        KewTypeAttribute.Builder attrDefnBuilder = KewTypeAttribute.Builder.create((String)attributeId, (String)typeId, (String)attrDefnId, (Integer)sequenceNumber);
        return attrDefnBuilder.build();
    }

    class ClassOrSubclassMatcher<T>
    extends BaseMatcher<Class<T>> {
        private final Class<T> targetClass;

        public ClassOrSubclassMatcher(Class<T> targetClass) {
            this.targetClass = targetClass;
        }

        public boolean matches(Object obj) {
            if (obj != null && obj instanceof Class) {
                return this.targetClass.isAssignableFrom((Class)obj);
            }
            return false;
        }

        public void describeTo(Description desc) {
            desc.appendText("Matches a class or subclass");
        }
    }
}

